/* VMS_SYS_PROCESS_SCAN.C -- 24-NOV-1998 Uwe Zessin
   Python interface to SYS$PROCESS_SCAN()

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()

WARNING! SYS$PROCESS_SCAN() uses 'by value' into the item-list !
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;
/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;		/* exception vms_sys.error */
/* ------------------------------------------------------------------------- */
/* reference to translation table for PSCAN$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$PSCANDEF[];
/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */
/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------ */
/* input a Python long integer - output a binary octaword */
extern long vms__cvt_pylong2octa (PyObject * r_longint, long * o_octaword);

/* ------------------------------------------------------------------------- */
/* free any malloc()ed buffers for input-items pointed by item-list,	*/
/*      the item-list itself,						*/
/*      the back-pointer list into VMSDEF structure,			*/

static void vms_sys__pscan_free
	(struct vmsdef_xr_itmlst3  * ar_itemlist
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef )
{
     struct vmsdef_xr_itmlst3  * ar_itemlist_ptr;	/* walk along */
     struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef_ptr;	/* walk along */

     ar_itemlist_ptr   = ar_itemlist;
     ar_itm_vmsdef_ptr = ar_itm_vmsdef;

     /* loop over item-list and free allocated buffers */
     /* Warning: for boolean items W_BUFSIZ == 0 ! */
     while ((ar_itemlist_ptr->w_itmcod != 0) ||
	    (ar_itemlist_ptr->w_bufsiz != 0)   )
     {
	/* check for passed by-value/reference */

	/* drop buffer, if one is allocated */
	/* this check is different than all other code because it checks */
	/*  bufsiz and not bufadr, because bufadr is equivalent with itmval */
	if (ar_itemlist_ptr->w_bufsiz != 0)
	{
	    (void) free (ar_itemlist_ptr->itmlst3_a_bufadr);
	}
	ar_itemlist_ptr++;		/* next item */
	ar_itm_vmsdef_ptr++;
     }
     (void) free (ar_itemlist);		/* free the entire VMS item-list */
     (void) free (ar_itm_vmsdef);	/* free back-pointer array to VMSDEF */
     return;
} /* vms_sys__pscan_free () */

/* ------------------------------------------------------------------------- */

char vms_sys_process_scan__doc[] =
"pidctx = vms_sys.process_scan (pidctx [,itmlst])\n\
Process Scan.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_process_scan (PyObject *self, PyObject *args)
{
	unsigned long		  l_pidctx;
	PyObject		* ar_pidctx;

	/* item-list - tuple of tuples:                    */
	/*  ( ('PSCAN$_name',data,flags), ('PSCAN$_name',data), ...) */
	PyObject		* ar_py_item_list;

	unsigned long		  l_itmlst_size;	/* number of strings */
	unsigned long		  l_itmlst_idx;		/* index into "      */

	/* item tuple - ('PSCAN$_name',data,flags) */
	PyObject		* ar_py_item_tuple;	/* item tuple */

	PyObject		* ar_py_item_code;	/* PSCAN$_name */
	char			* at_item_code;		/* "	       */
	unsigned short int	  w_item_code;		/* from VMSDEF */

	/* item 'data' */
	PyObject		* ar_py_item_data;	/* ASCI[IC]/BWLQO */

	/* item 'flags' */
	PyObject		* ar_py_item_flags;	/* Long */
	unsigned long		  l_flags;

	unsigned long		  l_trn_idx; /* into VMSDEF_GR_$PSCANDEF[] */

	/* VMS item-list to be passed to SYS$PROCESS_SCAN() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;	/* start address */
	struct vmsdef_xr_itmlst3 * ar_itemlist_ptr;	/* walk along    */

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for input-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef_ptr;	/* walk along    */

	unsigned long		  l_malloc_bytes;	/* for malloc() */

	unsigned long		  l_status;

	PyObject		* ar_ctxout;		/* return to Python */

	/* -------------------- */
	ar_py_item_list = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "l|O", &l_pidctx, &ar_py_item_list))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: done */

	/* -------------------- */
	/* argument 2: itmlst */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 2: itmlst - must be tuple of tuples");
	    return NULL;
	}

	l_itmlst_size = PyTuple_Size(ar_py_item_list);

	/* ---------------------------------------- */
	/* allocate memory for:
	||	- each item-list element
	||	- the item-list termination element
	*/
	l_malloc_bytes =
	    ( (l_itmlst_size * sizeof(struct vmsdef_xr_itmlst3)) + /* items */
	      sizeof(struct vmsdef_xr_itmlst3) /* termination of itemlist */
	    );
	ar_itemlist = malloc (l_malloc_bytes);
	if (ar_itemlist == NULL)
	{
	    return PyErr_NoMemory();
	}
	/* Set the allocated memory to 0. */
	/* This is needed if the loop to build the item-list fails	 */
	/*  and the cleanup has to free() any input buffers that	 */
	/*  have been malloc()ed so far. I don't have to set any	 */
	/*  ar_itemlist_ptr->itmlst3_a_bufadr to NULL before building the list */
	(void) memset (ar_itemlist, 0, l_malloc_bytes);

	/* ar_itemlist_ptr is used to walk along the individual elements */
	/*  in the VMS item-list */
	ar_itemlist_ptr = ar_itemlist;

	/* ---------------------------------------- */
/*??*/	/* allocate memory for:
	||	- an array of pointers from the item to its corresponding
	||	  VMSDEF structure element
	*/
	l_malloc_bytes = (l_itmlst_size * 4);	/* for VMSDEF pointers % */
					/* % - needs no termination */
	ar_itm_vmsdef = malloc (l_malloc_bytes);
	if (ar_itm_vmsdef == NULL)
	{
	    (void) free (ar_itemlist);		/* prevent memory leak */
	    return PyErr_NoMemory();
	}
	ar_itm_vmsdef_ptr = ar_itm_vmsdef;	/* used to walk over array */

/* -------------------- */
/* loop over item-list */
for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; l_itmlst_idx++)
{
  /* get item-list element - ('PSCAN$_name',data[,flags]) */
  ar_py_item_tuple = PyTuple_GetItem(ar_py_item_list, l_itmlst_idx);
  if (ar_py_item_tuple == NULL)
  {
    /* free item-list *and* all malloc()ed buffers */
    (void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
    return NULL;
  }
  /* -------------------- */
  /* each list element must be a tuple itself ('PSCAN$_name',data[,flags]) */
  if (!PyTuple_Check(ar_py_item_tuple))
  {
    /* free item-list *and* all malloc()ed buffers */
    (void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
    return PyErr_Format(PyExc_TypeError,
	"argument 2: itmlst - item:%d must be tuple", l_itmlst_idx);
  }
  /* -------------------- */
  /* get item-code ('PSCAN$_name') from tuple */
  ar_py_item_code = PyTuple_GetItem(ar_py_item_tuple, 0);
  if (PyErr_Occurred())
  {
    /* free item-list *and* all malloc()ed buffers */
    (void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
    return NULL;
  }
  /* -------------------- */
  /* item-code must be a string ('PSCAN$_name') */
  if (!PyString_Check(ar_py_item_code))
  {
    /* free item-list *and* all malloc()ed buffers */
    (void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
    return PyErr_Format(PyExc_TypeError,
	"argument 2: itmlst - item:%d item-code must be string", l_itmlst_idx);
  }

  /* -------------------- */
  /* convert item-code string to PSCAN$_ numerical value */
  l_trn_idx    = 0;
  at_item_code = PyString_AS_STRING(ar_py_item_code);
  while (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_vmsvermin != 0)
  {
    /* check VMS version */
    if ((VMSDEF_GR_$PSCANDEF[l_trn_idx].w_vmsvermin <= vmsdef_gw_vmsver) &&
	(VMSDEF_GR_$PSCANDEF[l_trn_idx].w_vmsvermax >= vmsdef_gw_vmsver)  )
    {
      /* compare item name */
      if (strcmp(at_item_code,VMSDEF_GR_$PSCANDEF[l_trn_idx].at_itmnam_py) == 0)
      {
	/* @@ this must be an INPUT item-code */
	/*  SYS$PROCESS_SCAN does not take any OUTPUT item-codes */
			/* ... */
	/* found textual match - use numerical value of item-code */
	w_item_code = VMSDEF_GR_$PSCANDEF[l_trn_idx].w_itmcod;
	break;				/* leave while() loop */
      } /* item code string match */
    } /* w_vmsvermin / w_vmsvermax match with vmsdef_gw_vmsver */
    l_trn_idx++;				/* check next item code */
  } /* while (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_vmsvermin != 0) */

  /* ---------------------------------------- */
  if (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_vmsvermin == 0)
  {
    /* item code not found - abort */
    /* free item-list *and* all malloc()ed buffers */
    (void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);

    return PyErr_Format(PyExc_ValueError,
	"argument 2: itmlst - unknown item code: %.100s", at_item_code);
  }

  /* ---------------------------------------- */
  /* printf ("@@itm:%s=%d\n", PyString_AS_STRING(ar_py_item_code), (int)w_item_code); */

  /* @@ can be moved into input-item processing */

  /* store numerical item-code into VMS item-list */
  ar_itemlist_ptr->w_itmcod = w_item_code;

  /* ---------------------------------------- */
  /* only process input-items, ignore output-items */
  if (VMSDEF_GR_$PSCANDEF[l_trn_idx].l_flags & ITMTBL_M_ITMINP)
  {
    /* get data portion of the item tuple */
    ar_py_item_data = PyTuple_GetItem(ar_py_item_tuple, 1);
    if (PyErr_Occurred())
    {
      /* free item-list *and* all malloc()ed buffers */
      (void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
      return NULL;
    }

    /* data type */
    if (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys == ITMTYP_K_ASCII)
    {
      /* check data-type with $PSCANDEF */
      if (!PyString_Check(ar_py_item_data))
      {
	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
	return PyErr_Format(PyExc_TypeError,
	    "argument 2: itmlst - item:%d data must be string", l_itmlst_idx);
      }
      /* input item: take length from object */
      /* string length must be <= 65535 to fit into string descr. */
      if (PyString_Size(ar_py_item_data) > 65535)
      {
	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
	return PyErr_Format(PyExc_TypeError,
	 "argument 2: itmlst - item:%d string size limited to 65535 characters",
	 l_itmlst_idx);
      }

      /* allocate a buffer and copy string - this makes it: */
      /*  a) thread-safe */
      /*  b) doesn't require special handling for free() */
      /*  c) no need to take care of Py_INCREF / Py_DECREF */
      ar_itemlist_ptr->itmlst3_a_bufadr =
				malloc (PyString_Size(ar_py_item_data));
      if (ar_itemlist_ptr->itmlst3_a_bufadr == NULL)
      {
	/* Warning! ar_itemlist_ptr->w_bufsiz must be 0 */
	/* for vms_sys__pscan_free(),		*/
	/*  because no buffer was allocated		*/

	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
	return PyErr_NoMemory();
      }

      /* string need be passed 'by reference' */
      ar_itemlist_ptr->w_bufsiz = PyString_Size(ar_py_item_data);

      /* copy string from object to item-list buffer */
      (void) memcpy
		(ar_itemlist_ptr->itmlst3_a_bufadr
		,PyString_AS_STRING(ar_py_item_data)
		,(size_t)ar_itemlist_ptr->w_bufsiz
			);
    } /* ITMTYP_K_ASCII */
    else
    {
      /* ITMTYP_K_ASCIC is not used / supported */

      /* item-type = BWLQO */
	/* size of item types - in PYVMS_GLOBAL.C */
	extern long vmsdef_gl_itmtypsiz[];

	unsigned long	  l_datatypsiz;	/* size of single datatype item */
	unsigned long	  l_data_count;	/* number of items */
	unsigned long     l_data;	/* B/W/L storage */
	unsigned long	  loop;	   /* counter to loop over elements of 1 item */
	char		* ab_data; /* pointer to data elements in 1 item */

	/* size of data type (e.g. W = 2 bytes) of this item */
	/* @@ don't need to mask off ITMTYP_M_USIGN */
	l_datatypsiz = vmsdef_gl_itmtypsiz[VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys];

	/* allocate memory for buffer unless BWL */
	if (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_bufsiz > 4)
	{
	  l_malloc_bytes = (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_bufsiz);
	  ab_data = malloc (l_malloc_bytes);
	  if (ab_data == NULL)
	  {
	    /* Warning! ar_itemlist_ptr->w_bufsiz must be 0 */
	    /* for vms_sys__pscan_free(),		    */
	    /*  because no buffer was allocated		    */

	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
	    return PyErr_NoMemory();
	  }
	  ar_itemlist_ptr->itmlst3_a_bufadr = ab_data;
	  (void) memset (ar_itemlist_ptr->itmlst3_a_bufadr, 0, l_malloc_bytes);

	  /* items bigger than 4 bytes need be passed 'by reference' */
	  ar_itemlist_ptr->w_bufsiz = l_malloc_bytes;
	}
	else
	{
	  /* passed 'by value' (directly inside item-list) */
	  ab_data = (char *)&ar_itemlist_ptr->itmlst3_l_itmval;
	}

	l_data = 0;

	if (
	    (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys == ITMTYP_K_BYTE) ||
	    (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys == ITMTYP_K_WORD) ||
	    (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys == ITMTYP_K_LONG)
	   )
	{
	    if (!PyInt_Check(ar_py_item_data)) /*item-data or item-of-tuple */
	    {
	      /* free item-list *and* all malloc()ed buffers */
	      (void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
	      return PyErr_Format(PyExc_TypeError,
		"argument 2: itmlst - item:%d data must be integer",
		l_itmlst_idx);
	    }

	    /* translate Python integer into C long */
	    l_data = PyInt_AsLong(ar_py_item_data);
	    if (PyErr_Occurred())
	    {
	      /* free item-list *and* all malloc()ed buffers */
	      (void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
	      return NULL;
	    }

	    *(long *)ab_data = l_data;
	} /* w_typ_sys == (ITMTYP_K_BYTE || WORD || LONG */
	else
	{
	  if (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys == ITMTYP_K_QUAD)
	  {
	    /* convert Python long integer object into QUAD */
	    long   l_status;

	    if (!PyLong_Check(ar_py_item_data))
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
		return PyErr_Format(PyExc_TypeError,
		    "argument 2: itmlst - item:%d data must be long integer",
		    l_itmlst_idx);
	    }
	    l_status = vms__cvt_pylong2quad (ar_py_item_data, (long*)ab_data);
	    if (l_status != SS$_NORMAL)
	    {
	      /* free item-list *and* all malloc()ed buffers */
	      (void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
	      return PyErr_Format(PyExc_SystemError,
		"argument 2: itmlst - item:%d vms__cvt_pylong2quad() failed",
		l_itmlst_idx);
	    } /* (w_typ_sys == ITMTYP_K_QUAD) */
	    else
	    {
	      if (VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys == ITMTYP_K_OCTA)
	      {
		/* convert Python long integer object into OCTA */
		long   l_status;

		if (!PyLong_Check(ar_py_item_data))
		{
		  /* free item-list *and* all malloc()ed buffers */
		  (void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
		  return PyErr_Format(PyExc_TypeError,
		      "argument 2: itmlst - item:%d data must be long integer",
		      l_itmlst_idx);
		}
		l_status = vms__cvt_pylong2octa (ar_py_item_data, (long*)ab_data);
		if (l_status != SS$_NORMAL)
		{
		  /* free item-list *and* all malloc()ed buffers */
		  (void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
		  return PyErr_Format(PyExc_SystemError,
		  "argument 2: itmlst - item:%d vms__cvt_pylong2quad() failed",
		  l_itmlst_idx);
		}
	      } /* (w_typ_sys == ITMTYP_K_OCTA) */
	      else
	      {
		/* @@ non-implemented item-type */
		/* free item-list *and* all malloc()ed buffers */
		(void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
		return PyErr_Format(PyExc_SystemError,
		  "argument 2: itmlst - item:%d unable to translate ITMTYP:%d",
		  l_itmlst_idx,
		  (unsigned int)VMSDEF_GR_$PSCANDEF[l_trn_idx].w_typ_sys);
	      } /* else- w_typ_sys == ITMTYP_K_OCTA */
	    } /* else- w_typ_sys == ITMTYP_K_QUAD */
	  } /* else- w_typ_sys == (ITMTYP_K_QUAD */
	} /* else- w_typ_sys == (ITMTYP_K_BYTE || WORD || LONG */
	/*-----*/
    } /* else- itmtyp == ITMTYP_K_ASCII */
    /* ---------------------------------------- */
    /* check if item tuple has a 'flags' component */
    if (PyTuple_Size(ar_py_item_tuple) > 2)
    {
      /* get flags portion of the item tuple */
      ar_py_item_flags = PyTuple_GetItem(ar_py_item_tuple, 2);
      if (PyErr_Occurred())
      {
	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
	return NULL;
      }
      /* flags must be 'integer' */
      if (!PyInt_Check(ar_py_item_flags))
      {
	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);
	return PyErr_Format(PyExc_TypeError,
		"argument 2: itmlst - item:%d item-flags must be integer",
		l_itmlst_idx);
      }
      /* translate Python integer into C long */
      l_flags = PyInt_AsLong(ar_py_item_flags);
      if (PyErr_Occurred())
      {
	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free (ar_itemlist, ar_itm_vmsdef);
	return NULL;
      }
    }
    else
    {
      l_flags = 0;	/* flags was omitted */
    }

    /* store flags in item-list */
    ar_itemlist_ptr->itmlst3_l_itmflg = l_flags;
  } /* (VMSDEF_GR_$PSCANDEF[l_trn_idx].l_flags & ITMTBL_M_ITMINP) */
/*else
/*{
/*  /* an output-element - ignore */
/*}

  /* ---------------------------------------- */
  /* always store pointer to VMSDEF entry for this item-code    */
  /* because this is used in a decision to build the dictionary */
  /* which is returned to Python */
  *ar_itm_vmsdef_ptr = &VMSDEF_GR_$PSCANDEF[l_trn_idx];

  /* ---------------------------------------- */
  ar_itemlist_ptr++;		/* next address of itemlist element  */
  ar_itm_vmsdef_ptr++;		/* next pointer into VMSDEF	     */
} /* for (l_itmlst_idx = 0; l_itmlst_idx < l_itmlst_size; .. */

	/* terminate VMS item-list */
	ar_itemlist_ptr->w_itmcod = 0;
	ar_itemlist_ptr->w_bufsiz = 0;
	/* Note: the other pointers don't need termination	   */
	/* Warning: there is no storage allocated for termination! */

	/* -------------------- */
	l_status = sys$process_scan
		(&l_pidctx 	/* pidctx   */
		,ar_itemlist	/* [itmlst] */
		);

	/* -------------------- */
	/* free item-list *and* all malloc()ed buffers */
	(void) vms_sys__pscan_free(ar_itemlist, ar_itm_vmsdef);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    ar_pidctx = PyInt_FromLong(l_pidctx);	/* define context */
	    return ar_pidctx;
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_process_scan () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_PROCESS_SCAN.C */
