/* VMS_SYS_RENAME.C -- 26-FEB-1999 Uwe Zessin
   Python interface to SYS$RENAME()
*/


#include "python.h"

#include <starlet.h>		/* SYS$name, ... */

#include "vmsobj_fab.h"

/* ------------------------------------------------------------------------- */

char vms_sys_rename__doc[] =
"status = vms_sys.rename (old-fab, [err], [suc], new-fab)\n\
Rename / move Directory entry (RMS).";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_rename (PyObject *self, PyObject *args)
{
	vmsobj_fab		* ar_py_fab_old;
	struct FAB		* ar_vms_fab_old;

	vmsobj_fab		* ar_py_fab_new;
	struct FAB		* ar_vms_fab_new;

	PyObject		* ar_py_err;
	long			* al_err;

	PyObject		* ar_py_suc;
	long			* al_suc;

	unsigned long		  l_status;

	/* -------------------- */
	ar_py_err = Py_None;
	ar_py_suc = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "OOOO",
	    &ar_py_fab_old,
	    &ar_py_err,
	    &ar_py_suc,
	    &ar_py_fab_new ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: old-fab */
	if (! vmsobj_fab_Check(ar_py_fab_old))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 1: old-fab - must be vmsobj_fab object");
	    return NULL;
	}
	ar_vms_fab_old = ar_py_fab_old->ab_fab;

	/* -------------------- */
	/* argument 2: err - ignored */
	al_err = 0;

	/* -------------------- */
	/* argument 3: suc - ignored */
	al_suc = 0;

	/* -------------------- */
	/* argument 4: new-fab */
	if (! vmsobj_fab_Check(ar_py_fab_new))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 4: new-fab - must be vmsobj_fab object");
	    return NULL;
	}
	ar_vms_fab_new = ar_py_fab_new->ab_fab;

	/* -------------------- */
	l_status = sys$rename
		(ar_vms_fab_old	/* old-fab */
		,al_err		/* [err]   */
		,al_suc		/* [suc]   */
		,ar_vms_fab_new	/* new-fab */
		);

	/* -------------------- */
	return PyInt_FromLong(l_status);
} /* vms_sys_rename () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_RENAME.C */
