/* VMS_SYS_SCAN_INTRUSION.C -- 31-MAY-1999 Uwe Zessin
   Python interface to SYS$SCAN_INTRUSION()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */

char vms_sys_scan_intrusion__doc[] =
"status = vms_sys.scan_intrusion (logfail_status,\
 failed_user, job_type, [source_terminal], [source_node], [source_user],\
 [source_addr], [failed_password], [parent_user], [parent_id], [flags])\n\
Scan Intrusion Database.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_scan_intrusion (PyObject *self, PyObject *args)
{
	unsigned long		  l_logfail_status;	/* by ref, not opt. */

	char			* at_failed_user;
	struct dsc$descriptor_s   r_failed_user;
	unsigned long		  l_failed_user_len;

	unsigned long		  l_job_type;		/* by value, not opt. */

	char			* at_source_terminal;
	struct dsc$descriptor_s   r_source_terminal;
	struct dsc$descriptor_s * ar_source_terminal;
	unsigned long		  l_source_terminal_len;

	char			* at_source_node;
	struct dsc$descriptor_s   r_source_node;
	struct dsc$descriptor_s * ar_source_node;
	unsigned long		  l_source_node_len;

	char			* at_source_user;
	struct dsc$descriptor_s   r_source_user;
	struct dsc$descriptor_s * ar_source_user;
	unsigned long		  l_source_user_len;

	char			* at_source_addr;
	struct dsc$descriptor_s   r_source_addr;
	struct dsc$descriptor_s * ar_source_addr;
	unsigned long		  l_source_addr_len;

	char			* at_failed_password;
	struct dsc$descriptor_s   r_failed_password;
	struct dsc$descriptor_s * ar_failed_password;
	unsigned long		  l_failed_password_len;

	char			* at_parent_user;
	struct dsc$descriptor_s   r_parent_user;
	struct dsc$descriptor_s * ar_parent_user;
	unsigned long		  l_parent_user_len;

	PyObject		* ar_parent_id;
	unsigned long		  l_parent_id;	/* by value */

	PyObject		* ar_flags;
	unsigned long		  l_flags;	/* by value */

	unsigned long		  l_status;

	/* -------------------- */
	at_source_terminal = NULL; l_source_terminal_len = 0;
	at_source_node     = NULL; l_source_node_len     = 0;
	at_source_user     = NULL; l_source_user_len     = 0;
	at_source_addr     = NULL; l_source_addr_len     = 0;
	at_failed_password = NULL; l_failed_password_len = 0;
	at_parent_user     = NULL; l_parent_user_len     = 0;
	ar_parent_id       = Py_None;
	ar_flags           = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "ls#l|z#z#z#z#z#z#OO",
	    &l_logfail_status,
	    &at_failed_user,     &l_failed_user_len,
	    &l_job_type,
	    &at_source_terminal, &l_source_terminal_len,
	    &at_source_node,     &l_source_node_len,
	    &at_source_user,     &l_source_user_len,
	    &at_source_addr,     &l_source_addr_len,
	    &at_failed_password, &l_failed_password_len,
	    &at_parent_user,     &l_parent_user_len,
	    &ar_parent_id,
	    &ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: logfail_status */
	/* done by PyArg_ParseTuple() */

	/* -------------------- */
	/* argument 2: failed_user */
	if (at_failed_user == NULL)
	{
	    PyErr_SetString(PyExc_ValueError,
		"argument 2: failed_user - argument is not optional");
	    return NULL;
	}
	if (l_failed_user_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	  "argument 2: failed_user - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_failed_user.dsc$w_length  = l_failed_user_len;
	r_failed_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_failed_user.dsc$b_class   = DSC$K_CLASS_S;
	r_failed_user.dsc$a_pointer = at_failed_user;

	/* -------------------- */
	/* argument 3: job_type */
	/* done by PyArg_ParseTuple() */

	/* -------------------- */
	/* argument 4: source_terminal */
	if (at_source_terminal == NULL)
	{
	    ar_source_terminal = 0;			/* omitted */
	}
	else
	{
	    if (l_source_terminal_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
      "argument 4: source_terminal - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_source_terminal.dsc$w_length  = l_source_terminal_len;
	    r_source_terminal.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_source_terminal.dsc$b_class   = DSC$K_CLASS_S;
	    r_source_terminal.dsc$a_pointer = at_source_terminal;
	    ar_source_terminal = &r_source_terminal;
	}

	/* -------------------- */
	/* argument 5: source_node */
	if (at_source_node == NULL)
	{
	    ar_source_node = 0;			/* omitted */
	}
	else
	{
	    if (l_source_node_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	  "argument 5: source_node - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_source_node.dsc$w_length  = l_source_node_len;
	    r_source_node.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_source_node.dsc$b_class   = DSC$K_CLASS_S;
	    r_source_node.dsc$a_pointer = at_source_node;
	    ar_source_node = &r_source_node;
	}

	/* -------------------- */
	/* argument 6: source_user */
	if (at_source_user == NULL)
	{
	    ar_source_user = 0;			/* omitted */
	}
	else
	{
	    if (l_source_user_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	  "argument 6: source_user - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_source_user.dsc$w_length  = l_source_user_len;
	    r_source_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_source_user.dsc$b_class   = DSC$K_CLASS_S;
	    r_source_user.dsc$a_pointer = at_source_user;
	    ar_source_user = &r_source_user;
	}

	/* -------------------- */
	/* argument 7: source_addr */
	if (at_source_addr == NULL)
	{
	    ar_source_addr = 0;			/* omitted */
	}
	else
	{
	    if (l_source_addr_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	  "argument 7: source_addr - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_source_addr.dsc$w_length  = l_source_addr_len;
	    r_source_addr.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_source_addr.dsc$b_class   = DSC$K_CLASS_S;
	    r_source_addr.dsc$a_pointer = at_source_addr;
	    ar_source_addr = &r_source_addr;
	}

	/* -------------------- */
	/* argument 8: failed_password */
	if (at_failed_password == NULL)
	{
	    ar_failed_password = 0;			/* omitted */
	}
	else
	{
	    if (l_failed_password_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
      "argument 8: failed_password - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_failed_password.dsc$w_length  = l_failed_password_len;
	    r_failed_password.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_failed_password.dsc$b_class   = DSC$K_CLASS_S;
	    r_failed_password.dsc$a_pointer = at_failed_password;
	    ar_failed_password = &r_failed_password;
	}

	/* -------------------- */
	/* argument 9: parent_user */
	if (at_parent_user == NULL)
	{
	    ar_parent_user = 0;			/* omitted */
	}
	else
	{
	    if (l_parent_user_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	  "argument 9: parent_user - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_parent_user.dsc$w_length  = l_parent_user_len;
	    r_parent_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_parent_user.dsc$b_class   = DSC$K_CLASS_S;
	    r_parent_user.dsc$a_pointer = at_parent_user;
	    ar_parent_user = &r_parent_user;
	}

	/* -------------------- */
	/* argument 10: parent_id */
	if (ar_parent_id == Py_None)
	{
	    l_parent_id = 0;	/* omitted, by value */
	}
	else
	{
	    if (!PyInt_Check(ar_parent_id))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 10: parent_id - must be integer or None");
		return NULL;
	    }
	    l_parent_id = PyInt_AsLong(ar_parent_id);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 11: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;	/* omitted, by value */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 11: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* note: P1 is passed by value - the VMS docu is wrong */
	l_status = sys$scan_intrusion
			(l_logfail_status	/* by value */
			,&r_failed_user
			,l_job_type		/* by value */
			,ar_source_terminal
			,ar_source_node
			,ar_source_user
			,ar_source_addr
			,ar_failed_password
			,ar_parent_user
			,l_parent_id		/* by value */
			,l_flags		/* by value */
			);

	return Py_BuildValue ("l", l_status);

} /* vms_sys_scan_intrusion () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SCAN_INTRUSION.C */
