/* VMS_SYS_SET_RESOURCE_DOMAIN.C -- 15-JUL-1999 Uwe Zessin
   Python interface to SYS$SET_RESOURCE_DOMAIN()

*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */

char vms_sys_set_resource_domn__doc[] =
"rsdm_id = vms_sys.set_resource_domain (func, rsdm_id, domain_number,\
 [nullarg], [access], [acmode])\n\
Set Resource Domain.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_set_resource_domain (PyObject *self, PyObject *args)
{
	unsigned long		  l_func;
	unsigned long		  l_rsdm_id;
	unsigned long		  l_domain_number;

	PyObject		* ar_nullarg;

	PyObject		* ar_access;
	unsigned long		  l_access;	/* by value */

	PyObject		* ar_acmode;
	unsigned long		  l_acmode;	/* by value */

	unsigned long		  l_status;

	/* -------------------- */
	ar_nullarg = Py_None;
	ar_access  = Py_None;
	ar_acmode  = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "lll|OOO",
	    &l_func,
	    &l_rsdm_id,
	    &l_domain_number,
	    &ar_nullarg,
	    &ar_access,
	    &ar_acmode ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: func */
	/* -------------------- */
	/* argument 2: rsdm_id */
	/* -------------------- */
	/* argument 3: domain_number */

	/* -------------------- */
	/* argument 4: nullarg */
	/* ignored */

	/* -------------------- */
	/* argument 5: access */
	if (ar_access == Py_None)
	{
	    l_access = 0;	/* omitted, by value */
	}
	else
	{
	    if (!PyInt_Check(ar_access))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: access - must be integer or None");
		return NULL;
	    }
	    l_access = PyInt_AsLong(ar_access);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 6: acmode */
	if (ar_acmode == Py_None)
	{
	    l_acmode = 0;	/* omitted, by value */
	}
	else
	{
	    if (!PyInt_Check(ar_acmode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 6: acmode - must be integer or None");
		return NULL;
	    }
	    l_acmode = PyInt_AsLong(ar_acmode);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$set_resource_domain
			(l_func			/* by value */
			,&l_rsdm_id
			,l_domain_number	/* by value */
			,0			/* [nullarg] */
			,l_access		/* by value */
			,l_acmode		/* by value */
			);

	/* -------------------- */
	return Py_BuildValue ("ll", l_status, l_rsdm_id);

} /* vms_sys_set_resource_domain () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SET_RESOURCE_DOMAIN.C */
