/* VMS_SYS_SET_SECURITY.C -- 04-JUL-1999 Uwe Zessin
   Python interface to SYS$SET_SECURITY()

19-JUL-1999 ZE. -- alternate bits for input/output items
*/

#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for OSS$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$OSSDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"	/* extern vms__itmlst_*() */

/* ------------------------------------------------------------------------- */

char vms_sys_set_security__doc[] =
"dict = vms_sys.set_security (\
[clsnam], [objnam], [objhan], [flags], [itmlst], [contxt] ,[acmode])\n\
Set Security Characteristics.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_set_security (PyObject *self, PyObject *args)
{
	char			* at_clsnam;
	struct dsc$descriptor_s   r_clsnam;
	struct dsc$descriptor_s * ar_clsnam;
	unsigned long		  l_clsnam_len;

	char			* at_objnam;
	struct dsc$descriptor_s   r_objnam;
	struct dsc$descriptor_s * ar_objnam;
	unsigned long		  l_objnam_len;

	PyObject		* ar_objhan;
	unsigned long		  l_objhan;
	unsigned long		* al_objhan;

	PyObject		* ar_flags;
	unsigned long		  l_flags;	/* by-value */

	/* item-list - tuple of strings = ('OSS$_name','OSS$_name',...) */
	PyObject		* ar_py_item_list;

	/* VMS item-list to be passed to SYS$SET_SECURITY() */
	struct vmsdef_xr_itmlst3  * ar_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	  * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	PyObject		* ar_contxt;
	unsigned long		  l_contxt;
	unsigned long		* al_contxt;

	PyObject		* ar_acmode;
	unsigned long		  l_acmode;
	unsigned long		* al_acmode;

	unsigned long		  l_status;
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	at_clsnam       = NULL; l_clsnam_len = 0;
	at_objnam       = NULL; l_objnam_len = 0;
	ar_objhan       = Py_None;
	ar_flags        = Py_None;
	ar_py_item_list = Py_None;
	ar_contxt       = Py_None;
	ar_acmode       = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|z#z#OOOOO",
	    &at_clsnam, &l_clsnam_len,
	    &at_objnam, &l_objnam_len,
	    &ar_objhan,
	    &ar_flags,
	    &ar_py_item_list,
	    &ar_contxt,
	    &ar_acmode ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: clsnam */
	if (at_clsnam == NULL)
	{
	    ar_clsnam = 0;		/* omitted */
	}
	else
	{
	    if (l_clsnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 1: clsnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_clsnam.dsc$w_length  = l_clsnam_len;
	    r_clsnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_clsnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_clsnam.dsc$a_pointer = at_clsnam;
	    ar_clsnam = &r_clsnam;
	}

	/* -------------------- */
	/* argument 2: objnam */
	if (at_objnam == NULL)
	{
	    ar_objnam = 0;		/* omitted */
	}
	else
	{
	    if (l_objnam_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	       "argument 2: objnam - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up descriptor */
	    r_objnam.dsc$w_length  = l_objnam_len;
	    r_objnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_objnam.dsc$b_class   = DSC$K_CLASS_S;
	    r_objnam.dsc$a_pointer = at_objnam;
	    ar_objnam = &r_objnam;
	}

	/* -------------------- */
	/* argument 3: objhan */
	if (ar_objhan == Py_None)
	{
	    al_objhan = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_objhan))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: objhan - must be integer or None");
		return NULL;
	    }
	    l_objhan = PyInt_AsLong(ar_objhan);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_objhan = &l_objhan;
	}

	/* -------------------- */
	/* argument 4: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;		/* omitted, by-value */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 5: itmlst -- is checked below */

	/* -------------------- */
	/* argument 6: contxt */
	if (ar_contxt == Py_None)
	{
	    al_contxt = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_contxt))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 6: contxt - must be integer or None");
		return NULL;
	    }
	    l_contxt = PyInt_AsLong(ar_contxt);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_contxt = &l_contxt;
	}

	/* -------------------- */
	/* argument 7: acmode */
	if (ar_acmode == Py_None)
	{
	    al_acmode = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_acmode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 7: acmode - must be integer or None");
		return NULL;
	    }
	    l_acmode = PyInt_AsLong(ar_acmode);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_acmode = &l_acmode;
	}

	/* -------------------- -------------------- */
	/* argument 5: itmlst */
	if (ar_py_item_list == Py_None)
	{
	    ar_itemlist = 0;		/* omitted */
	}
	else
	{
	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_build
			/* re-use bits from $TRNLNM */
		(ITMTBL_M_ITMITL		/* input-item bit    */
		,0 /* ITMTBL_M_ITMOTL */	/* output-item bit   */
		,&VMSDEF_GR_$OSSDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	l_status = sys$set_security
		(ar_clsnam
		,ar_objnam
		,al_objhan
		,l_flags	/* by-value */
		,ar_itemlist
		,al_contxt
		,al_acmode
		);

	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* return 'objhan' if it was supplied as argument */
	if (al_objhan != 0)
	{
	    ar_dictobj = PyInt_FromLong(l_objhan);
	    if (ar_dictobj == NULL)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		Py_DECREF(ar_dict);
		return NULL;
	    }
	    if (PyDict_SetItemString(ar_dict, "objhan", ar_dictobj) < 0)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		Py_DECREF(ar_dict);
		Py_DECREF(ar_dictobj);
		return NULL;
	    }
	    Py_DECREF(ar_dictobj);
	}

	/* -------------------- */
	/* return 'contxt' if it was supplied as argument */
	if (al_contxt != 0)
	{
	    ar_dictobj = PyInt_FromLong(l_contxt);
	    if (ar_dictobj == NULL)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		Py_DECREF(ar_dict);
		return NULL;
	    }
	    if (PyDict_SetItemString(ar_dict, "contxt", ar_dictobj) < 0)
	    {
		/* free item-list *and* all malloc()ed buffers */
		(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		Py_DECREF(ar_dict);
		Py_DECREF(ar_dictobj);
		return NULL;
	    }
	    Py_DECREF(ar_dictobj);
	}

	/* -------------------- */
	/* build remaining items only if system service returned 'success' */
	if (ar_py_item_list != Py_None)
	{
/*	  if (l_status == SS$_NORMAL)
/*	  {
/*	    PyObject * ar_xxx;
/*
/*	    ar_xxx = vms__itmlst_outprc
/*		(ITMTBL_M_ITMOTL		/* output-item bit   */
/*		,&VMSDEF_GR_$OSSDEF		/* VMSDEF_GR_$xxxDEF */
/*		,&ar_itemlist		/* return VMS item list           */
/*		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
/*		,&aw_retlenlist		/* return VMS itmlst retlen array */
/*		,ar_dict	/* is modified! */
/*		);
/*
/*	    if (ar_xxx == NULL)
/*	    {
/*		return NULL;		/* item list build failed */
/*	    }
/*	  }
*/	  /* free item-list *and* all malloc()ed buffers */
	  (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* -------------------- */
	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_set_security () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SET_SECURITY.C */
