/* VMS_SYS_SETDFPROT.C -- 01-JAN-1999 Uwe Zessin
   Python interface to SYS$SETDFPROT()

   04-FEB-1999 ZE. -- updates for Alpha after long developement phase on VAX
*/

/* ------------------------------------------------------------ */

#include "python.h"
#include "vmsdef.h"

#include <rmsdef.h>		/* RMS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

#ifndef __ALPHA		/* sys$setddir defined in Alpha/DEC C V5.2 */
#ifdef __DECC
#ifndef __DECC_VER	/* don't know if this is defined in all versions ... */
#define __DECC_VER 0
#endif /* __DECC_VER */
#if __DECC_VER < 50600000 /* @@ might need to change for newer version */
#ifndef __unknown_params
#define __unknown_params ...
#endif
#pragma __nostandard	  /* non-ANSI-Standard feature */
extern unsigned long sys$setdfprot(__unknown_params);
#pragma __standard
#endif /* __DECC_VER < 50600000 */
#endif /* __DECC */
#endif /* __ALPHA */
/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* exception object in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_setdfprot__doc[] =
"cur-def-prot = vms_sys.setdfprot ([new-def-prot])\n\
Set Default File Protection.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_setdfprot (PyObject *self, PyObject *args)
{
	unsigned short int	  w_cur_def_prot;

	PyObject		* ar_new_def_prot;
	unsigned long		  l_new_def_prot;
	unsigned short int	  w_new_def_prot;
	unsigned short int	* aw_new_def_prot;

	unsigned long		  l_status;

	/* -------------------- */
	ar_new_def_prot = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|O", &ar_new_def_prot))
	{
	    return NULL;
	}

	/* -------------------- */
	if (ar_new_def_prot == Py_None)
	{
	    aw_new_def_prot = 0;
	}
	else
	{
	    if (!PyInt_Check(ar_new_def_prot))
	    {
		PyErr_SetString(PyExc_TypeError,
	 "argument 1: new-def-prot - must be positive 16-bit integer or None");
		return NULL;
	    }

	    l_new_def_prot = PyInt_AsLong(ar_new_def_prot);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_new_def_prot > 65535)
	    {
		PyErr_SetString(PyExc_TypeError,
	 "argument 1: new-def-prot - must be positive 16-bit integer or None");
		return NULL;
	    }

	    w_new_def_prot  = l_new_def_prot;
	    aw_new_def_prot = &w_new_def_prot;
	}
	/* -------------------- */
	l_status = sys$setdfprot (aw_new_def_prot, &w_cur_def_prot);

	/* -------------------- */
	if (l_status == RMS$_NORMAL) /* not SS$_NORMAL ! */
	{
	    return PyInt_FromLong((unsigned long)w_cur_def_prot);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_setdfprot () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SETDFPROT.C */
