/* VMS_SYS_SETPRV.C -- 27-NOV-1998 Uwe Zessin
   Python interface to SYS$SETPRV()
*/

/* ------------------------------------------------------------ */

#include "python.h"
#include "vmsdef.h"

#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */
/* function prototypes for external routines */

/* ------------------------------ */
/* input a binary quadword - output a Python long integer */
extern PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------ */
/* input a Python long integer - output a binary quadword */
extern long vms__cvt_pylong2quad (PyObject * r_longint, long * q_quadword);

/* ------------------------------------------------------------------------- */

char vms_sys_setprv__doc[] =
"prvprv = vms_sys.setprv ([enbflg] [,prvadr] [,prmflg])\n\
Set Privileges.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_setprv (PyObject *self, PyObject *args)
{
	PyObject		* ar_enbflg;
	unsigned long		  l_enbflg;

	PyObject		* ar_prmflg;
	unsigned long		  l_prmflg;

	PyObject		* ar_prvadr;
	long			  q_prvadr[2];
	long			* aq_prvadr;

	PyObject		* ar_prvprv;
	long			  q_prvprv[2];

	unsigned long		  l_status;

	/* -------------------- */
	ar_enbflg = Py_None;	/* defaults */
	ar_prvadr = Py_None;
	ar_prmflg = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "|OOO",
	    &ar_enbflg, &ar_prvadr, &ar_prmflg))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: enbflg */
	if (ar_enbflg == Py_None)
	{
	    l_enbflg = 0;
	}
	else
	{
	    if (!PyInt_Check(ar_enbflg))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: enbflg - must be integer or None");
		return NULL;
	    }
	    l_enbflg = PyInt_AsLong(ar_enbflg);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 2: prvadr */
	if (ar_prvadr == Py_None)
	{
	    aq_prvadr = 0;
	}
	else
	{
	    if (!PyLong_Check(ar_prvadr))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: prvadr - must be long integer or None");
		return NULL;
	    }
	    l_status = vms__cvt_pylong2quad (ar_prvadr, &q_prvadr[0]);
	    if (l_status != SS$_NORMAL)
	    {
		return NULL;		/* error string has been set */
	    }
	    aq_prvadr = &q_prvadr[0];
	}

	/* -------------------- */
	/* argument 3: prmflg */
	if (ar_prmflg == Py_None)
	{
	    l_prmflg = 0;
	}
	else
	{
	    if (!PyInt_Check(ar_prmflg))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: prmflg - must be integer or None");
		return NULL;
	    }
	    l_prmflg = PyInt_AsLong(ar_prmflg);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	l_status = sys$setprv
		(l_enbflg	/* by value */
		,aq_prvadr
		,l_prmflg	/* by value */
		,&q_prvprv
		);

	/* -------------------- */
	if ( (l_status == SS$_NORMAL) || (l_status == SS$_NOTALLPRIV) )
	{
	    ar_prvprv = vms__cvt_quad2pylong (&q_prvprv[0]);
	    if (ar_prvprv == NULL)
	    {
		return NULL;
	    }

	    return Py_BuildValue ("lO", l_status, ar_prvprv);
	} /* (l_status == ...) */

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_setprv () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SETPRV.C */
