/* VMS_SYS_SETUAI.C -- 16-SEP-1998 Uwe Zessin
   Python interface to SYS$SETUAI()

   29-DEC-1998 ZE. -- table VMSDEF_GR_$UAIDEF was changed for unsigned integers
			on output items (SYS$GETUAI)
   10-JAN-1999 ZE. -- modify to use common item-list routines
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for UAI$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$UAIDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_setuai__doc[] =
"vms_sys.setuai (None, [contxt], usrnam, itmlst [,None] [,None] [,None])\n\
Set User Authorization Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_setuai (PyObject *self, PyObject *args)
{
	PyObject		* ar_arg1;

	PyObject		* ar_contxt;
	unsigned long		  l_contxt;
	unsigned long		* al_contxt;

	char			* at_usrnam;
	struct dsc$descriptor_s   r_usrnam;
	unsigned long		  l_usrnam_len;

	/* item-list - tuple of tuples:                    */
	/*  ( ('UAI$_name',data), ('UAI$_name',data), ...) */
	PyObject		* ar_py_item_list;

	PyObject		* ar_arg5;
	PyObject		* ar_arg6;
	PyObject		* ar_arg7;

	/* item tuple - ('UAI$_name',data) */
	PyObject		* ar_py_item_tuple;	/* item tuple */

	/* VMS item-list to be passed to SYS$SETUAI() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for input-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	unsigned long		  l_status;
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into "   */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "OOs#O|OOO",
	    &ar_arg1, &ar_contxt, &at_usrnam, &l_usrnam_len,
	    &ar_py_item_list, &ar_arg5, &ar_arg6, &ar_arg7))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: nullarg - ignore */
	/* argument 5 - 7: nullarg - ignore */

	/* -------------------- */
	/* argument 2: contxt */
	if (ar_contxt == Py_None)
	{
	    al_contxt = 0;		/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_contxt))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: contxt - must be integer or None");
		return NULL;
	    }
	    l_contxt  = PyInt_AsLong(ar_contxt);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_contxt = &l_contxt;
	}

	/* -------------------- */
	/* argument 3: usrnam */
	if (l_usrnam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 3: usrnam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_usrnam.dsc$w_length  = l_usrnam_len;
	r_usrnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_usrnam.dsc$b_class   = DSC$K_CLASS_S;
	r_usrnam.dsc$a_pointer = at_usrnam;

	/* -------------------- */
	/* argument 4: itmlst */
	if (!PyTuple_Check(ar_py_item_list))
	{
	    PyErr_SetString(PyExc_TypeError,
		"argument 4: itmlst - must be tuple of tuples");
	    return NULL;
	}
	else
	{
	    PyObject * ar_xxx;

	    /* SYS$SETUAI currently (V6.1) does not have any output-items */
	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,0 /* ITMTBL_M_ITMOUT */	/* output-item bit   */
		,&VMSDEF_GR_$UAIDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	}

	/* -------------------- */
	l_status = sys$setuai
		(0		/* [nullarg] */
		,al_contxt 	/* [contxt]  */
		,&r_usrnam	/* usrnam    */
		,ar_itemlist	/* itmlst    */
		,0		/* [nullarg] */
		,0		/* [nullarg] */
		,0		/* [nullarg] */
		);

	/* -------------------- */
	/* create a dictionary to return a varying number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	PyDict_SetItemString(ar_dict, "status", ar_dictobj); /* @@ERRCHK */
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* currently, on OpenVMS VAX V6.1, there are no output-item */
	/* -------------------- */
	/* free item-list *and* all malloc()ed buffers */
	(void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);

	/* -------------------- */
	/* return 'contxt' if it was supplied as argument 2 */
	if (al_contxt != 0)
	{
	    ar_dictobj = PyInt_FromLong(l_contxt);
	    if (ar_dictobj == NULL)
	    {
		Py_DECREF(ar_dict);
		return NULL;
	    }
	    PyDict_SetItemString(ar_dict, "contxt", ar_dictobj); /* @@chkerr */
	    Py_DECREF(ar_dictobj);
	}

	/* -------------------- */
	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_setuai () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SETUAI.C */
