/* VMS_SYS_SHOW_INTRUSION.C -- 01-JUN-1999 Uwe Zessin
   Python interface to SYS$SHOW_INTRUSION()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* input a binary quadword - output a Python long integer */
PyObject * vms__cvt_quad2pylong (long q_quadword[2]);

/* ------------------------------------------------------------------------- */

typedef struct xr_breakin_block
{
	unsigned short int	w_type;
	unsigned short int	w_flags;
	unsigned long		l_count;
	long			q_time[2];
} xr_breakin_block;

/* ------------------------------------------------------------------------- */

char vms_sys_show_intrusion__doc[] =
"status, intruder, breakin_block, context = vms_sys.show_intrusion\
 (user_criteria, [flags], [context])\n\
Show Intrusion Information.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_show_intrusion (PyObject *self, PyObject *args)
{
	char			* at_user_criteria;
	struct dsc$descriptor_s   r_user_criteria;
	unsigned long		  l_user_criteria_len;

	char			* at_intruder;
	struct dsc$descriptor_s   r_intruder;
	unsigned long		  l_intruder_len;

	struct xr_breakin_block	  r_breakin_block;
	PyObject		* ar_time; /* Q_TIME component */

	PyObject		* ar_flags;
	unsigned long		  l_flags;	/* by value */

	PyObject		* ar_context;
	unsigned long		  l_context;
	unsigned long		* al_context;

	unsigned long		  l_status;
	PyObject		* ar_return;

	/* -------------------- */
	at_user_criteria = NULL;    l_user_criteria_len = 0;
	ar_flags         = Py_None;
	ar_context       = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#|OO",
	    &at_user_criteria, &l_user_criteria_len,
	    &ar_flags,
	    &ar_context ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: user_criteria */
	if (at_user_criteria == NULL)
	{
	    PyErr_SetString(PyExc_ValueError,
		"argument 1: user_criteria - argument is not optional");
	    return NULL;
	}
	if (l_user_criteria_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	"argument 1: user_criteria - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_user_criteria.dsc$w_length  = l_user_criteria_len;
	r_user_criteria.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_user_criteria.dsc$b_class   = DSC$K_CLASS_S;
	r_user_criteria.dsc$a_pointer = at_user_criteria;

	/* -------------------- */
	/* argument 2: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;	/* omitted, by value */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 2: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 3: context */
	if (ar_context == Py_None)
	{
	    al_context = 0;	/* omitted */
	    l_context  = 0;	/* however always returned */
	}
	else
	{
	    if (!PyInt_Check(ar_context))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 3: context - must be integer or None");
		return NULL;
	    }
	    l_context = PyInt_AsLong(ar_context);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_context = &l_context;
	}

	/* -------------------- */
	/* allocate memory */
#define S_INTRUDER 1058
	at_intruder = malloc (S_INTRUDER);
	if (at_intruder == NULL)
	{
	    (void) PyErr_NoMemory();
	    return NULL;
	}
	l_intruder_len = 0;
	r_intruder.dsc$w_length  = S_INTRUDER;
	r_intruder.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_intruder.dsc$b_class   = DSC$K_CLASS_S;
	r_intruder.dsc$a_pointer = at_intruder;

	(void) memset (&r_breakin_block, 0, sizeof(r_breakin_block));

	/* -------------------- */
	l_status = sys$show_intrusion
			(&r_user_criteria
			,&r_intruder
			,&l_intruder_len
			,&r_breakin_block
			,l_flags		/* by value */
			,al_context
			);

	/* -------------------- */
	/* convert quadword to Python long integer */
	ar_time = vms__cvt_quad2pylong (&r_breakin_block.q_time[0]);
	if (ar_time == NULL)
	{
	    /* error text has been set, release malloc()ed memory */
	    (void) free (at_intruder);
	    return NULL;
	}

	ar_return = Py_BuildValue ("ls#(lllO)l",
	    l_status,
	    at_intruder, l_intruder_len,
	      (unsigned int)r_breakin_block.w_type,
	      (unsigned int)r_breakin_block.w_flags,
	      (unsigned int)r_breakin_block.l_count,
	      ar_time,
	    l_context );
	/* ar_return can be NULL on error, but this is just returned */

	(void) free (at_intruder);

	return ar_return;

} /* vms_sys_show_intrusion () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SHOW_INTRUSION.C */
