/* VMS_SYS_SNDJBCW.C -- 17-MAR-1999 Uwe Zessin
   Python interface to SYS$SNDJBCW()

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()

Note: the [astadr] and [astprm] arguments are not implemented.
*/


#include "python.h"
#include "vmsdef.h"
#include "vmsobj_iosb.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern vmsdef_xw_vmsver vmsdef_gw_vmsver;
/* ------------------------------------------------------------------------- */
/* reference to translation table for SJC$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$SJCDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_sndjbcw__doc[] =
"vms_sys.sndjbcw ([efn], func, [nullarg], [itmlst], [iosb], [astadr], [astprm])\n\
Send to Job Controller.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_sndjbcw (PyObject *self, PyObject *args)
{
	PyObject		* ar_efn;
	unsigned long		  l_efn;	/* BY VALUE */

	char			* at_func;
	unsigned long		  l_func_len;
	unsigned short int	  w_func;

	unsigned long		  l_function_code;
	unsigned long		  l_trn_index;

	PyObject		* ar_nullarg3;	/* @@ ignored */

	/* item-list - tuple of strings = ('SJC$_name','SJC$_name',...) */
	PyObject		* ar_py_item_list;

	/* VMS item-list to be passed to SYS$SNDJBCW() */
	struct vmsdef_xr_itmlst3  * ar_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	  * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */

	vmsobj_iosb		* ar_py_iosb;
	long			* aq_vms_iosb;

	PyObject		* ar_astadr;	/* @@ ignored */
	PyObject		* ar_astprm;	/* @@ ignored */

	unsigned long		  l_status;
	PyObject		* ar_dict;	/* dictionary to be returned */
	PyObject		* ar_dictobj;	/* temp. for insert into " */

	/* -------------------- */
	ar_nullarg3     = Py_None;	/* @@ ignored */
	ar_py_item_list = Py_None;
	ar_py_iosb      = (vmsobj_iosb *)Py_None;
	ar_astadr       = Py_None;	/* @@ ignored */
	ar_astprm       = Py_None;	/* @@ ignored */

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "Os#|OOOOO",
	    &ar_efn,
	    &at_func, &l_func_len,
	    &ar_nullarg3,
	    &ar_py_item_list,
	    &ar_py_iosb,
	    &ar_astadr,
	    &ar_astprm ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: efn */
	if (ar_efn == Py_None)
	{
	    l_efn = 0;			/* omitted - BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_efn))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: efn - must be integer or None");
		return NULL;
	    }
	    l_efn = PyInt_AsLong(ar_efn);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* argument 3: func */
	/* convert function-code string to SJC$_ numerical value */
	w_func = 0;
	l_trn_index = 0;
	while (VMSDEF_GR_$SJCDEF[l_trn_index].w_vmsvermin != 0)
	{
	  /* check VMS version */
	  if ((VMSDEF_GR_$SJCDEF[l_trn_index].w_vmsvermin <= vmsdef_gw_vmsver) &&
	      (VMSDEF_GR_$SJCDEF[l_trn_index].w_vmsvermax >= vmsdef_gw_vmsver)  )
	  {
	    if (strcmp(at_func,VMSDEF_GR_$SJCDEF[l_trn_index].at_itmnam_py)
		== 0)
	    {
		/* check if item is really a function code - item 'R' */
		if (! (VMSDEF_GR_$SJCDEF[l_trn_index].l_flags &
			ITMTBL_M_SNDJBC_FNCREQ)
		   )
		{
		    /* wrong type of function code - abort */
		    return PyErr_Format(PyExc_ValueError,
			"argument 2: not a valid function code: %.100s",
			at_func);
		}
		/* found textual match - use numerical value of function-code */
		w_func = VMSDEF_GR_$SJCDEF[l_trn_index].w_itmcod;
		break;
	    }
	  }
	  l_trn_index++;			/* check next function code */
	}

	/* -------------------- */
	if (VMSDEF_GR_$SJCDEF[l_trn_index].w_vmsvermin == 0)
	{
	    /* function code not found - abort */
	    return PyErr_Format(PyExc_ValueError,
		"argument 2: invalid function code: %.100s", at_func);
	}
	/* function code is in 'w_func' */

	/* -------------------- */
	/* argument 3: nullarg - is ignored */

	/* -------------------- */
	/* argument 4: itmlst */
	if (ar_py_item_list == Py_None)
	{
	    ar_itemlist   = 0;		/* omitted */
	    ar_itm_vmsdef = 0;
	    aw_retlenlist = 0;
	}
	else
	{
	    if (!PyTuple_Check(ar_py_item_list))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: itmlst - must be a tuple of tuples/strings");
		return NULL;
	    }
	    else
	    {
	      PyObject * ar_xxx;

	      ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMINP		/* input-item bit    */
		,ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$SJCDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	      if (ar_xxx == NULL)
	      {
		return NULL;		/* item list build failed */
	      }
	    }
	}

	/* -------------------- */
	/* argument 5: iosb */
	if (ar_py_iosb == (vmsobj_iosb *)Py_None)
	{
	    /* create a new vmsobj_iosb object */
	    ar_py_iosb = vmsobj_iosb_new (NULL);
	    if (ar_py_iosb == NULL)
	    {
	      /* free item-list *and* all malloc()ed buffers */
	      (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	      return NULL;
	    }
	}
	else
	{
	    if (!vmsobj_iosb_Check(ar_py_iosb))
	    {
	        /* free item-list *and* all malloc()ed buffers */
	        (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
		PyErr_SetString(PyExc_TypeError,
		    "argument 5: iosb - must be vmsobj_iosb or None");
		return NULL;
	    }
	}
	aq_vms_iosb = ar_py_iosb->aq_iosb;

	/* -------------------- */
	/* argument 6: astadr - @@ ignored */

	/* -------------------- */
	/* argument 7: astprm - @@ ignored */

	/* -------------------- */
	l_status = sys$sndjbcw
		(l_efn		/* [efn] - BY VALUE */
		,w_func		/* func		    */
		,0		/* [nullarg] @@ ignored */
		,ar_itemlist	/* itmlst	    */
		,aq_vms_iosb	/* [iosb]	    */
		,0		/* [astadr] @@ ignored */
		,0		/* [astprm] @@ ignored */
		);

	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	if (PyDict_SetItemString(ar_dict, "status", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* return 'iosb' */
	ar_dictobj = (PyObject *)ar_py_iosb;
	Py_INCREF (ar_dictobj);
	if (PyDict_SetItemString(ar_dict, "iosb", ar_dictobj) < 0)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    Py_DECREF(ar_dictobj);
	    return NULL;
	}
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* build remaining items only if system service returned 'success' */
	if (l_status == SS$_NORMAL)
	{
	  /* check if item list was specified */
	  if (ar_itemlist != 0)
	  {

	    PyObject * ar_xxx;

	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOUT		/* output-item bit   */
		,&VMSDEF_GR_$SJCDEF		/* VMSDEF_GR_$xxxDEF */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	  }
	}

	/* -------------------- */
	/* check if item list was specified */
	if (ar_itemlist != 0)
	{
	  /* free item-list *and* all malloc()ed buffers */
	  (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* -------------------- */
	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_sndjbcw () */

/* ------------------------------------------------------------------------- */

/* ----------

# memory-leak test 1:
...
---------- */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_SNDJBCW.C */
