/* VMS_SYS_TRNLNM.C -- 28-NOV-1998 Uwe Zessin
   Python interface to SYS$TRNLNM()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
/* reference to translation table for LNM$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$LNMDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

char vms_sys_trnlnm__doc[] =
"dict = vms_sys.trnlnm ([attr], tabnam, lognam [,acmode] [,itmlst])\n\
Translate Logical Name.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_trnlnm (PyObject *self, PyObject *args)
{
	PyObject		* ar_attr;
	unsigned long		  l_attr;
	unsigned long		* al_attr;

	char			* at_tabnam;
	struct dsc$descriptor_s   r_tabnam;
	unsigned long		  l_tabnam_len;

	char			* at_lognam;
	struct dsc$descriptor_s   r_lognam;
	unsigned long		  l_lognam_len;

	PyObject		* ar_acmode;
	unsigned long		  l_acmode;
	unsigned char		  b_acmode;
	unsigned char		* ab_acmode;

	/* item-list - tuple of tuples:                    */
	/*  ( ('LNM$_name',data), ('LNM$_name',data), ...) */
	PyObject		* ar_py_item_list;

	/* VMS item-list to be passed to SYS$TRNLNM() */
	struct vmsdef_xr_itmlst3 * ar_itemlist;		/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	 * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for input-item processing */
	struct vmsdef_xr_itmtbl * * ar_itm_vmsdef;	/* start address */

	PyObject		* ar_dictobj;
	PyObject		* ar_dict;

	unsigned long		  l_status;

	/* -------------------- */
	ar_acmode       = Py_None;
	ar_py_item_list = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "Os#s#|OO",
	    &ar_attr,
	    &at_tabnam, &l_tabnam_len,
	    &at_lognam, &l_lognam_len,
	    &ar_acmode,
	    &ar_py_item_list ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: attr */
	if (ar_attr == Py_None)
	{
	    al_attr = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_attr))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 1: attr - must be integer or None");
		return NULL;
	    }
	    l_attr  = PyInt_AsLong(ar_attr);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    al_attr = &l_attr;
	}
	/* -------------------- */
	/* argument 2: tabnam */
	if (l_tabnam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 2: tabnam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_tabnam.dsc$w_length  = l_tabnam_len;
	r_tabnam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_tabnam.dsc$b_class   = DSC$K_CLASS_S;
	r_tabnam.dsc$a_pointer = at_tabnam;

	/* -------------------- */
	/* argument 3: lognam */
	if (l_lognam_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	       "argument 3: lognam - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_lognam.dsc$w_length  = l_lognam_len;
	r_lognam.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_lognam.dsc$b_class   = DSC$K_CLASS_S;
	r_lognam.dsc$a_pointer = at_lognam;

	/* -------------------- */
	/* argument 4: acmode */
	if (ar_acmode == Py_None)
	{
	    ab_acmode = 0;	/* omitted */
	}
	else
	{
	    if (!PyInt_Check(ar_acmode))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: acmode - must be 8-bit integer or None");
		return NULL;
	    }
	    l_acmode = PyInt_AsLong(ar_acmode);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	    if (l_acmode > 255)
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: acmode - must be 8-bit integer or None");
		return NULL;
	    }
	    b_acmode  = (unsigned char)l_acmode;
	    ab_acmode = &b_acmode;
	}

	/* -------------------- */
	/* argument 5: itmlst */
	if (ar_py_item_list == Py_None)
	{
	    ar_itemlist = 0;			/* omitted */
	}
	else
	{
	    PyObject * ar_xxx; /* @@ ?? */

	    /* a different in/output-item mask because codes collide */
	    ar_xxx = vms__itmlst_build
		(ITMTBL_M_ITMITL	/* input-item bit    */
		,ITMTBL_M_ITMOTL	/* output-item bit   */
		,&VMSDEF_GR_$LNMDEF		/* VMSDEF_GR_$xxxDEF */
		,ar_py_item_list		/* Python itmlst obj */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	} /* else - (ar_py_item_list == Py_None) */

	/* -------------------- */
	l_status = sys$trnlnm
			(al_attr
			,&r_tabnam
			,&r_lognam
			,ab_acmode
			,ar_itemlist
			);

	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */
	/* always return the status code */
	ar_dictobj = PyInt_FromLong(l_status);
	if (ar_dictobj == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	    Py_DECREF(ar_dict);
	    return NULL;
	}
	PyDict_SetItemString(ar_dict, "status", ar_dictobj); /* @@ errchk */
	Py_DECREF(ar_dictobj);

	/* -------------------- */
	/* build remaining items only if system service returned 'success' */
	if (l_status == SS$_NORMAL)
	{
	  /* process item-list only if it was specified */
	  if (ar_py_item_list != Py_None)
	  {
	    PyObject * ar_xxx;

	    /* a different output-item mask because codes collide with $CRELNM*/
	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOTL	/* output-item bit   */
		,&VMSDEF_GR_$LNMDEF		/* VMSDEF_GR_$xxxDEF */
		,&ar_itemlist		/* return VMS item list           */
		,&ar_itm_vmsdef		/* return VMSDEF back-ptr array   */
		,&aw_retlenlist		/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }
	  }
	}

	/* -------------------- */
	if (ar_py_item_list != Py_None)
	{
	  /* free item-list *and* all malloc()ed buffers */
	  (void) vms__itmlst_free(ar_itemlist, ar_itm_vmsdef, aw_retlenlist);
	}

	/* -------------------- */
	/* done, return to Python with the dictionary */
	return ar_dict;

} /* vms_sys_trnlnm () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_TRNLNM.C */
