/* VMS_SYS_VERIFY_PROXY.C -- 21-JAN-1998 Uwe Zessin
   Python interface to SYS$VERIFY_PROXY()
*/


#include "python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <ssdef.h>		/* SS$_name	 */
#include <starlet.h>		/* SYS$name, ... */

/* ------------------------------------------------------------------------- */
extern PyObject *vms_sys_gr_error;	/* in VMS_SYS.C */
/* ------------------------------------------------------------------------- */

char vms_sys_verify_proxy__doc[] =
"local_user = vms_sys.verify_proxy \
(rem_node, rem_user, [proposed_user] [,flags])\n\
Verify a Proxy.";

/* ------------------------------------------------------------------------- */

PyObject *
vms_sys_verify_proxy (PyObject *self, PyObject *args)
{
	char			* at_rem_node;
	struct dsc$descriptor_s   r_rem_node;
	unsigned long		  l_rem_node_len;

	char			* at_rem_user;
	struct dsc$descriptor_s   r_rem_user;
	unsigned long		  l_rem_user_len;

	char			* at_proposed_user;
	struct dsc$descriptor_s   r_proposed_user;
	struct dsc$descriptor_s * ar_proposed_user;
	unsigned long		  l_proposed_user_len;

	PyObject		* ar_flags;
	unsigned long		  l_flags;

#define S_LOCAL_USER 32
	char			  t_local_user[S_LOCAL_USER];
	struct dsc$descriptor_s   r_local_user;
	unsigned short int	  w_local_user_length;

	unsigned long		  l_status;

	/* -------------------- */
	at_proposed_user = NULL;
	ar_flags	 = Py_None;

	/* -------------------- */
	if (!PyArg_ParseTuple(args, "s#s#|z#O",
	    &at_rem_node,      &l_rem_node_len,
	    &at_rem_user,      &l_rem_user_len,
	    &at_proposed_user, &l_proposed_user_len,
	    &ar_flags ))
	{
	    return NULL;
	}

	/* -------------------- */
	/* argument 1: rem_node */
	if (l_rem_node_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 1: rem_node - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_rem_node.dsc$w_length  = l_rem_node_len;
	r_rem_node.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_rem_node.dsc$b_class   = DSC$K_CLASS_S;
	r_rem_node.dsc$a_pointer = at_rem_node;

	/* -------------------- */
	/* argument 2: rem_user */
	if (l_rem_user_len > 65535)
	{
	    PyErr_SetString(PyExc_ValueError,
	     "argument 2: rem_user - string size limited to 65535 characters");
	    return NULL;
	}
	/* set up string descriptor */
	r_rem_user.dsc$w_length  = l_rem_user_len;
	r_rem_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_rem_user.dsc$b_class   = DSC$K_CLASS_S;
	r_rem_user.dsc$a_pointer = at_rem_user;

	/* -------------------- */
	/* argument 3: proposed_user */
	if (at_proposed_user == NULL)
	{
	    ar_proposed_user = 0;	/* omitted */
	}
	else
	{
	    if (l_proposed_user_len > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
	"argument 3: proposed_user - string size limited to 65535 characters");
		return NULL;
	    }
	    /* set up string descriptor */
	    r_proposed_user.dsc$w_length  = l_proposed_user_len;
	    r_proposed_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	    r_proposed_user.dsc$b_class   = DSC$K_CLASS_S;
	    r_proposed_user.dsc$a_pointer = at_proposed_user;
	    ar_proposed_user = &r_proposed_user;
	}

	/* -------------------- */
	/* argument 4: flags */
	if (ar_flags == Py_None)
	{
	    l_flags = 0;	/* omitted, BY VALUE */
	}
	else
	{
	    if (!PyInt_Check(ar_flags))
	    {
		PyErr_SetString(PyExc_TypeError,
		    "argument 4: flags - must be integer or None");
		return NULL;
	    }
	    l_flags = PyInt_AsLong(ar_flags);
	    if (PyErr_Occurred())
	    {
		return NULL;
	    }
	}

	/* -------------------- */
	/* set up descriptor */
	r_local_user.dsc$w_length  = S_LOCAL_USER;
	r_local_user.dsc$b_dtype   = DSC$K_DTYPE_T;
	r_local_user.dsc$b_class   = DSC$K_CLASS_S;
	r_local_user.dsc$a_pointer = &t_local_user[0];

	/* -------------------- */
	l_status = sys$verify_proxy
		(&r_rem_node
		,&r_rem_user
		,ar_proposed_user
		,&r_local_user
		,&w_local_user_length
		,l_flags	/* by value */
		);

	/* -------------------- */
	if (l_status == SS$_NORMAL)
	{
	    return Py_BuildValue ("s#"
		,&t_local_user[0]
		,(unsigned int)w_local_user_length
		);
	}

	/* -------------------- */
	/* error */
	return PyVMS_ErrSetVal(vms_sys_gr_error, 1, l_status);
} /* vms_sys_verify_proxy () */

/* ------------------------------------------------------------------------- */

/* EOF: VMS_SYS_VERIFY_PROXY.C */
