/* VMSCVF__ACE2STRING.C - 01-JUL-1999 - Uwe Zessin
   converter-function for output item OSS$_READ_ENTRY

   OpenVMS item (binary ACE) into Python item (string)

   This is necessary, because the returned length is not filled in.
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

/* ------------------------------------------------------------------------- */

PyObject * vmscvf__ace2string
	(struct vmsdef_xr_itmlst3  * ar_itemlist   /* itemlist entry  */
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef /* VMSDEF entry    */
	,unsigned short int        * aw_retlenlist /* returned length */
	)
{
	char		* ab_data;
	unsigned char	  b_acllen;

	PyObject	* ar_acestr;		/* return */

	/* -------------------- */
	ab_data = ar_itemlist->itmlst3_a_bufadr; /* OpenVMS memory address */

	b_acllen = * ab_data;			/* length of ACE */

	/* Note: the ACE includes the length byte */
	ar_acestr = Py_BuildValue ("s#", ab_data, (unsigned int)b_acllen);

	/* -------------------- */
	return ar_acestr;			/* can be NULL, if error */
}

/* ------------------------------------------------------------------------- */

/* EOF: VMSCVF__ACE2STRING.C */
