/* VMSCVF__ACL2STRING.C - 03-JUL-1999 - Uwe Zessin
   converter-function for output item OSS$_READ_ACL

   OpenVMS item (binary ACE) into Python item (string)

   This is necessary, because the returned length is not filled in.

   The code assumes that a 65535 pre-zero-filled buffer has been allocated.

OSS$_ACL_READ  0017 05520 VA O 65535  S/S =vmscvf__acl2string
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

/* ------------------------------------------------------------------------- */

PyObject * vmscvf__acl2string
	(struct vmsdef_xr_itmlst3  * ar_itemlist   /* itemlist entry  */
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef /* VMSDEF entry    */
	,unsigned short int        * aw_retlenlist /* returned length */
	)
{
	unsigned char	* ab_data;
	unsigned char	  b_acllen;

	long		  l_acllen;

	PyObject	* ar_aclstr;		/* return */

	/* -------------------- */
	ab_data  = ar_itemlist->itmlst3_a_bufadr; /* OpenVMS memory address */
	l_acllen = 0;

	/* -------------------- */
	/* loop over all ACEs in the ACL if ACL exists */
	if (*ab_data != 0)
	{
	    unsigned char * ab_acelen;
	    unsigned char   b_acelen;

	    ab_acelen = ab_data;		/* first ACE */
	    while (1)
	    {
		b_acelen = *ab_acelen;		/* length of ACE */
		if (b_acelen == 0)
		{
		    break;			/* no more ACEs */
		}
		l_acllen += (unsigned long)b_acelen;
		if (l_acllen >= 65535)
		{
		    break;			/* ACL full */
		}
		ab_acelen += b_acelen;		/* next ACE address */
	    } /* while (1) */
	}

	/* -------------------- */
	ar_aclstr = Py_BuildValue ("s#", ab_data, (unsigned int)l_acllen);

	/* -------------------- */
	return ar_aclstr;			/* can be NULL, if error */
}

/* ------------------------------------------------------------------------- */

/* EOF: VMSCVF__ACL2STRING.C */
