/* VMSCVF__ITM2ACCNAM.C - 30-JUN-1999 - Uwe Zessin
   converter-function for output item OSS$_ACCESS_NAMES

   OpenVMS item into Python item

   Python item is: VMSOBJ__ACCESS_NAMES
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include "vmsobj__access_names.h"

/* ------------------------------------------------------------------------- */

PyObject * vmscvf__itm2accnam
	(struct vmsdef_xr_itmlst3  * ar_itemlist   /* itemlist entry  */
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef /* VMSDEF entry    */
	,unsigned short int        * aw_retlenlist /* returned length */
	)
{
	char		* ab_data;

	PyObject	* ar_accnam;		/* return */

	/* -------------------- */
	/* create a 'vmsobj__access_names' object */

	ab_data = ar_itemlist->itmlst3_a_bufadr; /* OpenVMS memory address */

	/* Note: VMSACCNAM_M_ALLOCNAMES must be clear ! */
	ar_accnam = (PyObject *) vmsobj__access_names_new
				    ((long *) ab_data, VMSACCNAM_M_ALLOCTABLE);

	/* -------------------- */
	/* now clear buffer address in the itemlist, so that the buffer */
	/* is not free()-ed on itemlist-deallocation			*/
	ar_itemlist->itmlst3_a_bufadr = 0;

	/* -------------------- */
	return ar_accnam;	/* can be NULL, if error */
}

/* ------------------------------------------------------------------------- */

/* EOF: VMSCVF__ITM2ACCNAM.C */
