/* VMSCVF__QUIFID.C - 03-APR-1999 - Uwe Zessin
   converter-function for QUI$_FILE_IDENTIFICATION

   OpenVMS item into Python item

   Format of output-tuple:
	( 'device:'	- string of max. 16 bytes
	, (NUM,SEQ,RCN) - FID, tuple of 3 16-bit integers
	, (NUM,SEQ,RCN) - DID, "
	)

30-JUN-1999 ZE. -- more parameters for converter-function
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */

PyObject * vmscvf__quifid
	(struct vmsdef_xr_itmlst3  * ar_itemlist   /* itemlist entry  */
	,struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef /* VMSDEF entry    */
	,unsigned short int        * aw_retlenlist /* returned length */
	)
{
	unsigned char		* ab_data;
	unsigned char		  b_dev_len;

	PyObject		* ar_device;
	PyObject		* ar_fid;
	PyObject		* ar_did;

	PyObject		* ar_quifid;	/* return */

	/* -------------------- */
	/* convert ASCIC to Python string */
	ab_data   = ar_itemlist->itmlst3_a_bufadr; /* OpenVMS memory address */
	b_dev_len = *ab_data;	/* ASCIC byte count */
	ab_data++;		/* address of string */

	ar_device = Py_BuildValue ("s#", ab_data, (unsigned int)b_dev_len);
	if (ar_device == NULL)
	{
	    return NULL;
	}
	ab_data += 15;		/* address of FID */

	/* -------------------- */
	/* convert FID to Python tuple */
	ar_fid = vms__cvt_bin2py
		    ((char *)ab_data			/* data address */
		    ,ITMTYP_K_WORD			/* data type    */
		    ,(unsigned short int) 6		/* data length  */
		  );
	if (ar_fid == NULL)
	{
	    Py_DECREF(ar_device);
	    return NULL;
	}
	ab_data += 6;		/* address of DID */

	/* -------------------- */
	/* convert DID to Python tuple */
	ar_did = vms__cvt_bin2py
		    ((char *)ab_data			/* data address */
		    ,ITMTYP_K_WORD			/* data type    */
		    ,(unsigned short int) 6		/* data length  */
		  );
	if (ar_did == NULL)
	{
	    Py_DECREF(ar_device);
	    Py_DECREF(ar_fid);
	    return NULL;
	}

	/* -------------------- */
	/* build tuple to be returned */
	ar_quifid = Py_BuildValue ("OOO", ar_device, ar_fid, ar_did);
	Py_DECREF(ar_device);
	Py_DECREF(ar_fid);
	Py_DECREF(ar_did);

	/* -------------------- */
	return ar_quifid;	/* can be NULL, if error */
}

/* ------------------------------------------------------------------------- */

/* EOF: VMSCVF__QUIFID.C */
