/* VMSCVF__SJCFID.C - 28-MAR-1999 - Uwe Zessin
   converter-function for SJC$_FILE_IDENTIFICATION

   Python item into OpenVMS item

   Format of input-tuple:
	( 'device:'	- string of max. 16 bytes
	, (NUM,SEQ,RCN) - FID, tuple of 3 16-bit integers
	, (NUM,SEQ,RCN) - DID, "
	)
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"
#include "vmscvf__sjcfid.h"

/* ------------------------------------------------------------------------- */

int vmscvf__sjcfid
	(PyObject		 *  ar_py_item	/* from Python item list  */
	,unsigned long		    l_itmidx	/* index into item-list   */
	,struct vmscvf_xr_sjcfid ** ar_data	/* OpenVMS memory address */
	,unsigned short int	 *  aw_length	/* size of buffer */
	)
{
	unsigned long		  l_item_size;

	PyObject		* ar_dvi;
	PyObject		* ar_fid;
	PyObject		* ar_did;

	char			* at_dev;
	unsigned long		  l_dev_len;

	unsigned char		* ab_buffer;
	unsigned char		* ab_data;
	unsigned short int	* aw_data;

	unsigned long		  l_xid_idx;	/* index into FID/DID tuple */
	PyObject		* ar_tuple_item; /* item of FID/DID tuple */
	unsigned long		  l_data;

	/* -------------------- */
	if (! PyTuple_Check(ar_py_item))
	{
	    PyErr_SetString(PyExc_TypeError,
		"vmscvf__sjcfid(): argument must be 3-item tuple");
	    return -1;
	}

	/* -------------------- */
	l_item_size = PyTuple_Size(ar_py_item);
	if (l_item_size != 3)
	{
	    PyErr_SetString(PyExc_TypeError,
	       "vmscvf__sjcfid(): argument must be 3-item tuple(dev,fid,did)");
	    return -1;
	}	

	/* -------------------- */
	ar_dvi = PyTuple_GetItem(ar_py_item,0);
	if (ar_dvi == NULL)
	{
	    return -1;
	}	

	/* ---------- */
	if (! PyString_Check(ar_dvi))
	{
	    PyErr_SetString(PyExc_TypeError,
		"vmscvf__sjcfid(): argument(device) must be string");
	    return -1;
	}	

	/* ---------- */
	l_dev_len = PyString_Size(ar_dvi);
	if (l_dev_len > 15)
	{
	    PyErr_SetString(PyExc_TypeError,
  "vmscvf__sjcfid(): argument(device) - string size limited to 15 characters");
	    return -1;
	}	

	/* -------------------- */
	ar_fid = PyTuple_GetItem(ar_py_item,1);
	if (ar_fid == NULL)
	{
	    PyErr_SetString(PyExc_TypeError,
		"vmscvf__sjcfid(): argument(fid) must be 3-item tuple");
	    return -1;
	}	

	/* ---------- */
	l_item_size = PyTuple_Size(ar_fid);
	if (l_item_size != 3)
	{
	    return -1;
	}	

	/* -------------------- */
	ar_did = PyTuple_GetItem(ar_py_item,2);
	if (ar_did == NULL)
	{
	    return -1;
	}	

	/* ---------- */
	l_item_size = PyTuple_Size(ar_did);
	if (l_item_size != 3)
	{
	    PyErr_SetString(PyExc_TypeError,
		"vmscvf__sjcfid(): argument(did) must be 3-item tuple");
	    return -1;
	}	

	/* -------------------- */
	/* allocate buffer */
	ab_buffer = malloc (28);
	if (ab_buffer == NULL)
	{
	    (void) PyErr_NoMemory();
	    return -1;
	}
	ab_data = ab_buffer;			/* pointer walks over buffer */

	/* -------------------- */
	/* copy device name */
	(void) memset (ab_data, 0, 16);

	if (l_dev_len > 0)
	{
	    unsigned char  b_dev_len;

	    b_dev_len = l_dev_len;
	    *ab_data  = b_dev_len;		/* ASCIC - length */
	    ab_data++;

	    at_dev = PyString_AS_STRING(ar_dvi);
	    (void) memcpy (ab_data, at_dev, l_dev_len);
	}
	else
	{
	    ab_data++;				/* skip ASCIC length */
	}
	ab_data += 15;			/* address of FID (3W) */

	aw_data = (unsigned short int *)ab_data;

	/* -------------------- */
	/* copy FID */
	for (l_xid_idx = 0; l_xid_idx < 3; l_xid_idx++)
	{
	    ar_tuple_item = PyTuple_GetItem(ar_fid, l_xid_idx);
	    if (ar_tuple_item == NULL)
	    {
		free (ab_buffer);
		return -1;
	    }
	    if (! PyInt_Check(ar_tuple_item))
	    {
		free (ab_buffer);
		(void) PyErr_Format(PyExc_TypeError,
		    "argument(fid,item:%d) - must be integer", l_xid_idx);
		return -1;
	    }
	    l_data = PyInt_AsLong(ar_tuple_item);
	    if (PyErr_Occurred())
	    {
		free (ab_buffer);
		return -1;
	    }
	    *aw_data = l_data;
	    aw_data++;		/* next word */
	} /* for() */

	/* -------------------- */
	/* copy DID */
	for (l_xid_idx = 0; l_xid_idx < 3; l_xid_idx++)
	{
	    ar_tuple_item = PyTuple_GetItem(ar_did, l_xid_idx);
	    if (ar_tuple_item == NULL)
	    {
		free (ab_buffer);
		return -1;
	    }
	    if (! PyInt_Check(ar_tuple_item))
	    {
		free (ab_buffer);
		(void) PyErr_Format(PyExc_TypeError,
		    "argument(did,item:%d) - must be integer", l_xid_idx);
		return -1;
	    }
	    l_data = PyInt_AsLong(ar_tuple_item);
	    if (PyErr_Occurred())
	    {
		free (ab_buffer);
		return -1;
	    }
	    *aw_data = l_data;
	    aw_data++;		/* next word */
	} /* for() */

	/* -------------------- */
	/* return buffer address to caller */
	*ar_data = (struct vmscvf_xr_sjcfid *)ab_buffer;

	/* return size of buffer */
	*aw_length = 28;

	return 0;
}

/* ------------------------------------------------------------------------- */

/* EOF: VMSCVF__SJCFID.C */
