#ifndef _VMSDEF_H_
#define _VMSDEF_H_

/* VMSDEF.H -- 30-SEP-1996 Uwe Zessin
   06-SEP-1997 ZE. -- add new item-code table format
   30-SEP-1997 ZE. -- rename from VMS_DEFTABLE.H to VMSDEF.H
   16-OCT-1997 ZE. -- Rename field 'w_vmsver' to 'w_vmsvermin' and add field
			'w_vmsvermax' because some data can change from
			version to version.
   17-OCT-1997 ZE. -- add data structure for directory of VMSDEF tables
   29-NOV-1997 ZE. -- changes for Python V1.5B1
   03-JAN-1998 ZE. -- additional data structure for constants/bitmasks that
			don't map to item codes
   11-JAN-1998 ZE. -- change/add ITMTBL_M_*
   25-APR-1998 ZE. -- add PYVMS_XR_IDSC 'ImageDeSCriptor'
		(has nothing to do with 'classical' VMSDEF but I don't want to
		create many include files)
   06-SEP-1998 ZE. -- change format of vmsdef_xr_itmtbl - new type codes
   24-SEP-1998 ZE. -- move 'struct vmsdef_xr_itmlst3' here
   17-OCT-1998 ZE. -- add 'struct vmsdef_xr_itmlst2'
			improve readability, more comments
   22-NOV-1998 ZE. -- enhance 'vmsdef_xr_itmlst3' for SYS$PROCESS_SCAN()
   28-NOV-1998 ZE. -- add ITMTBL_M_ITMITL + ITMTBL_M_ITMOTL -
			input+output item code for SYS$TRNLNM()
   27-DEC-1998 ZE. -- add ITMTYP_M_USIGN for phase-in of unsigned BWLQO
   04-JAN-1999 ZE. -- PyVMS_ErrSetVal () returns NULL - update prototype
   22-JAN-1999 ZE. -- ITMTBL_M_INITVOL_SYMBITM + ITMTYP_K_BOOL for support
			of SYS$INIT_VOL()
   14-FEB-1999 ZE. -- add 64-bit bitmask support, reorganize vmsdef_x_bitmsk
   13-MAR-1999 ZE. -- add ITMTBL_M_BYVALUE, ITMTBL_M_CVTFNC
   05-APR-1999 ZE. -- add ITMTBL_M_SETRETLEN (SYS$GETQUIW)
   29-MAY-1999 ZE. -- add 'vmsdef_xr_lksb' - lock status block
   22-JUN-1999 ZE. -- fix 'vmsdef_xr_lksb.o_lkvb' (lock value block)
*/

/* ---------------------------------------- */

#ifdef __cplusplus
    extern "C" {
#endif

#include "python.h"

#if defined(__DECC) || defined(__DECCXX)
#pragma __member_alignment __save
#pragma __member_alignment
#endif

/* ---------------------------------------- */

PyObject * PyVMS_ErrSetVal(PyObject *error, int n, int cond, ...);

/* ---------------------------------------- */
/* VMS version number used in VMSDEF tables, see also: vmsdef_xr_vmsvertbl */
typedef  unsigned short int  vmsdef_xw_vmsver;

/* ---------------------------------------- */
/* VMSDEF item-code tables, e.g.: VMSDEF_GR_$DVIDEF[] */

typedef int (*vmscvf_x_function) \
			(PyObject * _a		/* itemlist item */
			,unsigned long _b	/* itemlist index */
			,char ** _c		/* OpenVMS memory address */
			,unsigned short int *_d); /* size of buffer */

struct vmsdef_xr_itmtbl {
	unsigned short int	  w_itmcod;	/* VMS item code */
	unsigned short int	  w_bufsiz;	/* item buffer size */
	vmsdef_xw_vmsver	  w_vmsvermin;	/* minimum VMS version */
	vmsdef_xw_vmsver	  w_vmsvermax;	/* maximum VMS version */
	char			* at_itmnam_py;	/* Python item name */
	union
	{
	    void		* ar_bitmsk;	/* pointer to vmsdef_x_bitmsk */
	    int		      (*ab_cvtfnci)();	/* converter function */
	    PyObject	    * (*ab_cvtfnco)();	/* converter function */
	} _bitmsk_cvtfnc;
	unsigned long		  l_flags;	/* see below */
	unsigned short int	  w_typ_lib;	/* data type LIB$name() */
	unsigned short int	  w_typ_sys;	/* data type SYS$name() */
};
#define itmtbl_ar_bitmsk  _bitmsk_cvtfnc.ar_bitmsk
#define itmtbl_ab_cvtfnci _bitmsk_cvtfnc.ab_cvtfnci /* PyObject->memory   */
#define itmtbl_ab_cvtfnco _bitmsk_cvtfnc.ab_cvtfnco /* memory  ->PyObject */

typedef struct vmsdef_xr_itmtbl vmsdef_xr_itmtbl;

/* contents of L_FLAGS -- synchronize names + values with VMSDEF2MAR.COM and
   VMSVER2MAR.COM ! */
#define ITMTBL_M_ARCH_VAX	 1 /* item valid on VAX architecture	*/
#define ITMTBL_M_ARCH_ALPHA	 2 /* item valid on Alpha architecture	*/
#define ITMTBL_M_ARRAY           4 /* input item can be variable length */
				   /*  tuple of data type specified	*/
#define ITMTBL_M_GETQUI_FNCREQ	 8 /* $GETQUI() - request function code */
#define ITMTBL_M_SNDJBC_FNCREQ	 8 /* $SNDJBC() - function code		*/
#define ITMTBL_M_GETSYI_SYSPAR	 8 /* $GETSYI() system parameter	*/
#define ITMTBL_M_GETSYI_SYSVAL	16 /* $GETSYI() system value		*/
#define ITMTBL_M_INITVOL_SYMITM 16 /* $INIT_VOL() symbolic item code	*/
#define ITMTBL_M_ITMOUT		32 /* output item code			*/
#define ITMTBL_M_ITMINP		64 /* input item code			*/
#define ITMTBL_M_ITMITL	       128 /* input item code for $TRNLNM()	*/
#define ITMTBL_M_ITMOTL        256 /* output item code for $TRNLNM()	*/
  /* item code definitions for $CRELNM and $TRNLNM collide */
#define ITMTBL_M_MSK64	       512 /* 64-bit bitmask			*/
#define ITMTBL_M_BYVALUE      1024 /* BWL buffer passed 'by value'	*/
#define ITMTBL_M_CVTFNC       2048 /* use converter-function via ar_bitmsk */
#define ITMTBL_M_SETRETLEN    4096 /* pre-set returned length address	*/
				   /* necessary for SYS$GETQUIW */

/* contents of w_typ_lib/ w_typ_sys */
#define ITMTYP_K_ASCII 1
#define ITMTYP_K_ASCIC 2	/* counted ascii */
#define ITMTYP_K_BYTE  3
#define ITMTYP_K_WORD  4
#define ITMTYP_K_LONG  5
#define ITMTYP_K_QUAD  6
#define ITMTYP_K_OCTA  7
#define ITMTYP_K_BOOL  8	/* SYS$INIT_VOL() item-list */
#define ITMTYP_K_MAXTYP ITMTYP_K_BOOL /* max defined */
#define ITMTYP_M_USIGN 128	/* mask bit for unsigned type */
/* new item must also be added to VMSDEF2MAR.COM +
   vmsdef_gl_itmtypsiz[] in PYVMS_GLOBAL.C */

/* ---------------------------------------- */
/* define bitmask structures - pointed to by VMSDEF_XR_ITMTBL.AR_BITMSK */
struct vmsdef_x_bitmsk {
	char			* at_bit_name;	/* bit name */
	vmsdef_xw_vmsver	  w_vmsvermin;	/* minimum VMS version */
	vmsdef_xw_vmsver	  w_vmsvermax;	/* maximum VMS version */
	/* insert nothing else here! value0 is now Q-aligned */
	unsigned long		  l_bit_value;	/* bit value (1,2,4,8,...) */
};
typedef struct vmsdef_x_bitmsk vmsdef_x_bitmsk;

/* the first 3 entries of vmsdef_x_bitmsk + vmsdef_x_bitmsk64 are shared */

struct vmsdef_x_bitmsk64 {
	char			* at_bit_name;	/* bit name */
	vmsdef_xw_vmsver	  w_vmsvermin;	/* minimum VMS version */
	vmsdef_xw_vmsver	  w_vmsvermax;	/* maximum VMS version */
	/* insert nothing else here! value0 is now Q-aligned */
	unsigned long		  l_bit_value0;	/* bit value (1,2,4,8,...) */
	unsigned long		  l_bit_value1;	/* bit value (1,2,4,8,...) */
};
typedef struct vmsdef_x_bitmsk64 vmsdef_x_bitmsk64;

/* ---------------------------------------- */
/* translation table for VMS version strings to integer version number */
/* (no maximum/minimum version number) */

struct vmsdef_xr_vmsvertbl {
	vmsdef_xw_vmsver	  w_vmsver;	/* VMS version number */
	unsigned short int	  w_filler;
	char			* at_vmsver;	/* VMS version string */
	unsigned long		  l_flags;	/* see above ITMTBL_M_ARCH_* */
};
typedef struct vmsdef_xr_vmsvertbl vmsdef_xr_vmsvertbl;

/* ---------------------------------------- */
/* contents of L_TBLTYP -- synchronize names + values with VMSDEF2MAR.COM and
   VMSVER2MAR.COM ! */
			    /* 0 is reserved for end-of list */
#define CONMSKTBL_K_BITMASK32  1
#define CONMSKTBL_K_CONSTANT32 2
#define CONMSKTBL_K_BITMASK64  3

/* data structure for constants and bitmask tables pointer */
struct vmsdef_xr_conmsktbl {
	void			* ar_bitmsk;	/* pointer to vmsdef_x_bitmsk */
	unsigned long		  l_tbltyp;	/* CONMSKTBL_K_xxx */
};
typedef struct vmsdef_xr_conmsktbl vmsdef_xr_conmsktbl;

/* ---------------------------------------- */
/* data structure for directory of VMSDEF tables - VMSDEF_GR_DIRECTORY[] */

struct vmsdef_xr_defdirtbl {
	void			* ar_itmtbl;	/* addr of table */
	void			* ar_conmsktbl;	/* constants and masks */
	char			* at_vmsdefnam;	/* xxxDEF name */
};
typedef struct vmsdef_xr_defdirtbl vmsdef_xr_defdirtbl;

/* ---------------------------------------- */
/* PYVMS_XR_IDSC 'ImageDeSCriptor' */
struct vmsdef_xr_idsc {
	void			* a_next;	/* next IDSC */
	vmsdef_xw_vmsver	  w_vmsver;	/* VMS version */
	short int		  w_fill;
	void			* ar_vmslbr;	/* vms_lbr functions */
	void			* ar_vmslib;	/* vms_lib functions */
	void			* ar_vmssys;	/* vms_sys functions */
				/* layout not worked out */
};
typedef struct vmsdef_xr_idsc vmsdef_xr_idsc;

/* ---------------------------------------- */
/* OpenVMS itemlist_2 structure */
struct vmsdef_xr_itmlst2 {
	unsigned short int	  w_bufsiz;	/* buffer size		  */
	unsigned short int	  w_itmcod;	/* item code		  */
	void			* a_bufadr;	/* buffer address	  */
};
typedef struct vmsdef_xr_itmlst2 vmsdef_xr_itmlst2;

/* ---------------------------------------- */
/* OpenVMS itemlist_3 structure */
struct vmsdef_xr_itmlst3 {
	unsigned short int	  w_bufsiz;	/* buffer size		  */
	unsigned short int	  w_itmcod;	/* item code		  */
	union
	{
	    void		* a_bufadr;	/* buffer address	  */
	    unsigned long	  l_itmval;	/* item value		  */
	} _bufadr_itmval;
	union
	{
	    void		* aw_retlenaddr;/* returned lenth address */
	    unsigned long	  l_itmflg;	/* item flags		  */
	} _retlenaddr_itmflg;
};
#define itmlst3_a_bufadr      _bufadr_itmval.a_bufadr
#define itmlst3_l_itmval      _bufadr_itmval.l_itmval
#define itmlst3_aw_retlenaddr _retlenaddr_itmflg.aw_retlenaddr
#define itmlst3_l_itmflg      _retlenaddr_itmflg.l_itmflg

typedef struct vmsdef_xr_itmlst3 vmsdef_xr_itmlst3;

/* ---------------------------------------- */
/* OpenVMS lksb structure - LocK Status Block */
struct vmsdef_xr_lksb {
	unsigned short int	w_condval;	/* condition value	*/
	unsigned short int	w_reserved;
	unsigned long		l_lckid;	/* lock identification	*/
	unsigned long		o_lvb[4];	/* lock value block	*/
};

typedef struct vmsdef_xr_lksb vmsdef_xr_lksb;

/* ---------------------------------------- */

#ifdef __cplusplus
    }
#endif

#if defined(__DECC) || defined(__DECCXX)
#pragma __member_alignment __restore
#endif

/* ---------------------------------------- */

#endif /* _VMSDEF_H_ */

/* EOF: VMSDEF.H */
