/* @@ code copied from Donn Cave's port */

/* 29-NOV-1997 ZE. -- changes for Python V1.5B1
   12-DEC-1997 ZE. -- include starlet.h for clean compile
   10-OCT-1998 ZE. -- fix memory leak
   04-JAN-1999 ZE. -- PyVMS_ErrSetVal () returns NULL
*/

#include "python.h"

#include <descrip.h>
#include <stdarg.h>
/* #include "vmsdef.h" */
/* #include "vmsmisc.h" @@ obsolete */
#include <starlet.h>	/* SYS$name */

struct err_and_cond {
	int condition;
	PyObject *error;
};

/*
 * Set error, value from condition.
 */
static int
VMSErrSet(struct dsc$descriptor_s *msg, struct err_and_cond *ec)
{
	PyObject *val;
	val = Py_BuildValue("(is#)", ec->condition, msg->dsc$a_pointer,
		msg->dsc$w_length);
	PyErr_SetObject(ec->error, val);
	Py_DECREF(val);			/* 981010 ZE. */
	return 0;	/* Don't write to SYS$ERROR */
}

/*
 * Process error.  Usually there will be only one condition value, but
 * for example with RMS there would often be two.  $PUTMSG takes the
 * supplied values and a format string defined for the primary value, and
 * prints the whole mess.  Below it gets an optional accessory routine,
 * which instead of printing copies into a Python error.
 */
PyObject *
PyVMS_ErrSetVal (PyObject *error, int n, int cond, ...)
{
	va_list va;
	int vec[16];
	int i;
	struct err_and_cond ec;

	va_start(va, cond);
	vec[0] = n;
	vec[1] = cond;
	for (i = 2; i < n; ++i)
		vec[i] = va_arg(va, int);
	va_end(va);
	ec.condition = cond;
	ec.error = error;
	/* Format message, pass to exception translation instead of output. */
	sys$putmsg(vec, VMSErrSet, 0, &ec);

	return NULL;
}

/* EOF: VMSMISC.C */
