#ifndef VMSOBJ__ACCESS_NAMES_H
#define VMSOBJ__ACCESS_NAMES_H
#ifdef __cplusplus
extern "C" {
#endif

/* ACL access names (e.g. READ,WRITE,EXECUTE) to bit mapping*/

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	long		  l_accnam_flags;
	long		* aq_access_names;
} vmsobj__access_names;

extern DL_IMPORT(PyTypeObject) vmsobj__access_names_type;
extern DL_IMPORT(vmsobj__access_names *)
		vmsobj__access_names_new (long * aq_access_names, long l_flags);

#define vmsobj__access_names_Check(op) \
		((op)->ob_type == &vmsobj__access_names_type)

#define VMSACCNAM_M_ALLOCTABLE 1 /* deallocate table on object deletion */
#define VMSACCNAM_M_ALLOCNAMES 2 /* bit names separately allocated */

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ__ACCESS_NAMES_H */
