/* VMSOBJ__MEMBUF.C - 30-JAN-1999 ZE.
   membuf object. Template was: [.OBJECTS]XXOBJECT.C

   This object provides memory space for other objects (e.g. RAB).

   03-MAR-1999 ZE. -- add zero() function to clear buffer contents
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include "vmsobj__def.h"
/* -------------------- */
/* #include "vmsobj__membuf.h" */
typedef struct {
	PyObject_HEAD
	long	  l_flags;
	long	  l_bufsiz;	/* buffer size */
	char	* ab_membuf;	/* buffer address */
} vmsobj__membuf;

/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj__membuf_type;

/* ------------------------------------------------------------------------- */

vmsobj__membuf *
vmsobj__membuf_new (long l_bufsiz, char * at_src)
{
	vmsobj__membuf *xp;

	/* -------------------- */
	if (l_bufsiz <= 0)
	{
	    /* must be positive size */
	    PyErr_SetString(PyExc_AttributeError,
		"vmsobj__membuf size must be positive");
	    return NULL;
	}
	else
	{
	    /* -------------------- */
	    /* new 'vmsobj__membuf' object */
	    xp = PyObject_NEW (vmsobj__membuf, &vmsobj__membuf_type);
	    if (xp == NULL)
	    {
		return NULL;
	    }
	    xp->l_flags = 0;

	    /* -------------------- */
	    xp->ab_membuf = malloc (l_bufsiz);
	    if (xp->ab_membuf == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    xp->l_flags |= VMSOBJ_M_ALLOC;

	    /* -------------------- */
	    if (at_src == NULL)
	    {
		/* initialize buffer */
		(void) memset (xp->ab_membuf, 0, l_bufsiz);
	    }
	    else
	    {
		/* copy an initialization-string */
		(void) strncpy (xp->ab_membuf, at_src, l_bufsiz);
	    }

	    xp->l_bufsiz = l_bufsiz;
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj__membuf methods */

static void
vo_membuf_dealloc (vmsobj__membuf *xp)
{
	/* was MEMBUF allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS MEMBUF */
	    if (xp->ab_membuf != NULL)
	    {
		(void) free (xp->ab_membuf);
	    }
	}

	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */

static char vo_membuf_zero__doc[] =
"None = vmsobj__membuf.zero()\nOverwrite contents of buffer with NULs.";

/* overwrite current contents of buffer with '\0' */
static PyObject *
vo_membuf_zero (vmsobj__membuf *self, PyObject *args)
{
	/* @@ ignore args */
	(void) memset (self->ab_membuf, 0, self->l_bufsiz);
	Py_INCREF(Py_None);
	return Py_None;
}

/* ------------------------------------------------------------------------- */

static PyMethodDef vo_membuf_methods[] = {
    {"zero", (PyCFunction)vo_membuf_zero, METH_VARARGS, vo_membuf_zero__doc},
    {NULL,   NULL,			  0,		NULL} /* sentinel */
};

/* ------------------------------------------------------------------------- */

/* This object has no attributes table. Its attributes ('buffer' + 'size')
   are directly checked with cmp(). */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_membuf_getattr (vmsobj__membuf *xp, char *name)
{
	PyObject * ar_return;

	/* -------------------- */
	if (strcmp (name, "buffer") == 0)
	{
	    return Py_BuildValue("s#", xp->ab_membuf, xp->l_bufsiz);
	} /* size attribute */

	/* -------------------- */
	if (strcmp (name, "size") == 0)
	{
	    return PyInt_FromLong (xp->l_bufsiz);
	} /* size attribute */

	/* -------------------- */
	/* no other readable attributes */

        ar_return = Py_FindMethod(vo_membuf_methods, (PyObject *)xp, name);

	if (ar_return == NULL)
	{
	    PyErr_SetString(PyExc_AttributeError,
		"non-existing vmsobj__membuf attribute");
	    ar_return = NULL;
	}
	return ar_return;
}

/* ------------------------------------------------------------------------- */

static int
vo_membuf_setattr (vmsobj__membuf *xp, char *name, PyObject *v)
{
	/* -------------------- */
	/* there is currently no writeable attribute */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing or readonly vmsobj__membuf attribute");
	return -1;
}

/* ------------------------------------------------------------------------- */

static PyObject *
vo_membuf_repr (vmsobj__membuf *ar_membuf)
{
	char buf[40];

	sprintf(buf, "<vmsobj__membuf, buffer at 0x%08x>", (ar_membuf->ab_membuf));
	return PyString_FromString(buf);
}

/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj__membuf_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj__membuf",		/*tp_name*/
	sizeof(vmsobj__membuf),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_membuf_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_membuf_getattr,	/*tp_getattr*/
	(setattrfunc)vo_membuf_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_membuf_repr,	/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ__MEMBUF.C */
