/* VMSOBJ__OWNERSHIP_NAMES.C - 12-AUG-1999 ZE.
   ownership names (SYSTEM, OWNER, GROUP, WORLD) mapping
*/

/* ideas:
>>> new_ownership = ownership_object.copy()
>>> new_ownership[2] = 'B2'
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <descrip.h>
#include <lib$routines.h>

#include "vmsobj__def.h"
#include "vmsobj__ownership_names.h"

/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj__ownership_names_type;

/* ------------------------------------------------------------------------- */

vmsobj__ownership_names *
vmsobj__ownership_names_new (long * aq_ownership_names, long l_flags)
{
	vmsobj__ownership_names *xp;

	/* -------------------- */
	/* new 'vmsobj__ownership_names' object */
	xp = PyObject_NEW (vmsobj__ownership_names, &vmsobj__ownership_names_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	xp->l_ownership_flags  = l_flags;
	/* pointers to other objects that the OWNERSHIP_NAMES points to */
	xp->aq_ownership_names = NULL;

	/* -------------------- */
	if (aq_ownership_names == NULL)
	{
	    int l_loop;

	    /* allocate memory for real OWNERSHIP_NAMES and note it's address */
	    xp->aq_ownership_names = malloc (32); /* 4 descriptors */
	    if (xp->aq_ownership_names == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }

	    /* initialize descriptors */
	    {
		struct dsc$descriptor_s * ar_dst;
		unsigned long		  l_namlen;
		unsigned long		  l_status;

		ar_dst = (struct dsc$descriptor_s *)xp->aq_ownership_names;

		/* ---------- */
		/* SYSTEM */
		l_namlen = 6;
		ar_dst->dsc$w_length  = 0;
		ar_dst->dsc$b_dtype   = DSC$K_DTYPE_T;
		ar_dst->dsc$b_class   = DSC$K_CLASS_D; /* DYNAMIC */
		ar_dst->dsc$a_pointer = 0;
		l_status = lib$sget1_dd (&l_namlen, ar_dst);
		if (l_status != 1)
		{
		    (void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		    return NULL;
		}
		(void) memcpy (ar_dst->dsc$a_pointer,
						"SYSTEM", (size_t)l_namlen);
		ar_dst++;

		/* ---------- */
		/* OWNER */
		l_namlen = 5;
		ar_dst->dsc$w_length  = 0;
		ar_dst->dsc$b_dtype   = DSC$K_DTYPE_T;
		ar_dst->dsc$b_class   = DSC$K_CLASS_D; /* DYNAMIC */
		ar_dst->dsc$a_pointer = 0;
		l_status = lib$sget1_dd (&l_namlen, ar_dst);
		if (l_status != 1)
		{
		    (void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		    return NULL;
		}
		(void) memcpy (ar_dst->dsc$a_pointer,
						"OWNER", (size_t)l_namlen);
		ar_dst++;

		/* ---------- */
		/* GROUP */
		l_namlen = 5;
		ar_dst->dsc$w_length  = 0;
		ar_dst->dsc$b_dtype   = DSC$K_DTYPE_T;
		ar_dst->dsc$b_class   = DSC$K_CLASS_D; /* DYNAMIC */
		ar_dst->dsc$a_pointer = 0;
		l_status = lib$sget1_dd (&l_namlen, ar_dst);
		if (l_status != 1)
		{
		    (void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		    return NULL;
		}
		(void) memcpy (ar_dst->dsc$a_pointer,
						"GROUP", (size_t)l_namlen);
		ar_dst++;

		/* ---------- */
		/* WORLD */
		l_namlen = 5;
		ar_dst->dsc$w_length  = 0;
		ar_dst->dsc$b_dtype   = DSC$K_DTYPE_T;
		ar_dst->dsc$b_class   = DSC$K_CLASS_D; /* DYNAMIC */
		ar_dst->dsc$a_pointer = 0;
		l_status = lib$sget1_dd (&l_namlen, ar_dst);
		if (l_status != 1)
		{
		    (void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		    return NULL;
		}
		(void) memcpy (ar_dst->dsc$a_pointer,
						"WORLD", (size_t)l_namlen);

		/* ---------- */
	    }

	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing OWNERSHIP_NAMES table */
	    xp->aq_ownership_names = aq_ownership_names;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj__ownership_names methods */

static void
vo__ownership_names_dealloc (vmsobj__ownership_names *xp)
{
	struct dsc$descriptor_s * ar_dsc;
	long			  l_cnt;

	/* was OWNERSHIP_NAMES table allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of OWNERSHIP_NAMES table */
	    if (xp->aq_ownership_names != NULL)
	    {
		ar_dsc = (struct dsc$descriptor_s *)xp->aq_ownership_names;
		for (l_cnt = 0; l_cnt < 4; l_cnt++)
		{
		    if (ar_dsc->dsc$w_length != 0)
		    {
			lib$sfree1_dd (ar_dsc); /* @@ ignore runtime errors */
		    }
		    ar_dsc++;
		}
		/* free the descriptor array */
		(void) free (xp->aq_ownership_names);
	    }
	}
	else
	{
	    /* The OWNERSHIP_NAMES table was not allocated by the object      */
	    /* creation routine - its address was supplied to it. Keep it. */
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo__ownership_names_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj__ownership_names_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* bit number */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj__ownership_names_attr vmsobj__ownership_names_attr;

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* address bits */


static vmsobj__ownership_names_attr vmsobj_r__ownership_names_attr [] = {
	{"BIT_0",	0,	ITMTYP_K_ASCII,0	} ,
	{NULL,  	0,	0,	       0	}
};

/* ------------------------------------------------------------------------- */
static PyObject *ar_ownership_doc;

static PyObject *
vo__ownership_names_getattr (vmsobj__ownership_names *xp, char *name)
{
	unsigned long l_attr_idx;

	if (strcmp (name, "__doc__") == 0)
	{
	    if (ar_ownership_doc == NULL)
	    {
		ar_ownership_doc = PyString_FromString(
						"vmsobj__ownership_names object");
	    }
	    return ar_ownership_doc;
	}

	l_attr_idx = 0;
	while (vmsobj_r__ownership_names_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r__ownership_names_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->aq_ownership_names;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r__ownership_names_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r__ownership_names_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r__ownership_names_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo__ownership_names_methods, (PyObject *)xp, name);
} /* vo__ownership_names_getattr (vmsobj__ownership_names *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo__ownership_names_setattr (vmsobj__ownership_names *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r__ownership_names_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r__ownership_names_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    l_status = 0;
	    ab_data = (char *)xp->aq_ownership_names;

	    if (vmsobj_r__ownership_names_attr[l_attr_idx].w_offset & ROAT)
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj__ownership_names attribute");
		return -1;
	    }

	    if (vmsobj_r__ownership_names_attr[l_attr_idx].w_offset & OBIO)
	    {
		/* object I/O */
		unsigned short int    w_objtyp;
		char		   * at_string;
		unsigned long	     l_string_len;

		w_objtyp = vmsobj_r__ownership_names_attr[l_attr_idx].w_offset & OFSMSK;
		switch (w_objtyp)
		{
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	    } /* object I/O */
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }

	    return l_status;       /* possible error mesage has been set */
	  } /* attribute name match */
	  l_attr_idx++;
	} /* while () */

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj__ownership_names attribute");
	return -1;
} /* vo__ownership_names_setattr () */

/* ------------------------------------------------------------------------- */

static PyObject *
vo__ownership_names_repr (vmsobj__ownership_names *ar__ownership_names)
{
	char buf[60];

	sprintf(buf, "<vmsobj__ownership_names, OWNERSHIP_NAMES at 0x%08x>",
		ar__ownership_names->aq_ownership_names);
	return PyString_FromString(buf);
} /* vo__ownership_names_repr () */

/* ------------------------------------------------------------------------- */

/* make a copy of ownership-names and update its pointer in the object */

static int
vo_copy_ownership (vmsobj__ownership_names *ar__ownership_names)
{
	struct dsc$descriptor_s * ar_dsc_src;
	struct dsc$descriptor_s * ar_dsc_dst;
	long			  l_cnt;
	long			  l_status;

	ar_dsc_dst = malloc (32); /* 4 descriptors */
	if (ar_dsc_dst == NULL)
	{
	    (void) PyErr_NoMemory();
	    return -1;
	}

	ar_dsc_src =
	    (struct dsc$descriptor_s *)ar__ownership_names->aq_ownership_names;
	ar__ownership_names->aq_ownership_names = (long *)ar_dsc_dst;

	for (l_cnt = 0; l_cnt < 4; l_cnt++)
	{
	    ar_dsc_dst->dsc$w_length  = 0;
	    ar_dsc_dst->dsc$b_dtype   = DSC$K_DTYPE_T;
	    ar_dsc_dst->dsc$b_class   = DSC$K_CLASS_D; /* DYNAMIC */
	    ar_dsc_dst->dsc$a_pointer = 0;
	    if (ar_dsc_src->dsc$w_length != 0)
	    {
		l_status = lib$scopy_dxdx (ar_dsc_src, ar_dsc_dst);
		if (l_status != 1) /* SS$_NORMAL */
		{
		    /* @@ memory leak ! */
			/* all string descriptors allocated so far  and */
			/*  'ar_dsc_dst' are lost for now */

		    /* restore old pointer */
		    ar__ownership_names->aq_ownership_names =
							(long *)ar_dsc_src;

		    (void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		    return -1;
		}
	    }
	    ar_dsc_src++;
	    ar_dsc_dst++;
	} /* for -- copy 4 descriptors */

	/* descriptors must now be deallocated on object deletion */
	ar__ownership_names->l_flags |= VMSOBJ_M_ALLOC;
	return 0;
} /* vo_copy_ownership () */

/* ------------------------------------------------------------------------- */

static int
ownership_length (vmsobj__ownership_names *ar__ownership_names)
{
	return 4; /* fixed length */
} /* ownership_length () */

/* ---------------------------------------- */

static PyObject *ar_indexerr;

static PyObject *
ownership_item (vmsobj__ownership_names *ar__ownership_names, int idx)
{
	struct dsc$descriptor_s * ar_ownership;
	long			  l_cnt;

	/* -------------------- */
	if (idx < 0 || idx >= 4) /* fixed length */
	{
	    if (ar_indexerr == NULL)
	    {
		ar_indexerr = PyString_FromString("index out of range");
	    }
	    PyErr_SetObject(PyExc_IndexError, ar_indexerr);
	    return NULL;
	}

	/* -------------------- */
	/* address of first string descriptor */
	ar_ownership =
	    (struct dsc$descriptor_s *)ar__ownership_names->aq_ownership_names;
	if (ar_ownership == NULL)
	{
	    PyObject *ar_bugchkerr;

	    ar_bugchkerr = PyString_FromString
		("BUGCHK ->aq_ownership_names == NULL");
	    PyErr_SetObject(PyExc_RuntimeError, ar_bugchkerr);
	    return NULL;
	}

	/* -------------------- */
	/* position to descriptor */
	for (l_cnt = 0; l_cnt < idx; l_cnt++)
	{
	    ar_ownership++;
	}

	/* -------------------- */
	/* descriptor is empty */
	if (ar_ownership->dsc$a_pointer == NULL)
	{
	    Py_INCREF (Py_None);
	    return Py_None;
	}

	/* -------------------- */
	return Py_BuildValue ("s#",
		ar_ownership->dsc$a_pointer,
		(unsigned int)ar_ownership->dsc$w_length);
} /* ownership_item () */

/* ---------------------------------------- */

static PyObject *
ownership_slice (vmsobj__ownership_names *ar__ownership_names,
			int ilow, int ihigh)
{
	PyListObject	* np;
	int		  l_idx;

	/* -------------------- */
	/* lower bound */
	if (ilow < 0)
	{
	    ilow = 0;
	}
	else
	{
	    if (ilow > 4)
	    {
		ilow = 4;
	    }
	}

	/* -------------------- */
	/* upper bound */
	if (ihigh < ilow)
	{
	    ihigh = ilow;
	}
	else
	{
	    if (ihigh > 4)
	    {
		ihigh = 4;
	    }
	}

	/* -------------------- */
	/* return a list */
	np = (PyListObject *) PyList_New(ihigh - ilow);
	if (np == NULL)
	{
	    return NULL;
	}

	/* -------------------- */
	/* create list entries from descriptor */
	for (l_idx = ilow; l_idx < ihigh; l_idx++)
	{
	    PyObject *v = ownership_item (ar__ownership_names, l_idx);
	    if (v == NULL)
	    {
		Py_DECREF (np);
		return NULL;
	    }
	    Py_INCREF(v);
	    np->ob_item[l_idx - ilow] = v;	/* put into list */
	}

	/* -------------------- */
	return (PyObject *)np;
} /* ownership_slice () */

/* ---------------------------------------- */

static int
ownership_ass_slice (a, ilow, ihigh, v)
	PyListObject *a;
	int ilow, ihigh;
	PyObject *v;
{

	PyErr_SetString(PyExc_ValueError,
		"ownership_ass_slice: remaining code not implemented");
	return -1;

	/* Because [X]DECREF can recursively invoke list operations on
	   this list, we must postpone all [X]DECREF activity until
	   after the list is back in its canonical shape.  Therefore
	   we must allocate an additional array, 'recycle', into which
	   we temporarily copy the items that are deleted from the
	   list. :-( */
/*	PyObject **recycle, **p;
/*	PyObject **item;
/*	int n; /* Size of replacement list */
/*	int d; /* Change in size */
/*	int k; /* Loop index */
/*#define b ((PyListObject *)v)
/*	if (v == NULL)
/*		n = 0;
/*	else if (PyList_Check(v)) {
/*		n = b->ob_size;
/*		if (a == b) {
/*			/* Special case "a[i:j] = a" -- copy b first */
/*			int ret;
/*			v = list_slice(b, 0, n);
/*			ret = list_ass_slice(a, ilow, ihigh, v);
/*			Py_DECREF(v);
/*			return ret;
/*		}
/*	}
/*	else {
/*		PyErr_BadArgument();
/*		return -1;
/*	}
	if (ilow < 0)
	{
	    ilow = 0;
	}
	else
	{
	    if (ilow > 4)
	    {
		ilow = 4;
	    }
	}

	if (ihigh < ilow)
	{
	    ihigh = ilow;
	}
	else
	{
	    if (ihigh > 4)
	    {
		ihigh = 4;
	    }
	}

/*	item = a->ob_item;
/*	d = n - (ihigh-ilow);
/*	if (ihigh > ilow)
/*		p = recycle = PyMem_NEW(PyObject *, (ihigh-ilow));
/*	else
/*		p = recycle = NULL;
/*	if (d <= 0) { /* Delete -d items; recycle ihigh-ilow items */
/*		for (k = ilow; k < ihigh; k++)
/*			*p++ = item[k];
/*		if (d < 0) {
/*			for (/*k = ihigh*/
/* ; k < a->ob_size; k++)
/*				item[k+d] = item[k];
/*			a->ob_size += d;
/*			NRESIZE(item, PyObject *, a->ob_size); /* Can't fail */
/*			a->ob_item = item;
/*		}
/*	}
/*	else { /* Insert d items; recycle ihigh-ilow items */
/*		NRESIZE(item, PyObject *, a->ob_size + d);
/*		if (item == NULL) {
/*			PyMem_XDEL(recycle);
/*			PyErr_NoMemory();
/*			return -1;
/*		}
/*		for (k = a->ob_size; --k >= ihigh; )
/*			item[k+d] = item[k];
/*		for (/*k = ihigh-1*/
/* ; k >= ilow; --k)
/*			*p++ = item[k];
/*		a->ob_item = item;
/*		a->ob_size += d;
/*	}
/*	for (k = 0; k < n; k++, ilow++) {
/*		PyObject *w = b->ob_item[k];
/*		Py_XINCREF(w);
/*		item[ilow] = w;
/*	}
/*	if (recycle) {
/*		while (--p >= recycle)
/*			Py_XDECREF(*p);
/*		PyMem_DEL(recycle);
/*	}
/*	return 0;
/*#undef b
*/
} /* ownership_ass_slice () */

/* ---------------------------------------- */

static int
ownership_ass_item (vmsobj__ownership_names *ar__ownership_names, int i, PyObject * v)
{
	unsigned long		l_name_length;
	struct dsc$descriptor_s * ar_ownership;
	int c;
	unsigned long		l_status;

	PyObject *old_value;

	/* -------------------- */
	if (i < 0 || i >= 4)
	{
	    PyErr_SetString(PyExc_IndexError, "assignment index out of range");
	    return -1;
	}

	/* -------------------- */
	/* item deletion */
	if (v == NULL)
	{
	    /* set a marker - deletion is done later, perhaps after a copy */
	    v = Py_None;	/* no Py_INCREF() ! */
	}

	/* -------------------- */
	/* 'v' must be string or None */
	if (PyString_Check(v))
	{
	    /* string is limited to 65535 characters */
	    l_name_length = PyString_Size(v);
	    if (l_name_length > 65535)
	    {
		PyErr_SetString(PyExc_ValueError,
		    "string length limited to 65535 characters");
		return -1;
	    }
	}
	else
	{
	    if (v != Py_None)
	    {
		PyErr_SetString(PyExc_TypeError, "must be a string or None");
		return -1;
	    }
	}

	/* -------------------- */
	if ( !(ar__ownership_names->l_flags & VMSOBJ_M_ALLOC) )
	{
	    /* make a copy for updates */
	    if (vo_copy_ownership (ar__ownership_names) != 0)
	    {
		return -1;
	    }
	}

	/* -------------------- */
	/* address of first string descriptor */
	ar_ownership =
	    (struct dsc$descriptor_s *)ar__ownership_names->aq_ownership_names;
	if (ar_ownership == NULL)
	{
	    PyObject *ar_bugchkerr;

	    ar_bugchkerr = PyString_FromString
					("BUGCHK ->aq_ownership_names == NULL");
	    PyErr_SetObject(PyExc_RuntimeError, ar_bugchkerr);
	    return -1;
	}

	/* -------------------- */
	/* position to string descriptor */
	for (c = 0; c < i; c++)
	{
	    ar_ownership++;
	}

	/* -------------------- */
	/* always drop old storage - regardless if 'v' = String or None */
	if (ar_ownership->dsc$a_pointer != NULL)
	{
	    l_status = lib$sfree1_dd (ar_ownership);
	    if (l_status != 1) /* SS$_NORMAL */
	    {
		(void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		return -1;
	    }
	    ar_ownership->dsc$w_length  = 0;
	    ar_ownership->dsc$a_pointer = 0;
	}

	/* -------------------- */
	/* put a new string into the empty descriptor */
	if (v != Py_None)
	{
	    long l_status;
	    l_status = lib$sget1_dd (&l_name_length, ar_ownership);
	    if (l_status != 1)
	    {
		(void) PyVMS_ErrSetVal(PyExc_RuntimeError, 1, l_status);
		return -1;
	    }
	    (void) memcpy (ar_ownership->dsc$a_pointer,
			PyString_AS_STRING(v),
			(size_t)l_name_length);
	}

	/* -------------------- */
 	return 0;
} /* ownership_ass_item () */

/* ------------------------------------------------------------------------- */

static PySequenceMethods ownership_as_sequence = {
	(inquiry)ownership_length,		/*sq_length*/
	0, /* (binaryfunc)list_concat,		/*sq_concat*/
	0, /* (intargfunc)list_repeat,		/*sq_repeat*/
	(intargfunc)ownership_item,		/*sq_item*/
	(intintargfunc)ownership_slice,		/*sq_slice*/
	(intobjargproc)ownership_ass_item,	/*sq_ass_item*/
	(intintobjargproc)ownership_ass_slice,	/*sq_ass_slice*/
};

/* ---------------------------------------- */

PyTypeObject vmsobj__ownership_names_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,						/*ob_size*/
	"vmsobj__ownership_names",			/*tp_name*/
	sizeof(vmsobj__ownership_names),		/*tp_basicsize*/
	0,						/*tp_itemsize*/
	/* methods */
	(destructor)vo__ownership_names_dealloc,	/*tp_dealloc*/
	(printfunc)0,					/*tp_print*/
	(getattrfunc)vo__ownership_names_getattr,	/*tp_getattr*/
	(setattrfunc)vo__ownership_names_setattr,	/*tp_setattr*/
	(cmpfunc)0,					/*tp_compare*/
	(reprfunc)vo__ownership_names_repr,		/*tp_repr*/
	0,						/*tp_as_number*/
	&ownership_as_sequence,				/*tp_as_sequence*/
	0,						/*tp_as_mapping*/
	(hashfunc)0,					/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ__OWNERSHIP_NAMES.C */
