/* VMSOBJ_FAB.C - 24-JAN-1999 ZE.
   File Access Block object. Template was: [.OBJECTS]XXOBJECT.C

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <fab.h>
#include "vmsobj__def.h"
#include "vmsobj_nam.h"
#include "vmsobj__xabtst.h"	/* test for _any_ XAB */

/* -------------------- */
/* this structure is also defined in "vmsobj_fab.h" */
typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct FAB	* ab_fab;	/* the VMS FAB */
	/* pointers to other objects that the FAB points to */
	PyObject	* ar_dna;	/* default name */
	PyObject	* ar_fna;	/* file name */
	PyObject	* ar_ctx;	/* FAB$L_CTX replacement */
	PyObject	* ar_nam;	/* NAM object */
	PyObject	* ar_xab;	/* XAB object */
} vmsobj_fab;

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_fab_type;

/* ------------------------------------------------------------------------- */
vmsobj_fab *
vmsobj_fab_new (struct FAB *arg)
{
	vmsobj_fab *xp;

	/* -------------------- */
	/* new 'vmsobj_fab' object */
	xp = PyObject_NEW (vmsobj_fab, &vmsobj_fab_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the FAB points to */
	xp->ar_dna = NULL;
	xp->ar_fna = NULL;
	xp->ar_ctx = NULL; /* FAB$L_CTX replacement */
	xp->ar_nam = NULL;
	xp->ar_xab = NULL;

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real FAB and note it's address */
	    xp->ab_fab = malloc (FAB$K_BLN);
	    if (xp->ab_fab == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    *xp->ab_fab  = cc$rms_fab;
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing FAB */
	    xp->ab_fab = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	/* store the vmsobj_fab object address in the FAB */
	xp->ab_fab->fab$l_ctx = (long)xp;

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_fab methods */

static void
vo_fab_dealloc (vmsobj_fab *xp)
{
	/* was FAB allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS FAB */
	    if (xp->ab_fab != NULL)
	    {
		(void) free (xp->ab_fab);
	    }
	}
	else
	{
	    /* The VMS FAB was not allocated by the object creation routine; */
	    /* its address was supplied to it.				     */
	    /* Remove the vmsobj_fab object address from the FAB.	     */
	    xp->ab_fab->fab$l_ctx = 0;

	/* @@ something of this broke VMS_LIB_DELETE_FILE */
	    /* Remove DNA from the FAB. */
	    /* xp->ab_fab->fab$l_dna = 0;
	    /* xp->ab_fab->fab$b_dns = 0;
	    /* Remove FNA from the FAB. */
	    /* xp->ab_fab->fab$l_fna = 0;
	    /* xp->ab_fab->fab$b_fns = 0;
	    /* Remove NAM from the FAB. */
	    /* xp->ab_fab->fab$l_nam = 0;
	    /* Remove any XABs from the FAB. */
	    /* xp->ab_fab->fab$l_xab = 0; */
	}

	/* -------------------- */
	/* delete references to other objects the FAB might point to */
	if (xp->ar_dna != NULL)
	{
	    Py_DECREF(xp->ar_dna);
	}
	if (xp->ar_fna != NULL)
	{
	    Py_DECREF(xp->ar_fna);
	}
	if (xp->ar_ctx != NULL)
	{
	    Py_DECREF(xp->ar_ctx);
	}
	if (xp->ar_nam != NULL)
	{
	    Py_DECREF(xp->ar_nam);
	}
	if (xp->ar_xab != NULL)
	{
	    Py_DECREF(xp->ar_xab);
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_fab_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_fab_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within FAB */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_fab_attr vmsobj_fab_attr;

/* FAB$B_BID + FAB$B_BLN are not changeable as they identify a FAB */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* address bits */

#define OB_K_DNA 1
#define OB_K_FNA 2
#define OB_K_CTX 3
#define OB_K_NAM 4
#define OB_K_XAB 5

static vmsobj_fab_attr vmsobj_r_fab_attr [] = {
	{"B_ACMODES",	74,	ITMTYP_K_BYTE,0	} ,
/* FAB$V_LNM_MODE, FAB$V_CHAN_MODE, FAB$V_FILE_MODE, FAB$V_CALLERS_MODE */
	{"L_ALQ",	16,	ITMTYP_K_LONG,0	} ,
	{"B_BID",	ROAT+0,	ITMTYP_K_BYTE,0	} , /* blk identifier */
	{"B_BKS",	62,	ITMTYP_K_BYTE,0	} ,
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} , /* blk length */
	{"W_BLS",	60,	ITMTYP_K_WORD,0	} ,
	{"CTX",		OBIO+OB_K_CTX,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_CTX",	ROAT+24,ITMTYP_K_LONG,0	} ,
	{"W_DEQ",	20,	ITMTYP_K_WORD,0	} ,
	{"L_DEV",	64,	ITMTYP_K_LONG,0	} , /* dev chars */
	  /* DEV_M_xxx ... */
	{"DNA",		OBIO+OB_K_DNA,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_DNA",	ROAT+48,ITMTYP_K_LONG,0	} ,
	{"B_DNS",	ROAT+53,ITMTYP_K_BYTE,0	} ,
	{"B_FAC",	22,	ITMTYP_K_BYTE,0	} ,
	 {"M_PUT",	22,	ITMTYP_K_BYTE,FAB$M_PUT } ,
	 {"M_GET",	22,	ITMTYP_K_BYTE,FAB$M_GET } ,
	 {"M_DEL",	22,	ITMTYP_K_BYTE,FAB$M_DEL } ,
	 {"M_UPD",	22,	ITMTYP_K_BYTE,FAB$M_UPD } ,
	 {"M_TRN",	22,	ITMTYP_K_BYTE,FAB$M_TRN } ,
	 {"M_BIO",	22,	ITMTYP_K_BYTE,FAB$M_BIO } ,
	 {"M_BRO",	22,	ITMTYP_K_BYTE,FAB$M_BRO } ,
	 {"M_EXE",	22,	ITMTYP_K_BYTE,FAB$M_EXE } ,
	{"FNA",		OBIO+OB_K_FNA,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_FNA",	ROAT+44,ITMTYP_K_LONG,0	} ,
	{"B_FNS",	ROAT+52,ITMTYP_K_BYTE,0	} ,
	{"L_FOP",	4,	ITMTYP_K_LONG,0	} ,
	 {"M_ASY",	4,	ITMTYP_K_LONG,FAB$M_ASY } ,
	 {"M_MXV",	4,	ITMTYP_K_LONG,FAB$M_MXV } ,
	 {"M_SUP",	4,	ITMTYP_K_LONG,FAB$M_SUP } ,
	 {"M_TMP",	4,	ITMTYP_K_LONG,FAB$M_TMP } ,
	 {"M_TMD",	4,	ITMTYP_K_LONG,FAB$M_TMD } ,
	 {"M_DFW",	4,	ITMTYP_K_LONG,FAB$M_DFW } ,
	 {"M_SQO",	4,	ITMTYP_K_LONG,FAB$M_SQO } ,
	 {"M_RWO",	4,	ITMTYP_K_LONG,FAB$M_RWO } ,
	 {"M_POS",	4,	ITMTYP_K_LONG,FAB$M_POS } ,
	 {"M_WCK",	4,	ITMTYP_K_LONG,FAB$M_WCK } ,
	 {"M_NEF",	4,	ITMTYP_K_LONG,FAB$M_NEF } ,
	 {"M_RWC",	4,	ITMTYP_K_LONG,FAB$M_RWC } ,
	 {"M_DMO",	4,	ITMTYP_K_LONG,FAB$M_DMO } ,
	 {"M_SPL",	4,	ITMTYP_K_LONG,FAB$M_SPL } ,
	 {"M_SCF",	4,	ITMTYP_K_LONG,FAB$M_SCF } ,
	 {"M_DLT",	4,	ITMTYP_K_LONG,FAB$M_DLT } ,
	 {"M_NFS",	4,	ITMTYP_K_LONG,FAB$M_NFS } ,
	 {"M_UFO",	4,	ITMTYP_K_LONG,FAB$M_UFO } ,
	 {"M_PPF",	4,	ITMTYP_K_LONG,FAB$M_PPF } ,
	 {"M_INP",	4,	ITMTYP_K_LONG,FAB$M_INP } ,
	 {"M_CTG",	4,	ITMTYP_K_LONG,FAB$M_CTG } ,
	 {"M_CBT",	4,	ITMTYP_K_LONG,FAB$M_CBT } ,
	 {"M_SYNCSTS",	4,	ITMTYP_K_LONG,FAB$M_SYNCSTS } ,
	 {"M_RCK",	4,	ITMTYP_K_LONG,FAB$M_RCK } ,
	 {"M_NAM",	4,	ITMTYP_K_LONG,FAB$M_NAM } ,
	 {"M_CIF",	4,	ITMTYP_K_LONG,FAB$M_CIF } ,
	 {"M_ESC",	4,	ITMTYP_K_LONG,FAB$M_ESC } ,
	 {"M_TEF",	4,	ITMTYP_K_LONG,FAB$M_TEF } ,
	 {"M_OFP",	4,	ITMTYP_K_LONG,FAB$M_OFP } ,
	 {"M_KFO",	4,	ITMTYP_K_LONG,FAB$M_KFO } ,
	{"B_FSZ",	63,	ITMTYP_K_BYTE,0	} ,
	{"W_GBC",	72,	ITMTYP_K_WORD,0	} ,
	{"W_IFI",	2,	ITMTYP_K_WORD,0	} ,
/* --	 {"M_PPF_RAT",	2,	ITMTYP_K_WORD,FAB$M_PPF_RAT } , bit6:13 */
	 {"M_PPF_IND",	2,	ITMTYP_K_WORD,FAB$M_PPF_IND } ,
	 {"M_PPIFI",	2,	ITMTYP_K_WORD,FAB$M_PPIFI } ,
	{"B_JOURNAL",	32,	ITMTYP_K_BYTE,0	} ,
	 {"M_ONLY_RU",	32,	ITMTYP_K_BYTE,FAB$M_ONLY_RU } ,
	 {"M_RU",	32,	ITMTYP_K_BYTE,FAB$M_RU } ,
	 {"M_BI",	32,	ITMTYP_K_BYTE,FAB$M_BI } ,
	 {"M_AI",	32,	ITMTYP_K_BYTE,FAB$M_AI } ,
	 {"M_AT",	32,	ITMTYP_K_BYTE,FAB$M_AT } ,
	 {"M_NEVER_RU",	32,	ITMTYP_K_BYTE,FAB$M_NEVER_RU } ,
	 {"M_JOURNAL_FILE", 32, ITMTYP_K_BYTE,FAB$M_JOURNAL_FILE } ,
	{"L_MRN",	56,	ITMTYP_K_WORD,0	} ,
	{"W_MRS",	54,	ITMTYP_K_WORD,0	} ,
	{"NAM",		OBIO+OB_K_NAM,
				ITMTYP_K_BOOL,0	} ,
	{"L_NAM",	ROAT+40,ITMTYP_K_LONG,0	} ,
	{"B_ORG",	29,	ITMTYP_K_BYTE,0	} ,/*FAB$R_ORG_BITS 4:8 */
	{"B_RAT",	30,	ITMTYP_K_BYTE,0	} ,
	 {"M_FTN",	30,	ITMTYP_K_BYTE,FAB$M_FTN } ,
	 {"M_CR",	30,	ITMTYP_K_BYTE,FAB$M_CR } ,
	 {"M_PRN",	30,	ITMTYP_K_BYTE,FAB$M_PRN } ,
	 {"M_BLK",	30,	ITMTYP_K_BYTE,FAB$M_BLK } ,
	 {"M_MSB",	30,	ITMTYP_K_BYTE,FAB$M_MSB } ,
	{"B_RCF",	75,	ITMTYP_K_BYTE,0	} ,
	 {"M_RCF_RU",	75,	ITMTYP_K_BYTE,FAB$M_RCF_RU } ,
	 {"M_RCF_AI",	75,	ITMTYP_K_BYTE,FAB$M_RCF_AI } ,
	 {"M_RCF_BI",	75,	ITMTYP_K_BYTE,FAB$M_RCF_BI } ,
	{"B_RFM",	31,	ITMTYP_K_BYTE,0	} ,
	{"B_RTV",	28,	ITMTYP_K_BYTE,0	} ,
	{"B_RU_FACILITY", 33,	ITMTYP_K_BYTE,0 } ,
	{"L_SDC",	68,	ITMTYP_K_LONG,0	} , /* sec dev char */
	  /* DEV_M_xxx */
	{"B_SHR",	23,	ITMTYP_K_BYTE,0	} ,
	 {"M_SHRPUT",	23,	ITMTYP_K_BYTE,FAB$M_SHRPUT } ,
	 {"M_SHRGET",	23,	ITMTYP_K_BYTE,FAB$M_SHRGET } ,
	 {"M_SHRDEL",	23,	ITMTYP_K_BYTE,FAB$M_SHRDEL } ,
	 {"M_SHRUPD",	23,	ITMTYP_K_BYTE,FAB$M_SHRUPD } ,
	 {"M_MSE",	23,	ITMTYP_K_BYTE,FAB$M_MSE } ,
	 {"M_NIL",	23,	ITMTYP_K_BYTE,FAB$M_NIL } ,
	 {"M_UPI",	23,	ITMTYP_K_BYTE,FAB$M_UPI } ,
	{"L_STS",	8,	ITMTYP_K_LONG,0	} ,
	{"L_STV",	12,	ITMTYP_K_LONG,0	} ,
	{"XAB",		OBIO+OB_K_XAB,
				ITMTYP_K_BOOL,0	} ,
	{"L_XAB",	ROAT+36,ITMTYP_K_LONG,0	} ,
	{NULL,  0,	0		}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_fab_getattr (vmsobj_fab *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_fab_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_fab_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_fab;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_fab_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_fab_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_fab_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_DNA:
		if (xp->ar_dna != NULL)
		{
		    Py_INCREF (xp->ar_dna);
		    return xp->ar_dna;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_FNA:
		if (xp->ar_fna != NULL)
		{
		    Py_INCREF (xp->ar_fna);
		    return xp->ar_fna;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_CTX:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_ctx != NULL)
		{
		    Py_INCREF (xp->ar_ctx);
		    return xp->ar_ctx;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_NAM:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_nam != NULL)
		{
		    Py_INCREF (xp->ar_nam);
		    return xp->ar_nam;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_XAB:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_xab != NULL)
		{
		    Py_INCREF (xp->ar_xab);
		    return xp->ar_xab;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_fab_attr[l_attr_idx].w_offset & OFSMSK);
	      if (vmsobj_r_fab_attr[l_attr_idx].l_mask == 0)
	      {
                /* return resultant-value */
                return vms__cvt_bin2py
                  (ab_data				/* data address */
                  ,vmsobj_r_fab_attr[l_attr_idx].w_typ	/* data type	*/
                  ,vmsdef_gl_itmtypsiz[			/* data length	*/
		     vmsobj_r_fab_attr[l_attr_idx].w_typ
				      ]
		  );
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_fab_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_fab_methods, (PyObject *)xp, name);
} /* vo_fab_getattr (vmsobj_fab *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_fab_setattr (vmsobj_fab *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_fab_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_fab_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_fab;

	    if ( !(vmsobj_r_fab_attr[l_attr_idx].w_offset & ROAT))
	    {
	      if (vmsobj_r_fab_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int    w_objtyp;
		char		   * at_string;
		unsigned long	     l_string_len;

		w_objtyp = vmsobj_r_fab_attr[l_attr_idx].w_offset & OFSMSK;
		if ((w_objtyp == OB_K_DNA) || (w_objtyp == OB_K_FNA))
		{
		  if (PyString_Check(v))
		  {
		    at_string    = PyString_AS_STRING(v);
		    l_string_len = PyString_Size(v);
		    if (l_string_len > 255)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"string length limited to 255 characters");
		      return -1;
		    }
		    /* keep reference, because FAB points to string area */
		    Py_INCREF (v);
		    ar_v = v;
		  }
		  else
		  {
		    if (v != Py_None)
		    {
		      PyErr_SetString(PyExc_TypeError,
			"attribute must be string or None");
		      return -1;
		    }
		    at_string    = 0;
		    l_string_len = 0;
		    ar_v	 = NULL; /* no reference to Py_None ! */
		  }
		} /* ((w_objtyp == OB_K_DNA) || (w_objtyp == OB_K_FNA)) */

		switch (w_objtyp)
		{
		/* ---------- */
		case OB_K_CTX:
		  if (xp->ar_ctx != NULL)
		  {
		    Py_DECREF(xp->ar_ctx);  /* drop old reference */
		  }
		  xp->ar_ctx = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_rab points to object */
		  Py_INCREF (v);
		  return 0; /* OK */
		/* ---------- */
		case OB_K_DNA:
		  if (xp->ar_dna != NULL)
		  {
		    Py_DECREF (xp->ar_dna);  /* drop old reference */
		  }
		  xp->ar_dna            = ar_v; /* remember for Py_DECREF */
		  xp->ab_fab->fab$l_dna = at_string;
		  xp->ab_fab->fab$b_dns = l_string_len;
		  return 0; /* OK */
		/* ---------- */
		case OB_K_FNA:
		  if (xp->ar_fna != NULL)
		  {
		    Py_DECREF (xp->ar_fna);  /* drop old reference */
		  }
		  xp->ar_fna            = v; /* remember for Py_DECREF */
		  xp->ab_fab->fab$l_fna = at_string;
		  xp->ab_fab->fab$b_fns = l_string_len;
		  return 0; /* OK */
		/* ---------- */
		case OB_K_NAM:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to NAM */
		    if (xp->ar_nam != NULL)
		    {
		      Py_DECREF(xp->ar_nam);  /* drop old reference */
		    }
		    xp->ab_fab->fab$l_nam = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is a NAM */
		  if (! vmsobj_nam_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_nam object or None");
		    return -1;
		  }
		  if (xp->ar_nam != NULL)
		  {
		    Py_DECREF(xp->ar_nam);  /* drop old reference */
		  }
		  {
		    vmsobj_nam * ar_nam;

		    /* keep reference, because vmsobj_fab points to object */
		    Py_INCREF (v);
		    ar_nam = (vmsobj_nam *)v;
		    xp->ar_nam = v;		/* remember for Py_DECREF */
		    xp->ab_fab->fab$l_nam = ar_nam->ab_nam;		    
		  }
		  return 0; /* OK */
		/* ---------- */
		case OB_K_XAB:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_xab != NULL)
		    {
		      Py_DECREF(xp->ar_xab);  /* drop old reference */
		      xp->ar_xab = NULL;
		    }
		    xp->ab_fab->fab$l_xab = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is _a_ vmsobj_xabXXX */
		  if (! vmsobj__anyxab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_xabXXX object or None");
		    return -1;
		  }
		  if (xp->ar_xab != NULL)
		  {
		    Py_DECREF(xp->ar_xab);  /* drop old reference */
		  }
		  {
		    vmsobj_xaball * ar_xab; /* any xabtype */

		    /* keep reference, because vmsobj_fab points to object */
		    Py_INCREF (v);
		    ar_xab = (vmsobj_xaball *)v;
		    xp->ar_xab = v;		/* remember for Py_DECREF */
		    /* (char*) to keep DEC-C on Alpha quiet */
		    xp->ab_fab->fab$l_xab = (char *)ar_xab->ab_xaball;
		  }
		  return 0; /* OK */
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_fab_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_fab_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
                  /* convert Python type */
                  l_status = vms__cvt_py2bin
                    (v					 /* Python data  */
		    ,ab_data				 /* data address */
                    ,vmsobj_r_fab_attr[l_attr_idx].w_typ /* data type	*/
                    ,vmsdef_gl_itmtypsiz[		 /* data length	*/
		     vmsobj_r_fab_attr[l_attr_idx].w_typ
				      ]
		  );
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_fab_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_fab_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_fab_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_fab_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_fab_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_fab_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_fab_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_fab_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_fab attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_fab attribute");
	return -1;
} /* static int vo_fab_setattr (vmsobj_fab *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_fab_repr (vmsobj_fab *ar_fab)
{
	char buf[40];

	sprintf(buf, "<vmsobj_fab, FAB at 0x%08x>", (ar_fab->ab_fab));
	return PyString_FromString(buf);
} /* static PyObject * vo_fab_repr (vmsobj_fab *ar_fab) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_fab_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_fab",			/*tp_name*/
	sizeof(vmsobj_fab),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_fab_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_fab_getattr,	/*tp_getattr*/
	(setattrfunc)vo_fab_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_fab_repr,		/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_FAB.C */
