#ifndef VMSOBJ_FAB_H
#define VMSOBJ_FAB_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS FAB (file access block) object */

#include <fab.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct FAB	* ab_fab;	/* the VMS FAB */
	/* pointers to other objects that the FAB points to */
	PyObject	* ar_dna;	/* default name */
	PyObject	* ar_fna;	/* file name */
	PyObject	* ar_ctx;	/* FAB$L_CTX */
	PyObject	* ar_nam;	/* NAM object (vmsobj_nam *)    */
	PyObject	* ar_xab;	/* XAB object (vmsobj_xabXXX *) */
} vmsobj_fab;

extern DL_IMPORT(PyTypeObject) vmsobj_fab_type;
extern DL_IMPORT(vmsobj_fab *) vmsobj_fab_new (struct FAB *arg);

#define vmsobj_fab_Check(op) ((op)->ob_type == &vmsobj_fab_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_FAB_H */
