/* VMSOBJ_IOSB.C - 20-JAN-1999 ZE.
   I/O status block object. Template was: [.OBJECTS]XXOBJECT.C

   24-FEB-1999 ZE. -- make 'vmsobj_iosb_attr' compatible with other VMSOBJs
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include "vmsobj__def.h"
/* -------------------- */
/* #include "vmsobj_iosb.h" */
typedef struct {
	PyObject_HEAD
	long	  l_flags;
	long	* aq_iosb;	/* the VMS I/O status block */
} vmsobj_iosb;

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_iosb_type;

/* ------------------------------------------------------------------------- */
vmsobj_iosb *
vmsobj_iosb_new (char *arg)
{
	vmsobj_iosb *xp;

	/* -------------------- */
	/* new 'vmsobj_iosb' object */
	xp = PyObject_NEW (vmsobj_iosb, &vmsobj_iosb_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real IOSB and note it's address */
	    xp->aq_iosb = malloc (8);
	    if (xp->aq_iosb == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    (void) memset (xp->aq_iosb, 0, 8);
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing IOSB */
	    xp->aq_iosb = (long *)arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_iosb methods */

static void
vo_iosb_dealloc (vmsobj_iosb *xp)
{
	/* was IOSB allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS IOSB */
	    if (xp->aq_iosb != NULL)
	    {
		(void) free (xp->aq_iosb);
	    }
	}

	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_iosb_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */
struct vmsobj_iosb_attr {
	char			* at_attrnam;	/* name of attribute  */
	short int		  w_offset;	/* offset within IOSB */
	unsigned short int	  w_typ;	/* data type	      */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_iosb_attr vmsobj_iosb_attr;

static vmsobj_iosb_attr vmsobj_r_iosb_attr [] = {
	{"b0",	0,	ITMTYP_K_BYTE,0	} ,
	{"b1",	1,	ITMTYP_K_BYTE,0	} ,
	{"b2",	2,	ITMTYP_K_BYTE,0	} ,
	{"b3",	3,	ITMTYP_K_BYTE,0	} ,
	{"b4",	4,	ITMTYP_K_BYTE,0	} ,
	{"b5",	5,	ITMTYP_K_BYTE,0	} ,
	{"b6",	6,	ITMTYP_K_BYTE,0	} ,
	{"b7",	7,	ITMTYP_K_BYTE,0	} ,
	{"w0",	0,	ITMTYP_K_WORD,0	} ,
	{"w1",	2,	ITMTYP_K_WORD,0	} ,
	{"w2",	4,	ITMTYP_K_WORD,0	} ,
	{"w3",	6,	ITMTYP_K_WORD,0	} ,
	{"l0",	0,	ITMTYP_K_LONG,0	} ,
	{"l1",	4,	ITMTYP_K_LONG,0	} ,
	{"b",	-8,	ITMTYP_K_BYTE,0	} , /* tuple */
	{"w",	-4,	ITMTYP_K_WORD,0	} , /* tuple */
	{"l",	-2,	ITMTYP_K_LONG,0	} , /* tuple */
	{"q",	0,	ITMTYP_K_QUAD,0	} ,
	{NULL,  0,	0	     ,0	}
};

/* ------------------------------------------------------------------------- */
static PyObject *
vo_iosb_getattr (vmsobj_iosb *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_iosb_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_iosb_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->aq_iosb;
	    if (vmsobj_r_iosb_attr[l_attr_idx].w_offset >= 0)
	    {
		ab_data += vmsobj_r_iosb_attr[l_attr_idx].w_offset;
                /* return resultant-value */
                return vms__cvt_bin2py
                  (ab_data				/* data address */
                  ,vmsobj_r_iosb_attr[l_attr_idx].w_typ /* data type	*/
                  ,vmsdef_gl_itmtypsiz[			/* data length	*/
		     vmsobj_r_iosb_attr[l_attr_idx].w_typ
				      ]
		  );
	    }
	    else
	    {
	        /* return a tuple */
		unsigned short int w_typ;
		unsigned short int w_siz;

		w_typ = vmsobj_r_iosb_attr[l_attr_idx].w_typ;
		w_siz = vmsdef_gl_itmtypsiz[
		     vmsobj_r_iosb_attr[l_attr_idx].w_typ
				      ] *
		     abs(vmsobj_r_iosb_attr[l_attr_idx].w_offset);

                return vms__cvt_bin2py
                  (ab_data				/* data address */
                  ,vmsobj_r_iosb_attr[l_attr_idx].w_typ /* data type	*/
                  ,vmsdef_gl_itmtypsiz[			/* data length	*/
		     vmsobj_r_iosb_attr[l_attr_idx].w_typ
				      ] *
		     abs(vmsobj_r_iosb_attr[l_attr_idx].w_offset)
		  );
	    }
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_iosb_methods, (PyObject *)xp, name);
}

/* ------------------------------------------------------------------------- */
static int
vo_iosb_setattr (vmsobj_iosb *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_iosb_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_iosb_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;

	    ab_data = (char *)xp->aq_iosb;

	    if (vmsobj_r_iosb_attr[l_attr_idx].w_offset >= 0)
	    {
		ab_data += vmsobj_r_iosb_attr[l_attr_idx].w_offset;
                /* convert Python type */
                l_status = vms__cvt_py2bin
                  (v					/* Python data  */
		  ,ab_data				/* data address */
                  ,vmsobj_r_iosb_attr[l_attr_idx].w_typ /* data type	*/
                  ,vmsdef_gl_itmtypsiz[			/* data length	*/
		     vmsobj_r_iosb_attr[l_attr_idx].w_typ
				      ]
		  );
	    }
	    else
	    {
	        /* accept a tuple */
                l_status = vms__cvt_py2bin
                  (v					/* Python data  */
		  ,ab_data				/* data address */
                  ,vmsobj_r_iosb_attr[l_attr_idx].w_typ /* data type	*/
                  ,vmsdef_gl_itmtypsiz[			/* data length	*/
		     vmsobj_r_iosb_attr[l_attr_idx].w_typ
				      ] *
		     abs(vmsobj_r_iosb_attr[l_attr_idx].w_offset)
		  );

	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_iosb attribute");
	return -1;
}

/* ------------------------------------------------------------------------- */
static PyObject *
vo_iosb_repr (vmsobj_iosb *ar_iosb)
{
	char buf[40];

	sprintf(buf, "<vmsobj_iosb, IOSB at 0x%08x>", (ar_iosb->aq_iosb));
	return PyString_FromString(buf);
}

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_iosb_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_iosb",			/*tp_name*/
	sizeof(vmsobj_iosb),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_iosb_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_iosb_getattr,	/*tp_getattr*/
	(setattrfunc)vo_iosb_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_iosb_repr,		/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_IOSB.C */
