/* VMSOBJ_LKSB.C - 29-MAY-1999 ZE.
   LKSB (LocK Status Block) object. 
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include "vmsobj__def.h"
#include "vmsobj_lksb.h"

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_lksb_type;

/* ------------------------------------------------------------------------- */
vmsobj_lksb *
vmsobj_lksb_new (struct vmsdef_xr_lksb *arg)
{
	vmsobj_lksb *xp;

	/* -------------------- */
	/* new 'vmsobj_lksb' object */
	xp = PyObject_NEW (vmsobj_lksb, &vmsobj_lksb_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real LKSB and note it's address */
#define S_LKSB 24
	    xp->ab_lksb = malloc (S_LKSB); /* sizeof(vmsdef_xr_lksb) */
	    if (xp->ab_lksb == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    (void) memset (xp->ab_lksb, 0, S_LKSB);	/* clear contents */
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing LKSB */
	    xp->ab_lksb = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_lksb methods */

static void
vo_lksb_dealloc (vmsobj_lksb *xp)
{
	/* was LKSB allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS LKSB */
	    if (xp->ab_lksb != NULL)
	    {
		(void) free (xp->ab_lksb);
	    }
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_lksb_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_lksb_attr {
	char			* at_attrnam;	/* name of attribute  */
	short int		  w_offset;	/* offset within LKSB */
	unsigned short int	  w_typ;	/* data type	      */
	long			  l_mask;	/* bit address	      */
};
typedef struct vmsobj_lksb_attr vmsobj_lksb_attr;

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* mask byte offset count */

static vmsobj_lksb_attr vmsobj_r_lksb_attr [] = {
	{"W_STATUS",	0,	ITMTYP_K_WORD,0	} ,
	{"W_RESERVED",	ROAT+2,	ITMTYP_K_WORD,0	} ,
	{"L_LOCKID",	4,	ITMTYP_K_LONG,0	} ,
	{"O_LVB",	8,	ITMTYP_K_OCTA,0	} ,
	{NULL,		0,	0,	0	}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_lksb_getattr (vmsobj_lksb *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_lksb_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_lksb_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_lksb;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_lksb_attr[l_attr_idx].w_offset >= 0) */

	    ab_data += (vmsobj_r_lksb_attr[l_attr_idx].w_offset & OFSMSK);
	    if (vmsobj_r_lksb_attr[l_attr_idx].l_mask == 0)
	    {
		/* return resultant-value */
		return vms__cvt_bin2py
		    (ab_data				  /* data address */
		    ,vmsobj_r_lksb_attr[l_attr_idx].w_typ /* data type	  */
		    ,vmsdef_gl_itmtypsiz[		  /* data length  */
			vmsobj_r_lksb_attr[l_attr_idx].w_typ
					]
		    );
	    }
	    else
	    {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_lksb_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	    }
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_lksb_methods, (PyObject *)xp, name);
} /* vo_lksb_getattr (vmsobj_lksb *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_lksb_setattr (vmsobj_lksb *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_lksb_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_lksb_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_lksb;

	    if ( !(vmsobj_r_lksb_attr[l_attr_idx].w_offset & ROAT))
	    {
		/* BWL,M  I/O */
		ab_data += (vmsobj_r_lksb_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_lksb_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
                  /* convert Python type */
                  l_status = vms__cvt_py2bin
                    (v					 /* Python data  */
		    ,ab_data				 /* data address */
                    ,vmsobj_r_lksb_attr[l_attr_idx].w_typ /* data type */
                    ,vmsdef_gl_itmtypsiz[		 /* data length	 */
		     vmsobj_r_lksb_attr[l_attr_idx].w_typ
				      ]
		  );
		/* .. */
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_lksb_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_lksb_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_lksb_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_lksb_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_lksb_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_lksb_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_lksb_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_lksb_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_lksb attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_lksb attribute");
	return -1;
} /* static int vo_lksb_setattr (vmsobj_lksb *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_lksb_repr (vmsobj_lksb *ar_lksb)
{
	char buf[40];

	sprintf(buf, "<vmsobj_lksb, LKSB at 0x%08x>", (ar_lksb->ab_lksb));
	return PyString_FromString(buf);
} /* static PyObject * vo_lksb_repr (vmsobj_lksb *ar_lksb) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_lksb_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_lksb",			/*tp_name*/
	sizeof(vmsobj_lksb),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_lksb_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_lksb_getattr,	/*tp_getattr*/
	(setattrfunc)vo_lksb_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_lksb_repr,		/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_LKSB.C */
