/* VMSOBJ_NAM.C - 09-FEB-1999 ZE.
   NAMe block object. Template was: [.OBJECTS]XXOBJECT.C

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
   29-MAY-1999 ZE. -- fixed W_DID_NUM + W_FID_NUM attributes that erroneously
			returned a tuple of 3W instead of a single Word

*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <nam.h>

#include "vmsobj__def.h"
#include "vmsobj_nam.h"		/* a NAM can point to another NAM - check */
#include "vmsobj__membuf.h"

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_nam_type;

/* ------------------------------------------------------------------------- */
vmsobj_nam *
vmsobj_nam_new (struct NAM *arg)
{
	vmsobj_nam *xp;

	/* -------------------- */
	/* new 'vmsobj_nam' object */
	xp = PyObject_NEW (vmsobj_nam, &vmsobj_nam_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the NAM points to */
	xp->ar_esa = NULL;
	xp->ar_rlf = NULL;
	xp->ar_rsa = NULL;

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real NAM and note it's address */
	    xp->ab_nam = malloc (NAM$K_BLN);

	    if (xp->ab_nam == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    *xp->ab_nam  = cc$rms_nam;
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing NAM */
	    xp->ab_nam = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_nam methods */

static void
vo_nam_dealloc (vmsobj_nam *xp)
{
	/* was NAM allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS NAM */
	    if (xp->ab_nam != NULL)
	    {
		(void) free (xp->ab_nam);
	    }
	}
	else
	{
	    /* The VMS NAM was not allocated by the object creation routine; */
	    /* its address was supplied to it.				     */
	    /* Remove any NAMs from the NAM. */
	    xp->ab_nam->nam$l_rlf  = 0;
	    /* remove string buffer */
	    xp->ab_nam->nam$l_esa  = 0;
	    xp->ab_nam->nam$b_ess  = 0;
	    xp->ab_nam->nam$b_esl  = 0;
	    /* remove string buffer */
	    xp->ab_nam->nam$l_rsa  = 0;
	    xp->ab_nam->nam$b_rss  = 0;
	    xp->ab_nam->nam$b_rsl  = 0;
	    /* possibly buffer removed - go safe */
	    xp->ab_nam->nam$b_node = 0;
	    xp->ab_nam->nam$l_node = 0;
	    xp->ab_nam->nam$b_dev  = 0;
	    xp->ab_nam->nam$l_dev  = 0;
	    xp->ab_nam->nam$b_dir  = 0;
	    xp->ab_nam->nam$l_dir  = 0;
	    xp->ab_nam->nam$b_name = 0;
	    xp->ab_nam->nam$l_name = 0;
	    xp->ab_nam->nam$b_type = 0;
	    xp->ab_nam->nam$l_type = 0;
	    xp->ab_nam->nam$b_ver  = 0;
	    xp->ab_nam->nam$l_ver  = 0;
	}

	/* -------------------- */
	/* delete references to other objects the NAM might point to */
	if (xp->ar_esa != NULL)
	{
	    Py_DECREF(xp->ar_esa);
	}
	if (xp->ar_rlf != NULL)
	{
	    Py_DECREF(xp->ar_rlf);
	}
	if (xp->ar_rsa != NULL)
	{
	    Py_DECREF(xp->ar_rsa);
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_nam_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_nam_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within NAM */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_nam_attr vmsobj_nam_attr;

/* NAM$B_BID + NAM$B_BLN are not changeable as they identify a NAM */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* address bits */

#define OB_K_DEV  1
#define OB_K_DIR  2
#define OB_K_DVI  3
#define OB_K_ESA  4
#define OB_K_NAME 5
#define OB_K_NODE 6
#define OB_K_RLF  7
#define OB_K_RSA  8
#define OB_K_TYPE 9
#define OB_K_VER  10

static vmsobj_nam_attr vmsobj_r_nam_attr [] = {
	{"B_BID",	ROAT+0,	ITMTYP_K_BYTE,0	} , /* blk identifier */
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} , /* blk length */
	{"DEV",		ROAT+OBIO+OB_K_DEV,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_DEV",	ROAT+57,ITMTYP_K_BYTE,0	} ,
	{"L_DEV",	ROAT+68,ITMTYP_K_LONG,0	} ,
	{"W_DID",	42,	ITMTYP_K_WORD,3	} , /* 3W */
	{"W_DID_NUM",	42,	ITMTYP_K_WORD,0	} , /* subfields of W_DID */
	{"W_DID_SEQ",	44,	ITMTYP_K_WORD,0	} , /* " */
	{"W_DID_RVN",	46,	ITMTYP_K_WORD,0	} , /* " */
	{"B_DID_RVN",	46,	ITMTYP_K_WORD,0	} , /* " */
	{"B_DID_NMX",	47,	ITMTYP_K_WORD,0	} , /* " */
	{"DIR",		ROAT+OBIO+OB_K_DIR,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_DIR",	ROAT+58,ITMTYP_K_BYTE,0	} ,
	{"L_DIR",	ROAT+72,ITMTYP_K_LONG,0	} ,
	{"DVI",		ROAT+OBIO+OB_K_DVI,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"T_DVI",	ROAT+20,ITMTYP_K_LONG,0 } , /* ASCIC len(<=16) */
	/* DVI: char nam$t_dvi [16]; */
	{"ESA",		OBIO+OB_K_ESA,		    /* expanded string area */
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_ESL",	ROAT+11,ITMTYP_K_BYTE,0	} , /* wrt by RMS */
	{"B_ESS",	ROAT+10,ITMTYP_K_BYTE,0	} , /* bufsiz if L_ESS */
	{"L_ESA",	ROAT+12,ITMTYP_K_LONG,0	} , /* bufadr */
	{"W_FID",	36,	ITMTYP_K_WORD,3	} , /* 3W */
	{"W_FID_NUM",	36,	ITMTYP_K_WORD,0	} , /* subfields of W_FID */
	{"W_FID_SEQ",	38,	ITMTYP_K_WORD,0	} , /* " */
	{"W_FID_RVN",	40,	ITMTYP_K_WORD,0	} , /* " */
	{"B_FID_RVN",	40,	ITMTYP_K_WORD,0	} , /* " */
	{"B_FID_NMX",	41,	ITMTYP_K_WORD,0	} , /* " */
	{"L_FNB",	52,	ITMTYP_K_LONG,0	} ,
	 {"M_CNCL_DEV",	52,	ITMTYP_K_LONG,NAM$M_CNCL_DEV } ,
	  /* v-- @@ a 3-bit field */
	 {"M_DIR_LVLS",	52,	ITMTYP_K_LONG,NAM$M_DIR_LVLS } ,
	 {"M_EXP_DEV",	52,	ITMTYP_K_LONG,NAM$M_EXP_DEV } ,
	 {"M_EXP_DIR",	52,	ITMTYP_K_LONG,NAM$M_EXP_DIR } ,
	 {"M_EXP_NAME",	52,	ITMTYP_K_LONG,NAM$M_EXP_NAME } ,
	 {"M_EXP_TYPE",	52,	ITMTYP_K_LONG,NAM$M_EXP_TYPE } ,
	 {"M_EXP_VER",	52,	ITMTYP_K_LONG,NAM$M_EXP_VER } ,
	 {"M_GRP_MBR",	52,	ITMTYP_K_LONG,NAM$M_GRP_MBR } ,
	 {"M_HIGHVER",	52,	ITMTYP_K_LONG,NAM$M_HIGHVER } ,
	 {"M_LOWVER",	52,	ITMTYP_K_LONG,NAM$M_LOWVER } ,
	 {"M_NODE",	52,	ITMTYP_K_LONG,NAM$M_NODE } ,
	 {"M_PPF",	52,	ITMTYP_K_LONG,NAM$M_PPF } ,
	 {"M_QUOTED",	52,	ITMTYP_K_LONG,NAM$M_QUOTED } ,
	 {"M_ROOT_DIR",	52,	ITMTYP_K_LONG,NAM$M_ROOT_DIR } ,
	 {"M_SEARCH_LIST", 52,	ITMTYP_K_LONG,NAM$M_SEARCH_LIST } ,
	 {"M_WILDCARD",	52,	ITMTYP_K_LONG,NAM$M_WILDCARD } ,
	 {"M_WILD_DIR",	52,	ITMTYP_K_LONG,NAM$M_WILD_DIR } ,
	 {"M_WILD_GRP",	52,	ITMTYP_K_LONG,NAM$M_WILD_GRP } ,
	 {"M_WILD_MBR",	52,	ITMTYP_K_LONG,NAM$M_WILD_MBR } ,
	 {"M_WILD_NAME", 52,	ITMTYP_K_LONG,NAM$M_WILD_NAME } ,
	 {"M_WILD_SFD1", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD1 } ,
	 {"M_WILD_SFD2", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD2 } ,
	 {"M_WILD_SFD3", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD3 } ,
	 {"M_WILD_SFD4", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD4 } ,
	 {"M_WILD_SFD5", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD5 } ,
	 {"M_WILD_SFD6", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD6 } ,
	 {"M_WILD_SFD7", 52,	ITMTYP_K_LONG,NAM$M_WILD_SFD7 } ,
	 {"M_WILD_TYPE", 52,	ITMTYP_K_LONG,NAM$M_WILD_TYPE } ,
	 {"M_WILD_UFD",	52,	ITMTYP_K_LONG,NAM$M_WILD_UFD } ,
	 {"M_WILD_VER",	52,	ITMTYP_K_LONG,NAM$M_WILD_VER } ,
	{"NAME",	ROAT+OBIO+OB_K_NAME,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_NAME",	ROAT+59,ITMTYP_K_BYTE,0	} ,
	{"L_NAME",	ROAT+76,ITMTYP_K_LONG,0	} ,
	{"NODE",	ROAT+OBIO+OB_K_NODE,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_NODE",	ROAT+56,ITMTYP_K_BYTE,0	} ,
	{"L_NODE",	ROAT+64,ITMTYP_K_LONG,0	} ,
	{"B_NOP",	8,	ITMTYP_K_BYTE,0	} ,
	 {"M_NOCONCEAL", 8,	ITMTYP_K_LONG,NAM$M_NOCONCEAL } ,
	 {"M_PWD",	8,	ITMTYP_K_LONG,NAM$M_PWD } ,
	 {"M_SRCHXABS",	8,	ITMTYP_K_LONG,NAM$M_SRCHXABS } ,
	 {"M_SYNCHK",	8,	ITMTYP_K_LONG,NAM$M_SYNCHK } ,
	 {"M_SLPARSE",	8,	ITMTYP_K_LONG,NAM$M_SLPARSE } ,
	{"B_RFS",	9,	ITMTYP_K_BYTE,0	} , /* remote filesys -undoc */
	{"RLF",		OBIO+OB_K_RLF,		    /* related file - NAM */
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_RLF",	ROAT+16,ITMTYP_K_LONG,0	} ,
	{"RSA",		OBIO+OB_K_RSA,		    /* resultant string area */
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_RSL",	ROAT+3, ITMTYP_K_BYTE,0	} , /* wrt by RMS */
	{"B_RSS",	ROAT+2, ITMTYP_K_BYTE,0	} , /* bufsiz if L_RSS */
	{"L_RSA",	ROAT+4, ITMTYP_K_LONG,0	} , /* bufadr */
	{"TYPE",	ROAT+OBIO+OB_K_TYPE,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_TYPE",	ROAT+60,ITMTYP_K_BYTE,0	} ,
	{"L_TYPE",	ROAT+80,ITMTYP_K_LONG,0	} ,
	{"VER",		ROAT+OBIO+OB_K_VER,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"B_VER",	ROAT+61,ITMTYP_K_BYTE,0	} ,
	{"L_VER",	ROAT+84,ITMTYP_K_LONG,0	} ,
	{"L_WCC",	48,	ITMTYP_K_LONG,0 } ,
	 {"M_IFI",	48,	ITMTYP_K_LONG,NAM$M_IFI } ,
	 {"M_SRCHNMF",	48,	ITMTYP_K_LONG,NAM$M_SRCHNMF } ,
	 {"M_SVCTX",	48,	ITMTYP_K_LONG,NAM$M_SVCTX } ,
	{NULL,  	0,	0		}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_nam_getattr (vmsobj_nam *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_nam_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_nam_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_nam;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_nam_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_nam_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_DEV:
		if (xp->ab_nam->nam$l_dev == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_dev,
			(unsigned int)xp->ab_nam->nam$b_dev);
	      /* ---------- */
	      case OB_K_DIR:
		if (xp->ab_nam->nam$l_dir == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_dir,
			(unsigned int)xp->ab_nam->nam$b_dev);
	      /* ---------- */
	      case OB_K_DVI:
		{
		  unsigned char   b_dvilen;
		  char		* at_dvi;

		  b_dvilen = xp->ab_nam->nam$t_dvi[0]; /* ASCIC */
		  if ((b_dvilen == 0) || (b_dvilen >= NAM$C_DVI))
		  {
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		  }
		  at_dvi = &xp->ab_nam->nam$t_dvi[0]; /* ASCIC */
		  at_dvi++;
		  return Py_BuildValue ("s#", at_dvi, (unsigned int)b_dvilen);
		}
	      /* ---------- */
	      case OB_K_ESA:
		/* read via L_ESA + B_ESL, not vmsobj__membuf object! */
		/* B_ESL is pre-initialized on set-attibute and */
		/*  later updated by RMS */
		if (xp->ab_nam->nam$l_esa == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_esa,
			(unsigned int)xp->ab_nam->nam$b_esl);
	      /* ---------- */
	      case OB_K_NAME:
		if (xp->ab_nam->nam$l_name == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_name,
			(unsigned int)xp->ab_nam->nam$b_name);
	      /* ---------- */
	      case OB_K_NODE:
		if (xp->ab_nam->nam$l_node == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_node,
			(unsigned int)xp->ab_nam->nam$b_node);
	      /* ---------- */
	      case OB_K_RLF:
		/* related file is a NAM */
		if (xp->ar_rlf == NULL)
		{
		    Py_INCREF(Py_None);
		}
		Py_INCREF(xp->ar_rlf);
		return xp->ar_rlf;
	      /* ---------- */
	      case OB_K_RSA:
		/* read via L_RSA + B_RSL, not vmsobj__membuf object! */
		/* B_RSL is pre-initialized on set-attibute and */
		/*  later updated by RMS */
		if (xp->ab_nam->nam$l_rsa == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_rsa,
			(unsigned int)xp->ab_nam->nam$b_rsl);
	      /* ---------- */
	      case OB_K_TYPE:
		if (xp->ab_nam->nam$l_type == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_type,
			(unsigned int)xp->ab_nam->nam$b_type);
	      /* ---------- */
	      case OB_K_VER:
		if (xp->ab_nam->nam$l_ver == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		return Py_BuildValue ("s#",
			xp->ab_nam->nam$l_ver,
			(unsigned int)xp->ab_nam->nam$b_ver);
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK);

	      /* special check for W_DID + W_FID, which are 3W */
	      if (
		  (vmsobj_r_nam_attr[l_attr_idx].l_mask == 3) &&
		  (
		   ((vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK) == 36) ||
		   ((vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK) == 42)
		  )
		 )
	      {
		  /* return resultant-value (3W) */
		  return vms__cvt_bin2py
		    (ab_data				 /* data address */
		    ,vmsobj_r_nam_attr[l_attr_idx].w_typ /* data type    */
		    ,(unsigned short int) 6		 /* data length  */
		  );
	      }

	      if (vmsobj_r_nam_attr[l_attr_idx].l_mask == 0)
	      {
		  /* return resultant-value */
		  return vms__cvt_bin2py
		    (ab_data				 /* data address */
		    ,vmsobj_r_nam_attr[l_attr_idx].w_typ /* data type	 */
		    ,vmsdef_gl_itmtypsiz[		 /* data length	 */
			vmsobj_r_nam_attr[l_attr_idx].w_typ
					]
		  );
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_nam_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_nam_methods, (PyObject *)xp, name);
} /* vo_nam_getattr (vmsobj_nam *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_nam_setattr (vmsobj_nam *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_nam_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_nam_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_nam;

	    if ( !(vmsobj_r_nam_attr[l_attr_idx].w_offset & ROAT))
	    {
	      /* the following object I/Os are readonly: */
	      /* OB_K_DEV, OB_K_DIR, OB_K_NAME, OB_K_NODE, OB_K_TYPE, */
	      /* OB_K_VER, OB_K_DVI, */
	      /* remaining object I/Os : */
	      /* OB_K_ESA, */
		/* provide a user buffer L_ESA = addr, B_ESS = size */
		/* use code from FAB */
		/* if None -assignment, then zero L_NODE, DEV, DIR,  ... */
	      /* OB_K_RLF, */
		/* a NAM! */
	      /* OB_K_RSA */
		/* provide a user buffer L_RSA = addr, B_RSS = size */
		/* use code from FAB */
		/* if None -assignment, then zero L_NODE, DEV, DIR,  ... */

	      if (vmsobj_r_nam_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int    w_objtyp;
		char		   * at_string;
		unsigned long	     l_string_len;

		w_objtyp = vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK;
		if ((w_objtyp == OB_K_ESA) || (w_objtyp == OB_K_RSA))
		{
		  /* they need a vmsobj__membuf object */
		  if (!vmsobj__membuf_Check(v))
		  {
		    if (v != Py_None)
		    {
		      PyErr_SetString(PyExc_TypeError,
			"buffer must be vmsobj__membuf or None");
		      return -1;
		    }
		    at_string    = NULL;
		    l_string_len = 0;
		    ar_v	 = NULL; /* vmsobj__membuf */
		  }
		  else
		  {
		    /* size of buffer object must be <= 255 */
		    if (((vmsobj__membuf *)v)->l_bufsiz > 255)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"buffer size limited to 255 characters");
		      return -1;
		    }
		    at_string    = ((vmsobj__membuf *)v)->ab_membuf;
		    l_string_len = ((vmsobj__membuf *)v)->l_bufsiz;
		    /* keep reference, because NAM points to membuf */
		    Py_INCREF (v);
		    ar_v	 = v; /* vmsobj__membuf */
		  }
		} /* ((w_objtyp == OB_K_ESA) || (w_objtyp == OB_K_RSA)) */

		switch (w_objtyp)
		{
		/* ---------- */
		case OB_K_ESA:
		  if (xp->ar_esa != NULL)
		  {
		    Py_DECREF (xp->ar_esa);  /* drop old reference */
		  }
		  xp->ar_esa             = ar_v; /* remember for Py_DECREF */
		  xp->ab_nam->nam$l_esa  = at_string;
		  xp->ab_nam->nam$b_ess  = l_string_len;
		  xp->ab_nam->nam$b_esl  = l_string_len;
		  /* possibly buffer removed - go safe */
		  xp->ab_nam->nam$b_node = 0;
		  xp->ab_nam->nam$l_node = 0;
		  xp->ab_nam->nam$b_dev  = 0;
		  xp->ab_nam->nam$l_dev  = 0;
		  xp->ab_nam->nam$b_dir  = 0;
		  xp->ab_nam->nam$l_dir  = 0;
		  xp->ab_nam->nam$b_name = 0;
		  xp->ab_nam->nam$l_name = 0;
		  xp->ab_nam->nam$b_type = 0;
		  xp->ab_nam->nam$l_type = 0;
		  xp->ab_nam->nam$b_ver  = 0;
		  xp->ab_nam->nam$l_ver  = 0;
		  return 0; /* OK */
		/* ---------- */
		case OB_K_RLF:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next NAM */
		    if (xp->ar_rlf != NULL)
		    {
		      Py_DECREF(xp->ar_rlf);  /* drop old reference */
		      xp->ar_rlf = NULL;
		    }
		    xp->ab_nam->nam$l_rlf = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is a NAM */
		  if (! vmsobj_nam_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_nam object or None");
		    return -1;
		  }
		  if (xp->ar_rlf != NULL)
		  {
		    Py_DECREF (xp->ar_rlf);  /* drop old reference */
		  }
		  {
		    vmsobj_nam * ar_nam;

		    /* keep reference, because vmsobj_nam points to object */
		    Py_INCREF (v);
		    ar_nam = (vmsobj_nam *)v;
		    xp->ar_rlf = v;		/* remember for Py_DECREF */
		    xp->ab_nam->nam$l_rlf = ar_nam->ab_nam;		    
		  }
		  return 0; /* OK */
		/* ---------- */
		case OB_K_RSA:
		  if (xp->ar_rsa != NULL)
		  {
		    Py_DECREF (xp->ar_rsa);  /* drop old reference */
		  }
		  xp->ar_rsa             = ar_v; /* remember for Py_DECREF */
		  xp->ab_nam->nam$l_rsa  = at_string;
		  xp->ab_nam->nam$b_rss  = l_string_len;
		  xp->ab_nam->nam$b_rsl  = l_string_len;
		  /* possibly buffer removed - go safe */
		  xp->ab_nam->nam$b_node = 0;
		  xp->ab_nam->nam$l_node = 0;
		  xp->ab_nam->nam$b_dev  = 0;
		  xp->ab_nam->nam$l_dev  = 0;
		  xp->ab_nam->nam$b_dir  = 0;
		  xp->ab_nam->nam$l_dir  = 0;
		  xp->ab_nam->nam$b_name = 0;
		  xp->ab_nam->nam$l_name = 0;
		  xp->ab_nam->nam$b_type = 0;
		  xp->ab_nam->nam$l_type = 0;
		  xp->ab_nam->nam$b_ver  = 0;
		  xp->ab_nam->nam$l_ver  = 0;
		  return 0; /* OK */
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK);

		/* special check for W_DID + W_FID, which are 3W */
		if (
		    (vmsobj_r_nam_attr[l_attr_idx].l_mask == 3) &&
		    (
		     ((vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK) == 36) ||
		     ((vmsobj_r_nam_attr[l_attr_idx].w_offset & OFSMSK) == 42)
		    )
		   )
		{
		  /* convert Python type (3W) */
                  l_status = vms__cvt_py2bin
                    (v					 /* Python data  */
		    ,ab_data				 /* data address */
                    ,vmsobj_r_nam_attr[l_attr_idx].w_typ /* data type	 */
                    ,(unsigned short int) 6		 /* data length	 */
		  );
		}

		if (vmsobj_r_nam_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
                  /* convert Python type */
                  l_status = vms__cvt_py2bin
                    (v					 /* Python data  */
		    ,ab_data				 /* data address */
                    ,vmsobj_r_nam_attr[l_attr_idx].w_typ /* data type	 */
                    ,vmsdef_gl_itmtypsiz[		 /* data length	 */
		     vmsobj_r_nam_attr[l_attr_idx].w_typ
				      ]
		    );
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_nam_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_nam_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_nam_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_nam_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_nam_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_nam_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_nam_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_nam_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_nam attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_nam attribute");
	return -1;
} /* static int vo_nam_setattr (vmsobj_nam *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_nam_repr (vmsobj_nam *ar_nam)
{
	char buf[40];

	sprintf(buf, "<vmsobj_nam, NAM at 0x%08x>", (ar_nam->ab_nam));
	return PyString_FromString(buf);
} /* static PyObject * vo_nam_repr (vmsobj_nam *ar_nam) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_nam_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_nam",			/*tp_name*/
	sizeof(vmsobj_nam),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_nam_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_nam_getattr,	/*tp_getattr*/
	(setattrfunc)vo_nam_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_nam_repr,		/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_NAM.C */
