#ifndef VMSOBJ_NAM_H
#define VMSOBJ_NAM_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS NAM (NAMe block) object */

#include <nam.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct NAM	* ab_nam;	/* the VMS NAM */
	/* pointers to other objects that the NAM points to  */
	PyObject	* ar_esa;	/* MEMBUF object     */
	PyObject	* ar_rlf;	/* vmsobj_nam object */
	PyObject	* ar_rsa;	/* MEMBUF object     */
} vmsobj_nam;

extern DL_IMPORT(PyTypeObject) vmsobj_nam_type;
extern DL_IMPORT(vmsobj_nam *) vmsobj_nam_new (struct NAM *arg);

#define vmsobj_nam_Check(op) ((op)->ob_type == &vmsobj_nam_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_NAM_H */
