/* VMSOBJ_RAB.C - 25-JAN-1999 ZE.
   Record Access Block object. Template was: [.OBJECTS]XXOBJECT.C

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <rab.h>
#ifndef RAB$M_REV
#define RAB$M_REV 128
#endif

#include "vmsobj__def.h"
#include "vmsobj__membuf.h"
#include "vmsobj_fab.h"
#include "vmsobj__xabtst.h"	/* test for _any_ XAB */

/* -------------------- */
/* this structure is also defined in "vmsobj_rab.h" */
typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct RAB	* ab_rab;	/* the VMS RAB */
	/* pointers to other objects that the RAB points to */
	PyObject	* ar_ctx;	/* RAB$L_CTX replacement */
	PyObject	* ar_fab;	/* FAB object */
	PyObject	* ar_xab;	/* XAB object */
	PyObject	* ar_kbfpbf;	/* key/prompt buffer */
	PyObject	* ar_rbf;	/* MEMBUF object */
	PyObject	* ar_ubf;	/* MEMBUF object */
} vmsobj_rab;

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_rab_type;

/* ------------------------------------------------------------------------- */
vmsobj_rab *
vmsobj_rab_new (struct RAB *arg)
{
	vmsobj_rab *xp;

	/* -------------------- */
	/* new 'vmsobj_rab' object */
	xp = PyObject_NEW (vmsobj_rab, &vmsobj_rab_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the RAB points to */
	xp->ar_ctx    = NULL;	/* RAB$L_CTX replacement */
	xp->ar_fab    = NULL;
	xp->ar_xab    = NULL;
	xp->ar_kbfpbf = NULL;	/* key/prompt buffer */
	xp->ar_rbf    = NULL;	/* MEMBUF object */
	xp->ar_ubf    = NULL;	/* MEMBUF object */

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real RAB and note it's address */
	    xp->ab_rab = malloc (RAB$K_BLN);
	    if (xp->ab_rab == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    *xp->ab_rab  = cc$rms_rab;
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing RAB */
	    xp->ab_rab = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	/* store the vmsobj_rab object address in the RAB */
	xp->ab_rab->rab$l_ctx = (long)xp;

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_rab methods */

static void
vo_rab_dealloc (vmsobj_rab *xp)
{
	/* was RAB allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS RAB */
	    if (xp->ab_rab != NULL)
	    {
		(void) free (xp->ab_rab);
	    }
	}
	else
	{
	    /* The VMS RAB was not allocated by the object creation routine; */
	    /* its address was supplied to it.				     */
	    /* Remove the vmsobj_rab object address from the RAB.	     */
	    xp->ab_rab->rab$l_ctx = 0;
	    /* Remove any XABs from the RAB. */
	    xp->ab_rab->rab$l_xab = 0;
	}

	/* -------------------- */
	/* delete references to other objects the RAB might point to */
	if (xp->ar_ctx != NULL)
	{
	    Py_DECREF(xp->ar_ctx);
	}
	if (xp->ar_fab != NULL)
	{
	    Py_DECREF(xp->ar_fab);
	}
	if (xp->ar_xab != NULL)
	{
	    Py_DECREF(xp->ar_xab);
	}
	if (xp->ar_kbfpbf != NULL)
	{
	    Py_DECREF(xp->ar_kbfpbf);
	}
	if (xp->ar_rbf != NULL)
	{
	    Py_DECREF(xp->ar_rbf);
	}
	if (xp->ar_ubf != NULL)
	{
	    Py_DECREF(xp->ar_ubf);
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_rab_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_rab_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within RAB */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_rab_attr vmsobj_rab_attr;

/* RAB$B_BID + RAB$B_BLN are not changeable as they identify a RAB */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* mask byte offset count */

#define OB_K_CTX 1
#define OB_K_FAB 2
#define OB_K_XAB 3
#define OB_K_KBF 4 /* KBF + PBF use the same pointer in the RAB */
#define OB_K_PBF 5
#define OB_K_RBF 6
#define OB_K_UBF 7

static vmsobj_rab_attr vmsobj_r_rab_attr [] = {
	{"B_BID",	ROAT+0,	ITMTYP_K_BYTE,0	} , /* blk identifier */
	{"L_BKT",	56,	ITMTYP_K_LONG,0	} ,
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} , /* blk length */
	{"CTX",		OBIO+OB_K_CTX,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_CTX",	ROAT+24,ITMTYP_K_LONG,0	} ,
	{"L_DCT",	56,	ITMTYP_K_LONG,0	} , /* same cell as L_BKT */
	{"FAB",		OBIO+OB_K_FAB,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_FAB",	ROAT+60,ITMTYP_K_LONG,0	} ,
	{"W_ISI",	2,	ITMTYP_K_WORD,0	} ,
	 {"M_PPF_RAT",	2,	ITMTYP_K_WORD,RAB$M_PPF_RAT } ,
	 {"M_PPF_IND",	2,	ITMTYP_K_WORD,RAB$M_PPF_IND } ,
	 {"M_PPISI",	2,	ITMTYP_K_WORD,RAB$M_PPISI } ,
	{"KBF",		OBIO+OB_K_KBF,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_KBF",	ROAT+48,ITMTYP_K_LONG,0	} , /* = RAB$L_PBF */
	{"B_KRF",	53,	ITMTYP_K_BYTE,0	} ,
	{"B_KSZ",	ROAT+52,ITMTYP_K_BYTE,0	} , /* = RAB$B_PSZ */
	{"B_MBC",	55,	ITMTYP_K_BYTE,0	} ,
	{"B_MBF",	54,	ITMTYP_K_BYTE,0	} ,
	{"PBF",		OBIO+OB_K_PBF,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_PBF",	ROAT+48,ITMTYP_K_LONG,0	} , /* = RAB$L_KBF */
	{"B_PSZ",	ROAT+52,ITMTYP_K_BYTE,0	} , /* = RAB$B_KSZ */
	{"B_RAC",	30,	ITMTYP_K_BYTE,0	} ,
	{"RBF",		OBIO+OB_K_RBF,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_RBF",	ROAT+40,ITMTYP_K_LONG,0	} ,
	{"W_RFA",	16,	ITMTYP_K_WORD,0	} , /* 3W - special code */
	{"L_RFA0",	16,	ITMTYP_K_LONG,0	} ,
	{"W_RFA4",	20,	ITMTYP_K_WORD,0	} ,
/* @@ record header buffer - size = FAB$B_FSZ, yes: FAB$ ! */
	{"L_RHB",	ROAT+44,ITMTYP_K_LONG,0	} ,
	{"L_ROP",	4,	ITMTYP_K_LONG,0	} ,
	 {"M_ASY",	4,	ITMTYP_K_WORD,RAB$M_ASY } ,
	 {"M_TPT",	4,	ITMTYP_K_WORD,RAB$M_TPT } ,
	 {"M_REA",	4,	ITMTYP_K_WORD,RAB$M_REA } ,
	 {"M_RRL",	4,	ITMTYP_K_WORD,RAB$M_RRL } ,
	 {"M_UIF",	4,	ITMTYP_K_WORD,RAB$M_UIF } ,
	 {"M_MAS",	4,	ITMTYP_K_WORD,RAB$M_MAS } ,
	 {"M_FDL",	4,	ITMTYP_K_WORD,RAB$M_FDL } ,
	 {"M_REV",	4,	ITMTYP_K_WORD,RAB$M_REV } ,
	 {"M_EOF",	4,	ITMTYP_K_WORD,RAB$M_EOF } ,
	 {"M_RAH",	4,	ITMTYP_K_WORD,RAB$M_RAH } ,
	 {"M_WBH",	4,	ITMTYP_K_WORD,RAB$M_WBH } ,
	 {"M_BIO",	4,	ITMTYP_K_WORD,RAB$M_BIO } ,
	 {"M_CDK",	4,	ITMTYP_K_WORD,RAB$M_CDK } ,
	 {"M_LOA",	4,	ITMTYP_K_WORD,RAB$M_LOA } ,
	 {"M_LIM",	4,	ITMTYP_K_WORD,RAB$M_LIM } ,
	 {"M_SYNCSTS",	4,	ITMTYP_K_WORD,RAB$M_SYNCSTS } ,
	 {"M_LOC",	4,	ITMTYP_K_WORD,RAB$M_LOC } ,
	 {"M_WAT",	4,	ITMTYP_K_WORD,RAB$M_WAT } ,
	 {"M_ULK",	4,	ITMTYP_K_WORD,RAB$M_ULK } ,
	 {"M_RLK",	4,	ITMTYP_K_WORD,RAB$M_RLK } ,
	 {"M_NLK",	4,	ITMTYP_K_WORD,RAB$M_NLK } ,
	 {"M_KGE",	4,	ITMTYP_K_WORD,RAB$M_KGE } ,
	 {"M_KGT",	4,	ITMTYP_K_WORD,RAB$M_KGT } ,
	 {"M_NXR",	4,	ITMTYP_K_WORD,RAB$M_NXR } ,
	 {"M_RNE",	4,	ITMTYP_K_WORD,RAB$M_RNE } ,
	 {"M_TMO",	4,	ITMTYP_K_WORD,RAB$M_TMO } ,
	 {"M_CVT",	4,	ITMTYP_K_WORD,RAB$M_CVT } ,
	 {"M_RNF",	4,	ITMTYP_K_WORD,RAB$M_RNF } ,
	 {"M_ETO",	4,	ITMTYP_K_WORD,RAB$M_ETO } ,
	 {"M_PTA",	4,	ITMTYP_K_WORD,RAB$M_PTA } ,
	 {"M_PMT",	4,	ITMTYP_K_WORD,RAB$M_PMT } ,
	 {"M_CCO",	4,	ITMTYP_K_WORD,RAB$M_CCO } ,
	 {"M_EQNXT",	4,	ITMTYP_K_WORD,RAB$M_EQNXT } , /* = KGE */
	 {"M_NXT",	4,	ITMTYP_K_WORD,RAB$M_NXT } ,   /* = KGT */
	{"W_RSZ",	ROAT+34,ITMTYP_K_WORD,0	} ,
	{"L_STS",	8,	ITMTYP_K_LONG,0	} ,
	{"L_STV",	12,	ITMTYP_K_LONG,0	} ,
	{"W_STV0",	12,	ITMTYP_K_WORD,0	} ,
	{"W_STV2",	14,	ITMTYP_K_WORD,0	} ,
	{"B_TMO",	31,	ITMTYP_K_BYTE,0	} ,
	{"UBF",		OBIO+OB_K_UBF,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_UBF",	ROAT+36,ITMTYP_K_LONG,0	} ,
	{"W_USZ",	ROAT+32,ITMTYP_K_WORD,0	} ,
	{"XAB",		OBIO+OB_K_XAB,
				ITMTYP_K_BOOL,0	} ,
	{"L_XAB",	ROAT+64,ITMTYP_K_LONG,0	} ,
	{NULL,		0,	0,	0	}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_rab_getattr (vmsobj_rab *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_rab_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_rab_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_rab;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_rab_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_rab_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_rab_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_CTX:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_ctx != NULL)
		{
		    Py_INCREF (xp->ar_ctx);
		    return xp->ar_ctx;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_FAB:
		if (xp->ar_fab != NULL)
		{
		    Py_INCREF (xp->ar_fab);
		    return xp->ar_fab;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_KBF: /* KBF + PBF use the same pointer in the RAB */
	      case OB_K_PBF:
		if (xp->ar_kbfpbf != NULL)
		{
		    Py_INCREF (xp->ar_kbfpbf);
		    return (xp->ar_kbfpbf);
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_XAB:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_xab != NULL)
		{
		    Py_INCREF (xp->ar_xab);
		    return xp->ar_xab;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_RBF:
/* @@ it is possible that rab$l_rbf contains the address of an RMS
buffer, not the membuf address  RAB$M_LOC */
		if (xp->ab_rab->rab$l_rbf == 0)
		{
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
/* @@		return Py_BuildValue ("s#",
			xp->ab_rab->rab$l_rbf,
			(unsigned int)xp->ab_rab->rab$w_rsz);
*/
		return PyString_FromStringAndSize (
			xp->ab_rab->rab$l_rbf,
			(unsigned int)xp->ab_rab->rab$w_rsz);
	      /* ---------- */
	      case OB_K_UBF:
		if (xp->ar_ubf != NULL)
		{
		    Py_INCREF (xp->ar_ubf);
		    return (xp->ar_ubf);
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_rab_attr[l_attr_idx].w_offset & OFSMSK);
	      if (vmsobj_r_rab_attr[l_attr_idx].l_mask == 0)
	      {
		/* special check for W_RFA, which is 3W */
		if (
		    ((vmsobj_r_rab_attr[l_attr_idx].w_offset & OFSMSK) == 16) &&
		    (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_WORD   )
		   )
		{
		  /* return resultant-value (3W) */
		  return vms__cvt_bin2py
		    (ab_data				  /* data address */
		    ,vmsobj_r_rab_attr[l_attr_idx].w_typ  /* data type    */
		    ,(unsigned short int) 6		  /* data length  */
		  );
		}
		else
		{
		  /* return resultant-value */
		  return vms__cvt_bin2py
		    (ab_data				 /* data address */
		    ,vmsobj_r_rab_attr[l_attr_idx].w_typ /* data type	 */
		    ,vmsdef_gl_itmtypsiz[		 /* data length	 */
			vmsobj_r_rab_attr[l_attr_idx].w_typ
					]
		  );
		}
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_rab_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_rab_methods, (PyObject *)xp, name);
} /* vo_rab_getattr (vmsobj_rab *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_rab_setattr (vmsobj_rab *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_rab_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_rab_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_rab;

	    if ( !(vmsobj_r_rab_attr[l_attr_idx].w_offset & ROAT))
	    {
	      if (vmsobj_r_rab_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int   w_objtyp;
		char		   * at_string;
		unsigned long	     l_string_len;
		PyObject	   * ar_rbfubf;

		w_objtyp = vmsobj_r_rab_attr[l_attr_idx].w_offset & OFSMSK;
		if ((w_objtyp == OB_K_KBF) || (w_objtyp == OB_K_PBF))
		{
		  /* common code */
		  if (PyString_Check(v))
		  {
		    at_string    = PyString_AS_STRING(v);
		    l_string_len = PyString_Size(v);
		    if (l_string_len > 255)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"string length limited to 255 characters");
		      return -1;
		    }
		    /* keep reference, because RAB points to string area */
		    Py_INCREF (v);
		    ar_v = v;
		  }
		  else
		  {
		    if (v != Py_None)
		    {
		      PyErr_SetString(PyExc_TypeError,
			"attribute must be string or None");
		      return -1;
		    }
		    at_string    = 0;
		    l_string_len = 0;
		    ar_v	 = NULL; /* no reference to Py_None ! */
		  }
                } /* ((w_objtyp == OB_K_KBF) || (w_objtyp == OB_K_PBF)) */
		/* ---------- */
		if ((w_objtyp == OB_K_RBF) || (w_objtyp == OB_K_UBF))
		{
		  /* common code */
		  if (PyString_Check(v))
		  {
		    at_string    = PyString_AS_STRING(v);
		    l_string_len = PyString_Size(v);
		    if (l_string_len > 32767)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"buffer size limited to 32767 characters");
		      return -1;
		    }
		    /* create a vmsobj__membuf object and fill with string */
		    ar_rbfubf = (PyObject *)
				vmsobj__membuf_new (l_string_len, at_string);
		    if (ar_rbfubf == NULL)
		    {
			return -1; /* object creation failed */
		    }
		  }
		  else
		  { /* !PyString_Check(v) */
		    /* if not string, must be vmsobj__membuf */
		    if (!vmsobj__membuf_Check(v))
		    {
		      if (v != Py_None)
		      {
			PyErr_SetString(PyExc_TypeError,
			  "buffer must be string, vmsobj__membuf or None");
			return -1;
		      }
		      at_string    = NULL;
		      l_string_len = 0;
		      ar_rbfubf    = NULL; /* vmsobj__membuf */
		    }
		    /* size of buffer object must be < 32768 */
		    if (((vmsobj__membuf *)v)->l_bufsiz > 32767)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"buffer size limited to 32767 characters");
			return -1;
		    }
		    at_string    = ((vmsobj__membuf *)v)->ab_membuf;
		    l_string_len = ((vmsobj__membuf *)v)->l_bufsiz;
		    ar_rbfubf = v; /* vmsobj__membuf */
		  }
		} /* ((w_objtyp == OB_K_RBF) || (w_objtyp == OB_K_UBF)) */
		/* ---------- */

	        switch (w_objtyp)
	        {
		/* ---------- */
		case OB_K_CTX:
		  if (xp->ar_ctx != NULL)
		  {
		    Py_DECREF(xp->ar_ctx);  /* drop old reference */
		  }
		  xp->ar_ctx = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_rab points to object */
		  Py_INCREF (v);
		  return 0; /* OK */
		/* ---------- */
		case OB_K_FAB:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to FAB */
		    if (xp->ar_fab != NULL)
		    {
		      Py_DECREF(xp->ar_fab);  /* drop old reference */
		      xp->ar_fab = NULL;
		    }
		    xp->ab_rab->rab$l_fab = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is a FAB */
		  if (! vmsobj_fab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_fab object or None");
		    return -1;
		  }
		  if (xp->ar_fab != NULL)
		  {
		    Py_DECREF(xp->ar_fab);  /* drop old reference */
		  }
		  {
		    vmsobj_fab * ar_fab;
		    ar_fab = (vmsobj_fab *)v;
		    /* keep reference, because vmsobj_rab points to object */
		    Py_INCREF (v);
		    xp->ar_fab = v;		/* remember for Py_DECREF */
		    xp->ab_rab->rab$l_fab = ar_fab->ab_fab;
		  }
		  return 0; /* OK */
		/* ---------- */
		case OB_K_KBF: /* KBF + PBF use the same pointer in the RAB */
		case OB_K_PBF:
		  if (xp->ar_kbfpbf != NULL)
		  {
		    Py_DECREF (xp->ar_kbfpbf);  /* drop old reference */
		  }
		  xp->ar_kbfpbf         = ar_v; /* remember for Py_DECREF */
						/* INCREF already done above */
		  xp->ab_rab->rab$l_kbf = at_string;   /* same as ->rab$l_pbf */
		  xp->ab_rab->rab$b_ksz = l_string_len;
		  return 0; /* OK */
	        /* ---------- */
	        case OB_K_RBF:
		  if (xp->ar_rbf != NULL)
		  {
		    Py_DECREF (xp->ar_rbf);	/* drop old reference */
		  }
		  xp->ar_rbf = ar_rbfubf;	/* remember for Py_DECREF */
		  xp->ab_rab->rab$l_rbf = at_string;
		  xp->ab_rab->rab$w_rsz = l_string_len;
		  return 0; /* OK */
		/* ---------- */
	        case OB_K_UBF:
		  if (xp->ar_ubf != NULL)
		  {
		    Py_DECREF (xp->ar_ubf);	/* drop old reference */
		  }
		  xp->ar_ubf = ar_rbfubf;	/* remember for Py_DECREF */
		  xp->ab_rab->rab$l_ubf = at_string;
		  xp->ab_rab->rab$w_usz = l_string_len;
		  return 0; /* OK */
		/* ---------- */
		case OB_K_XAB:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_xab != NULL)
		    {
		      Py_DECREF(xp->ar_xab);  /* drop old reference */
		      xp->ar_xab = NULL;
		    }
		    xp->ab_rab->rab$l_xab = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is _a_ vmsobj_xabXXX */
		  if (! vmsobj__anyxab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_xabXXX object or None");
		    return -1;
		  }
		  if (xp->ar_xab != NULL)
		  {
		    Py_DECREF(xp->ar_xab);  /* drop old reference */
		  }
		  xp->ar_xab = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_rab points to object */
		  Py_INCREF (v);
		  return 0; /* OK */
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_rab_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_rab_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
		 /* special check for W_RFA, which is 3W */
		 if (
		    ((vmsobj_r_rab_attr[l_attr_idx].w_offset & OFSMSK) == 16) &&
		    (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_WORD   )
		   )
		 {
		  /* convert Python type (3W) */
                  l_status = vms__cvt_py2bin
                    (v					 /* Python data  */
		    ,ab_data				 /* data address */
                    ,vmsobj_r_rab_attr[l_attr_idx].w_typ /* data type	*/
                    ,(unsigned short int) 6		 /* data length	*/
		  );
		 }
		 else
		 {
                  /* convert Python type */
                  l_status = vms__cvt_py2bin
                    (v					 /* Python data  */
		    ,ab_data				 /* data address */
                    ,vmsobj_r_rab_attr[l_attr_idx].w_typ /* data type	*/
                    ,vmsdef_gl_itmtypsiz[		 /* data length	*/
		     vmsobj_r_rab_attr[l_attr_idx].w_typ
				      ]
		  );
		 }
		/* .. */
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_rab_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_rab_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_rab_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_rab attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_rab attribute");
	return -1;
} /* static int vo_rab_setattr (vmsobj_rab *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_rab_repr (vmsobj_rab *ar_rab)
{
	char buf[40];

	sprintf(buf, "<vmsobj_rab, RAB at 0x%08x>", (ar_rab->ab_rab));
	return PyString_FromString(buf);
} /* static PyObject * vo_rab_repr (vmsobj_rab *ar_rab) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_rab_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_rab",			/*tp_name*/
	sizeof(vmsobj_rab),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_rab_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_rab_getattr,	/*tp_getattr*/
	(setattrfunc)vo_rab_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_rab_repr,		/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_RAB.C */
