#ifndef VMSOBJ_RAB_H
#define VMSOBJ_RAB_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS RAB (file access block) object */

#include <rab.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct RAB	* ab_rab;	/* the VMS RAB */
	/* pointers to other objects that the RAB points to */
	PyObject	* ar_ctx;	/* RAB$L_CTX */
	PyObject	* ar_fab;	/* FAB object */
	PyObject	* ar_xab;	/* XAB object */
	PyObject	* ar_kbfpbf;	/* key/prompt buffer */
	PyObject	* ar_rbf;	/* MEMBUF object */
	PyObject	* ar_ubf;	/* MEMBUF object */

} vmsobj_rab;

extern DL_IMPORT(PyTypeObject) vmsobj_rab_type;
extern DL_IMPORT(vmsobj_rab *) vmsobj_rab_new (struct RAB *arg);

#define vmsobj_rab_Check(op) ((op)->ob_type == &vmsobj_rab_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_RAB_H */
