#ifndef VMSOBJ_XABALL_H
#define VMSOBJ_XABALL_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABALL (allocation XAB (eXtended Access Block)) object */

#include <xaballdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABALL	* ab_xaball;	/* the VMS XABALL */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABALL points to */
	PyObject	* ar_nxt;	/* next XAB object */
} vmsobj_xaball;

extern DL_IMPORT(PyTypeObject) vmsobj_xaball_type;
extern DL_IMPORT(vmsobj_xaball *) vmsobj_xaball_new (struct XABALL *arg);

#define vmsobj_xaball_Check(op) ((op)->ob_type == &vmsobj_xaball_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABALL_H */
