#ifndef VMSOBJ_XABDAT_H
#define VMSOBJ_XABDAT_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABDAT (DAte + Time XAB (eXtended Access Block)) object */

#include <xabdatdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABDAT	* ab_xabdat;	/* the VMS XABDAT */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABDAT points to */
	PyObject	* ar_nxt;	/* next XAB object */
} vmsobj_xabdat;

extern DL_IMPORT(PyTypeObject) vmsobj_xabdat_type;
extern DL_IMPORT(vmsobj_xabdat *) vmsobj_xabdat_new (struct XABDAT *arg);

#define vmsobj_xabdat_Check(op) ((op)->ob_type == &vmsobj_xabdat_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABDAT_H */
