#ifndef VMSOBJ_XABFHC_H
#define VMSOBJ_XABFHC_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABFHC
  (File Header Characteristics XAB (eXtended Access Block)) object */

#include <xabfhcdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABFHC	* ab_xabfhc;	/* the VMS XABFHC */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABFHC points to */
	PyObject	* ar_nxt;	/* next XAB object */
	PyObject	* ar_itmlst;	/* itemlist object */
} vmsobj_xabfhc;

extern DL_IMPORT(PyTypeObject) vmsobj_xabfhc_type;
extern DL_IMPORT(vmsobj_xabfhc *) vmsobj_xabfhc_new (struct XABFHC *arg);

#define vmsobj_xabfhc_Check(op) ((op)->ob_type == &vmsobj_xabfhc_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABFHC_H */
