/* VMSOBJ_XABITM.C - 13-FEB-1999 ZE.
   File Header Characteristic XAB (eXtended Access Block) object. 

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <xabitmdef.h>
#include "vmsobj__def.h"
#include "vmsobj__xabtst.h"	/* test for _any_ XAB */

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */
/* reference to translation table for XAB$_name text/code */
extern struct vmsdef_xr_itmtbl VMSDEF_GR_$XABITMDEF[];
/* ------------------------------------------------------------------------- */
#include "vms__itmlst_routines.h"

/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_xabitm_type;

/* ------------------------------------------------------------------------- */
vmsobj_xabitm *
vmsobj_xabitm_new (struct XABITM *arg)
{
	vmsobj_xabitm *xp;

	/* -------------------- */
	/* new 'vmsobj_xabitm' object */
	xp = PyObject_NEW (vmsobj_xabitm, &vmsobj_xabitm_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the XABITM points to		*/
	xp->ar_nxt        = NULL;	/* next XAB object		*/
	xp->ar_itmlst     = NULL;	/* itemlist object		*/
	/* 3 variables below are used for cross-procedure access */
	xp->ar_itemlist	  = NULL;	/* VMS itemlist			*/
	xp->aw_retlenlist = NULL;	/* returned length array	*/
	xp->ar_itm_vmsdef = NULL;	/* back-pointer to VMSDEF item	*/

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real XABITM and note it's address */
	    xp->ab_xabitm = malloc (XAB$C_ITMLEN);
	    if (xp->ab_xabitm == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    /* there is/was no cc$rms_xabitm to use for init */
	    (void) memset (xp->ab_xabitm, 0, (size_t)XAB$C_ITMLEN);
	    xp->ab_xabitm->xab$b_bln = XAB$C_ITMLEN;	/* XABITM size    */
	    xp->ab_xabitm->xab$b_cod = XAB$C_ITM;	/* XABITM id code */
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing XABITM */
	    xp->ab_xabitm = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_xabitm methods */

static void
vo_xabitm_dealloc (vmsobj_xabitm *xp)
{
	/* was XABITM allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS XABITM */
	    if (xp->ab_xabitm != NULL)
	    {
		(void) free (xp->ab_xabitm);
	    }
	}
	else
	{
	    if (xp->ar_nxt != NULL)
	    {
		xp->ab_xabitm->xab$l_nxt = 0;
	    }
	    if (xp->ar_itmlst != NULL)
	    {
		xp->ab_xabitm->xab$l_itemlist = 0;
	    }
	}

	/* -------------------- */
	/* delete references to other objects the XABITM might point to */
	if (xp->ar_nxt != NULL)
	{
	    Py_DECREF(xp->ar_nxt);	/* next XAB object */
	}
	if (xp->ar_itmlst != NULL)
	{
	    Py_DECREF(xp->ar_itmlst);	/* itemlist object */
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_xabitm_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_xabitm_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within XABITM */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_xabitm_attr vmsobj_xabitm_attr;

/* XAB$B_COD + XAB$B_BLN are not changeable as they identify a XABITM */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* mask byte offset count */

#define OB_K_NXT 1 /* next XAB object */
#define OB_K_ITM 2 /* item-list object */

static vmsobj_xabitm_attr vmsobj_r_xabitm_attr [] = {
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} ,
	{"B_COD",	ROAT+0,	ITMTYP_K_BYTE,0	} ,
	{"ITEMLIST",	OBIO+OB_K_ITM,
				ITMTYP_K_BOOL,0	} , /* object I/O */

	{"L_ITEMLIST",	ROAT+8,	ITMTYP_K_LONG,0	} ,
/* XAB$K_SENSEMODE 1 / XAB$K_SETMODE   2 */
	{"B_MODE",	12,	ITMTYP_K_BYTE,0	} ,
	{"NXT",		OBIO+OB_K_NXT,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_NXT",	ROAT+4,	ITMTYP_K_LONG,0	} ,
	{NULL,		0,	0,	0	}
};

/* ------------------------------------------------------------------------- */

PyObject *
vo_xabitm_getattr (vmsobj_xabitm *xp, char *name)
{
	unsigned long l_attr_idx;
	PyObject * ar_dict;
	PyObject * ar_xxx;

	l_attr_idx = 0;
	while (vmsobj_r_xabitm_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabitm_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_xabitm;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_xabitm_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_xabitm_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_xabitm_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_NXT:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_nxt != NULL)
		{
		    Py_INCREF (xp->ar_nxt);
		    return xp->ar_nxt;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_ITM:
		if (xp->ar_itmlst == NULL)
		{
		    /* Note: can't use an existing itemlist of an existing   */
		    /*  XAB that was assigned during new(), because there is */
		    /*  no VMSDEF information for output processing	     */
		    Py_INCREF (Py_None);
		    return Py_None;
		}
		/* -------------------- */
		/* return contents of itemlist in a dictionary */
/* <<<<<<<<<< */
	/* -------------------- */
	/* create a dictionary to return a variable number of output-items */
	ar_dict = PyDict_New();
	if (ar_dict == NULL)
	{
	    /* free item-list *and* all malloc()ed buffers */
	    (void) vms__itmlst_free (xp->ar_itemlist, xp->ar_itm_vmsdef,
		xp->aw_retlenlist);
	    return NULL;
	}

	/* -------------------- */

	    ar_xxx = vms__itmlst_outprc
		(ITMTBL_M_ITMOUT	/* output-item bit   */
		,&VMSDEF_GR_$XABITMDEF	/* VMSDEF_GR_$xxxDEF */
		,&xp->ar_itemlist	/* return VMS item list           */
		,&xp->ar_itm_vmsdef	/* return VMSDEF back-ptr array   */
		,&xp->aw_retlenlist	/* return VMS itmlst retlen array */
		,ar_dict	/* is modified! */
		);

	    if (ar_xxx == NULL)
	    {
		return NULL;		/* item list build failed */
	    }

	/* -------------------- */
	/* Note: itemlist must not be free()ed here */
	/* The object still exists! */

	/* done, return to Python with the dictionary */
	return ar_dict;
/* >>>>>>>>>> */
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_xabitm_attr[l_attr_idx].w_offset & OFSMSK);
	      if (vmsobj_r_xabitm_attr[l_attr_idx].l_mask == 0)
	      {
		/* return resultant-value */
		return vms__cvt_bin2py
		  (ab_data				  /* data address */
		  ,vmsobj_r_xabitm_attr[l_attr_idx].w_typ /* data type	  */
		  ,vmsdef_gl_itmtypsiz[		 	  /* data length  */
			vmsobj_r_xabitm_attr[l_attr_idx].w_typ
					]
		  );
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_xabitm_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_xabitm_methods, (PyObject *)xp, name);
} /* vo_xabitm_getattr (vmsobj_xabitm *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_xabitm_setattr (vmsobj_xabitm *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabitm_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabitm_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_xabitm;

	    if ( !(vmsobj_r_xabitm_attr[l_attr_idx].w_offset & ROAT))
	    {
	      if (vmsobj_r_xabitm_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int   w_objtyp;

		w_objtyp = vmsobj_r_xabitm_attr[l_attr_idx].w_offset & OFSMSK;
	        switch (w_objtyp)
	        {
		/* ---------- */
		case OB_K_NXT:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_nxt != NULL)
		    {
		      Py_DECREF(xp->ar_nxt);  /* drop old reference */
		      xp->ar_nxt = NULL;
		    }
		    xp->ab_xabitm->xab$l_nxt = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is _a_ vmsobj_xabXXX */
		  if (! vmsobj__anyxab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_xabXXX object or None");
		    return -1;
		  }
		  if (xp->ar_nxt != NULL)
		  {
		    Py_DECREF(xp->ar_nxt);  /* drop old reference */
		  }
		  xp->ar_nxt = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_xabitm points to object */
		  Py_INCREF (v);
		  /* A different XAB than XABITM might have been passed. */
		  /* All XAB objects must share the VMS' XAB address in  */
		  /* their structures. */
		  /* (char*) to keep DEC-C on Alpha quiet */
		  xp->ab_xabitm->xab$l_nxt =
					(char *)((vmsobj_xabitm *)v)->ab_xabitm;
		  return 0; /* OK */
		/* ---------- */
		case OB_K_ITM:
		  /* None deallocates the current item-list */
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_itmlst != NULL)
		    {
		      Py_DECREF(xp->ar_itmlst);  /* drop old reference */
		      (void) vms__itmlst_free (xp->ar_itemlist
					      ,xp->ar_itm_vmsdef
					      ,xp->aw_retlenlist);
		      xp->ar_itemlist	= NULL;	/* VMS itemlist			*/
		      xp->aw_retlenlist = NULL;	/* returned length array	*/
		      xp->ar_itm_vmsdef = NULL;	/* back-pointer to VMSDEF item	*/
		    }
		    xp->ab_xabitm->xab$l_itemlist = 0;
		    return 0; /* OK */
		  }
		  /* ---------- */
		  /* first build new itemlist - then drop old one */
		  if (!PyTuple_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
	  "itemlist must be a tuple of strings, tuples (string,data) or None");
		    return -1;
		  }
		  else
		  {
		    PyObject * ar_xxx;
		    /* temporary pointers */
		    struct vmsdef_xr_itmlst3  * ar_itemlist_t;
		    unsigned short int	      * aw_retlenlist_t;
		    struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef_t;

		    ar_xxx = vms__itmlst_build
			(ITMTBL_M_ITMINP	/* input-item bit    */
			,ITMTBL_M_ITMOUT	/* output-item bit   */
			,&VMSDEF_GR_$XABITMDEF	/* VMSDEF_GR_$xxxDEF */
			,v			/* Python itmlst obj */
			,&ar_itemlist_t	  /* return VMS item list           */
			,&ar_itm_vmsdef_t /* return VMSDEF back-ptr array   */
			,&aw_retlenlist_t /* return VMS itmlst retlen array */
			);

		    if (ar_xxx == NULL)
		    {
			return -1;		/* item list build failed */
		    }

		    /* -------------------- */
		    /* fill in 'returned length address' so a query of the */
		    /*  itemlist can always be returned */
		    {
		      struct vmsdef_xr_itmlst3  * ar_itemlist_ptr;
		      struct vmsdef_xr_itmtbl   * ar_itm_vmsdef_ptr;
		      unsigned short int	* aw_retlenlist_ptr;

		      ar_itemlist_ptr   =  ar_itemlist_t;
		      ar_itm_vmsdef_ptr = *ar_itm_vmsdef_t;
		      aw_retlenlist_ptr =  aw_retlenlist_t;
		      /* loop over VMS itemlist */
		      /* Warning: for boolean items W_BUFSIZ == 0 ! */
		      while ((ar_itemlist_ptr->w_itmcod != 0) ||
			     (ar_itemlist_ptr->w_bufsiz != 0)   )
		      {
			/* if this is an output-item ... */
			if (ar_itm_vmsdef_ptr->l_flags & ITMTBL_M_ITMOUT)
			{
			  *aw_retlenlist_ptr = ar_itemlist_ptr->w_bufsiz;
			}
			/* else -- @@ ignore any input-items in item-list */

			ar_itemlist_ptr++;		    /* next item */
			ar_itm_vmsdef_ptr++;
			aw_retlenlist_ptr++;
		      } /* while (ar_itemlist_ptr->w_itmcod + ->w_bufsiz != 0) */
		    }

		    /* -------------------- */
		    /* now deallocate old VMS itemlist (if one exists) */
		    if (xp->ar_itmlst != NULL)
		    {
		      Py_DECREF(xp->ar_itmlst);  /* drop old reference */
		      (void) vms__itmlst_free (xp->ar_itemlist
					      ,xp->ar_itm_vmsdef
					      ,xp->aw_retlenlist);
		    }

		    /* -------------------- */
		    /* reassign pointers */
		    xp->ar_itemlist   = ar_itemlist_t;
		    xp->ar_itm_vmsdef = ar_itm_vmsdef_t;
		    xp->aw_retlenlist = aw_retlenlist_t;
		    /* keep reference, because vmsobj_xabitm points to object */
		    Py_INCREF (v);
		    xp->ar_itmlst = v;
		    /* assign VMS itemlist to XAB */
		    /* (char*) to keep DEC-C on Alpha quiet */
		    xp->ab_xabitm->xab$l_itemlist = (char *)xp->ar_itemlist;
		  }
		  return 0; /* OK */
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_xabitm_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_xabitm_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
                  /* convert Python type */
                  l_status = vms__cvt_py2bin
                    (v					    /* Python data  */
		    ,ab_data				    /* data address */
                    ,vmsobj_r_xabitm_attr[l_attr_idx].w_typ /* data type    */
                    ,vmsdef_gl_itmtypsiz[		    /* data length  */
		     vmsobj_r_xabitm_attr[l_attr_idx].w_typ
				      ]
		  );
		/* .. */
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_xabitm_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabitm_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabitm_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabitm_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_xabitm_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabitm_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabitm_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabitm_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_xabitm attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_xabitm attribute");
	return -1;
} /* static int vo_xabitm_setattr (vmsobj_xabitm *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabitm_repr (vmsobj_xabitm *ar_xabitm)
{
	char buf[40];

	sprintf(buf, "<vmsobj_xabitm, XABITM at 0x%08x>", (ar_xabitm->ab_xabitm));
	return PyString_FromString(buf);
} /* static PyObject * vo_xabitm_repr (vmsobj_xabitm *ar_xabitm) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_xabitm_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_xabitm",		/*tp_name*/
	sizeof(vmsobj_xabitm),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_xabitm_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_xabitm_getattr,	/*tp_getattr*/
	(setattrfunc)vo_xabitm_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_xabitm_repr,	/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_XABITM.C */
