#ifndef VMSOBJ_XABITM_H
#define VMSOBJ_XABITM_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABITM (item-list XAB (eXtended Access Block)) object */

#include <xabitmdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABITM	* ab_xabitm;	/* the VMS XABITM */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABITM points to */
	PyObject		  * ar_nxt;	/* next XAB object */
	PyObject		  * ar_itmlst;	/* itemlist object */

	/* 3 variables below are used for cross-procedure access */

	/* VMS item-list to be connected to XAB$L_ITEMLIST */
	struct vmsdef_xr_itmlst3  * ar_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	  * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */
} vmsobj_xabitm;

extern DL_IMPORT(PyTypeObject) vmsobj_xabitm_type;
extern DL_IMPORT(vmsobj_xabitm *) vmsobj_xabitm_new (struct XABITM *arg);

#define vmsobj_xabitm_Check(op) ((op)->ob_type == &vmsobj_xabitm_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABITM_H */
