/* VMSOBJ_XABKEY.C - 22-FEB-1999 ZE.
   KEY definition XAB (eXtended Access Block) object. 

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <xabkeydef.h>
#include "vmsobj__def.h"
#include "vmsobj__xabtst.h"	/* test for _any_ XAB */

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_xabkey_type;

/* ------------------------------------------------------------------------- */
vmsobj_xabkey *
vmsobj_xabkey_new (struct XABKEY *arg)
{
	vmsobj_xabkey *xp;

	/* -------------------- */
	/* new 'vmsobj_xabkey' object */
	xp = PyObject_NEW (vmsobj_xabkey, &vmsobj_xabkey_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the XABKEY points to */
	xp->ar_nxt  = NULL;	/* next XAB object */
	xp->b_knmsiz = 0;	/* xab$l_knm = ASCIC */
	(void) memset (&xp->t_knm[0], 0, 32);

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real XABKEY and note it's address */
	    xp->ab_xabkey = malloc (XAB$K_KEYLEN);
	    if (xp->ab_xabkey == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    *xp->ab_xabkey  = cc$rms_xabkey;
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing XABKEY */
	    xp->ab_xabkey = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_xabkey methods */

static void
vo_xabkey_dealloc (vmsobj_xabkey *xp)
{
	/* was XABKEY allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS XABKEY */
	    if (xp->ab_xabkey != NULL)
	    {
		(void) free (xp->ab_xabkey);
	    }
	}
	else
	{
	    /* The VMS XABKEY was not allocated by the object creation */
	    /* routine; its address was supplied to it.		       */
	    /* Remove pointers from XAB. */
	    xp->ab_xabkey->xab$l_knm = 0;
	}

	/* -------------------- */
	/* delete references to other objects the XABKEY might point to */
	if (xp->ar_nxt != NULL)
	{
	    Py_DECREF(xp->ar_nxt);	/* next XAB object */
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_xabkey_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_xabkey_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within XABKEY */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_xabkey_attr vmsobj_xabkey_attr;

/* XAB$B_COD + XAB$B_BLN are not changeable as they identify a XABKEY */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* mask byte offset count */

#define OB_K_NXT 1 /* next XAB object */
#define OB_K_KNM 2 /* key name */

/* 256+offset is used to mark an array of 8B,8W */
static vmsobj_xabkey_attr vmsobj_r_xabkey_attr [] = {
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} ,
	{"B_COD",	ROAT+0,	ITMTYP_K_BYTE,0	} ,
	{"L_COLNAM",	ROAT+84,ITMTYP_K_LONG,0	} , /* no object I/O impl. */
	{"L_COLSIZ",	ROAT+80,ITMTYP_K_LONG,0	} , /* no object I/O impl. */
	{"L_COLTBL",	ROAT+76,ITMTYP_K_LONG,0	} , /* no object I/O impl. */
	{"B_DAN",	10,	ITMTYP_K_BYTE,0	} ,
	{"B_DBS",	13,	ITMTYP_K_BYTE,0	} ,
	{"W_DFL",	28,	ITMTYP_K_WORD,0	} ,
	{"B_DTP",	19,	ITMTYP_K_BYTE,0	} ,
	{"L_DVB",	60,	ITMTYP_K_LONG,0	} ,
	{"B_FLG",	18,	ITMTYP_K_BYTE,0	} ,
	 {"M_DUP",	18,	ITMTYP_K_WORD,XAB$M_DUP } ,
	 {"M_CHG",	18,	ITMTYP_K_WORD,XAB$M_CHG } ,
	 {"M_NUL",	18,	ITMTYP_K_WORD,XAB$M_NUL } ,
	 {"M_IDX_NCMPR", 18,	ITMTYP_K_WORD,XAB$M_IDX_NCMPR } ,
	 {"M_KEY_NCMPR", 18,	ITMTYP_K_WORD,XAB$M_KEY_NCMPR } ,
	 {"M_DAT_NCMPR", 18,	ITMTYP_K_WORD,XAB$M_DAT_NCMPR } ,
	{"B_IAN",	8,	ITMTYP_K_BYTE,0	} ,
	{"B_IBS",	12,	ITMTYP_K_BYTE,0	} ,
	{"W_IFL",	26,	ITMTYP_K_WORD,0	} ,
	{"KNM",		OBIO+OB_K_KNM,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_KNM",	ROAT+56,ITMTYP_K_LONG,0	} ,
	{"B_LAN",	9,	ITMTYP_K_BYTE,0	} ,
	{"B_LVL",	11,	ITMTYP_K_BYTE,0	} ,
	{"W_MRL",	24,	ITMTYP_K_WORD,0	} ,
	{"B_NSG",	20,	ITMTYP_K_BYTE,0	} ,
	{"B_NUL",	21,	ITMTYP_K_BYTE,0	} ,
	{"NXT",		OBIO+OB_K_NXT,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_NXT",	ROAT+4,	ITMTYP_K_LONG,0	} ,
	{"W_POS",	256+30,	ITMTYP_K_WORD,0	} , /* 8W */
	{"W_POS0",	30,	ITMTYP_K_WORD,0	} ,
	{"W_POS1",	32,	ITMTYP_K_WORD,0	} ,
	{"W_POS2",	34,	ITMTYP_K_WORD,0	} ,
	{"W_POS3",	36,	ITMTYP_K_WORD,0	} ,
	{"W_POS4",	38,	ITMTYP_K_WORD,0	} ,
	{"W_POS5",	40,	ITMTYP_K_WORD,0	} ,
	{"W_POS6",	42,	ITMTYP_K_WORD,0	} ,
	{"W_POS7",	44,	ITMTYP_K_WORD,0	} ,
	{"B_PROLOG",	72,	ITMTYP_K_BYTE,0	} ,
	{"B_REF",	23,	ITMTYP_K_BYTE,0	} ,
	{"L_RVB",	14,	ITMTYP_K_LONG,0	} ,
	{"B_SIZ",	256+46,	ITMTYP_K_WORD,0	} , /* 8B */
	{"B_SIZ0",	46,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ1",	47,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ2",	48,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ3",	49,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ4",	50,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ5",	51,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ6",	52,	ITMTYP_K_WORD,0	} ,
	{"B_SIZ7",	53,	ITMTYP_K_WORD,0	} ,
	{"B_TKS",	22,	ITMTYP_K_WORD,0	} ,
	{"B_TYP",	256+64,	ITMTYP_K_WORD,0	} , /* 8B */ /* V6.1 - nodoc */
	{"B_TYP0",	64,	ITMTYP_K_WORD,0	} , /* V6.1 - nodoc */
	{"B_TYP1",	65,	ITMTYP_K_WORD,0	} ,
	{"B_TYP2",	66,	ITMTYP_K_WORD,0	} ,
	{"B_TYP3",	67,	ITMTYP_K_WORD,0	} ,
	{"B_TYP4",	68,	ITMTYP_K_WORD,0	} ,
	{"B_TYP5",	69,	ITMTYP_K_WORD,0	} ,
	{"B_TYP6",	70,	ITMTYP_K_WORD,0	} ,
	{"B_TYP7",	71,	ITMTYP_K_WORD,0	} ,
	{NULL,		0,	0,	0	}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabkey_getattr (vmsobj_xabkey *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabkey_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabkey_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_xabkey;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_xabkey_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_NXT:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_nxt != NULL)
		{
		    Py_INCREF (xp->ar_nxt);
		    return xp->ar_nxt;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_KNM:
		if (xp->ab_xabkey->xab$l_knm == 0)
		{
		  /* no value assigned */
		    /* return an empty string */
		    return Py_BuildValue ("s#", Py_None, (unsigned int)0);
		}
		else
		{
		  unsigned char   b_knmlen;
		  char		* at_knm;

		  at_knm   = xp->ab_xabkey->xab$l_knm;
		  b_knmlen = *at_knm;			/* count byte */
		  at_knm++;				/* skip ASCIC count */
		  return Py_BuildValue ("s#", at_knm, (unsigned int)b_knmlen);
		}
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OFSMSK);
	      if (vmsobj_r_xabkey_attr[l_attr_idx].l_mask == 0)
	      {
		/* special checks for W_POS, B_SIZ + B_TYP, which are 8W, 8B */
		if ((vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OFSMSK) >= 256)
		{
		  /* set offset to real value */
		  ab_data -= 256;

		  /* return resultant-value (8B,8W) */
		  return vms__cvt_bin2py
		    (ab_data				    /* data address */
		    ,vmsobj_r_xabkey_attr[l_attr_idx].w_typ /* data type    */
		    ,vmsdef_gl_itmtypsiz[		    /* data length  */
			vmsobj_r_xabkey_attr[l_attr_idx].w_typ
					] *8
		  );
		}
               else
		{
		  /* return resultant-value */
		  return vms__cvt_bin2py
		    (ab_data				    /* data address */
		    ,vmsobj_r_xabkey_attr[l_attr_idx].w_typ /* data type    */
		    ,vmsdef_gl_itmtypsiz[		    /* data length  */
			vmsobj_r_xabkey_attr[l_attr_idx].w_typ
					]
		    );
		}
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_xabkey_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_xabkey_methods, (PyObject *)xp, name);
} /* vo_xabkey_getattr (vmsobj_xabkey *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_xabkey_setattr (vmsobj_xabkey *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabkey_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabkey_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_xabkey;

	    if ( !(vmsobj_r_xabkey_attr[l_attr_idx].w_offset & ROAT))
	    {
	      if (vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int   w_objtyp;

		w_objtyp = vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OFSMSK;
	        switch (w_objtyp)
	        {
		/* ---------- */
		case OB_K_NXT:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_nxt != NULL)
		    {
		      Py_DECREF(xp->ar_nxt);  /* drop old reference */
		      xp->ar_nxt = NULL;
		    }
		    xp->ab_xabkey->xab$l_nxt = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is _a_ vmsobj_xabXXX */
		  if (! vmsobj__anyxab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_xabXXX object or None");
		    return -1;
		  }
		  if (xp->ar_nxt != NULL)
		  {
		    Py_DECREF(xp->ar_nxt);  /* drop old reference */
		  }
		  xp->ar_nxt = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_xabkey points to object */
		  Py_INCREF (v);
		  /* A different XAB than XABKEY might have been passed. */
		  /* All XAB objects must share the VMS' XAB address in  */
		  /* their structures. */
		  /* (char*) to keep DEC-C on Alpha quiet */
		  xp->ab_xabkey->xab$l_nxt =
					(char *)((vmsobj_xabkey *)v)->ab_xabkey;
		  return 0; /* OK */
		/* ---------- */
	        case OB_K_KNM:
		  if (PyString_Check(v))
		  {
		    char		* at_string;
		    unsigned long	  l_string_len;

		    at_string    = PyString_AS_STRING(v);
		    l_string_len = PyString_Size(v);
		    if (l_string_len > 31)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"string length limited to 31 characters");
		      return -1;
		    }

		    (void) memcpy (&xp->t_knm[0], at_string, l_string_len);
		    xp->b_knmsiz = l_string_len;

		    /* (char*) to keep DEC-C on Alpha quiet */
		    xp->ab_xabkey->xab$l_knm = (char *)&xp->b_knmsiz; /* ASCIC addr */

		    /* Py_INCREF(v) not needed, because string was copied */
		    return 0; /* OK */
		  }
		  if (v != Py_None)
		  {
		    PyErr_SetString(PyExc_TypeError,
			"attribute must be string or None");
		    return -1;
		  }

		  xp->ab_xabkey->xab$l_knm = 0;
		  xp->b_knmsiz = 0;
		  (void) memset (&xp->t_knm[0], 0, 32);
		  return 0; /* OK */
	        /* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_xabkey_attr[l_attr_idx].l_mask == 0)
		{
		  /* special checks for W_POS, B_SIZ + B_TYP, which are 8W, 8B */
		  if ((vmsobj_r_xabkey_attr[l_attr_idx].w_offset & OFSMSK) >= 256)
		  {
		    /* set offset to real value */
		    ab_data -= 256;

/* @@ check that BW don't overflow */
		    /* convert Python type */
                    l_status = vms__cvt_py2bin
                    (v					    /* Python data  */
		    ,ab_data				    /* data address */
                    ,vmsobj_r_xabkey_attr[l_attr_idx].w_typ /* data type    */
                    ,vmsdef_gl_itmtypsiz[		    /* data length  */
		     vmsobj_r_xabkey_attr[l_attr_idx].w_typ
				      ] *8
		    );
		  }
		  else
		  {
                    /* convert Python type */
                    l_status = vms__cvt_py2bin
                    (v					    /* Python data  */
		    ,ab_data				    /* data address */
                    ,vmsobj_r_xabkey_attr[l_attr_idx].w_typ /* data type    */
                    ,vmsdef_gl_itmtypsiz[		    /* data length  */
		     vmsobj_r_xabkey_attr[l_attr_idx].w_typ
				      ]
		    );
		    /* .. */
		  }
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_xabkey_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabkey_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabkey_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabkey_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_xabkey_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabkey_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabkey_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabkey_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_xabkey attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_xabkey attribute");
	return -1;
} /* static int vo_xabkey_setattr (vmsobj_xabkey *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabkey_repr (vmsobj_xabkey *ar_xabkey)
{
	char buf[40];

	sprintf(buf, "<vmsobj_xabkey, XABKEY at 0x%08x>", (ar_xabkey->ab_xabkey));
	return PyString_FromString(buf);
} /* static PyObject * vo_xabkey_repr (vmsobj_xabkey *ar_xabkey) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_xabkey_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_xabkey",		/*tp_name*/
	sizeof(vmsobj_xabkey),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_xabkey_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_xabkey_getattr,	/*tp_getattr*/
	(setattrfunc)vo_xabkey_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_xabkey_repr,	/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_XABKEY.C */
