#ifndef VMSOBJ_XABKEY_H
#define VMSOBJ_XABKEY_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABKEY (KEY definition XAB (eXtended Access Block)) object */

#include <xabkeydef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABKEY	* ab_xabkey;	/* the VMS XABKEY */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABKEY points to */
	PyObject	* ar_nxt;	/* next XAB object */
	unsigned char	  b_knmsiz;	/* xab$l_knm = ASCIC */
	char		  t_knm[32];
} vmsobj_xabkey;

extern DL_IMPORT(PyTypeObject) vmsobj_xabkey_type;
extern DL_IMPORT(vmsobj_xabkey *) vmsobj_xabkey_new (struct XABKEY *arg);

#define vmsobj_xabkey_Check(op) ((op)->ob_type == &vmsobj_xabkey_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABKEY_H */
