/* VMSOBJ_XABPRO.C - 02-MAR-1999 ZE.
   PROtection XAB (eXtended Access Block) object. 

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <xabprodef.h>
#include "vmsobj__def.h"
#include "vmsobj__xabtst.h"	/* test for _any_ XAB */
#include "vmsobj__membuf.h"	/* creates a new vmsobj__membuf object */

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_xabpro_type;

/* ------------------------------------------------------------------------- */
vmsobj_xabpro *
vmsobj_xabpro_new (struct XABPRO *arg)
{
	vmsobj_xabpro *xp;

	/* -------------------- */
	/* new 'vmsobj_xabpro' object */
	xp = PyObject_NEW (vmsobj_xabpro, &vmsobj_xabpro_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the XABPRO points to */
	xp->ar_nxt    = NULL;	/* next XAB object */
	xp->ar_aclbuf = NULL;	/* ACL buffer - vmsobj__membuf object */

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real XABPRO and note it's address */
	    xp->ab_xabpro = malloc (XAB$K_PROLEN);
	    if (xp->ab_xabpro == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    *xp->ab_xabpro = cc$rms_xabpro;
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing XABPRO */
	    xp->ab_xabpro = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_xabpro methods */

static void
vo_xabpro_dealloc (vmsobj_xabpro *xp)
{
	/* was XABPRO allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS XABPRO */
	    if (xp->ab_xabpro != NULL)
	    {
		(void) free (xp->ab_xabpro);
	    }
	}
	else
	{
	    /* The VMS XABPRO was not allocated by the object creation */
	    /* routine; its address was supplied to it.		       */
	    /* Remove pointers from XAB. */
	    xp->ab_xabpro->xab$l_nxt    = 0;
	    xp->ab_xabpro->xab$l_aclbuf = 0;
	}

	/* -------------------- */
	/* delete references to other objects the XABPRO might point to */
	if (xp->ar_nxt != NULL)
	{
	    Py_DECREF(xp->ar_nxt);	/* next XAB object */
	}
	if (xp->ar_aclbuf != NULL)
	{
	    Py_DECREF(xp->ar_aclbuf);	/* ACL buffer - vmsobj__membuf object */
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_xabpro_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_xabpro_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within XABPRO */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_xabpro_attr vmsobj_xabpro_attr;

/* XAB$B_COD + XAB$B_BLN are not changeable as they identify a XABPRO */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* mask byte offset count */

#define OB_K_NXT 1 /* next XAB object */
#define OB_K_ABF 2 /* XAB$L_ACLBUF */
#define OB_K_MTA 3 /* XAB$B_MTACC - 1 character */

static vmsobj_xabpro_attr vmsobj_r_xabpro_attr [] = {
	{"ACLBUF",	OBIO+OB_K_ABF,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_ACLBUF",	ROAT+24,ITMTYP_K_LONG,0	} ,
	{"L_ACLCTX",	32,	ITMTYP_K_LONG,0	} ,
	{"W_ACLLEN",	ROAT+30,ITMTYP_K_WORD,0	} , /* open or display filed */
	{"W_ACLSIZ",	ROAT+28,ITMTYP_K_WORD,0	} , /* buffer input size */
	{"L_ACLSTS",	36,	ITMTYP_K_LONG,0	} ,
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} ,
	{"B_COD",	ROAT+0,	ITMTYP_K_BYTE,0	} ,
	{"W_GRP",	14,	ITMTYP_K_WORD,0	} ,
	{"W_MBM",	12,	ITMTYP_K_WORD,0	} ,
	{"MTACC",	OBIO+OB_K_MTA,
				ITMTYP_K_BOOL,0	} , /* object I/O - 1 char */
	{"B_MTACC",	10,	ITMTYP_K_BYTE,0	} ,
	{"NXT",		OBIO+OB_K_NXT,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_NXT",	ROAT+4,	ITMTYP_K_LONG,0	} ,
	{"W_PRO",	8,	ITMTYP_K_WORD,0	} ,
	{"B_PROT_MODE",	16,	ITMTYP_K_BYTE,0	} , /* current */
/*	{"Q_PROT_MODE",	16,	ITMTYP_K_QUAD,0	} , /* future ?*/
	{"B_PROT_OPT",	11,	ITMTYP_K_BYTE,0	} ,
	 {"M_PROPAGATE", 11,	ITMTYP_K_BYTE,XAB$M_PROPAGATE } ,
	{"L_UIC",	12,	ITMTYP_K_LONG,0	} ,
	{NULL,		0,	0,	0	}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabpro_getattr (vmsobj_xabpro *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabpro_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabpro_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_xabpro;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_xabpro_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_xabpro_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_xabpro_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_ABF: /* ACLBUF */
		if (xp->ab_xabpro->xab$l_aclbuf != 0)
		{
		  return Py_BuildValue ("s#",
				xp->ab_xabpro->xab$l_aclbuf,
				(unsigned int) xp->ab_xabpro->xab$w_aclsiz);
		}
		Py_INCREF(Py_None);
		return Py_None;
	      /* ---------- */
	      case OB_K_MTA: /* XAB$B_MTACC */
		/* return single character in XAB$B_MTACC */
		return Py_BuildValue ("s#",
				xp->ab_xabpro->xab$b_mtacc, (unsigned int) 1);
	      /* ---------- */
	      case OB_K_NXT:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_nxt != NULL)
		{
		    Py_INCREF (xp->ar_nxt);
		    return xp->ar_nxt;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_xabpro_attr[l_attr_idx].w_offset & OFSMSK);
	      if (vmsobj_r_xabpro_attr[l_attr_idx].l_mask == 0)
	      {
		  /* return resultant-value */
		  return vms__cvt_bin2py
		    (ab_data				    /* data address */
		    ,vmsobj_r_xabpro_attr[l_attr_idx].w_typ /* data type    */
		    ,vmsdef_gl_itmtypsiz[		    /* data length  */
			vmsobj_r_xabpro_attr[l_attr_idx].w_typ
					]
		    );
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_xabpro_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_xabpro_methods, (PyObject *)xp, name);
} /* vo_xabpro_getattr (vmsobj_xabpro *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_xabpro_setattr (vmsobj_xabpro *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabpro_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabpro_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_xabpro;

	    if ( !(vmsobj_r_xabpro_attr[l_attr_idx].w_offset & ROAT))
	    {
	      if (vmsobj_r_xabpro_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int   w_objtyp;

		char		   * ab_aclbuf;
		unsigned long	     l_aclbuf_len;
		PyObject	   * ar_aclbuf;

		w_objtyp = vmsobj_r_xabpro_attr[l_attr_idx].w_offset & OFSMSK;
	        switch (w_objtyp)
	        {
		/* ---------- */
		case OB_K_ABF: /* ACLBUF */
		  if (v == Py_None)
		  {
		    /* drop old buffer */
		    if (xp->ar_aclbuf != NULL)
		    {
		      Py_DECREF(xp->ar_aclbuf);
		    }
		    xp->ab_xabpro->xab$l_aclbuf = 0;
		    xp->ab_xabpro->xab$l_aclctx = 0;
		    xp->ab_xabpro->xab$w_acllen = 0;
		    xp->ab_xabpro->xab$w_aclsiz = 0;
		    xp->ab_xabpro->xab$l_aclsts = 0;
		    return 0;	/* OK */
		  }
		  /* ---------- */
		  if (PyString_Check(v))
		  {
		    ab_aclbuf    = PyString_AS_STRING(v);
		    l_aclbuf_len = PyString_Size(v);
		    if (l_aclbuf_len > 65535)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"ACL length limited to 65535 bytes");
		      return -1;
		    }
		    /* don't need to keep reference, because a copy is */
		    /*  made to a vmsobj__membuf object */
		    /* Py_INCREF (v); */
		    /* create a vmsobj__membuf object and fill with string */
		    ar_aclbuf = (PyObject *)
				vmsobj__membuf_new (l_aclbuf_len, ab_aclbuf);
		    if (ar_aclbuf == NULL)
		    {
			return -1; /* object creation failed */
		    }
		    v = ar_aclbuf; /* use this with common code below */
		  }
		  /* ---------- */
		  if (! vmsobj__membuf_Check(v))
		  {
		      PyErr_SetString(PyExc_TypeError,
			"attribute must be string, vmsobj__membuf or None");
		      return -1;
		  }
		  /* ---------- */
		  /* v = vmsobj__membuf object */
		  /* drop old object, if one was there XAB */
		  if (xp->ar_aclbuf != NULL)
		  {
		      Py_DECREF(xp->ar_aclbuf);
		  }
		  /* keep reference to object */
		  xp->ar_aclbuf = v;
		  Py_INCREF (v);
		  /* connect to XAB */
		  {
		    vmsobj__membuf * ab_membuf;

		    ab_membuf = (vmsobj__membuf *)xp->ar_aclbuf;
		    xp->ab_xabpro->xab$l_aclbuf = ab_membuf->ab_membuf;
		    xp->ab_xabpro->xab$l_aclctx = 0;
		    /* LEN = actual length from RMS */
		    xp->ab_xabpro->xab$w_acllen = ab_membuf->l_bufsiz;
		    /* SIZ = buffer size into RMS */
		    xp->ab_xabpro->xab$w_aclsiz = ab_membuf->l_bufsiz;
		  }
		  return 0;	/* OK */
		/* ---------- */
		case OB_K_MTA: /* XAB$B_MTACC */
		  /* accept single character for XAB$B_MTACC */
		  if (PyString_Check(v))
		  {
		    char		* at_string;
		    unsigned long	  l_string_len;

		    at_string    = PyString_AS_STRING(v);
		    l_string_len = PyString_Size(v);
		    if (l_string_len > 1)
		    {
		      PyErr_SetString(PyExc_ValueError,
			"string length limited to 1 character");
		      return -1;
		    }

		    (void) memcpy (&xp->ab_xabpro->xab$b_mtacc,
					at_string, l_string_len);

		    /* Py_INCREF(v) not needed, because string was copied */
		    return 0; /* OK */
		  }
		  if (v != Py_None)
		  {
		    PyErr_SetString(PyExc_TypeError,
			"attribute must be string or None");
		    return -1;
		  }

		  /* v == Py_None */
		  xp->ab_xabpro->xab$b_mtacc = 0;
		  return 0; /* OK */
		/* ---------- */
		case OB_K_NXT:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_nxt != NULL)
		    {
		      Py_DECREF(xp->ar_nxt);  /* drop old reference */
		      xp->ar_nxt = NULL;
		    }
		    xp->ab_xabpro->xab$l_nxt = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is _a_ vmsobj_xabXXX */
		  if (! vmsobj__anyxab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_xabXXX object or None");
		    return -1;
		  }
		  if (xp->ar_nxt != NULL)
		  {
		    Py_DECREF(xp->ar_nxt);  /* drop old reference */
		  }
		  xp->ar_nxt = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_xabpro points to object */
		  Py_INCREF (v);
		  /* A different XAB than XABPRO might have been passed. */
		  /* All XAB objects must share the VMS' XAB address in  */
		  /* their structures. */
		  /* (char*) to keep DEC-C on Alpha quiet */
		  xp->ab_xabpro->xab$l_nxt =
					(char *)((vmsobj_xabpro *)v)->ab_xabpro;
		  return 0; /* OK */
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_xabpro_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_xabpro_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
                    /* convert Python type */
                    l_status = vms__cvt_py2bin
                    (v					    /* Python data  */
		    ,ab_data				    /* data address */
                    ,vmsobj_r_xabpro_attr[l_attr_idx].w_typ /* data type    */
                    ,vmsdef_gl_itmtypsiz[		    /* data length  */
		     vmsobj_r_xabpro_attr[l_attr_idx].w_typ
				      ]
		    );
		    /* .. */
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_xabpro_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabpro_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabpro_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabpro_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_xabpro_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabpro_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabpro_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabpro_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_xabpro attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_xabpro attribute");
	return -1;
} /* static int vo_xabpro_setattr (vmsobj_xabpro *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabpro_repr (vmsobj_xabpro *ar_xabpro)
{
	char buf[40];

	sprintf(buf, "<vmsobj_xabpro, XABPRO at 0x%08x>", (ar_xabpro->ab_xabpro));
	return PyString_FromString(buf);
} /* static PyObject * vo_xabpro_repr (vmsobj_xabpro *ar_xabpro) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_xabpro_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_xabpro",		/*tp_name*/
	sizeof(vmsobj_xabpro),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_xabpro_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_xabpro_getattr,	/*tp_getattr*/
	(setattrfunc)vo_xabpro_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_xabpro_repr,	/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_XABPRO.C */
