#ifndef VMSOBJ_XABPRO_H
#define VMSOBJ_XABPRO_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABPRO (KEY definition XAB (eXtended Access Block)) object */

#include <xabprodef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABPRO	* ab_xabpro;	/* the VMS XABPRO */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABPRO points to */
	PyObject	* ar_nxt;	/* next XAB object */
	PyObject	* ar_aclbuf;	/* ACL buffer - vmsobj__membuf object */
} vmsobj_xabpro;

extern DL_IMPORT(PyTypeObject) vmsobj_xabpro_type;
extern DL_IMPORT(vmsobj_xabpro *) vmsobj_xabpro_new (struct XABPRO *arg);

#define vmsobj_xabpro_Check(op) ((op)->ob_type == &vmsobj_xabpro_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABPRO_H */
