/* VMSOBJ_XABRDT.C - 08-MAR-1999 ZE.
   Revision Date+Time XAB (eXtended Access Block) object. 

   24-MAR-1999 ZE. -- replace some PyErr_SetString() with PyErr_Format()
*/

/* ------------------------------------------------------------------------- */

#include "Python.h"
#include "vmsdef.h"

#include <xabrdtdef.h>
#include "vmsobj__def.h"
#include "vmsobj__xabtst.h"	/* test for _any_ XAB */

/* ------------------------------------------------------------------------- */
/* Generic routine to convert binary data to a Python type. */

extern PyObject * vms__cvt_bin2py
        (char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type	*/
        ,unsigned short int        w_bufsiz             /* data length	*/
        );
/* ------------------------------------------------------------------------- */
/* Generic routine to convert a Python type to binary data. */
extern long vms__cvt_py2bin
        (PyObject                * ar_py_data           /* Python data  */
        ,char                    * ab_data_addr         /* data address */
        ,unsigned short int        w_data_type          /* data type    */
        ,unsigned short int        w_bufsiz             /* data length  */
        );
/* ------------------------------------------------------------------------- */

PyTypeObject vmsobj_xabrdt_type;

/* ------------------------------------------------------------------------- */
vmsobj_xabrdt *
vmsobj_xabrdt_new (struct XABRDT *arg)
{
	vmsobj_xabrdt *xp;

	/* -------------------- */
	/* new 'vmsobj_xabrdt' object */
	xp = PyObject_NEW (vmsobj_xabrdt, &vmsobj_xabrdt_type);
	if (xp == NULL)
	{
	    return NULL;
	}
	xp->l_flags = 0;
	/* pointers to other objects that the XABRDT points to */
	xp->ar_nxt    = NULL;	/* next XAB object */

	/* -------------------- */
	if (arg == NULL)
	{
	    /* allocate memory for real XABRDT and note it's address */
	    xp->ab_xabrdt = malloc (XAB$K_RDTLEN);
	    if (xp->ab_xabrdt == NULL)
	    {
		PyMem_DEL(xp);
		(void) PyErr_NoMemory();
		return NULL;
	    }
	    *xp->ab_xabrdt = cc$rms_xabrdt;
	    xp->l_flags |= VMSOBJ_M_ALLOC;
	}
	else
	{
	    /* 'arg' has address of already existing XABRDT */
	    xp->ab_xabrdt = arg;
	    /* VMSOBJ_M_ALLOC is clear */
	}

	/* -------------------- */
	return xp;
}

/* ------------------------------------------------------------------------- */
/* vmsobj_xabrdt methods */

static void
vo_xabrdt_dealloc (vmsobj_xabrdt *xp)
{
	/* was XABRDT allocated on object creation? */
	if (xp->l_flags & VMSOBJ_M_ALLOC)
	{
	    /* release memory of VMS XABRDT */
	    if (xp->ab_xabrdt != NULL)
	    {
		(void) free (xp->ab_xabrdt);
	    }
	}
	else
	{
	    /* The VMS XABRDT was not allocated by the object creation */
	    /* routine; its address was supplied to it.		       */
	    /* Remove pointers from XAB. */
	    xp->ab_xabrdt->xab$l_nxt = 0;
	}

	/* -------------------- */
	/* delete references to other objects the XABRDT might point to */
	if (xp->ar_nxt != NULL)
	{
	    Py_DECREF(xp->ar_nxt);	/* next XAB object */
	}

	/* -------------------- */
	/* release memory of object */
	PyMem_DEL(xp);
}

/* ------------------------------------------------------------------------- */
static PyMethodDef vo_xabrdt_methods[] = {
	{NULL,		NULL}		/* sentinel */
};

/* ------------------------------------------------------------------------- */

struct vmsobj_xabrdt_attr {
	char			* at_attrnam;	/* name of attribute */
	short int		  w_offset;	/* offset within XABRDT */
	unsigned short int	  w_typ;	/* data type	     */
	long			  l_mask;	/* bit address	     */
};
typedef struct vmsobj_xabrdt_attr vmsobj_xabrdt_attr;

/* XAB$B_COD + XAB$B_BLN are not changeable as they identify a XABRDT */

#define ROAT	0x8000	/* read-only attribute */
#define OBIO	0x4000	/* object I/O */
#define OFSMSK	0x1fff	/* mask byte offset count */

#define OB_K_NXT 1 /* next XAB object */

static vmsobj_xabrdt_attr vmsobj_r_xabrdt_attr [] = {
	{"B_BLN",	ROAT+1,	ITMTYP_K_BYTE,0	} ,
	{"B_COD",	ROAT+0,	ITMTYP_K_BYTE,0	} ,
	{"NXT",		OBIO+OB_K_NXT,
				ITMTYP_K_BOOL,0	} , /* object I/O */
	{"L_NXT",	ROAT+4,	ITMTYP_K_LONG,0	} ,

	{"Q_RDT",	12,	ITMTYP_K_QUAD,0	} , /* offset from XABDAT */
	{"W_RVN",	20,	ITMTYP_K_WORD,0	} , /* " */
	{NULL,		0,	0,	0	}
};

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabrdt_getattr (vmsobj_xabrdt *xp, char *name)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabrdt_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabrdt_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long vmsdef_gl_itmtypsiz[];
	    char * ab_data;

	    ab_data = (char *)xp->ab_xabrdt;
	    /* ignore ROAT for get attribute */
	    /* if (vmsobj_r_xabrdt_attr[l_attr_idx].w_offset >= 0) */

	    if (vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & OBIO)	    
	    {
	      /* object I/O */
	      unsigned short int  w_objtyp;

	      w_objtyp = vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & OFSMSK;
	      switch (w_objtyp)
	      {
	      /* ---------- */
	      case OB_K_NXT:
		/* return with a Python object, if one was assigned before */
		if (xp->ar_nxt != NULL)
		{
		    Py_INCREF (xp->ar_nxt);
		    return xp->ar_nxt;
		}
		Py_INCREF (Py_None);
		return Py_None;
	      /* ---------- */
	      default:
		return PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
	      }
	    } /* object I/O */
	    else
	    { /* BWL,M  I/O */
	      ab_data += (vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & OFSMSK);
	      if (vmsobj_r_xabrdt_attr[l_attr_idx].l_mask == 0)
	      {
		  /* return resultant-value */
		  return vms__cvt_bin2py
		    (ab_data				    /* data address */
		    ,vmsobj_r_xabrdt_attr[l_attr_idx].w_typ /* data type    */
		    ,vmsdef_gl_itmtypsiz[		    /* data length  */
			vmsobj_r_xabrdt_attr[l_attr_idx].w_typ
					]
		    );
	      }
	      else
	      {
		/* return a BIT */
		if ((*ab_data) & vmsobj_r_xabrdt_attr[l_attr_idx].l_mask)
		{
		  return PyInt_FromLong( (long)1);
		}
		else
		{
		  return PyInt_FromLong( (long)0);
		}
	      }
	    } /* object or BLW,M I/O */
	  } /* attribute check */
	  l_attr_idx++;
	} /* while() - attribute loop */

	/* -------------------- */
	/* fallback */
	return Py_FindMethod(vo_xabrdt_methods, (PyObject *)xp, name);
} /* vo_xabrdt_getattr (vmsobj_xabrdt *xp, char *name) */

/* ------------------------------------------------------------------------- */

static int
vo_xabrdt_setattr (vmsobj_xabrdt *xp, char *name, PyObject *v)
{
	unsigned long l_attr_idx;

	l_attr_idx = 0;
	while (vmsobj_r_xabrdt_attr[l_attr_idx].at_attrnam != NULL)
	{
	  if (strcmp (name, vmsobj_r_xabrdt_attr[l_attr_idx].at_attrnam) == 0)
	  {
	    /* size of item types - in PYVMS_GLOBAL.C */
	    extern long   vmsdef_gl_itmtypsiz[];
	    long	  l_status;
	    char	* ab_data;
	    PyObject	* ar_v;

	    ab_data = (char *)xp->ab_xabrdt;

	    if ( !(vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & ROAT))
	    {
	      if (vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & OBIO)	    
	      {
		/* object I/O */
		unsigned short int   w_objtyp;

		w_objtyp = vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & OFSMSK;
	        switch (w_objtyp)
	        {
		/* ---------- */
		case OB_K_NXT:
		  if (v == Py_None)
		  {
		    /* 'None' = break connection to next XAB */
		    if (xp->ar_nxt != NULL)
		    {
		      Py_DECREF(xp->ar_nxt);  /* drop old reference */
		      xp->ar_nxt = NULL;
		    }
		    xp->ab_xabrdt->xab$l_nxt = 0;
		    return 0; /* OK */
		  }
		  /* check and make sure this is _a_ vmsobj_xabXXX */
		  if (! vmsobj__anyxab_Check(v))
		  {
		    PyErr_SetString(PyExc_TypeError,
			"must be a vmsobj_xabXXX object or None");
		    return -1;
		  }
		  if (xp->ar_nxt != NULL)
		  {
		    Py_DECREF(xp->ar_nxt);  /* drop old reference */
		  }
		  xp->ar_nxt = v;		/* remember for Py_DECREF */
		  /* keep reference, because vmsobj_xabrdt points to object */
		  Py_INCREF (v);
		  /* A different XAB than XABRDT might have been passed. */
		  /* All XAB objects must share the VMS' XAB address in  */
		  /* their structures. */
		  /* (char*) to keep DEC-C on Alpha quiet */
		  xp->ab_xabrdt->xab$l_nxt =
					(char *)((vmsobj_xabrdt *)v)->ab_xabrdt;
		  return 0; /* OK */
		/* ---------- */
		default:
		  (void) PyErr_Format(PyExc_SystemError,
			"BUGCHK - object I/O - unsupported object type: %d",
			(unsigned int)w_objtyp);
		  return -1;
		}
	      } /* object I/O */
	      else
	      { /* BWL,M  I/O */
		ab_data += (vmsobj_r_xabrdt_attr[l_attr_idx].w_offset & OFSMSK);
		if (vmsobj_r_xabrdt_attr[l_attr_idx].l_mask == 0)
		{
/* @@ check that BW don't overflow */
                    /* convert Python type */
                    l_status = vms__cvt_py2bin
                    (v					    /* Python data  */
		    ,ab_data				    /* data address */
                    ,vmsobj_r_xabrdt_attr[l_attr_idx].w_typ /* data type    */
                    ,vmsdef_gl_itmtypsiz[		    /* data length  */
		     vmsobj_r_xabrdt_attr[l_attr_idx].w_typ
				      ]
		    );
		    /* .. */
		}
		else
		{
		  long			l_v;
		  unsigned long		l_msk;
		  unsigned short int	w_msk;
		  unsigned char		b_msk;

		  /* set/clear a BIT */
		  if (!PyInt_Check(v))
		  {
		    PyErr_SetString(PyExc_AttributeError,
			"bitmask assignment needs integer");
		    return -1;
		  }
		  l_v = PyInt_AsLong(v);
		  if (PyErr_Occurred())
		  {
		    return -1;
		  }

		  if (l_v == 0)
		  {
		    /* clear bit */
		    l_msk = ~ vmsobj_r_xabrdt_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabrdt_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data &= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabrdt_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data &= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabrdt_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data &= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  }
		  else
		  {
		    /* set bit */
		    l_msk = vmsobj_r_xabrdt_attr[l_attr_idx].l_mask;
		    w_msk = l_msk;
		    b_msk = w_msk;

		    if (vmsobj_r_xabrdt_attr[l_attr_idx].w_typ == ITMTYP_K_BYTE)
		    {
		      *ab_data |= b_msk;
		    }
		    else
		    {
		      if (vmsobj_r_xabrdt_attr[l_attr_idx].w_typ == ITMTYP_K_WORD)
		      {
		        *ab_data |= w_msk;
		      }
		      else
		      {
			if (vmsobj_r_xabrdt_attr[l_attr_idx].w_typ == ITMTYP_K_LONG)
			{
			  *ab_data |= l_msk;
			}
			else
			{
			  /* @@ bad table */
			} /* -ITMTYP_K_LONG */
		      } /* -ITMTYP_K_WORD */
		    } /* -ITMTYP_K_BYTE */
		  } /* clear or set bit */
	          l_status = 1; /* OK */
	        } /* others or bitmask */
	      } /* object or BWL,M I/O */
	    } /* offset 0x8000 indicates readonly attribute */
	    else
	    {
		PyErr_SetString(PyExc_AttributeError,
		    "read-only vmsobj_xabrdt attribute");
		return -1;
	    }
	    if (l_status == 1)
	    {
	      l_status = 0;
	    }
	    return l_status;       /* possible error mesage has been set */
	  }
	  l_attr_idx++;
	}

	/* -------------------- */
	PyErr_SetString(PyExc_AttributeError,
	    "non-existing vmsobj_xabrdt attribute");
	return -1;
} /* static int vo_xabrdt_setattr (vmsobj_xabrdt *xp, char *name, PyObject *v) */

/* ------------------------------------------------------------------------- */

static PyObject *
vo_xabrdt_repr (vmsobj_xabrdt *ar_xabrdt)
{
	char buf[40];

	sprintf(buf, "<vmsobj_xabrdt, XABRDT at 0x%08x>", (ar_xabrdt->ab_xabrdt));
	return PyString_FromString(buf);
} /* static PyObject * vo_xabrdt_repr (vmsobj_xabrdt *ar_xabrdt) */

/* ------------------------------------------------------------------------- */
PyTypeObject vmsobj_xabrdt_type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"vmsobj_xabrdt",		/*tp_name*/
	sizeof(vmsobj_xabrdt),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)vo_xabrdt_dealloc,	/*tp_dealloc*/
	(printfunc)0,			/*tp_print*/
	(getattrfunc)vo_xabrdt_getattr,	/*tp_getattr*/
	(setattrfunc)vo_xabrdt_setattr,	/*tp_setattr*/
	(cmpfunc)0,			/*tp_compare*/
	(reprfunc)vo_xabrdt_repr,	/*tp_repr*/
	0,				/*tp_as_number*/
	0,				/*tp_as_sequence*/
	0,				/*tp_as_mapping*/
	(hashfunc)0,			/*tp_hash*/
};

/* ------------------------------------------------------------------------- */

/* EOF: VMSOBJ_XABRDT.C */
