#ifndef VMSOBJ_XABRDT_H
#define VMSOBJ_XABRDT_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABRDT (KEY definition XAB (eXtended Access Block)) object */

#include <xabrdtdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABRDT	* ab_xabrdt;	/* the VMS XABRDT */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABRDT points to */
	PyObject	* ar_nxt;	/* next XAB object */
} vmsobj_xabrdt;

extern DL_IMPORT(PyTypeObject) vmsobj_xabrdt_type;
extern DL_IMPORT(vmsobj_xabrdt *) vmsobj_xabrdt_new (struct XABRDT *arg);

#define vmsobj_xabrdt_Check(op) ((op)->ob_type == &vmsobj_xabrdt_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABRDT_H */
