#ifndef VMSOBJ_XABSUM_H
#define VMSOBJ_XABSUM_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABSUM (KEY definition XAB (eXtended Access Block)) object */

#include <xabsumdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABSUM	* ab_xabsum;	/* the VMS XABSUM */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABSUM points to */
	PyObject	* ar_nxt;	/* next XAB object */
} vmsobj_xabsum;

extern DL_IMPORT(PyTypeObject) vmsobj_xabsum_type;
extern DL_IMPORT(vmsobj_xabsum *) vmsobj_xabsum_new (struct XABSUM *arg);

#define vmsobj_xabsum_Check(op) ((op)->ob_type == &vmsobj_xabsum_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABSUM_H */
