#ifndef VMSOBJ_XABTRM_H
#define VMSOBJ_XABTRM_H
#ifdef __cplusplus
extern "C" {
#endif

/* OpenVMS XABTRM (TeRMinal XAB (eXtended Access Block)) object */

/* This object is only valid for RAB$L_XAB - it is not to be included */
/* in "vmsobj__xabtst.h" !! */

#include <xabtrmdef.h>

typedef struct {
	PyObject_HEAD
	long		  l_flags;
	struct XABTRM	* ab_xabtrm;	/* the VMS XABTRM */
	/* all XABs must share the entries up to above one */
	/* ----- */
	/* pointers to other objects that the XABTRM points to */
	PyObject		  * ar_nxt;	/* next XAB object */
	PyObject		  * ar_itmlst;	/* itemlist object */

	/* 3 variables below are used for cross-procedure access */

	/* VMS item-list to be connected to XAB$L_ITMLST */
	struct vmsdef_xr_itmlst3  * ar_itemlist;	/* start address */

	/* array that provides storage for returned length for output items */
	unsigned short int	  * aw_retlenlist;

	/* array of pointers from item-list entry into VMSDEF structure */
	/*  this is used for output-item processing */
	struct vmsdef_xr_itmtbl  ** ar_itm_vmsdef;	/* start address */
} vmsobj_xabtrm;

extern DL_IMPORT(PyTypeObject) vmsobj_xabtrm_type;
extern DL_IMPORT(vmsobj_xabtrm *) vmsobj_xabtrm_new (struct XABTRM *arg);

#define vmsobj_xabtrm_Check(op) ((op)->ob_type == &vmsobj_xabtrm_type)

#ifdef __cplusplus
}
#endif
#endif /* !VMSOBJ_XABTRM_H */
