unit Add;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, ExtCtrls, ComCtrls, attrib;

type
  TAddForm = class(TForm)
    lvwAdd: TListView;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure lvwAddDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure getUserList;
    procedure getComputerList;
    procedure GetOUList;
    procedure GetGroupList;
    procedure GetPServerList;
    procedure GetPrinterList;
    procedure GetQueueList;
    procedure GetCountryList;
    procedure GetOrganizationList;
    procedure ClearList;
    procedure GetUnknownList;
    { Public declarations }
  end;

var
  AddForm: TAddForm;

implementation
uses
  mainunit;

{$R *.DFM}

procedure TAddForm.ClearList;
var
  Y,Z : Integer;
begin
  attribForm.sgdAttr.Cells[0,0]:='Attribute';
  attribForm.sgdAttr.Cells[1,0]:='Syntax';
  attribForm.sgdAttr.Cells[2,0]:='Value';
  for Y := 0 to attribForm.sgdAttr.ColCount - 1 do
    for Z:= 1 to attribForm.sgdAttr.RowCount - 1 do
      attribForm.sgdAttr.Cells[Y,Z] := '';
end;

procedure TAddForm.FormCreate(Sender: TObject);
var
  NewItem : TListItem;
begin
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='User';
  NewItem.ImageIndex:=0;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='O (Organization)';
  NewItem.ImageIndex:=11;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='OU (Organizational Unit)';
  NewItem.ImageIndex:=1;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='C (Country)';
  NewItem.ImageIndex:=21;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='Computer';
  NewItem.ImageIndex:=16;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='Group';
  NewItem.ImageIndex:=2;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='Print Server';
  NewItem.ImageIndex:=6;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='Printer';
  NewItem.ImageIndex:=5;
  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='Queue';
  NewItem.ImageIndex:=7;
{  NewItem:=lvwAdd.Items.Add;
  NewItem.Caption:='Unknown';
  NewItem.ImageIndex:=8;}
end;

procedure TAddForm.GetOUList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Organizational Unit';
  attribForm.sgdAttr.Cells[0,2]:='Description';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='S (State or Province)';
  attribForm.sgdAttr.Cells[1,3]:='3';
  attribForm.sgdAttr.Cells[0,4]:='SA (Street Address)';
  attribForm.sgdAttr.Cells[1,4]:='3';
  attribForm.sgdAttr.Cells[0,5]:='Telephone Number';
  attribForm.sgdAttr.Cells[1,5]:='10';
  attribForm.sgdAttr.RowCount:=6;
end;

procedure TAddForm.GetGroupList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Group';
  attribForm.sgdAttr.Cells[0,2]:='Description';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='Full Name';
  attribForm.sgdAttr.Cells[1,3]:='3';
  attribForm.sgdAttr.Cells[0,4]:='Owner';
  attribForm.sgdAttr.cells[1,4]:='1';
  attribForm.sgdAttr.cells[2,4]:='[..]';
  attribForm.sgdAttr.RowCount:=5;
end;

procedure TAddForm.GetComputerList;   //1=Distingushed Name  4=Printable String
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Computer';
  attribForm.sgdAttr.Cells[0,2]:='Description';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='Operator';
  attribForm.sgdAttr.Cells[1,3]:='1';
  attribForm.sgdAttr.cells[2,3]:='[..]';
  attribForm.sgdAttr.Cells[0,4]:='Owner';
  attribForm.sgdAttr.cells[1,4]:='1';
  attribForm.sgdAttr.cells[2,4]:='[..]';
  attribForm.sgdAttr.Cells[0,5]:='Serial Number';
  attribForm.sgdAttr.Cells[1,5]:='4';
  attribForm.sgdAttr.cells[0,6]:='Status';
  attribForm.sgdAttr.Cells[1,6]:='8';
  attribForm.sgdAttr.RowCount:=8;
end;

procedure TAddForm.GetPServerList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Print Server';
  attribForm.sgdAttr.Cells[0,2]:='Description';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='Operator';
  attribForm.sgdAttr.Cells[1,3]:='1';
  attribForm.sgdAttr.cells[2,3]:='[..]';
  attribForm.sgdAttr.Cells[0,4]:='Printer';
  attribForm.sgdAttr.cells[1,4]:='25';
  attribForm.sgdAttr.cells[0,5]:='Status';
  attribForm.sgdAttr.Cells[1,5]:='8';
  attribForm.sgdAttr.Cells[0,6]:='Version';
  attribForm.sgdAttr.Cells[1,6]:='3';
  attribForm.sgdAttr.RowCount:=7;
end;

procedure TAddForm.GetCountryList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Country';
  attribForm.sgdAttr.Cells[0,2]:='Description';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.RowCount:=3;
end;

procedure TAddForm.GetOrganizationList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Organization';
  attribForm.sgdAttr.Cells[0,2]:='Description';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='S (State or Province)';
  attribForm.sgdAttr.Cells[1,3]:='3';
  attribForm.sgdAttr.Cells[0,4]:='SA (Street Address)';
  attribForm.sgdAttr.Cells[1,4]:='3';
  attribForm.sgdAttr.Cells[0,5]:='Telephone Number';
  attribForm.sgdAttr.Cells[1,5]:='10';
  attribForm.sgdAttr.RowCount:=6;
end;

procedure TAddForm.GetPrinterList;   //25=Typed Name
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Printer';
  attribForm.sgdAttr.Cells[0,2]:='Cartridge';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='Default Queue';
  attribForm.sgdAttr.cells[1,3]:='1';
  attribForm.sgdAttr.cells[2,3]:='[..]';
  attribForm.sgdAttr.Cells[0,4]:='Description';
  attribForm.sgdAttr.Cells[1,4]:='3';
  attribForm.sgdAttr.Cells[0,5]:='Memory';
  attribForm.sgdAttr.Cells[1,5]:='8';
  attribForm.sgdAttr.Cells[0,6]:='Notify';
  attribForm.sgdAttr.Cells[1,6]:='25';
  attribForm.sgdAttr.Cells[0,7]:='Operator';
  attribForm.sgdAttr.Cells[1,7]:='1';
  attribForm.sgdAttr.cells[2,7]:='[..]';
  attribForm.sgdAttr.Cells[0,8]:='Owner';
  attribForm.sgdAttr.cells[1,8]:='1';
  attribForm.sgdAttr.cells[2,8]:='[..]';
  attribForm.sgdAttr.Cells[0,9]:='Queue';
  attribForm.sgdAttr.Cells[1,9]:='25';
  attribForm.sgdAttr.cells[0,10]:='Status';
  attribForm.sgdAttr.Cells[1,10]:='8';
  attribForm.sgdAttr.Cells[0,11]:='Host Device';
  attribForm.sgdAttr.Cells[1,11]:='1';
  attribForm.sgdAttr.cells[2,11]:='[..]';
  attribForm.sgdAttr.Cells[0,12]:='L (Location);';
  attribForm.sgdAttr.Cells[1,12]:='3';
  attribForm.sgdAttr.RowCount:=13;
end;

procedure TAddForm.GetQueueList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Queue';
  attribForm.sgdAttr.Cells[0,2]:='*Host Server';
  attribForm.sgdAttr.Cells[1,2]:='1';
  attribForm.sgdAttr.cells[2,2]:='[..]';
  attribForm.sgdAttr.Cells[0,3]:='*Queue Directory';
  attribForm.sgdAttr.Cells[1,3]:='3';
  attribForm.sgdAttr.Cells[0,4]:='Description';
  attribForm.sgdAttr.Cells[1,4]:='3';
  attribForm.sgdAttr.Cells[0,5]:='L (Location);';
  attribForm.sgdAttr.Cells[1,5]:='3';
  attribForm.sgdAttr.Cells[0,6]:='Operator';
  attribForm.sgdAttr.Cells[1,6]:='1';
  attribForm.sgdAttr.cells[2,6]:='[..]';
  attribForm.sgdAttr.RowCount:=7;
end;

procedure TAddForm.GetUnknownList;
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='Unknown';
  attribForm.sgdAttr.Cells[0,2]:='*Unknown Object Restriction';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.RowCount:=3;
end;

procedure TAddForm.GetUserList; //3=CIS 7=Bool 20=Class name 22=counter 15=path 14=emailaddress 8=Integer 10=telephone
begin
  attribForm.sgdAttr.Cells[0,1]:='*Object Class';
  attribForm.sgdAttr.Cells[1,1]:='20';
  attribForm.sgdAttr.Cells[2,1]:='User';
  attribForm.sgdAttr.Cells[0,2]:='*Surname';
  attribForm.sgdAttr.Cells[1,2]:='3';
  attribForm.sgdAttr.Cells[0,3]:='Account Balance';
  attribForm.sgdAttr.Cells[1,3]:='22';
  attribForm.sgdAttr.Cells[0,4]:='Allow Unlimited Credit';
  attribForm.sgdAttr.Cells[1,4]:='7';
  attribForm.sgdAttr.Cells[2,4]:='[..]';
  attribForm.sgdAttr.Cells[0,5]:='Description';
  attribForm.sgdAttr.Cells[1,5]:='3';
  attribForm.sgdAttr.Cells[0,6]:='Home Directory';
  attribForm.sgdAttr.Cells[1,6]:='15';
  attribForm.sgdAttr.Cells[0,7]:='Language';
  attribForm.sgdAttr.Cells[1,7]:='3';
  attribForm.sgdAttr.Cells[0,8]:='Login Grace Limit';
  attribForm.sgdAttr.Cells[1,8]:='8';
  attribForm.sgdAttr.Cells[0,9]:='Password Allow Change';
  attribForm.sgdAttr.Cells[1,9]:='7';
  attribForm.sgdAttr.Cells[2,9]:='[..]';
  attribForm.sgdAttr.Cells[0,10]:='Password Min Length';
  attribForm.sgdAttr.Cells[1,10]:='8';
  attribForm.sgdAttr.Cells[0,11]:='Password Required';
  attribForm.sgdAttr.Cells[1,11]:='7';
  attribForm.sgdAttr.Cells[2,11]:='[..]';
  attribForm.sgdAttr.Cells[0,12]:='Password Unique Required';
  attribForm.sgdAttr.Cells[1,12]:='7';
  attribForm.sgdAttr.Cells[2,12]:='[..]';
  attribForm.sgdAttr.Cells[0,13]:='S (State or Province)';
  attribForm.sgdAttr.Cells[1,13]:='3';
  attribForm.sgdAttr.Cells[0,14]:='SA (Street Address)';
  attribForm.sgdAttr.Cells[1,14]:='3';
  attribForm.sgdAttr.Cells[0,15]:='Telephone Number';
  attribForm.sgdAttr.Cells[1,15]:='10';
  attribForm.sgdAttr.Cells[0,16]:='Title';
  attribForm.sgdAttr.Cells[1,16]:='3';
  attribForm.sgdAttr.RowCount:=17;
end;

procedure TAddForm.lvwAddDblClick(Sender: TObject);
var
  SelectItem : TListItem;
begin
  ClearList;
  SelectItem:=lvwAdd.Selected;
  if (SelectItem=nil) then
    exit;
  if SelectItem.Caption='User' then
    GetUserList
  else if SelectItem.Caption='Computer' then
    GetComputerList
  else if SelectItem.Caption='Group' then
    GetGroupList
  else if SelectItem.Caption='OU (Organizational Unit)' then
    GetOUList
  else if SelectItem.Caption='Print Server' then
    GetPServerList
  else if SelectItem.Caption='Printer' then
    GetPrinterList
  else if SelectItem.Caption='Queue' then
    GetQueueList
  else if SelectItem.Caption='C (Country)' then
    GetCountryList
  else if SelectItem.Caption='O (Organization)' then
    GetOrganizationList
  else if SelectItem.Caption='Unknown' then
    GetUnknownList
  else
    ShowMessage('Unknown Type: '+SelectItem.Caption);
  attribform.show;
  AddForm.Close;
end;
end.
