{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit attrib;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, MainUnit, Buttons, Grids, nwinc32;

type
  Tattribform = class(TForm)
    Bevel1: TBevel;
    BitBtn1: TBitBtn;
    sgdAttr: TStringGrid;
    edtName: TEdit;
    lblMandatory: TLabel;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure sgdAttrDblClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure sgdAttrClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  attribform: Tattribform;

implementation

uses value, Tree;

//uses main;

{$R *.DFM}

procedure Tattribform.BitBtn1Click(Sender: TObject);
begin
  if attribform.Caption='Viewing Directory Object' then
  begin
   edtName.Text:='';
   Close;
  end
  else if attribform.Caption='Adding Directory Object' then
  begin
    form1.AddDSObject;
    edtName.Text:='';
  end
  else if attribform.Caption='Modifying Directory Object' then
  begin
   edtName.Text:='';
//    ModifyDSObject;
    Close;
  end;
end;

procedure Tattribform.sgdAttrDblClick(Sender: TObject);
var
  selnode : TTreeNode;
  TheItem : String;
begin
   selnode:=TreeForm.tvwDS.selected;
   TheItem:=selnode.text;
   if (sgdAttr.Cells[2,sgdAttr.Row]='[..]') then
   begin
      strpcopy(@gobjectName,TheItem+'.'+TreeForm.edtContext.Text);
      strpcopy(attrName,sgdAttr.Cells[0,sgdAttr.Row]);
      frmValue.mmoValue.Lines.Clear;
      Form1.GetValues;
      frmValue.Show;
   end;
end;

procedure Tattribform.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure Tattribform.sgdAttrClick(Sender: TObject);
var
  nullname : Array [0..200] of char;
  objectID : nuint32;

begin
   if attribform.Caption<>'Adding Directory Object' then
     exit;
   if sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]='[..]' then
   begin
     if sgdAttr.Cells[1,sgdAttr.Row]='1' then
     begin
       strpcopy(nullname,InputBox('Distinguished Name', 'Enter a vaild Object Name (ie Fred.ACME)', ''));
       dcode := NWDSMapNametoId(dContext,connHandle,@nullname,@objectID);
       if (dcode<0) then
       begin
         if dcode=-601 then
            ShowMessage('Object does not exist')
         else if dcode=-610 then
           ShowMessage('Illegal NDS name')
         else
           ShowMessage('Object does not exist: '+inttostr(dcode));         
         exit;
       end;
       sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]:=strpas(nullname);
     end
     else if (sgdAttr.Cells[1,sgdAttr.Row]='5') or (sgdAttr.Cells[1,sgdAttr.Row]='8') then
     begin
       strpcopy(nullname,InputBox('Numeric String', 'Enter a vaild Numeric String (ie 222 45 66)', ''));
       sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]:=strpas(nullname);
     end
     else if sgdAttr.Cells[1,sgdAttr.Row]='7' then
     begin
       strpcopy(nullname,InputBox('Boolean', 'Enter True or False', ''));
       if uppercase(strpas(nullname))='TRUE' then
          sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]:='1'
       else
          sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]:='0';
     end
     else if sgdAttr.Cells[1,sgdAttr.Row]='15' then
     begin
       strpcopy(nullname,InputBox('Path', 'Enter a Path (ie SYS:PUBLIC)', ''));
       if pos(':',strpas(nullname))=0 then
       begin
         ShowMessage('Bad Path-Add a volume name');
         exit;
       end;
       sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]:=strpas(nullname);
     end
     else
       ShowMessage('Not Done');
   end;
  { if (sgdAttr.Col=1) and (sgdAttr.Row >0)  then
   begin
     syntaxId := strtoint(sgdAttr.Cells[sgdAttr.Col,sgdAttr.Row]);
     dcode := nwdsreadsyntaxdef(dContext,syntaxID,syntaxDef);
     if (dcode=0) then
       ShowMessage(strpas(syntaxDef.defStr));
   end;}
end;

end.
