{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit Dist;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FileCtrl, ComCtrls, ExtCtrls, nwinc32, inifiles;

type
  TDistForm = class(TForm)
    lstServers: TListBox;
    Label1: TLabel;
    bbtMap: TBitBtn;
    grpSoftware: TGroupBox;
    FileListBox: TFileListBox;
    lstDir: TDirectoryListBox;
    DriveCombo: TDriveComboBox;
    bbtClose: TBitBtn;
    mmoResults: TMemo;
    Label4: TLabel;
    bbtDist: TBitBtn;
    FilterComboBox1: TFilterComboBox;
    DestServerList: TListBox;
    BitBtn2: TBitBtn;
    StatusBar1: TStatusBar;
    lblDestDir: TLabel;
    edtDest: TEdit;
    SourceFileList: TListBox;
    grpMain: TGroupBox;
    rbnSoftware: TRadioButton;
    rbnConsole: TRadioButton;
    rbnNCF: TRadioButton;
    rbnExecute: TRadioButton;
    grpConsole: TGroupBox;
    lblConsole: TLabel;
    Bevel1: TBevel;
    grpExecute: TGroupBox;
    Label2: TLabel;
    edtExecute: TEdit;
    Bevel3: TBevel;
    edtConsole: TEdit;
    grpNCF: TGroupBox;
    lblLine: TLabel;
    lblFullPath: TLabel;
    mmoNCF: TMemo;
    edtNCF: TEdit;
    RadioButton1: TRadioButton;
    bbtSave: TBitBtn;
    bbtGetList: TBitBtn;
    lblTShould: TLabel;
    Label3: TLabel;
    grpUpdate: TGroupBox;
    lblTNLM: TLabel;
    Label5: TLabel;
    edtSource: TEdit;
    edtDest2: TEdit;
    cbLoad: TCheckBox;
    cbNow: TCheckBox;
    procedure bbtMapClick(Sender: TObject);
    procedure bbtCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bbtDistClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FileListBoxKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure rbnSoftwareClick(Sender: TObject);
    procedure rbnConsoleClick(Sender: TObject);
    procedure rbnNCFClick(Sender: TObject);
    procedure rbnExecuteClick(Sender: TObject);
    procedure bbtSaveClick(Sender: TObject);
    procedure bbtGetListClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure edtExecuteKeyPress(Sender: TObject; var Key: Char);
    procedure edtConsoleKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    procedure GetServerList;
    procedure DistSoftware;
    Procedure DistNCF;
    Procedure DistExecute;
    Procedure DistConsole;
    procedure DistUpdate;
    procedure StreamFileCopy(const sourcefilename, targetfilename: String);
    { Public declarations }
  end;

var
  DistForm: TDistForm;

implementation

uses map2, mainunit;

{$R *.DFM}

procedure TDistForm.bbtMapClick(Sender: TObject);
begin
  DistForm.Hide;
  Form1.bbtMapClick(DistForm);
end;

procedure TDistForm.bbtCloseClick(Sender: TObject);
begin
    DistForm.Hide;
end;

procedure TDistForm.GetServerList;
var
  i : Integer;
begin
  for i:=0 to Form1.lstServers.Items.Count-1 do
  begin
    lstServers.items.Add(Form1.lstServers.Items[i]);
  end;
  now
end;

procedure TDistForm.FormCreate(Sender: TObject);
begin
  getserverlist;
end;

procedure TDistForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DistForm.Hide;
end;

procedure TDistForm.bbtDistClick(Sender: TObject);
begin
  if grpsoftware.Visible=True then
  begin
    DistSoftware;
  end
  else if grpConsole.Visible=True then
  begin
    DistConsole;
  end
  else if grpNCF.Visible=True then
  begin
    DistNCF;
  end
  else if grpExecute.Visible=True then
  begin
    DistExecute;
  end
  else if grpUpdate.Visible=True then
  begin
    DistUpdate;
  end;
end;

procedure TDistForm.DistConsole;
var
  i: Integer;
  GoodCount : Integer;
  BadCount : integer;
  FileName : Array [0..200] of char;
  F2 : Textfile;
begin
 GoodCount:=0;
 BadCount:=0;
 DestServerList.Items.Clear;

 if pos('3.',Form1.lblVer.Caption)>0 then
 begin
   ShowMessage('Not Available on a 3.x Server');
   Exit;
 end;

 //First Check that there is a Console command to send
 if (edtConsole.Text='') then
 begin
   ShowMessage('No Console Command to Send');
   exit;
 end;

 if (edtConsole.Text='MODULES') then
 begin
   ShowMessage('MODULES is not allowed since it requires user input from the console');
   exit;
 end;

 if (edtConsole.Text='CONFIG') then
 begin
   ShowMessage('CONFIG is not allowed since it requires user input from the console');
   exit;
 end;

 if (edtConsole.Text='SET') then
 begin
   ShowMessage('CONFIG is not allowed since it requires user input from the console');
   exit;
 end;

//Now Get a list of the selected Servers
  for i:=0 to lstServers.Items.Count-1 do
  begin
    if lstServers.Selected[i]=True then
    begin
      destServerList.Items.Add(lstServers.Items[i]);
    end;
  end;

  if (DestServerList.Items.Count=0) then
  begin
    ShowMessage('No Destination Servers were selected');
    exit;
  end;

  //Start Executing
  screen.cursor:=crHourGlass;
  for i:=0 to DestServerList.Items.Count-1 do
  begin
    if Form1.mapadrive(DestServerList.Items[i],'SYS:') <> 0 then
        mmoResults.Lines.Add('Failed to map a drive to '+DestServerList.Items[i])
    else
    begin
        AssignFile(F2, driveletter+':\TEMP$$.NCF');
        ReWrite(F2);
        WriteLn(F2, edtConsole.text);
        CloseFile(F2);
        strpcopy(FileName, 'SYS:TEMP$$.NCF');
        ccode := NWSMExecuteNCFFile(TmpConnHandle,@FileName);
        if (ccode <> 0 ) then
        begin
            inc(BadCount);
            statusBar1.Panels[1].Text:=inttostr(BadCount)+' Commands Failed';
            mmoResults.Lines.Add('Failed to Execute '+edtConsole.text+' on '+DestServerList.Items[i]+': 0x'+inttohex(ccode,2));
        end
        else
        begin
            inc(GoodCount);
            statusBar1.Panels[0].Text:=inttostr(GoodCount)+' Commands Passed';
            mmoResults.Lines.Add('Executed '+edtConsole.text+' on '+DestServerList.Items[i]);
        end;
        DeleteFile(driveletter+':\TEMP$$.NCF');
        Form1.DeleteDrive;
    end;
  end;
  screen.cursor:=crDefault;
end;

procedure TDistForm.DistNCF;
var
  i, j: Integer;
  GoodCount : Integer;
  BadCount : integer;
  volname : Array [0..128] of char;
  F2 : Textfile;
begin
 GoodCount:=0;
 BadCount:=0;
 DestServerList.Items.Clear;

 //First Check that there is a Common Path to an NCF/TXT File
 if edtNCF.Text='' then
 begin
   ShowMessage('No NCF/TXT File to Modify');
   exit;
 end;

//Now Get a list of the selected Servers
  for i:=0 to lstServers.Items.Count-1 do
  begin
    if lstServers.Selected[i]=True then
    begin
      destServerList.Items.Add(lstServers.Items[i]);
    end;
  end;

  if (DestServerList.Items.Count=0) then
  begin
    ShowMessage('No Destination Servers were selected');
    exit;
  end;

  strpcopy(volname,copy(edtNCF.text,0,pos(':',edtNCF.TEXT)-1));

  //Start Executing
  for i:=0 to DestServerList.Items.Count-1 do
  begin
    if Form1.mapadrive(DestServerList.Items[i],volname) <> 0 then
        mmoResults.Lines.Add('Failed to map a drive to '+DestServerList.Items[i])
    else
    begin
        if not fileexists(driveletter+':\'+copy(edtNCF.text,pos(':',edtNCF.text)+1,200))then
        begin
            inc(BadCount);
            statusBar1.Panels[1].Text:=inttostr(BadCount)+' Commands Failed';
            mmoResults.Lines.Add('File '+edtNCF.text+' does not exist '+DestServerList.Items[i]+' no modifications made');
            break;
        end;
        AssignFile(F2, driveletter+':\'+copy(edtNCF.text,pos(':',edtNCF.text)+1,200));
        if fileexists(driveletter+':\'+copy(edtNCF.text,pos(':',edtNCF.text)+1,200)) then
           Append(F2)
        else
           ReWrite(F2);
        for j:=0 to mmoNCF.Lines.Count do
        begin
          WriteLn(F2, mmoNCF.Lines[j]);
        end;
        closeFile(F2);
        inc(GoodCount);
        statusBar1.Panels[0].Text:=inttostr(GoodCount)+' Files Modified';
        mmoResults.Lines.Add('Added Lines to the '+edtNCF.text+' File on '+DestServerList.Items[i]);
        Form1.DeleteDrive;
    end;
  end;
  mmoNCF.Lines.Clear;
end;

procedure TDistForm.DistExecute;
var
  i: Integer;
  GoodCount : Integer;
  BadCount : integer;
  FileName : Array [0..200] of char;
begin

 if pos('3.',Form1.lblVer.Caption)>0 then
 begin
   ShowMessage('Not Available on a 3.x Server');
   Exit;
 end;

 GoodCount:=0;
 BadCount:=0;
 DestServerList.Items.Clear;

 //First Check that there is a Console command to send
 if edtExecute.Text='' then
 begin
   ShowMessage('No NCF File to execute');
   exit;
 end;

//Now Get a list of the selected Servers
  for i:=0 to lstServers.Items.Count-1 do
  begin
    if lstServers.Selected[i]=True then
    begin
      destServerList.Items.Add(lstServers.Items[i]);
    end;
  end;

  if (DestServerList.Items.Count=0) then
  begin
    ShowMessage('No Destination Servers were selected');
    exit;
  end;

  //Start Executing
  for i:=0 to DestServerList.Items.Count-1 do
  begin

        if Form1.mapadrive(DestServerList.Items[i],'SYS:') <> 0 then //Needed only for the connection Handle
           mmoResults.Lines.Add('Failed to map a drive to '+DestServerList.Items[i])
        else
        begin
          strpcopy(FileName, edtExecute.Text);
          ccode := NWSMExecuteNCFFile(TmpConnHandle,@FileName);
          if (ccode <> 0 ) then
          begin
              inc(BadCount);
              statusBar1.Panels[1].Text:=inttostr(BadCount)+' Commands Failed';
              mmoResults.Lines.Add('Failed to Execute '+edtExecute.Text+' on '+DestServerList.Items[i]+': '+inttohex(ccode,2));
          end
          else
          begin
              inc(GoodCount);
              statusBar1.Panels[0].Text:=inttostr(GoodCount)+' Commands Passed';
              mmoResults.Lines.Add('Executed '+edtExecute.Text+' on '+DestServerList.Items[i]);
          end;
          Form1.DeleteDrive;
        end;
  end;
end;

procedure TDistForm.DistUpdate;
var
  i: Integer;
  GoodCount : Integer;
  BadCount : integer;
  FileName : Array [0..200] of char;
  F2: TextFile;
  volname : String;
  destdir : String;
begin
 GoodCount:=0;
 BadCount:=0;
 DestServerList.Items.Clear;

 //First Check that there is a NLM to send
 if not fileexists(edtSource.text) then
 begin
   ShowMessage('No Source NLM File found');
   exit;
 end;

//Check for a destination
if edtDest2.Text='' then
begin
  ShowMessage('No common destination directory');
  exit;
end;

//Now Get a list of the selected Servers
  for i:=0 to lstServers.Items.Count-1 do
  begin
    if lstServers.Selected[i]=True then
    begin
      destServerList.Items.Add(lstServers.Items[i]);
    end;
  end;

  if (DestServerList.Items.Count=0) then
  begin
    ShowMessage('No Destination Servers were selected');
    exit;
  end;

  //Start Executing
  for i:=0 to DestServerList.Items.Count-1 do
  begin
        volname:=copy(edtDest2.Text,0,pos(':',edtDest2.text));
        if Form1.mapadrive(DestServerList.Items[i],volname) <> 0 then //Needed only for the connection Handle
           mmoResults.Lines.Add('Failed to map a drive to '+DestServerList.Items[i])
        else
        begin
          try
          destdir:=copy(edtDest2.text,pos(':',edtDest2.text)+1,200);
          if not directoryexists(driveletter+':\'+destdir) then
          begin
              inc(BadCount);
              statusBar1.Panels[1].Text:=inttostr(BadCount)+' Commands Failed';
              mmoResults.Lines.Add('Destination directory does not exist on '+DestServerList.Items[i]);
              continue;
          end;

          strpcopy(filename, extractfilename(edtSource.Text));

          streamfilecopy(edtSource.text,driveletter+':\'+destdir+'\'+filename);
          if not fileexists(driveletter+':\'+destdir+'\'+filename) then
          begin
              inc(BadCount);
              statusBar1.Panels[1].Text:=inttostr(BadCount)+' Commands Failed';
              mmoResults.Lines.Add('NLM File was not copied to '+DestServerList.Items[i]+'. check file attributes');
              continue;
          end
          else
          begin
              inc(GoodCount);
              statusBar1.Panels[0].Text:=inttostr(GoodCount)+' Commands Passed';
              mmoResults.Lines.Add('NLM File was copied to '+DestServerList.Items[i]);
          end;

          if cbLoad.Checked=True then
          begin
            AssignFile(F2, driveletter+':\SYSTEM\AUTOEXEC.NCF');
            Append(F2);
            WriteLn(F2, 'LOAD '+filename);
            CloseFile(F2);
            inc(GoodCount);
            statusBar1.Panels[0].Text:=inttostr(GoodCount)+' Commands Passed';
            mmoResults.Lines.Add('Added Load '+strpas(filename)+' to '+DestServerList.Items[i]);
          end;

          if (cbNow.Checked=True) and (pos('3.',Form1.lblVer.Caption)=0) then
          begin
            NWSMUnLoadNLM(tmpconnHandle, @filename);
            ccode := NWSMLoadNLM(tmpconnHandle, @filename);
            if (ccode<>0) then
            begin
              inc(BadCount);
              statusBar1.Panels[1].Text:=inttostr(BadCount)+' Commands Failed';
              mmoResults.Lines.Add('Failed to UnloadLoad '+strpas(filename)+' on '+DestServerList.Items[i]+': '+inttohex(ccode,2));
            end
            else
            begin
                inc(GoodCount);
                statusBar1.Panels[0].Text:=inttostr(GoodCount)+' Commands Passed';
                mmoResults.Lines.Add('Unloaded/Loaded '+strpas(filename)+' on '+DestServerList.Items[i]);
            end;
          end;
          finally
            Form1.DeleteDrive;
          end;
        end;
  end;
end;

Procedure TDistForm.DistSoftware;
var
  i,j : Integer;
  DestDir : String;
  CommonVolName : String;
  CommonPath : String;
  GoodCount : Integer;
  BadCount : integer;
  TheDir : String;
begin
 GoodCount:=0;
 BadCount:=0;
 SourceFileList.Items.Clear;
 DestServerList.Items.Clear;
  if pos(':',edtDest.text)=0 then
  begin
    ShowMessage('No Volume was specified in the Common Destination Directory');
    exit;
  end;

//First Get a list of all the source files
  for i:=0 to FileListBox.Items.Count-1 do
  begin
    if FileListBox.selected[i]=True then
    begin
      SourceFileList.Items.Add(FileListBox.Items[i]);
    end;
  end;

//Now Get a list of the selected Servers
  for i:=0 to lstServers.Items.Count-1 do
  begin
    if lstServers.Selected[i]=True then
    begin
      destServerList.Items.Add(lstServers.Items[i]);
    end;
  end;

  //Now Get the Common Destination Subdirectory
  DestDir:=edtDest.Text;

  //Now Check that all the information is complete
  if (SourcefileList.Items.Count=0) then
  begin
    ShowMessage('No Source Files were selected');
    exit;
  end;

  if (DestServerList.Items.Count=0) then
  begin
    ShowMessage('No Destination Servers were selected');
    exit;
  end;

  if DestDir='' then
  begin
    ShowMessage('No Common Destination Directory was Found');
    exit;
  end;

  CommonVolName:=Copy(DestDir,0,pos(':',DestDir));
  CommonPath:=Copy(DestDir,pos(':',DestDir)+1,200);

  //Start Copying
  for i:=0 to DestServerList.Items.Count-1 do
  begin
    if Form1.mapadrive(DestServerList.Items[i],CommonVolName) <> 0 then
        mmoResults.Lines.Add('Failed to map a drive to '+DestServerList.Items[i])
    else
    begin
      for j:=0 to SourceFileList.Items.Count-1 do
      begin
        if DirectoryExists(driveletter+':\'+CommonPath) then
        begin
          if lstDir.Directory[Length(lstDir.Directory)]='\' then
            TheDir:=Copy(lstDir.Directory,0,Length(lstDir.Directory)-1)
          else
            TheDir:=lstDir.Directory;
          StreamFileCopy(TheDir+'\'+SourceFileList.Items[j],driveletter+':\'+CommonPath+'\'+SourceFileList.Items[j]);
          if fileexists(driveletter+':\'+CommonPath+'\'+SourcefileList.Items[j]) then
          begin
            inc(GoodCount);
            statusBar1.Panels[0].Text:='Added '+inttostr(GoodCount)+' Files';
            mmoResults.Lines.Add('Added '+SourceFileList.Items[j]+' to '+DestServerList.Items[i])
          end
          else
          begin
            inc(BadCount);
            statusBar1.Panels[1].Text:=inttostr(BadCount)+' Files Failed';
            mmoResults.Lines.Add('Failed to Add '+SourceFileList.Items[j]+' to '+DestServerList.Items[i]);
          end;
        end
        else
        begin
            inc(BadCount);
            statusBar1.Panels[1].Text:=inttostr(BadCount)+' Files Failed';
            mmoResults.Lines.Add('Failed to Add '+SourceFileList.Items[j]+' to '+DestServerList.Items[i]+' Destination Directory does not exist.');
        end;
      end;
      Form1.DeleteDrive;
    end;
  end;
end;

procedure TDistForm.StreamFileCopy( const sourcefilename, targetfilename: String);
Var
  S,T: TFileStream;
Begin
T:=nil;
  S := TFileStream.Create( sourcefilename, fmOpenRead );
  try try
    T := TFileStream.Create( targetfilename, fmOpenWrite or fmCreate );
    Screen.Cursor := crHourGlass;
  except
    begin
      Screen.Cursor := crDefault;
      ShowMessage('Could not create file');
    end;
  end;
    try try
      T.CopyFrom(S, S.Size ) ;
    except
      begin
        Screen.Cursor := crDefault;
//        ShowMessage('Counld not copy file');
      end;
    end;
    finally
      T.Free;
    end;
  finally
    Screen.Cursor:=CrDefault;
    S.Free;
  end;
  Screen.Cursor := crDefault;
end;

procedure TDistForm.BitBtn2Click(Sender: TObject);
begin
  mmoResults.Lines.Clear;
end;

procedure TDistForm.FileListBoxKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=46 then
    ShowMessage('YES');
end;

procedure TDistForm.rbnSoftwareClick(Sender: TObject);
begin
  grpSoftware.Visible:=True;
  grpConsole.Visible:=False;
  grpNCF.Visible:=False;
  grpExecute.Visible:=False;
  grpUpdate.Visible:=False;
end;

procedure TDistForm.rbnConsoleClick(Sender: TObject);
begin
  grpConsole.Visible:=True;
  grpSoftware.Visible:=False;
  grpNCF.Visible:=False;
  grpExecute.Visible:=False;
  grpUpdate.Visible:=False;
end;

procedure TDistForm.rbnNCFClick(Sender: TObject);
begin
  grpNCF.Visible:=True;
  grpSoftware.Visible:=False;
  grpConsole.Visible:=False;
  grpExecute.Visible:=False;
  grpUpdate.Visible:=False;
end;

procedure TDistForm.rbnExecuteClick(Sender: TObject);
begin
  grpExecute.Visible:=True;
  grpSoftware.Visible:=False;
  grpConsole.Visible:=False;
  grpNCF.Visible:=False;
  grpUpdate.Visible:=False;
end;

procedure TDistForm.bbtSaveClick(Sender: TObject);
var
  OadmIniFile : Tinifile;
  i : Integer;
  count : Integer;
begin
  count:=0;
  if not directoryexists('C:\WINDOWS') then
    mkdir('C:\WINDOWS');
  OadmIniFile := TIniFile.Create('C:\WINDOWS\OADMIN.INI');
  OadmIniFile.EraseSection('ServerList');
  for i:=0 to lstServers.Items.Count-1 do
  begin
    if lstServers.Selected[i]=True then
    begin
      inc(count);
      OadmIniFile.WriteString('ServerList','Name'+inttostr(count),lstServers.Items[i]);
    end;
  end;
  OadmInifile.WriteString('ServerList','Total',inttostr(count));
  OadmInifile.Free;
  ShowMessage('Server List is Saved');
end;

procedure TDistForm.bbtGetListClick(Sender: TObject);
var
  OadmIniFile : Tinifile;
  i, j: Integer;
  count : Integer;
begin
  lstServers.Selected[lstServers.ItemIndex]:=False;
  if not fileexists('C:\WINDOWS\OADMIN.INI') then
  begin
    ShowMessage('No Save List to retrieve');
    Exit;
  end;
  OadmIniFile := TIniFile.Create('C:\WINDOWS\OADMIN.INI');
  count:=strtoint(OadmIniFile.ReadString('ServerList','Total','0'));
  for i:=1 to count do
  begin
    ServerName:=OadmIniFile.ReadString('ServerList','Name'+inttostr(i),'nada');
    if serverName='nada' then
      continue;
    for j:=0 to lstServers.Items.Count-1 do
    begin
      if servername=lstServers.Items[j] then
      begin
        lstServers.Selected[j]:=True;
        continue;
      end;
    end;
  end;
end;

procedure TDistForm.RadioButton1Click(Sender: TObject);
begin
  grpUpdate.Visible:=True;
  grpSoftware.Visible:=False;
  grpConsole.Visible:=False;
  grpNCF.Visible:=False;
  grpExecute.Visible:=False;
end;

procedure TDistForm.edtExecuteKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then
    bbtDistClick(edtExecute);
end;

procedure TDistForm.edtConsoleKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then
    bbtDistClick(edtExecute);
end;

end.
