{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.                    

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit mainunit;

interface

uses
  Windows, Messages, SysUtils, Graphics, Forms, Dialogs, Buttons, nwinc32, FileCtrl,
  Classes, Controls, ExtCtrls, StdCtrls, Menus, Grids, overflow, ComCtrls, ShellAPI;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    bbtExit: TBitBtn;
    ImageList1: TImageList;
    Timer1: TTimer;
    PageControl1: TPageControl;
    ServersTab: TTabSheet;
    grpBasicInfo: TGroupBox;
    lblTVer: TLabel;
    lblVer: TLabel;
    lblTMax: TLabel;
    lblTUse: TLabel;
    lblTSFT: TLabel;
    lblTTTS: TLabel;
    lblMax: TLabel;
    lblUse: TLabel;
    lblVol: TLabel;
    lblSFT: TLabel;
    lblTTS: TLabel;
    lblTVol: TLabel;
    lblTUtil: TLabel;
    lblUtilize: TLabel;
    lblTServer: TLabel;
    bbtDown: TBitBtn;
    lstServers: TListBox;
    bbtAnalyze: TBitBtn;
    NLMTab: TTabSheet;
    VolTab: TTabSheet;
    ConnTab: TTabSheet;
    SetTab: TTabSheet;
    ncftab: TTabSheet;
    statstab: TTabSheet;
    lvwNLMs: TListView;
    lblTNLM: TLabel;
    Panel2: TPanel;
    lblTVolume: TLabel;
    lblTIRQ: TLabel;
    lvwIRQ: TListView;
    lblTpriorityirq: TLabel;
    grpUserInfo: TGroupBox;
    lblTLogin2: TLabel;
    lblTConnNum: TLabel;
    lblConnNum: TLabel;
    lblTime: TLabel;
    lblTTime: TLabel;
    lblTAddr: TLabel;
    lblAddr: TLabel;
    edtServer: TEdit;
    bbtSetModify: TBitBtn;
    bbtClearAll: TBitBtn;
    Image2: TImage;
    bbtUnload: TBitBtn;
    bbtLoad: TBitBtn;
    bbtDropConn: TBitBtn;
    lblTLogs: TLabel;
    lblTFileContents: TLabel;
    bbtSaveFile: TBitBtn;
    bbtCancelEdit: TBitBtn;
    grpStatsCat: TGroupBox;
    rbnCache: TRadioButton;
    rbnCPU: TRadioButton;
    bbtNLMhelp: TBitBtn;
    bbtConnRefresh: TBitBtn;
    bbtDisMount: TBitBtn;
    bbtMount: TBitBtn;
    lblTMounting: TLabel;
    ImageList2: TImageList;
    bbtAddNS: TBitBtn;
    bbtRemoveNS: TBitBtn;
    lblTFileLock: TLabel;
    lblFileLock: TLabel;
    lblTRecLock: TLabel;
    lblRecLock: TLabel;
    lblTBytesRead: TLabel;
    lblBytesRead: TLabel;
    lblTBytesWirte: TLabel;
    lblBytesWrite: TLabel;
    edtNLM: TEdit;
    lblTLogin: TLabel;
    lblLogin: TLabel;
    lblTConsole: TLabel;
    lblConsole: TLabel;
    bbtServerRefresh: TBitBtn;
    bbtNLMRefresh: TBitBtn;
    bbtVolRefresh: TBitBtn;
    bbtSetRefresh: TBitBtn;
    bbtNCFRefresh: TBitBtn;
    ImgPatch: TImage;
    lblTPatch: TLabel;
    imgDriver: TImage;
    lbtTDriver: TLabel;
    imgOther: TImage;
    lblTOther: TLabel;
    imgOld: TImage;
    lblTOld: TLabel;
    lstNLM: TListBox;
    imgNS: TImage;
    lblTNS: TLabel;
    FileTab: TTabSheet;
    grpFileInfo: TGroupBox;
    bbtOpenFilesRefresh: TBitBtn;
    bbtDeleteFile: TBitBtn;
    bbtNewFile: TBitBtn;
    rbnDirCache: TRadioButton;
    rbnFSInfo: TRadioButton;
    rbnGarbage: TRadioButton;
    rbnIPX: TRadioButton;
    rbnLAN1: TRadioButton;
    rbnMedia: TRadioButton;
    rbnLSL: TRadioButton;
    rbnPacket: TRadioButton;
    sgdStats: TStringGrid;
    sgdVolume: TStringGrid;
    lblTopenfiles: TLabel;
    lblTRequests: TLabel;
    lblRequests: TLabel;
    lblTConnType: TLabel;
    lblConnType: TLabel;
    lblTFileName: TLabel;
    lblFileName: TLabel;
    lblTOwner: TLabel;
    lblFileOwner: TLabel;
    lblTFileNS: TLabel;
    lblFileNS: TLabel;
    lblTDirectory: TLabel;
    lblVolume: TLabel;
    lblTSerial: TLabel;
    lblSerial: TLabel;
    lblTLicense: TLabel;
    lblLicense: TLabel;
    lblServer: TLabel;
    Bevel1: TBevel;
    pnlWarn: TPanel;
    lblTKBytes: TLabel;
    sgdSet: TStringGrid;
    TrackBar: TTrackBar;
    lblTTimer: TLabel;
    lstSet: TListBox;
    lstStats: TListBox;
    rbnLAN2: TRadioButton;
    rbnLAN3: TRadioButton;
    rbnLAN4: TRadioButton;
    sgdFiles: TStringGrid;
    lblTDir: TLabel;
    lblDir: TLabel;
    bbtMap: TBitBtn;
    bbtDist: TBitBtn;
    lblTNode: TLabel;
    bbtSend: TBitBtn;
    sgdOpenFiles: TStringGrid;
    bbtReLoadDS: TBitBtn;
    bbtTree: TBitBtn;
    sgdConn: TStringGrid;
    lblTEver: TLabel;
    lblEver: TLabel;
    lstConn: TListBox;
    rbnName: TRadioButton;
    rbnNode: TRadioButton;
    Label1: TLabel;
    lblNode: TLabel;
    bbtExecute: TBitBtn;
    mmoFileContents: TRichEdit;
    lstNCF: TListBox;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Tree1: TMenuItem;
    Tree2: TMenuItem;
    MapDrives1: TMenuItem;
    About1: TMenuItem;
    HelpTopics1: TMenuItem;
    Exit2: TMenuItem;
    bbtHelp: TBitBtn;
    lblID: TLabel;
    Label2: TLabel;
    sgdNCF: TStringGrid;
    Memo1: TMemo;
    bbtLogin: TBitBtn;
    bbtRconsole: TBitBtn;
    procedure bbtExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure lstServersClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure edtServerKeyPress(Sender: TObject; var Key: Char);
    procedure edtServerKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure bbtAnalyzeClick(Sender: TObject);
    procedure lvwConnClick(Sender: TObject);
    procedure bbtClearAllClick(Sender: TObject);
    procedure bbtDropConnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure lvwNLMsClick(Sender: TObject);
    procedure bbtUnloadClick(Sender: TObject);
    procedure edtNLMChange(Sender: TObject);
    procedure bbtLoadClick(Sender: TObject);
    procedure bbtNLMhelpClick(Sender: TObject);        
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure bbtConnRefreshClick(Sender: TObject);
    procedure bbtDisMountClick(Sender: TObject);
    procedure bbtMountClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bbtDownClick(Sender: TObject);
    procedure bbtAddNSClick(Sender: TObject);
    procedure bbtRemoveNSClick(Sender: TObject);
    procedure bbtServerRefreshClick(Sender: TObject);
    procedure bbtNLMRefreshClick(Sender: TObject);
    procedure bbtVolRefreshClick(Sender: TObject);
    procedure bbtSetRefreshClick(Sender: TObject);
    procedure bbtOpenFilesRefreshClick(Sender: TObject);
    procedure bbtNCFRefreshClick(Sender: TObject);
    procedure lstNLMClick(Sender: TObject);
    procedure bbtSaveFileClick(Sender: TObject);
    procedure bbtDeleteFileClick(Sender: TObject);
    procedure bbtNewFileClick(Sender: TObject);
    procedure bbtCancelEditClick(Sender: TObject);
    procedure mmoFileContentsKeyPress(Sender: TObject; var Key: Char);
    procedure rbnCacheClick(Sender: TObject);
    procedure sgdSetDblClick(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure sgdFilesClick(Sender: TObject);
    procedure bbtMapClick(Sender: TObject);
    procedure bbtDistClick(Sender: TObject);
    procedure lvwNLMsDblClick(Sender: TObject);
    procedure bbtReLoadDSClick(Sender: TObject);
    procedure bbtSendClick(Sender: TObject);
    procedure bbtTreeClick(Sender: TObject);
    procedure rbnNameClick(Sender: TObject);
    procedure rbnNodeClick(Sender: TObject);
    procedure DirectoryListBox1Enter(Sender: TObject);
    procedure DirectoryListBox1Exit(Sender: TObject);
    procedure bbtExecuteClick(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure bbtHelpClick(Sender: TObject);
    procedure HelpTopics1Click(Sender: TObject);
    procedure sgdNCFClick(Sender: TObject);
    procedure bbtLoginClick(Sender: TObject);
    procedure bbtRconsoleClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure LogintoTree;
    procedure GetServerList;
    procedure GetBasicInfo;
    procedure clearall;
    Procedure GetNLMlist;
    Procedure GetSetList;
    Procedure GetSetItem;
    Procedure GetConnList;
    Procedure GetVolList;
    Procedure GetIRQList;
    Procedure GetStats;
    Procedure GetOpenFiles;
    Procedure GetNCFFiles;
    Function  MapADrive(ServerName : String; VolName : String): Integer;
    Procedure LoadNLM(NLMName : String);
    Procedure DeleteDrive;
    Function  TickToStr(Ticks : LongInt): String;
    Procedure ClearStats;
    Procedure GetAttributes;
    Function GetValues: String;
    Procedure GetNLMInfo;
    Procedure LogMeIn;
    procedure populatestats;
    Function getpathfromDirEntry(Volume : String; DirEntry : Integer): String;
    procedure AddDSObject;
    { Public declarations }
  end;

var
  Form1: TForm1;
  ConnHandle: NWCONN_HANDLE;
  TmpConnHandle : NWCONN_HANDLE;
  ccode:NWCCODE;
  dcode:NWDSCCODE;
  servername : string;
  LastPos : Integer;
  dContext:NWDSContextHandle;
  attrName, GObjectName:array [0..100] of char;
  driveletter : string;
  drivenum : Integer;
  SaveFileName : String;
  GlobalSyntax : Integer;
  globalvol : string;
const
     userbmp : Integer = 0;
     oubmp : Integer = 1;
     groupbmp : Integer = 2;
     serverbmp : Integer = 3;
     volumebmp : Integer = 4;
     printerbmp : Integer = 5;
     pserverbmp : Integer = 6;
     pqueuebmp : Integer = 7;
     bobjbmp : Integer = 8;
     orolebmp : Integer = 9;
     servicebmp : Integer = 10;
     orgbmp : Integer = 11;
     rootbmp : Integer = 12;
     aliasbmp : Integer = 13;
     unknownbmp : Integer = 14;

implementation

uses Set1, Set2, attrib, value, Login, progress, NS, Add,
  map2, Dist, Tree, about, splash, Pass;

{$R *.DFM}

procedure TForm1.bbtExitClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.GetIRQList;
var
  NewItem : TListItem;
  fseLANConfigInfo : NWFSE_LAN_CONFIG_INFO;
  theirq : Integer;
  i : Integer;
  SelectItem : TListItem;
begin
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='0';
  NewItem.SubItems.Add('System Timer');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='1';
  NewItem.SubItems.Add('Keyboard');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='2';
  NewItem.SubItems.Add('Video (Cascade to 9)');
  NewItem.SubItems.Add('3C0-3CF');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='3';
  NewItem.SubItems.Add('Serial Comm 2');
  NewItem.SubItems.Add('300-31F');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='4';
  NewItem.SubItems.Add('Serial Comm 1');
  NewItem.SubItems.Add('3F8-3FF');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='5';
  NewItem.SubItems.Add('Parallel Port 2');
  NewItem.SubItems.Add('278-27F');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='6';
  NewItem.SubItems.Add('Diskette Controller');
  NewItem.SubItems.Add('3F0-3F7');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='7';
  NewItem.SubItems.Add('Parallel Port 1');
  NewItem.SubItems.Add('378-37F');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='8';
  NewItem.SubItems.Add('CMOS Clock');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='9';
  NewItem.SubItems.Add('Cascaded to IRQ 2');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='12';
  NewItem.SubItems.Add('Mouse (PS/2)');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='13';
  NewItem.SubItems.Add('Math Coprocessor');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='14';
  NewItem.SubItems.Add('HD Controller');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');
  NewItem:=lvwIRQ.Items.Add;
  NewItem.Caption:='15';
  NewItem.SubItems.Add('Reserverd (NetWare)');
  NewItem.SubItems.Add('');
  NewItem.SubItems.Add('Standard');

  if (pos('4.',lblVer.caption)>0) and (lblConsole.Caption='YES') then
  begin
    ccode:=NWGetLANConfigInfo(connHandle,1,fseLANConfigInfo);
    if (ccode<>0) then
    begin
      ShowMessage('NWGetLANConfigInfo Failed: '+inttohex(ccode,2));
      exit;
    end;
    theirq:=fseLanConfigInfo.LANConfigInfo.DriverInterrupt[0];
  end
  else
    exit;

  for i:=0 to lvwIRQ.Items.Count do
  begin
    if (theirq=strtoint(lvwIRQ.Items[i].caption)) then
    begin
      SelectItem:=lvwIrq.Items[i];
      SelectItem.ImageIndex:=8;
      NewItem:=lvwIRQ.Items.Insert(i+1);
      NewItem.ImageIndex:=8;
      break;
    end;
    if (theirq < strtoint(lvwIRQ.Items[i].Caption)) then
    begin
      NewItem:=lvwIRQ.Items.Insert(i);
      break;
    end;
  end;
  NewItem.Caption:=  inttostr(fseLanConfigInfo.LANConfigInfo.DriverInterrupt[0]);
  NewItem.SubItems.Add('Network Card');
  NewItem.SubItems.Add(inttohex(fseLanConfigInfo.LANConfigInfo.DriverIOPortsAndLengths[0],2)+'-'+
   inttohex(fseLanConfigInfo.LANConfigInfo.DriverIOPortsAndLengths[0]+fseLanConfigInfo.LANConfigInfo.DriverIOPortsAndLengths[1]-1,2));
  NewItem.SubItems.Add('Custom');
end;

procedure TForm1.GetVolList;
var
  i, j: integer;
  volname : array [0..100] of char;
  blocksize : Real;
  totalsize : Real;
  availsize : Real;
  purgesize : Real;
  notyetpurgesize : Real;
  bytesused : Real;
  dirHandle : NWDIR_HANDLE;
  spaceInfo : DIR_SPACE_INFO;
  NSLoadedList : array [0..6] of nuint8;
  actualListLen : nuint8;
  NameSpaceStr : String;

begin
    totalsize:=0;
    availsize:=0;
    bytesused:=0;
    StatusBar1.Panels[2].text:=lblVol.Caption+' Volumes';
    sgdVolume.Cells[0,0]:='Volume Name';
    sgdVolume.Cells[1,0]:='Name Space';
    sgdVolume.Cells[2,0]:='Availible';
    sgdVolume.Cells[3,0]:='Used';
    sgdVolume.Cells[4,0]:='Free Blocks';
    sgdVolume.Cells[5,0]:='Total';
    sgdVolume.Cells[6,0]:='Status';
    sgdVolume.RowCount:=strtoint(lblVol.Caption)+1;
    for i:=0 to strtoint(lblVol.Caption) do
    begin
     ccode := NWGetVolumeName(connHandle, i, @volname);
     if (ccode<>0) then
     begin
       exit;
     end;

     if strpas(volname)='' then
     begin
       exit;
     end;

     if lblConsole.Caption='YES' then
     begin
       ccode := NWAllocTemporaryDirectoryHandle (ConnHandle, 0, @volname, dirHandle, nil);
       if (ccode<>0) then
       begin
          if (inttohex(ccode,2)='8998') then
          begin
            sgdVolume.Cells[0,i+1]:=strpas(volname);
            sgdVolume.Cells[1,i+1]:='';
            sgdVolume.Cells[2,i+1]:='';
            sgdVolume.Cells[3,i+1]:='';
            sgdVolume.Cells[4,i+1]:='';
            sgdVolume.Cells[5,i+1]:='';
            sgdVolume.Cells[6,i+1]:='UnMounted';
            bbtMount.Enabled:=True;
            exit;
          end;
          ShowMessage('NWAllocTemporaryDirectoryHandle Failed: '+inttohex(ccode,2));
          exit;
       end;

       ccode := NWGetDirSpaceInfo (ConnHandle, dirHandle, 0, spaceInfo);
       if (ccode<>0) then
       begin
               ShowMessage('NWGetDirSpaceInfo Failed: '+inttohex(ccode,2));
               exit;
       end;

       blocksize:=spaceInfo.sectorsPerBlock/2;
       totalsize:=spaceInfo.totalBlocks * blocksize;
       availsize:=spaceInfo.availableBlocks * blocksize;
       purgesize:=spaceInfo.purgeableBlocks * blocksize;
       notyetpurgesize:=spaceInfo.notYetPurgeableBlocks * blocksize;
       bytesused:=totalsize-(availsize+purgesize-notyetpurgesize);
     end;

     ccode := NWGetNSLoadedList(connHandle, i, 6, @NSLoadedList, @actualListLen);
     if (ccode<>0) then
     begin
             ShowMessage('NWGetNSLoadedList Failed: '+inttohex(ccode,2));
     end;
     dec(actualListLen);
     for j:=0 to actualListLen do
     begin
      if (NSLoadedList[j]=0) then
       NameSpaceStr:='DOS'
      else if (NSLoadedList[j]=1) then
        NameSpaceStr:=NameSpaceStr+',MAC'
      else if (NSLoadedList[j]=2) then
        NameSpaceStr:=NameSpaceStr+',NFS'
      else if (NSLoadedList[j]=3) then
        NameSpaceStr:=NameSpaceStr+',FTAM'
      else if (NSLoadedList[j]=4) then
        NameSpaceStr:=NameSpaceStr+',LONG'
      else if (NSLoadedList[j]=5) then
        NameSpaceStr:=NameSpaceStr+',NAFS';
      end;
     sgdVolume.Cells[0,i+1]:=strpas(volname);
     sgdVolume.Cells[1,i+1]:=NameSpaceStr;
     sgdVolume.Cells[2,i+1]:=FormatFloat('###,###,###,##0',(Trunc(availsize)));
     sgdVolume.Cells[3,i+1]:=FormatFloat('###,###,###,##0',(Trunc(bytesused)));
     sgdVolume.Cells[4,i+1]:=FormatFloat('###,###,###,##0',(spaceInfo.availableBlocks));
     sgdVolume.Cells[5,i+1]:=FormatFloat('###,###,###,##0',(Trunc(totalsize)));
     sgdVolume.Cells[6,i+1]:='Mounted';
     if lblConsole.Caption='YES' then
     begin
       bbtDisMount.Enabled:=True;
       bbtAddNS.Enabled:=True;
     end;
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  connref: nuint32;
begin
//Add expiration Stuff here
{  if Date > strtodate('1/1/97') then
  begin
     ShowMessage('This evaluation copy of OnSite Admin has expired!'+#13+'Contact Steve Wootton or Shane Johns for a new copy');
     Application.Terminate;
  end;}

     drivenum:=0;
     ccode:=NWCallsInit(nil,nil);
     if (ccode<0)then
     begin
           ShowMessage('NWCallsInit Failed'+#13+'Error Code: '+inttostr(ccode));
        exit;
     end;
     
     ccode := NWCCGetPrimConnRef(@connref);
     if (ccode<>0) then
     begin
       if inttohex(ccode,2)='8847' then
       begin
         ShowMessage('You do not have a primary connection established');
         Application.Terminate;
       end
       else
         ShowMessage('NWGetPrimConnRef returned '+inttohex(ccode,2));
         Application.Terminate;
	 exit;
       end;

     ccode:=nwccopenconnbyref(connref, NWCC_OPEN_UNLICENSED, 0, @connHandle);
     if (ccode<>0) then
     begin
      	 ShowMessage('NWccopenconnbyref returned '+inttohex(ccode,2));
       	 exit;
     end;

     dContext:=NWDSCreateContext;
     if dContext = ERR_CONTEXT_CREATION then
     begin
        ShowMessage('NWDSCreateContext Failed');
        NWDSFreeContext(dContext);
        Screen.Cursor := crDefault;
        exit;
     end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
    fseFileServerInfo : NWFSE_FILE_SERVER_INFO;
    fseUserInfo : NWFSE_USER_INFO;
    connNum : Integer;
    username : Array [0..100] of char;
    iterHandle : nint16;
    openCtrl : OPEN_FILE_CONN_CTRL;
    openFile : OPEN_FILE_CONN;
    ConnTypeStr : String;
    Size : real;
    Y, Z : Integer;
    row : Integer;
    label fileopen;
begin
    row:=0;
    try
      ccode := NWGetFileServerInfo(connHandle,fseFileServerInfo);
    except
      exit;
    end;
    if (ccode<>0) then
    begin
         lblUtilize.Caption:='';
         goto Fileopen;
    end;
    lblUtilize.Caption:=inttostr(fseFileServerInfo.serverUtilization)+'%';
    if (sgdConn.RowCount > 2) and (lblConsole.Caption='YES') and (sgdConn.Row>0) then
    begin
      strpcopy(username, sgdConn.Cells[0,sgdConn.Row]);
      connNum:=strtoint(sgdConn.Cells[1,sgdConn.Row]);
      ccode := NWGetUserInfo(connHandle,connNum,@username,fseUserInfo);
      if (ccode<>0) or (strpas(username)='NOT_LOGGED_IN') then
      begin
         lblFileLock.Caption:='';
         lblRecLock.Caption:='';
         lblBytesRead.Caption:='';
         lblBytesWrite.Caption:='';
         lblRequests.Caption:='';
         lblConnType.Caption:='';
         lblLicense.Caption:='NO';
         getstats;
         goto Fileopen;
      end;
      lblFileLock.Caption:=inttostr(fseUserInfo.userInfo.fileLockCount);
      lblRecLock.Caption:=inttostr(fseUserInfo.userInfo.recordLockCount);
      size:=fseUserInfo.userInfo.totalBytesRead[0]+(fseUserInfo.userInfo.totalBytesRead[1]*256)+(fseUserInfo.userInfo.totalBytesRead[2]*256*256)+(fseUserInfo.userInfo.totalBytesRead[3]*256*256*256)+(fseUserInfo.userInfo.totalBytesRead[4]*256*256*256*256)+(fseUserInfo.userInfo.totalBytesRead[5]*256*256*256*256*256);
      lblBytesRead.Caption:=formatfloat('###,###,###,###,##0',size);
      size:=fseUserInfo.userInfo.totalBytesWritten[0]+(fseUserInfo.userInfo.totalBytesWritten[1]*256)+(fseUserInfo.userInfo.totalBytesWritten[2]*256*256)+(fseUserInfo.userInfo.totalBytesWritten[3]*256*256*256)+(fseUserInfo.userInfo.totalBytesWritten[4]*256*256*256*256)+(fseUserInfo.userInfo.totalBytesWritten[5]*256*256*256*256*256);
      lblBytesWrite.Caption:=formatfloat('###,###,###,###,##0',size);
      lblRequests.Caption:=formatfloat('###,###,###,###,##0',fseUserInfo.userInfo.totalRequests);
      lblLicense.Caption:='NO';
      case fseUserInfo.userInfo.connServiceType of
       2: begin ConnTypeStr:='NCP'; lblLicense.Caption:='YES';end;
       3: ConnTypeStr:='NLM';
       4: ConnTypeStr:='AFP';
       5: ConnTypeStr:='FTAM';
       6: ConnTypeStr:='ANCP';
      else
       ConnTypeStr:='';
      end;
      lblConnType.Caption:=ConnTypeStr;
    end
    else
    begin
         lblFileLock.Caption:='Unknown';
         lblRecLock.Caption:='Unknown';
         lblBytesRead.Caption:='Unknown';
         lblBytesWrite.Caption:='Unknown';
         lblRequests.Caption:='Unknown';
         lblConnType.Caption:='Unknown';
         lblLicense.Caption:='Unknown';
    end;
    Fileopen:
    if (lblConnNum.caption<>'') then
    begin
       for Y := 0 to sgdOpenFiles.ColCount - 1 do
         for Z:= 1 to sgdOpenFiles.RowCount - 1 do
           sgdOpenFiles.Cells[Y,Z] := '';
       iterHandle:=0;
       while (iterHandle<>-1) do
       begin
         try
           ccode := NWScanOpenFilesbyConn2(connHandle,strtoint(lblConnNum.caption),@iterHandle,openCtrl,openFile);
         except
           Exit;
         end;
         if (ccode<>0) then
         begin
            if inttohex(ccode,2)<>'88FF' then
            begin
               ShowMessage('NWScanOpenFilesbyConn2 Failed: '+inttohex(ccode,2));
               break;
            end
            else
              break;
         end;
         if lblConsole.Caption='YES' then
           bbtDropConn.Enabled:=True;
         inc(row);
         sgdOpenFiles.Cells[0,row]:=strpas(openFile.Filename);
         if (inttohex(openFile.nameSpace,2)='00') then
            sgdOpenFiles.Cells[1,row]:='DOS'
         else if (inttohex(openFile.nameSpace,2)='01') then
            sgdOpenFiles.Cells[1,row]:='MAC'
         else if (inttohex(openFile.nameSpace,2)='02') then
            sgdOpenFiles.Cells[1,row]:='NFS'
         else if (inttohex(openFile.nameSpace,2)='03') then
            sgdOpenFiles.Cells[1,row]:='FTAM'
         else if (inttohex(openFile.nameSpace,2)='04') then
            sgdOpenFiles.Cells[1,row]:='LONG'
        end;
     end;
     if row>2 then
       sgdOpenFiles.Rowcount:=row+1;
     if (lblConsole.Caption='YES') and (statstab.tabvisible=True) then
       GetStats;
end;

procedure TForm1.lstServersClick(Sender: TObject);
begin
  ClearAll;
  servername:=lstServers.Items[lstServers.ItemIndex];
  edtServer.Text:=servername;
  GetBasicInfo;
  bbtAnalyze.enabled:=True;
end;


procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.GetBasicInfo;
var
  serConnString : array [0..100] of char;
  VolName : array [0..100] of char;
  res : nuint;
  majorVer : nuint8;
  minVer : nuint8;
  rev : nuint8;
  maxConns : nuint16;
  connsInUse : nuint16;
  SFTLevel : nuint8;
  TTSLevel : nuint8;
  i : integer;
  connNumber : NWCONN_NUM;
  ObjName : array [0..100] of char;
  serialNum : nuint32;
  appNum : nuint16;
  versBuffer : VERSION_INFO;

begin
    clearall;
    pnlWarn.Visible:=True;
    lblServer.Caption:=EdtServer.Text;
    servername:=edtServer.Text;
    bbtDown.Enabled:=False;
    bbtExecute.Enabled:=False;
    lstServers.Enabled:=False;
    Screen.Cursor := crHourGlass;
    NWCCCloseConn(connHandle);
    res:=0;
    strpcopy(serconnstring,servername);
    bbtLogin.Enabled:=True;

    try
      ccode:=NWCCOpenConnByName(0,@serconnstring,NWCC_NAME_FORMAT_BIND,NWCC_OPEN_UNLICENSED,res,@connhandle);
    except
      Exit;
    end;
    if (ccode<>0) then
    begin
        // ShowMessage('WARNING: NWCCOpenConnByName returned:  '+inttohex(ccode,2));
         screen.cursor:=crDefault;
         bbtAnalyze.Enabled:=False;
         exit;
    end;

    ccode := NWGetFileServerInformation(connHandle,@serconnstring,@majorVer,@minVer,@rev,
         @maxConns,nil,@connsInUse,nil,@SFTLevel,@TTSLevel);
    if (ccode<>0) then
    begin
       {   ShowMessage('NWGetFileServerInformation returned:  '+inttohex(ccode,2));
           screen.cursor:=crDefault;
           exit;}
    end;

    ccode := NWGetFileServerVersionInfo(connHandle,versBuffer);
    if (ccode<>0) then
    begin
      {   ShowMessage('NWGetFileServerVersionInfo returned:  '+inttohex(ccode,2));
         screen.cursor:=crDefault;
         exit;}
    end;

    lblEver.Caption:=inttostr(versBuffer.maxConnectionsEverUsed);

    i:=1;
    while (i<255) do
    begin
     strpcopy(volname,'');
     ccode := NWGetVolumeName(connHandle, i, @volname);
     if Length(volname)<1 then
     begin
       LblVol.Caption:=inttostr(i);
       break;
     end;
     inc(i);
     if (ccode<>0) then
     begin
       //  ShowMessage('NWGetVolumeName returned:  '+inttohex(ccode,2));
     end;
    end;

    lblVer.Caption:=inttostr(majorVer)+'.'+inttostr(minVer);
    lblMax.Caption:=inttostr(maxconns);
    lblUse.Caption:=inttostr(connsInUse);
    lblSFT.Caption:=inttostr(SFTLevel);
    lblTTS.Caption:=inttostr(TTSLevel);
    edtServer.Text:=servername;
    Timer1.enabled:=true;

    ccode:=NWGetConnectionNumber(connHandle, connNumber);
    if (ccode<>0) then
    begin
        ShowMessage('NWGetConnectionNumber returned:  '+inttohex(ccode,2));
    end;

    ccode:=NWGetConnectionInformation(connHandle,connNumber,@ObjName,nil,nil,nil);
    if (ccode=0) then
      lblLogin.Caption:=strpas(Objname)
    else
      lblLogin.Caption:='';

    ccode := NWCheckConsolePrivileges(connHandle);
    if (ccode<>0) then
    begin
           lblConsole.Caption:='NO';
           bbtDown.Enabled:=False;
           bbtExecute.Enabled:=False;
           bbtReLoadDS.Enabled:=False;
    end
    else
    begin
           lblConsole.Caption:='YES';
           bbtRconsole.Enabled:=True;
           bbtDown.Enabled:=True;
           bbtExecute.Enabled:=True;
           bbtReLoadDS.Enabled:=True;
           serialNum:=0;
           ccode := NWGetNetworkSerialNumber(connHandle,@serialNum,@appNum);
           if (ccode<>0) then
             lblSerial.Caption:=''
           else
           begin
             serialNum:=nwlongswap(serialnum);
             lblSerial.Caption:=inttohex(serialNum,8)+':'+inttohex(appNum,4);
           end;
    end;
    Screen.Cursor := crDefault;
    lstServers.Enabled:=True;
end;

procedure TForm1.edtServerKeyPress(Sender: TObject; var Key: Char);
begin
  If Key=#13 then
  begin
    Servername:=edtServer.text;
    GetBasicInfo;
  end
  else
  begin
    Clearall;
  end;
  bbtAnalyze.Enabled:=True;
end;

procedure TForm1.edtServerKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
const
     wBackspace = $8;
var
  SS : String;
  CS : String;
  Index : Integer;
begin
  if lstServers.ItemIndex=-1 then
    lstServers.ItemIndex:=1;
  if length(edtServer.Text)<1 then
  begin
    lstServers.ItemIndex:=-1;
    exit;
  end
  else if edtServer.Selstart=0 then
  begin
    edtServer.text:='';
    lstServers.ItemIndex:=-1;
    exit;
  end;
  lstServers.Visible:=False;
  Index:=lstServers.ItemIndex;  
  SS:=Copy(edtServer.Text,1,edtServer.SelStart);
  while (lstServers.ItemIndex<>lstServers.Items.Count-1) do
  begin
    CS:=lstServers.Items[lstServers.ItemIndex];
    //if ansicomparetext(SS,CS)<0 then
    if (pos(SS,CS)=1) then
    begin
      edtServer.Text:=CS;
      edtServer.selstart:=Length(SS);
      lstServers.Visible:=Enabled;
      Exit;
    end
    else
    begin
      inc(Index);
      lstServers.ItemIndex:=Index;
    end;
  end;
  lstServers.ItemIndex:=1;
  lstServers.ItemIndex:=-1;
  edtServer.Text:=SS;
  lstServers.Visible:=True;
end;

procedure TForm1.GetNLMInfo;
var
  SelectItem : TListItem;
  themonth : string;
  selname : string;
  bigstring : string;
  bigstring2 : string;
  startNum : nuint32;
  nlmList : NWFSE_NLM_LOADED_LIST;
  filename : Array [0..260] of char;
  copyright : Array [0..360] of char;
  i : Integer;
  NLMInfostruct : NWFSE_NLM_INFO;
  NLMName : Array [0..360] of char;
  FileStr : String;
  cr : String;  
begin
  SelectItem:=lvwNLMs.Selected;
  if SelectItem=nil then
    exit;
    selname:=SelectItem.Caption;
    startNum := 0;
    nlmList.NLMsInList:=128;
    while (nlmList.NLMsInList = FSE_NLM_NUMS_RETURNED_MAX) do
    begin
            ccode := NWGetNLMLoadedList(connhandle, startNum, nlmList);
            if (ccode<>0) then
            begin
                 if (ccode=35270) then
                   ShowMessage('You must have console rights to the server to see the nlm list')
                 else
                   ShowMessage('NWGetNLMLoadedList returned '+inttohex(ccode,2));
                 exit;
                 lvwNLMs.Visible:=True;
                 Screen.Cursor:=crDefault;
            end;

            for i:=0 to nlmList.NLMsInList do
            begin
                strpcopy(Copyright,'');
                {$I-}
                try
                   ccode := NWGetNLMInfo(connhandle,nlmList.NLMNums[i],@fileName,@NLMName,@copyright,nlmInfostruct);
                except
                   on EAccessViolation do
                   begin
                     ccode := NWGetNLMInfo(connhandle,nlmList.NLMNums[i],@fileName,@NLMName,nil,nlmInfostruct);
                   end;
                end;
                {$I+}
                if (ccode<>0) then
                begin
                      break;
                end;

                FileStr:=strpas(@filename);
                if FileStr=selname then
                begin
                   case NLMinfostruct.NLMInfo.NLMType of
                   0:  cr:='NLM_GENERIC';
                   1:  cr:='LAN_DRIVER';
                   2:  cr:='DSK_DRIVER';
                   3:  cr:='NAM_SPACE';
                   4:  cr:='NLM_UTILITY';
                   5:  cr:='MIRRORED_SERVER_LINK';
                   6:  cr:='NLM_OS';
                   7:  cr:='NLM_PAGED_HIGH_OS';
                   8:  cr:='HOST_ADAPTER_MODULE';
                   9:  cr:='CUSTOM_DEVICE_MODULE';
                   10: cr:='NLM_FILE_SYSTEM';
                   11: cr:='NLM_REAL_MODE';
                   else
                       cr:='Unknown NLM Type';
                   end;
                   case NLMInfoStruct.NLMInfo.month of
                   1:  themonth:='January';
                   2:  themonth:='February';
                   3:  themonth:='March';
                   4:  themonth:='April';
                   5:  themonth:='May';
                   6:  themonth:='June';
                   7:  themonth:='July';
                   8:  themonth:='August';
                   9:  themonth:='September';
                   10: themonth:='October';
                   11: themonth:='November';
                   12: themonth:='December';
                   end;

                   BigString:=filestr+#13;
                   BigString:=BigString+'Version: '+inttostr(NLMInfostruct.NLMInfo.MajorVersion)
                   +'.'+inttostr(NLMInfostruct.NLMInfo.MinorVersion)+' Revision: '+inttostr(NLMInfoStruct.NLMInfo.revision)+#13;
                   BigString:=BigString+strpas(@NLMName)+#13;
                   BigString:=BigString+themonth+' '+inttostr(NLMInfostruct.NLMInfo.day)+', '+inttostr(NLMInfostruct.NLMInfo.year)+#13;
                   BigString:=Bigstring+strpas(@copyright)+#13;
                   BigString2:='Bytes available for allocation: '+FormatFloat('###,###,###,##0',NLMInfostruct.NLMInfo.allocAvailableBytes)+#13;
                   BigString2:=BigString2+'Bytes freed that can be reclaimed: '+FormatFloat('###,###,###,##0',NLMInfostruct.NLMInfo.allocFreeCount)+#13;
                   BigString2:=Bigstring2+'Last Gargabe Collection: '+ticktostr(NLMInfostruct.NLMInfo.lastGarbageCollection)+#13;
                   BigString2:=Bigstring2+'Message Language Number: '+inttostr(NLMInfostruct.NLMInfo.messageLanguage)+#13;
                   BigString2:=BigString2+'Number of external symbols: '+FormatFloat('###,###,###,##0',NLMInfostruct.NLMInfo.numOfReferencedPublics)+#13;
                   Application.processmessages;
                end;
         end;
        startNum := startnum+nlmList.NLMsInList;
    end;
    messageDlg(BigString+BigString2,mtInformation,[mbOK],0);
end;

procedure TForm1.GetNLMlist;
var
   NewItem : TListItem;
   startNum : nuint32;
   nlmList : NWFSE_NLM_LOADED_LIST;
   i: nuint32;
   filename : Array [0..30] of char;
   NLMName : Array [0..360] of char;
   NLMInfostruct : NWFSE_NLM_INFO;
   FileStr : String;
begin
//****** First Get a list of all NLMs (Patch and Other)
        startNum := 0;
        nlmList.NLMsInList:=128;
        lvwNLMs.Visible:=False;
        Screen.Cursor:=crHourGlass;
        while (nlmList.NLMsInList = FSE_NLM_NUMS_RETURNED_MAX) do
        begin
                ccode := NWGetNLMLoadedList(connhandle, startNum, nlmList);
                if (ccode<>0) then
                begin
                     if (ccode=35270) then
                       ShowMessage('You must have console rights to the server to see the nlm list')
                     else
                       ShowMessage('NWGetNLMLoadedList returned '+inttohex(ccode,2));
                     exit;
                     lvwNLMs.Visible:=True;
                     Screen.Cursor:=crDefault;
                end;

                StatusBar1.Panels[1].Text:=(inttostr(nlmList.NLMsInList)+' NLMs');
                for i:=0 to nlmList.NLMsInList-1 do
                begin
                        ccode := NWGetNLMInfo (connhandle,nlmList.NLMNums[i],@fileName,@NLMName,nil,nlmInfostruct);
                        if (ccode<>0) then
                        begin
                              Screen.Cursor:=crDefault;
                              lvwNLMs.Visible:=True;
                              break;
                        end;

                        FileStr:=strpas(@filename);
                        NewItem:=lvwNLMs.Items.Add;
                        NewItem.caption:=strpas(@filename);
                        if (pos('FX.NLM',FileStr)>0) or (pos('FIX.NLM',FileStr)>0) or (pos('FX2.NLM',FileStr)>0) or (pos('FIX2.NLM',FileStr)>0) then
                        begin
                           NewItem.ImageIndex:=4;
                        end
                        else if (pos('.CDM',FileStr)>0) or (pos('.DSK',FileStr)>0) or (pos('.LAN',FileStr)>0) or (pos('.HAM',FileStr)>0) then
                        begin
                           NewItem.ImageIndex:=5;
                        end
                        else if (pos('.NAM',FileStr)>0) then
                        begin
                           NewItem.ImageIndex:=6;
                        end
                        else
                        begin
                           NewItem.Imageindex:=1;
                        end;
                        NewItem.SubItems.Add('Version: '+inttostr(NLMInfostruct.NLMInfo.MajorVersion)
                        +'.'+inttostr(NLMInfostruct.NLMInfo.MinorVersion));
                        NewItem.SubItems.Add(strpas(@NLMName));
                        Application.processmessages;
                 end;
                startNum := startnum+nlmList.NLMsInList;
        end;
        lvwNLMs.Visible:=True;
        Screen.Cursor:=crDefault;
end;

procedure TForm1.GetSetItem;
begin
 Screen.Cursor:=crHourGlass;
 GetSetList;
 Screen.Cursor:=crDefault;
end;

procedure TForm1.GetSetList;
var
   NewItem : TListItem;
   startNum : nuint32;
   i, j : nuint32;
   fseServerSetCmdsInfo : NWFSE_SERVER_SET_CMDS_INFO;
   Category : array [0..499] of char;
   ValueStr : String;
   cmdtype : integer;
   Ticks : LongInt;
   Value : array [0..499] of byte;
   days, hours, minutes, seconds : Integer;
   Valuechar : array [0..499] of char;
   desc : string;
   m, count : Integer;
   mult : Integer;
   wholeline : String;
   Item : String;
begin
//****** Get a list of all Set Commands
  startNum:=0;
  Ticks:=0;
  hours:=0;

  ccode:=NWGetServerSetCommandsInfo(connHandle,startNum,fseServerSetCmdsInfo);
  if (ccode<>0) then
  begin
    ShowMessage('NWGetServerSetCommandsInfo Failed: '+inttohex(ccode,2));
  end;

  sgdSet.Cells[0,0]:='Category';
  sgdSet.Cells[1,0]:='Value';
  SgdSet.Cells[2,0]:='Type';
  lstSet.Items.Clear;
  
  for startNum:=0 to fseServerSetCmdsInfo.numberOfSetCommands do
  begin
    sgdSet.RowCount:=fseServerSetCmdsInfo.numberOfSetCommands+1;
    application.processmessages;
    ccode:=NWGetServerSetCommandsInfo(connHandle,startNum,fseServerSetCmdsInfo);
    if (ccode<>0) then
    begin
      if (inttohex(ccode,2)<>'89FF') then
       ShowMessage('NWGetServerSetCommandsInfo Failed: '+inttohex(ccode,2));
      break;
    end;
    for i:=0 to 499 do
    begin
       Application.processmessages;
       category[i]:=char(fseServerSetCmdsInfo.setNameAndValueInfo[i]);
       if category[i]=#0 then
       begin
         break;
       end;
    end;
    valuestr:='';
    cmdtype:=fseServerSetCmdsInfo.setCmdType;

    for j:=0 to 499 do
    begin
       inc(i);
       case cmdtype of
        0:   begin
               value[j]:=fseServerSetCmdsInfo.setNameAndValueInfo[i];
               if value[j]=0 then
               begin
                 valuestr:=inttostr(ticks);
                 if valuestr='' then valuestr:='0';
                 break;
               end;
              if (j=0) then
                ticks:=value[j]
              else
                ticks:=ticks+(value[j]*255)+value[j];
             end;
        1,6:   begin //TYPE_BOOLEAN  //TYPE_TRIGGER
               value[j]:=fseServerSetCmdsInfo.setNameAndValueInfo[i];
               if value[j]=0 then valuestr:='OFF'
                else valuestr:='ON';
               break;
             end;
        2:   begin //TYPE_TICKS
              value[j]:=fseServerSetCmdsInfo.setNameAndValueInfo[i];
              if value[j]=0 then
              begin
                valuestr:=ticktostr(ticks);
                break;
              end;
              if (j=0) then
              begin
                ticks:=value[j];
              end
              else
              begin
                mult:=1;
                for m:=1 to j do
                begin
                  mult:=mult*256;
                end;
                ticks:=ticks+(value[j]*mult);
              end;
             end;
        3:   begin //TYPE_BLOCK_SHIFT (512*number)
              value[j]:=fseServerSetCmdsInfo.setNameAndValueInfo[i];
               if value[j]=0 then
                 break;
               valuestr:=valuestr+inttostr(value[j]*512);
             end;
        4:   begin //TYPE_TIME_OFFSET ([+|-]hh:mm:ss converted to seconds)
              value[j]:=fseServerSetCmdsInfo.setNameAndValueInfo[i];
              if value[j]=0 then
              begin
                 days:=0;
                 minutes:=0;
                 seconds:=0;
                 if (ticks >= 60*60*24) then
                 begin
                   days:=(ticks DIV (60*60*24));
                   ticks:=(ticks MOD (60*60*24));
                 end;
                 if (ticks >= 60*60) then
                 begin
                   hours:=(ticks DIV (60*60));
                   ticks:=(ticks MOD (60*60));
                 end;
                 if (ticks >= 60) then
                 begin
                   minutes:=(ticks DIV 60);
                   seconds:=(ticks MOD 60);
                 end;
                 ticks:=0;

                 valuestr:=floattostr(days)+' Days '+floattostr(hours)+' Hrs '+floattostr(minutes)+' Min '+floattostr(seconds)+' Sec '+floattostr(ticks)+' Ticks';
                 break;
              end;
              if (j=0) then
                ticks:=value[j]
              else
                ticks:=ticks+(value[j]*255)+value[j];
             end;

        5:   begin valuechar[j]:=char(fseServerSetCmdsInfo.setNameAndValueInfo[i]); //Type String
                if valuechar[j]=#0 then
                begin
                  valuestr:=strpas(valuechar);
                  break;
                end;
             end;
       end;
     end;
    case fseServerSetCmdsInfo.setCmdCategory of
     0:  desc:='COMMUNICATIONS';
     1:  desc:='MEMORY';
     2:  desc:='FILE_CACHE';
     3:  desc:='DIR_CACHE';
     4:  desc:='FILE_SYSTEM';
     5:  desc:='LOCKS';
     6:  desc:='TRANSACTION_TRACKING';
     7:  desc:='DISK';
     8:  desc:='TIME';
     9:  desc:='NCP';
     10: desc:='MISCELLANEOUS';
     11: desc:='ERRORS';
    end;


    lstSet.Items.Add(strpas(category)+';'+valuestr+'|'+inttostr(cmdType));
     //+'--'+inttostr(cmdtype)+'--'+desc);
  end;
  for count:=0 to lstSet.Items.Count-1 do
  begin
     Item:=LstSet.Items[count];
     sgdSet.Cells[0,count+1]:=Copy(Item,0,pos(';',Item)-1);
     sgdSet.Cells[1,count+1]:=Copy(Item,pos(';',Item)+1,(pos('|',Item)-1)-pos(';',Item));
     sgdSet.Cells[2,count+1]:=Copy(Item,pos('|',Item)+1,50);
  end;
  StatusBar1.Panels[4].Text:=inttostr(fseServerSetCmdsInfo.numberOfSetCommands)+' Set Commands';
end;

Procedure TForm1.GetConnList;
var
   i : integer;
   loginid : Array [0..50] of char;
   maxconns : Integer;
   pObjID : nuint32;
   addr:NWINET_ADDR;
   nodeaddr : String;
   loginstr : String;
begin
//****** Get a list of all Connections
  sgdOpenFiles.Cells[0,0]:='FileName';
  sgdOpenFiles.Cells[1,0]:='Name Spc';
  screen.Cursor:=crHourGlass;
  maxconns:=strtoint(lblMax.caption);
  StatusBar1.Panels[3].Text:=lblMax.Caption+' connections';
  for i := 1 to maxconns do
  begin
    ccode:= NWGetConnectionInformation(connHandle,i,@loginid,nil,@pObjID,nil);
    if (ccode = 0) and not (inttohex(pObjId,2) = '0L') then
    begin
      ccode := NWGetInetAddr(connHandle, i, addr);
      if (ccode<>0) then
      begin
        ShowMessage('NWGetInetAddr Failed!'+#13+'Error Code: '+inttostr(ccode));
        Exit;
      end;

      nodeaddr:=inttohex(addr.netnodeAddr[0],2)+inttohex(addr.netnodeAddr[1],2)
             +inttohex(addr.netnodeAddr[2],2)+inttohex(addr.netnodeAddr[3],2)
             +inttohex(addr.netnodeAddr[4],2)+inttohex(addr.netnodeAddr[5],2);
     if (pos(edtserver.text+'.',loginid)>0) then
        loginstr:='*'+strpas(loginid)
     else
        loginstr:=strpas(loginid);

     if rbnName.Checked=True then
     begin
       lstConn.Items.Add(loginstr+':'+inttostr(i)+'+'+nodeaddr);
       sgdConn.Cells[0,0]:='Login Id';
       sgdConn.Cells[1,0]:='Conn #';
       sgdConn.Cells[2,0]:='Node Addr';
     end
     else
     begin
       sgdConn.Cells[0,0]:='Node';
       sgdConn.Cells[1,0]:='Conn #';
       sgdConn.Cells[2,0]:='Login ID';
       lstConn.Items.Add(nodeaddr+':'+inttostr(i)+'+'+loginstr);
     end;
    end;
  end;
  for i:=0 to lstConn.Items.Count-1 do
  begin
    sgdConn.Cells[0,i+1]:=Copy(lstConn.Items[i],0,pos(':',lstConn.Items[i])-1);
    sgdConn.Cells[1,i+1]:=Copy(lstConn.Items[i],pos(':',lstConn.Items[i])+1, pos('+',lstConn.Items[i])-pos(':',lstConn.Items[i])-1);
    sgdConn.Cells[2,i+1]:=Copy(lstConn.Items[i],pos('+',lstConn.Items[i])+1,100);
    if i >0 then
    sgdConn.RowCount:=i+2;
  end;
  lstConn.Items.Clear;
  StatusBar1.Panels[3].Text:=inttostr(sgdConn.RowCount-1)+' connections';
  lvwConnClick(sgdConn);
  screen.Cursor:=crDefault;
end;

procedure TForm1.bbtAnalyzeClick(Sender: TObject);
begin
   if (edtServer.Text='') then
   begin
     bbtAnalyze.Enabled:=False;
     exit;
   end;
     
   if (lblconsole.Caption='NO') then
   begin
     if MessageDlg('You do not have Console Operator Rights.'+#13+'Do you want to login to '+servername+' as a different user?',mtConfirmation,[mbNo,mbYes],0)=mrYes then
     begin
       loginform.lblServer.Caption:=edtServer.Text;
       loginform.Caption:='NetWare Bindery Login';
       loginform.show;
       exit;
     end;
   end;

   Timer1.Enabled:=False;
   GetBasicInfo;
   if (lblconsole.Caption='') then
   begin
     Exit;
   end;
   frmProgress.ProgressBar1.Position:=0;
   frmProgress.Show;
   frmProgress.lblProgress.Caption:='Getting Basic Info';
   Application.ProcessMessages;   
   pnlWarn.Visible:=False;
   Screen.Cursor:=crHourGlass;

   if (lblConsole.Caption='NO') or (pos('3.',lblVer.caption)>0) then
   begin
     ConnTab.TabVisible:=True;
     frmProgress.ProgressBar1.Position:=20;
     frmProgress.lblProgress.Caption:='Getting Connection List';
     Application.ProcessMessages;
     GetConnList;
     frmProgress.ProgressBar1.Position:=40;
     frmProgress.lblProgress.Caption:='Getting Volume List';
     Application.ProcessMessages;
     VolTab.TabVisible:=True;
     GetVolList;
     frmProgress.ProgressBar1.Position:=60;
     frmProgress.lblProgress.Caption:='Getting IRQ List';
     Application.ProcessMessages;
     GetIRQList;
     frmProgress.ProgressBar1.Position:=80;
     bbtDismount.enabled:=False;
     bbtMount.enabled:=False;
     frmProgress.ProgressBar1.Position:=90;
     if (lblConsole.Caption='YES') then //must be console operator on a 3.x server
     begin
        frmProgress.lblProgress.Caption:='Getting NCF and LOG File List';
        Application.ProcessMessages;
        NCFTab.TabVisible:=True;
        GetNCFFiles;
        frmProgress.lblProgress.Caption:='Getting Open File List';
        Application.ProcessMessages;
        FileTab.TabVisible:=True;
        GetOpenFiles;
     end;
   end
   else
   begin
     NLMTab.TabVisible:=True;
     frmProgress.ProgressBar1.Position:=20;
     frmProgress.lblProgress.Caption:='Getting NLM List';
     Application.ProcessMessages;
     GetNLMList;
     frmProgress.ProgressBar1.Position:=30;
     frmProgress.lblProgress.Caption:='Getting Volume List';
     Application.ProcessMessages;
     VolTab.TabVisible:=True;
     GetVolList;
     frmProgress.ProgressBar1.Position:=40;
     frmProgress.lblProgress.Caption:='Getting IRQ List';
     Application.ProcessMessages;
     GetIRQList;
     frmProgress.ProgressBar1.Position:=50;
     frmProgress.lblProgress.Caption:='Getting Connection List';
     Application.ProcessMessages;
     ConnTab.TabVisible:=True;
     GetConnList;
     frmProgress.ProgressBar1.Position:=60;
     frmProgress.lblProgress.Caption:='Getting Set Command List';
     Application.ProcessMessages;
     SetTab.TabVisible:=True;
     GetSetList;
     frmProgress.ProgressBar1.Position:=70;
     StatsTab.TabVisible:=True;
//     GetStats;
     frmProgress.ProgressBar1.Position:=80;
     frmProgress.lblProgress.Caption:='Getting Open File List';
     Application.ProcessMessages;
     FileTab.TabVisible:=True;
     GetOpenFiles;
     frmProgress.ProgressBar1.Position:=90;
     frmProgress.lblProgress.Caption:='Getting NCF and LOG File List';
     Application.ProcessMessages;
     NCFTab.TabVisible:=True;
     GetNCFFiles;
   end;
   frmProgress.Close;
   frmProgress.ProgressBar1.Position:=0;
   Application.ProcessMessages;
   Screen.Cursor:=crDefault;
   Timer1.Enabled:=True;
end;

procedure TForm1.ClearAll;
var
  Y, Z : Integer;
begin
  if (lblVer.Caption='') then
    Exit; //Everything is already cleared out!
  NWCCCloseConn(ConnHandle);
  DeleteDrive;
  bbtAddNs.Enabled:=False;
  bbtDisMount.Enabled:=False;
  bbtMount.Enabled:=False;
  lblVer.Caption:='';
  lblEver.Caption:='';
  lblLicense.Caption:='';
  lblMax.Caption:='';
  lblUse.Caption:='';
  lblVol.Caption:='';
  lblSerial.Caption:='';
  lblSFT.Caption:='';
  lblTTS.Caption:='';
  lblUtilize.Caption:='';
  lblLogin.Caption:='';
  lblConsole.Caption:='';
  bbtDown.Enabled:=False;
  bbtLogin.Enabled:=False;
  bbtRconsole.Enabled:=False;
  bbtExecute.Enabled:=False;
  bbtReloadDS.Enabled:=False;
  TreeForm.tvwDS.Items.Clear;
  lstNCF.Items.Clear;
  lvwNLMs.Items.Clear;
  for Y := 0 to sgdVolume.ColCount - 1 do
    for Z:= 0 to sgdVolume.RowCount - 1 do
      sgdVolume.Cells[Y,Z] := '';
  lvwIRQ.Items.Clear;
  for Y := 0 to sgdConn.ColCount - 1 do
    for Z:= 0 to sgdConn.RowCount - 1 do
      sgdConn.Cells[Y,Z] := '';
  sgdConn.RowCount:=2;
  for Y := 0 to sgdNCF.ColCount - 1 do
    for Z:= 0 to sgdNCF.RowCount - 1 do
      sgdNCF.Cells[Y,Z] := '';
  sgdNCF.RowCount:=2;
  for Y := 0 to sgdFiles.ColCount - 1 do
    for Z:= 0 to sgdFiles.RowCount - 1 do
      sgdFiles.Cells[Y,Z] := '';
  sgdFiles.RowCount:=2;
  for Y := 0 to sgdSet.ColCount - 1 do
    for Z:= 0 to sgdSet.RowCount - 1 do
      sgdSet.Cells[Y,Z] := '';
  sgdSet.RowCount:=2;
  for Y := 0 to sgdOpenFiles.ColCount - 1 do
    for Z:= 0 to sgdOpenFiles.RowCount - 1 do
      sgdOpenFiles.Cells[Y,Z] := '';
  sgdOpenFiles.RowCount:=2;
  lblID.Caption:='';
  lblConnNum.Caption:='';
  lblTime.Caption:='';
  lblAddr.Caption:='';
  lblNode.Caption:='';
  lblFileLock.Caption:='';
  lblRecLock.Caption:='';
  lblBytesRead.Caption:='';
  lblBytesWrite.Caption:='';
  lblRequests.Caption:='';
  lblConnType.Caption:='';  
  NLMTab.TabVisible:=False;
  VolTab.TabVisible:=False;
  SetTab.TabVisible:=False;
  StatsTab.TabVisible:=False;
  ConnTab.TabVisible:=False;
  NCFTab.TabVisible:=False;
  FileTab.TabVisible:=False;
  StatusBar1.Panels[1].Text:='';
  StatusBar1.Panels[2].Text:='';
  StatusBar1.Panels[3].Text:='';
  StatusBar1.Panels[4].Text:='';
  StatusBar1.Panels[5].Text:='';
  StatusBar1.Panels[6].Text:='';
  StatusBar1.Panels[7].Text:='';
  lstNLM.Items.Clear;
  ClearStats;
  edtNLM.Text:='';
  TreeForm.edtContext.Text:='';
  Timer1.Enabled:=False;
  TreeForm.edtTree.Text:='';
  bbtCancelEdit.Enabled:=False;
  bbtSaveFile.Enabled:=False;
  bbtDeleteFile.Enabled:=False;
  bbtNewFile.Enabled:=False;
  lblFileName.Caption:='';
  lblFileOwner.Caption:='';
  lblFileNs.Caption:='';
  lblVolume.Caption:='';
  lblDir.Caption:='';
  lblServer.Caption:='';
  mmoFileContents.Lines.Clear;
end;

procedure TForm1.lvwConnClick(Sender: TObject);
var
   connNum: Integer;
   ccode:NWCCODE;
   loginid:array [0..100] of nstr8;
   pObjType : pnuint16;
   pObjID : nuint32;
   pLoginTime : array [0..6] of byte;
   addr:NWINET_ADDR;
   socket: string;
   newsocket: string;
   Y,Z : Integer;
begin
   lblID.Caption:='';
   lblConnNum.Caption:='';
   lblTime.Caption:='';
   lblFileLock.Caption:='';
   lblRecLock.Caption:='';
   lblBytesRead.Caption:='';
   lblBytesWrite.Caption:='';
   lblRequests.Caption:='';
   lblAddr.Caption:='';
   lblNode.Caption:='';
   lblConnType.Caption:='';
   lblLicense.Caption:='';
   if (sgdConn.Cells[1,sgdConn.Row]='') then
     Exit;
   connNum:=strtoint(sgdConn.Cells[1,sgdConn.Row]);

   ccode:= NWGetConnectionInformation(connHandle,connNum,@loginid,@pObjType,@pObjID,@pLoginTime);
   if (ccode<>0) then
   begin
      ShowMessage('NWGetConnectionInformation Failed!'+#13+'Error Code: '+inttostr(ccode));
      Exit;
   end;

   lblID.Caption:=strpas(loginid);
   lblConnNum.Caption:=inttostr(connNum);
   lblTime.Caption:=inttostr(pLoginTime[1])+'\'+inttostr(pLoginTime[2])
   +'\'+inttostr(pLoginTime[0])+' '+inttostr(pLoginTime[3])+':'+inttostr(pLoginTime[4])
   +':'+inttostr(pLoginTime[5]);

   ccode := NWGetInetAddr(connHandle, connNum, addr);
   if (ccode<>0) then
   begin
     ShowMessage('NWGetInetAddr Failed!'+#13+'Error Code: '+inttostr(ccode));
     Exit;
   end;

   socket:=inttohex(addr.socket,4);
   newsocket:=socket[3]+socket[4]+socket[1]+socket[2];
   lblAddr.Caption:=inttohex(addr.networkAddr[0],2)+inttohex(addr.networkAddr[1],2)
          +inttohex(addr.networkAddr[2],2)+inttohex(addr.networkAddr[3],2);
   lblNode.Caption:=inttohex(addr.netnodeAddr[0],2)+inttohex(addr.netnodeAddr[1],2)
          +inttohex(addr.netnodeAddr[2],2)+inttohex(addr.netnodeAddr[3],2)
          +inttohex(addr.netnodeAddr[4],2)+inttohex(addr.netnodeAddr[5],2)+':'+newsocket;

   for Y := 0 to sgdOpenFiles.ColCount - 1 do
     for Z:= 1 to sgdOpenFiles.RowCount - 1 do
       sgdOpenFiles.Cells[Y,Z] := '';
   if lblConsole.Caption='YES' then
     bbtDropConn.enabled:=True;
   bbtSend.enabled:=True;
end;

procedure TForm1.bbtClearAllClick(Sender: TObject);
begin
  ClearAll;
  edtServer.Text:='';
  lstServers.ItemIndex:=-1;
end;

procedure TForm1.bbtDropConnClick(Sender: TObject);
var
  connNum : Integer;
  msg : array [0..200] of char;
begin
  if MessageDlg('If this a client 32 connection the client will automatically reconnect to the server.'+#13+'This may cause a server-client conflict loop'+#13+'Do you want to drop this connection?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
    Exit;
  connNum:=strtoint(lblConnNum.Caption);
  strpcopy(msg,'Your connection to '+edtServer.text+' was dropped by the admin!');

  ccode:=NWSendBroadcastMessage(connHandle,@msg,1,@connNum,nil);

  ccode:=NWClearConnectionNumber(connHandle,connNum);
  if (ccode<>0) then
  begin
    ShowMessage('NWClearConnectionNumber Failed: '+inttohex(ccode,2));
  end;
  GetConnList;
  bbtDropConn.Enabled:=False;
end;

procedure TForm1.GetServerList;
var
  count: Integer;
  searchstring:array [0..2] of char;
  server: array [0..250] of char;
  id: nuint32;
begin
     id := -1;
     count := 0;
     strcopy(searchstring, '*');

     while (ccode = 0) do
     begin
         application.processmessages;
	 ccode := NWScanObject (
           {connection handle}             connHandle,
	   {Search string wildcard}        @searchstring,
	   {object type}                   {OT_WILD,}OT_FILE_SERVER,
	   { Points to the last object ID }@id,
	   {the object name}               @server,
	   {@objtype,}                     nil,
	   {@hasPropertiesFlag,}           nil,
	   {@objFlags,}                    nil,
	   {@objSecurity);}                nil);

	 if (ccode=0)then
	 begin
           lstServers.Items.add(strpas(server));
	   inc(count);
	 end;
     end;
    StatusBar1.Panels[0].text:=inttostr(count)+' Servers';
end;

procedure TForm1.FormShow(Sender: TObject);
var
  majorVer : nuint8;
  minorVer : nuint8;
  revLevel : nuint8;
  betaLevel : nuint8;
  ClientType : nuint16;
begin
   betaLevel:=0;
   {Need to make sure the client is current and NOT Microsofts!!!!}
   ccode := NWGetRequesterVersion(@majorVer,@MinorVer,@revlevel);
   if (ccode<>0) then
     ShowMessage('NWGetRequesterVersion Failed: '+inttohex(ccode,2));

   if majorVer=0 then
     ShowMessage('Your have an early Requester Version: '+inttostr(majorVer)+'.'+inttostr(MinorVer)+'.'+inttostr(revlevel)+'.'+inttostr(betalevel)+#13+'You need to upgrade your client, contact (http://support.novell.com)'+#13+'This application may not work properly');

   ClientType:=NWGetClientType();

   if ClientType<>3 then
     ShowMessage('You may not have the Client 32 loaded, this application may not run properly'+#13+'If you are running NT, ignore this message');

   GetServerList;
   clearall;
   splashForm.Close;
   SplashForm.Free;
end;

procedure TForm1.lvwNLMsClick(Sender: TObject);
var
  SelectItem : TListItem;
begin
  bbtUnload.enabled:=False;
  SelectItem:=lvwNLMs.Selected;
  If SelectItem=nil then
   exit;
  If SelectItem.ImageIndex<>0 then
  begin
    bbtUnload.enabled:=True;
  end;
end;

procedure TForm1.bbtUnloadClick(Sender: TObject);
var
  SelectItem : TListItem;
  NLMName : String;
  NLMName0 : Array [0..50] of char;
begin
  SelectItem:=lvwNLMs.Selected;
  NlmName:=SelectItem.Caption;
  strpcopy(NLMName0, NLMName);
  ccode:=NWSMUnLoadNLM(connHandle, @NLMName0);
  if (ccode<>0) then
  begin
    if (inttohex(ccode,2)='009E') or (inttohex(ccode,2)='899E') then
      ShowMessage('Bad file name or no file name given')
    else if (inttohex(ccode,2)='202') then
      ShowMessage('Unable to unload specified module')
    else
      ShowMessage('NWSMUnLoadNLM Failed with :'+inttohex(ccode,2));
    Exit;
  end;
  lvwNLMs.Items.Clear;
  GetNLMList;
  bbtUnload.Enabled:=False;
end;

procedure TForm1.edtNLMChange(Sender: TObject);
begin
 If (edtNLM.Text<>'') then
   bbtLoad.Enabled:=True;
end;

procedure TForm1.LoadNLM(NLMName : String);
var
  NLMName0 : Array [0..482] of char;
begin
  Screen.Cursor:=crHourGlass;
  strpcopy(NLMName0, NLMName);
  ccode:=NWSMLoadNLM(connHandle, @NLMName0);
  if (ccode<>0) then
  begin
    if (inttohex(ccode,2)='009E') or (inttohex(ccode,2)='899E') then
      ShowMessage('Bad file name or no file name given')
    else if (inttohex(ccode,2)='202') then
      ShowMessage('Unable to load specified module')
    else
      ShowMessage('NWSMLoadNLM Failed with :'+inttohex(ccode,2));
    Screen.Cursor:=crDefault;
    Exit;
  end;
  lvwNLMs.Items.Clear;
  GetNLMList;
  edtNLM.Text:='';
  bbtLoad.Enabled:=False;
  Screen.Cursor:=crDefault;
end;

procedure TForm1.bbtLoadClick(Sender: TObject);
begin
  LoadNLM(edtNLM.Text);
end;

procedure TForm1.bbtNLMhelpClick(Sender: TObject);
begin
  ShowMessage('NLM name (including the path if it is not in the server path), and command line parameters if any.'+#13+
'The NLM does not have to include the extensions. .NLM will be assumed if the extensions are not included.');

end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
 If Key=#13 then
  bbtLoadClick(edtNLM);
end;

procedure TForm1.bbtConnRefreshClick(Sender: TObject);
var
  Y,Z : Integer;
begin
 for Y := 0 to sgdConn.ColCount - 1 do
   for Z:= 0 to sgdConn.RowCount - 1 do
     sgdConn.Cells[Y,Z] := '';
 sgdConn.RowCount:=2;
 bbtDropConn.Enabled:=False;
 GetConnList;
 lblID.Caption:='';
 lblConnNum.Caption:='';
 lblTime.Caption:='';
 lblAddr.Caption:='';
 lblNode.Caption:='';
end;

procedure TForm1.bbtDisMountClick(Sender: TObject);
Var
  Volname : array [0..100] of char;
begin
  bbtDisMount.Enabled:=False;
  if (sgdVolume.Row=0) then
    exit;
  Screen.Cursor:=crHourGlass;
  strpcopy(Volname, sgdVolume.Cells[0,sgdVolume.Row]);
  ccode := NWSMDisMountVolumeByName(connHandle, @volname);
  if (ccode<>0) then
  begin
    ShowMessage('NWSMDisMountVolumeByName Failed: '+inttohex(ccode,2));
  end;
  GetVolList;
  Screen.Cursor:=crDefault;
  bbtAddNS.Enabled:=False;
end;

procedure TForm1.bbtMountClick(Sender: TObject);
var
  volname : array [0..100] of char;
  junknum : Integer;
begin
  bbtMount.Enabled:=False;
  if (sgdVolume.Row=0) then
    exit;
  Screen.Cursor:=crHourGlass;
  sgdVolume.Visible:=False;
  application.processmessages;
  strpcopy(Volname, sgdVolume.Cells[0,sgdVolume.Row]);
  ccode:=NWSMMountVolume(connHandle, @volname, @junknum);
  if (ccode<>0) then
  begin
    ShowMessage('NWSMMountVolumeByName Failed: '+inttohex(ccode,2));
    sgdVolume.Visible:=True;
    Screen.Cursor:=CrDefault;
    exit;
  end;
//  Sleep(250);
  GetVolList;
  sgdVolume.Visible:=True;
  Screen.Cursor:=crDefault;
  bbtAddNS.Enabled:=True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 NWCCCloseConn(ConnHandle);
 DeleteDrive;
end;

procedure TForm1.bbtDownClick(Sender: TObject);
var
  servername : string;
begin
  servername:=edtServer.Text;

  if MessageDlg('Are you sure you want to down '+servername+'?',mtConfirmation,[mbNo, mbYes],0) = mrNo then
    exit;

  ccode:=NWDownFileServer(connHandle,1);
  if (ccode<>0) then
  begin
    if (inttohex(ccode,2)='89FF') then
    begin
      if MessageDlg(servername+' has files open are you sure',mtWarning,[mbYes, mbNo],0) = mrYes then
      begin
        ccode:=NWDownFileServer(connHandle,0);
        if (ccode<>0) then
          MessageDlg('NWDownFileServer Failed :'+inttohex(ccode,2),mtWarning,[mbOK],0)
        else
        begin
          bbtClearAllClick(bbtDown);
          MessageDlg(servername+' is down',mtInformation,[mbOK],0);
        end;
      end;
    end
    else
    begin
       MessageDlg('NWDownFileServer Failed :'+inttohex(ccode,2),mtWarning,[mbOK],0);
    end;
  end
  else
  begin
    bbtClearAllClick(bbtDown);
    MessageDlg(servername+' is down',mtInformation,[mbOK],0);
  end;
end;

procedure TForm1.bbtAddNSClick(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to add a name space?',mtConfirmation,[mbNo, mbYes],0) = mrNo then
    exit;
  frmNS.Show;
end;

procedure TForm1.bbtRemoveNSClick(Sender: TObject);
begin
 MessageDlg('To remove a name space, you must use the VREPAIR NLM'+#13+'The volume must be unmounted',mtInformation,[mbOK],0)
end;

procedure TForm1.bbtServerRefreshClick(Sender: TObject);
begin
  Screen.Cursor:=crHourGlass;
  lstServers.Visible:=False;
  lstServers.Items.Clear;
  GetServerList;
  lstServers.Visible:=True;
  Screen.Cursor:=crDefault;
end;

procedure TForm1.bbtNLMRefreshClick(Sender: TObject);
begin
  lvwNLMs.Items.Clear;
  GetNLMList;
end;

procedure TForm1.bbtVolRefreshClick(Sender: TObject);
var
  Y, Z : Integer;
begin
  bbtDisMount.Enabled:=False;
  bbtMount.Enabled:=False;
  bbtADDNS.Enabled:=False;
  for Y := 0 to sgdVolume.ColCount - 1 do
    for Z:= 0 to sgdVolume.RowCount - 1 do
      sgdVolume.Cells[Y,Z] := '';
  lvwIRQ.Items.Clear;
  GetVolList;
  GetIRQList;
end;

procedure TForm1.bbtSetRefreshClick(Sender: TObject);
Var
 Y, Z : Integer;
begin
  for Y := 0 to sgdSet.ColCount - 1 do
    for Z:= 0 to sgdSet.RowCount - 1 do
      sgdSet.Cells[Y,Z] := '';
   GetSetList;
end;

procedure TForm1.ClearStats;
var
  Y, Z : Integer;
begin
  sgdStats.toprow:=1;
//  sgdStats.Row:=1;
  for Y := 0 to sgdStats.ColCount - 1 do
    for Z:= 0 to sgdStats.RowCount - 1 do
      sgdStats.Cells[Y,Z] := '';
end;

procedure TForm1.GetStats;
begin
  if rbnCache.Checked=True then
    GetCacheStats
  else if rbnCPU.Checked=True then
    overflow.GetCPUStats
  else if rbnDirCache.Checked=True then
    overflow.GetDirCacheStats
  else if rbnFSInfo.Checked=True then
    overflow.GetServerInfoStats
  else if rbnGarbage.Checked=True then
    overflow.GetGarbageStats
  else if rbnIPX.Checked=True then
    overflow.GetIPXStats
  else if rbnLAN1.Checked=True then
    overflow.GetLANStats
  else if rbnLAN2.Checked=True then
    overflow.GetLANStats
  else if rbnLAN3.Checked=True then
    overflow.GetLANStats
  else if rbnLAN4.Checked=True then
    overflow.GetLANStats
  else if rbnMedia.Checked=True then
    overflow.GetNCPStats
  else if rbnLSL.Checked=True then
    overflow.GetLSLStats
  else if rbnPacket.Checked=True then
    overflow.GetPacketBurstStats;
end;

procedure TForm1.GetOpenFiles;
var
   i : nuint32;
   loginid : Array [0..50] of char;
   maxconns : Integer;
   pObjID : nuint32;
   iterHandle : nint16;
   openCtrl : OPEN_FILE_CONN_CTRL;
   openFile : OPEN_FILE_CONN;
   Y,Z :Integer;
   row : Integer;
begin
  for Y := 0 to sgdFiles.ColCount - 1 do
    for Z:= 0 to sgdFiles.RowCount - 1 do
      sgdFiles.Cells[Y,Z] := '';
    sgdFiles.RowCount:=2;
//****** Get a list of all Connections
     maxconns:=strtoint(lblMax.caption);
     sgdFiles.Cells[0,0]:='File Name';
     sgdFiles.Cells[1,0]:='Opener ID';
     sgdFiles.Cells[2,0]:='Name Space';
     sgdFiles.Cells[3,0]:='Vol #';
     sgdFiles.Cells[4,0]:='Dir #';
     for i := 1 to maxconns do
     begin
       ccode:= NWGetConnectionInformation(connHandle,i,@loginid,nil,@pObjID,nil);
       if (ccode = 0) and not (inttohex(pObjId,2) = '0L') then
       begin
         row:=1;
         iterHandle:=0;
         while (iterHandle<>-1) do
         begin
           ccode := NWScanOpenFilesbyConn2(connHandle,i,@iterHandle,openCtrl,openFile);
           if (ccode<>0) then
           begin
              if inttohex(ccode,2)<>'88FF' then
              begin
                exit;
              end
              else
                iterhandle:=-1;
                break;
           end;
           sgdFiles.Cells[0,row]:=strpas(openFile.Filename);
           sgdFiles.Cells[1,row]:=strpas(loginid);
           if (inttohex(openFile.nameSpace,2)='00') then
              sgdFiles.Cells[2,row]:='DOS'
           else if (inttohex(openFile.nameSpace,2)='01') then
              sgdFiles.Cells[2,row]:='MAC'
           else if (inttohex(openFile.nameSpace,2)='02') then
              sgdFiles.Cells[2,row]:='NFS'
           else if (inttohex(openFile.nameSpace,2)='03') then
              sgdFiles.Cells[2,row]:='FTAM'
           else if (inttohex(openFile.nameSpace,2)='04') then
              sgdFiles.Cells[2,row]:='LONG';
           sgdFiles.Cells[3,row]:=inttostr(openFile.volnumber);
           sgdFiles.Cells[4,row]:=inttostr(openFile.parent);
           inc(row);
           sgdFiles.RowCount:=row+1;
           end;
        end;
     end;
     StatusBar1.Panels[5].Text:=inttostr(sgdFiles.RowCount-1)+' Open Files';
end;

procedure TForm1.bbtOpenFilesRefreshClick(Sender: TObject);
begin
  Screen.Cursor:=CrHourGlass;
  GetOpenFiles;
  Screen.Cursor:=CrDefault;
end;

procedure TForm1.GetNCFFiles;
var
  R: TSearchRec;  {Directory scan result record}
  K: Integer;  {while-loop variable}
  FileHandle: Integer;
  Size : Integer;
  nullstring : Array[0..150] of char;
  i : Integer;
  sizestr : String;
  Item : String;
begin
  sgdNCF.Cells[0,0]:='Name';
  sgdNCF.Cells[1,0]:='Size';
  if (sgdVolume.Cells[6,1]='UnMounted') then
  begin
    ShowMessage('NCF/LOG files could not be retrieved becase the SYS Volume is unmounted');
    exit;
  end;

  MapADrive(edtServer.Text,'SYS:');

//*************** Get System's subdirectory NCF Files
  K := FindFirst(driveletter+':\SYSTEM\*.NCF', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\SYSTEM\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add('SYSTEM\'+R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);

//************** Get the System's Log Files

  K := FindFirst(driveletter+':\SYSTEM\*.LOG', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\SYSTEM\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add('SYSTEM\'+R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);

//*************** Get Etc's subdirectory NCF Files
  K := FindFirst(driveletter+':\ETC\*.NCF', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\ETC\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add('ETC\'+R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);

//************** Get ETC's Log Files

  K := FindFirst(driveletter+':\ETC\*.LOG', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\ETC\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add('ETC\'+R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);

//************** Get ETC's CFG Files

  K := FindFirst(driveletter+':\ETC\*.CFG', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\ETC\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add('ETC\'+R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);


//************ Get ERR Files from System

  K := FindFirst(driveletter+':\SYSTEM\*.ERR', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\SYSTEM\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add('SYSTEM\'+R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);


//************ Now Get ERR Files from Root

  K := FindFirst(driveletter+':\*.ERR', faAnyfile, R);
  while K = 0 do
  begin
    strpcopy(nullstring,driveletter+':\'+R.Name);
    FileHandle:=FileOpen(nullstring, fmOpenRead);
    size:=getfilesize(FileHandle,nil);
    FileClose(FileHandle);
    lstNCF.Items.Add(R.Name+'|'+FormatFloat('###,###,###,##0',size));
    K := FindNext(R);
  end;
    FindClose(R);

StatusBar1.Panels[6].Text:=inttostr(lstNCF.Items.Count)+' NCF/Logs';
sgdNCF.RowCount:=lstNCF.Items.Count+1;
for i:=0 to lstNCF.Items.Count-1 do
begin
  Item:=lstNCF.Items[i];
  sgdNCF.Cells[0,i+1]:=Copy(Item,0,pos('|',Item)-1);
  sizestr:=Copy(Item,pos('|',Item)+1,100);
  if sizestr='-1' then
    sizestr:='Opened';
  sgdNCF.Cells[1,i+1]:=sizestr;
end;
  lstNCF.Items.Clear;

//************** Now Get the NLM Files *** for nlm tab

  K := FindFirst(driveletter+':\SYSTEM\*.NLM', faAnyfile, R);
  while K = 0 do
  begin
    lstNLM.Items.Add(R.Name);
    K := FindNext(R);
  end;
    FindClose(R);
  bbtNewFile.Enabled:=True;
  if lstNCF.Items.Count > 0 then
    bbtDeleteFile.Enabled:=True;
  DeleteDrive;
end;

procedure TForm1.bbtNCFRefreshClick(Sender: TObject);
begin
  lstNCF.Items.Clear;
  GetNCFFiles;
end;

Function  TForm1.MapADrive(ServerName : String; VolName : String): Integer;
var
  rcode:NWRCODE;
  i, status: Integer;
  conn:NWCONN_HANDLE;
  rootpath:array [0..256] of char;
  relativePath: array [0..256] of char;
  upr_ans: array [0..200] of char;
  server:array [0..150] of char;
  nullvolname:array [0..50] of char;
  dirpath:array [0..100] of char;
  conn2: NWCONN_HANDLE;
begin
  drivenum:=0;
  result:=1;
//********** First Get a connection handle

  strpcopy(@server,servername);
  try
    rcode:=NWCCOpenConnByName(0,@server,NWCC_NAME_FORMAT_BIND,NWCC_OPEN_UNLICENSED,0,@tmpconnhandle);
  except
    Exit;
  end;
  if (rcode<>0) then
  begin
     ShowMessage('WARNING: NWCCOpenConnByName returned:  '+inttostr(ccode));
     Exit;
  end;
//********** First find the next available drive ******//
  strpcopy(rootpath,'');
  for i:=6 to 26 do
  begin
    ccode := NWGetDriveStatus(i,NW_FORMAT_SERVER_VOLUME,@status,conn,@rootPath,@relativePath,nil);
    if (ccode<0)then
    begin
       ShowMessage('NWGetDriveStatus Failed'+#13+'Error Code: '+inttostr(ccode));
       exit;
    end;
    if (status<>4431872) and (Length(RootPath)=0) then
    begin
      drivenum:=i;
      strpcopy(@upr_ans, servername+'\'+VolName+'\:');
      ccode := NWParsePath(@upr_ans,@server,conn2,@nullvolName,@dirPath);
      if ccode<>0 then
      begin
         ShowMessage('NWParsePath failed '+inttohex(ccode,4));
         Exit;
      end;
      ccode := NWSetDriveBase(drivenum,conn2,0,@nullvolname,0);
      if (ccode<>0) then
      begin
        if (inttohex(ccode,2)='8803') then
        begin
          if MessageDlg('You do not have Console Operator Rights.'+#13+'Do you want to login to '+servername+' as a different user?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
             exit;
          Loginform.show;
          loginform.Caption:='Drive Mapping Login';
          loginform.lblServer.Caption:=servername;
          globalvol:=volname;
          exit;
        end;
        ShowMessage('NWSetDriveBase Failed: '+inttohex(ccode,2));
        Exit;
      end
      else
        Break;
    end;
  end;
  if drivenum=0 then
  begin
    ShowMessage('There are no drive letter available to map'+#13+'Unable to get NCF/LOG info');
    Exit;
  end;
  driveletter := chr(64 + drivenum);
  result:=0;
end;

procedure TForm1.DeleteDrive;
begin
  if (drivenum=0) then
    exit;
  ccode := NWDeleteDriveBase(drivenum,0);
  if (ccode<>0)then
  begin
     ShowMessage('NWDeleteDriveBase Failed: '+inttohex(ccode,2));
  end;
  nwcccloseConn(tmpConnHandle);
  driveletter:='';
  drivenum:=0;
end;

procedure TForm1.lstNLMClick(Sender: TObject);
begin
  edtNLM.Text:=lstNLM.Items[lstNLM.ItemIndex];
end;

procedure TForm1.bbtSaveFileClick(Sender: TObject);
begin
  If SaveFileName='NEW$$' then
  begin
    SaveFileName:=':\SYSTEM\'+Inputbox('InPut Box','Enter a NCF or LOG File Name', 'Untitled');
    if (pos('.NCF',uppercase(SaveFileName))=0) and (pos('.LOG',uppercase(SaveFileName))=0) then
    begin
      if (pos('.',SaveFileName)>0) then
        SaveFileName:=Copy(SaveFilename,0, pos('.',SaveFilename)-1);
      SaveFilename:=SaveFilename+'.NCF';
    end;
  end;
  if mapadrive(edtServer.Text,'SYS:')<>0 then
    exit;
  try
    mmoFileContents.Lines.SaveToFile(driveletter+SaveFileName);
    mmoFileContents.Lines.Clear;
    mmoFileContents.Lines.LoadFromFile(driveletter+SaveFileName);
  finally
    lstNCF.Items.Clear;
    deleteDrive;
    GetNCFFiles;
  end;
end;

procedure TForm1.bbtDeleteFileClick(Sender: TObject);
var
  SelectItem : String;
begin
  if sgdNCF.Row=0 then
    Exit;
  SelectItem:=sgdNCF.Cells[0,sgdNCF.Row];
  if Messagedlg('Are you sure you want to delete '+SelectItem+'?',mtConfirmation,[mbNo, mbYes],0) = mrNo then
    exit;
  bbtDeleteFile.Enabled:=False;
  mmoFileContents.Lines.Clear;
  mapadrive(edtServer.Text,'SYS:');
  if fileexists(driveletter+':\'+SelectItem) then
     DeleteFile(driveletter+':\'+SelectItem)
  else
     DeleteFile(driveletter+':\'+SelectItem);
  if fileexists(driveletter+':\'+SelectItem) then
     ShowMessage('Could not delete '+SelectItem);
  lstNCF.Items.Clear;
  deletedrive;
  GetNCFFiles;
end;

procedure TForm1.bbtNewFileClick(Sender: TObject);
begin
  SaveFileName:='NEW$$';
  //Reload lvwNCF to get rid of the current selection.
  lstNCF.Items.Clear;
  GetNCFFiles;
  mmoFileContents.Lines.Clear;
  mmoFileContents.setFocus;
  mmoFileContents.ReadOnly:=False;
  lblTFileContents.Caption:='File Contents';
end;

procedure TForm1.bbtCancelEditClick(Sender: TObject);
begin
  bbtCancelEdit.Enabled:=False;
  mmoFileContents.Lines.Clear;
  if (SaveFileName<>'') and (SaveFileName<>'NEW$$') then
  begin
    mapadrive(edtServer.Text,'SYS:');
    mmoFileContents.Lines.LoadFromFile(driveletter+SaveFileName);
    deletedrive;
  end;
end;

procedure TForm1.mmoFileContentsKeyPress(Sender: TObject; var Key: Char);
begin
  bbtCancelEdit.Enabled:=True;
  bbtSaveFile.Enabled:=True;
end;

Function  TForm1.TickToStr(Ticks : LongInt): String;
var
   TickPs, TickPm, TickPh, TickPd : real;
   days, hours, minutes, seconds : extended;
begin
      TickPs := 18.205;         //18.205
      TickPm := 18.205*60;      //1092.3
      TickPh := 18.205*60*60;    //65538
      TickPd := 18.205*60*60*24; //1572912
      days:=ticks / TickPd;
      days:=trunc(days);
        ticks := ticks - Trunc(days*TickPd);
      hours:=ticks / TickPh;
      hours:=trunc(hours);
        ticks := ticks - Trunc(hours*TickPh);
      minutes:=ticks / TickPm;
      minutes:=trunc(minutes);
        ticks := ticks - Trunc(minutes*TickPm);
      seconds:=ticks / TickPs;
      seconds:=trunc(seconds);
        ticks := ticks - Trunc(seconds*TickPs);
      if ticks<0 then
       ticks:=0;
      if days<0 then
       days:=0;
      if hours<0 then
       hours:=0;
      if minutes<0 then
       minutes:=0;
      if seconds<0 then
       seconds:=0;
      if ticks>17 then
      begin
        seconds:=seconds+1;
        ticks:=0;
      end;
      if seconds>59 then
      begin
        minutes:=minutes+1;
        seconds:=0;
      end;
      if minutes>59 then
      begin
        hours:=hours+1;
        minutes:=0;
      end;
      if hours>23 then
      begin
        days:=days+1;
        hours:=0;
      end;
      TickToStr:=floattostr(days)+' Days '+floattostr(hours)+' Hrs '+floattostr(minutes)+' Min '+floattostr(seconds)+' Sec '+floattostr(ticks)+' Ticks';
end;

procedure TForm1.rbnCacheClick(Sender: TObject);
begin
  ClearStats;
end;

procedure TForm1.GetAttributes;
var
   ccode:NWDSCCODE;
   iterator:NWDS_ITERATION;
   outBuf,inbuf:^Buf_T;
   inptr, outptr:pointer;
   attrcount, valcount:NWCOUNT;
   i,Z,Y:Integer;
   syntax:NWSYNTAX_ID;

begin

  for Y := 0 to attribform.sgdAttr.ColCount - 1 do
    for Z:= 0 to attribform.sgdAttr.RowCount - 1 do
      attribform.sgdAttr.Cells[Y,Z] := '';

  ccode:=NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @inbuf);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSAllocBuf Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;

  ccode:=NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @outBuf);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSAllocBuf Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;

  inptr:=inBuf;
  outptr:=outBuf;

  ccode:=NWDSInitBuf(dContext,DSV_READ,inptr);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSInitBuf Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;

  Iterator:=-1;

  ccode:=NWDSRead(dContext,@gobjectName,0,TRUE,inptr,@iterator,outptr);
  if (ccode <> 0) then
  begin
  	if (ccode = -603) then
        begin
        	ShowMessage('-603: The Requested attribute could not be found!');
        end
        else if (ccode = -601) then
        	ShowMessage('-601: The Requested object could not be read!')
        else
          ShowMessage('NWDSRead Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;

  ccode:=NWDSGetAttrCount(dContext,outptr,@attrCount);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSGetAttrCount Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;

  attribForm.sgdattr.Cells[0,0]:='Attribute';
  attribForm.sgdattr.Cells[1,0]:='Syntax';
  attribForm.sgdattr.Cells[2,0]:='Value';
  attribForm.sgdattr.Rowcount:=attrCount+1;
  for i:=1 to attrcount do
  begin
       ccode:=NWDSGetAttrName(dContext,outptr,@attrName,@valCount,@syntax);
       if (ccode <> 0)then
       begin
         ShowMessage('NWDSGetAttrName Failed'+#13+'Error Code: '+inttostr(ccode));
         Screen.Cursor := crDefault;
         exit;
       end;
       attribform.sgdattr.Cells[0,i]:=strpas(attrName);
       attribform.sgdattr.Cells[2,i]:=GetValues;
       attribform.sgdattr.Cells[1,i]:=inttostr(globalsyntax);
  end;
  attribform.caption:='Viewing Directory Object';
  attribform.show;
  attribform.sgdAttr.Options:=[goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goColSizing,goTabs,goAlwaysShowEditor,goThumbTracking];  
end;

Function TForm1.GetValues: String;
var
  rights, trim:string;
  iterator:NWDS_ITERATION;
  outBuf2,inbuf2:^Buf_T;
  i,j:Integer;
  ccode:NWDSCCODE;
  attrcount,valcount:NWCOUNT;
  presyntax:NWSYNTAX_ID;
  syntax: integer;
  sattrName: String;
  attrSize:NWSIZE;
  privs:NWDS_PRIVILEGES;
  days: real;
  seconds: nuint32;
  attrval : pointer;
  outptr,inptr :pointer;
  var FileHandle: NWFILE_HANDLE;
  tmpBuffer:array [0..512] of char;

begin
  syntax:=0;
  ccode:=NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @inbuf2);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSAllocBuf Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;

  ccode:=NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @outBuf2);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSAllocBuf Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        NWDSFreeBuf(@inBuf2);
        exit;
  end;

  {Use generic pointers to avoid GPFs}
  inptr:=inBuf2;
  outptr:=outBuf2;

  ccode:=NWDSInitBuf(dContext,DSV_READ,inptr);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSInitBuf Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        NWDSFreeBuf(inptr);
        NWDSFreeBuf(outptr);
        exit;
  end;

  ccode:=NWDSPutAttrName(dContext,inptr,@attrName);
  if (ccode <> 0)then
  begin
    ShowMessage('NWDSPutAttrName Failed'+#13+'Error Code: '+inttostr(ccode));
    Screen.Cursor := crDefault;
    NWDSFreeBuf(inptr);
    NWDSFreeBuf(outptr);
    exit;
  end;

iterator:=-1;

 ccode:=NWDSRead(dContext,@gobjectName,1,FALSE,inptr,@iterator,outptr);
 if (ccode <> 0) then
 begin
               if (ccode = -603) then
       begin
               ShowMessage('-603: The Requested attribute could not be found!');
       end
       else if (ccode = -601) then
               ShowMessage('-601: The Requested object could not be read!')
       else
         ShowMessage('NWDSRead Failed'+#13+'Error Code: '+inttostr(ccode));
       NWDSFreeBuf(inptr);
       NWDSFreeBuf(outptr);
       Screen.Cursor := crDefault;
       exit;
  end;
  ccode:=NWDSGetAttrCount(dContext,outptr,@attrCount);
  if (ccode <> 0)then
  begin
        ShowMessage('NWDSGetAttrCount Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        exit;
  end;
  for i:=1 to attrcount do
  begin
     ccode:=NWDSGetAttrName(dContext,outptr,@attrName,@valCount,@presyntax);
     if (ccode <> 0)then
     begin
       ShowMessage('NWDSGetAttrName Failed'+#13+'Error Code: '+inttostr(ccode));
       Screen.Cursor := crDefault;
       exit;
     end;

     for j:=1 to valcount do
     begin

   { Allocate contiguous memory --
    Note that the attribute value size is computed each time a value
	  is read.  Each attribute may have multiple values and each value
	  may be a different size. }

        ccode := NWDSComputeAttrValSize(dContext, outptr, presyntax, @attrSize);
        if (ccode < 0)then
        begin
          ShowMessage('NWDSComputeAttrValSize Failed'+#13+'Error Code: '+inttostr(ccode));
          NWDSFreeBuf(inptr);
          NWDSFreeBuf(outptr);
          Screen.Cursor := crDefault;
          exit;
        end;
        syntax:=presyntax;

        getmem(attrval, attrsize);

        ccode:=NWDSGetAttrVal(dContext,outptr,syntax,attrval);
           
        if (ccode <> 0)then
        begin
          ShowMessage('NWDSGetAttrVal Failed'+#13+'Error Code: '+inttostr(ccode));
          NWDSFreeBuf(inptr);
          NWDSFreeBuf(outptr);
          Screen.Cursor := crDefault;
          exit;
        end;

        if syntax=23 then {SYN_BACK_LINK}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add(inttostr(Back_Link_t(attrval^).remoteID));
          trim:=strpas(@Back_Link_T(attrval^).objectName^);
          delete(trim,1,4);
          frmValue.mmoValue.Lines.Add(trim);
        end
        else if syntax=7  then {SYN_BOOLEAN}
        begin
          if Boolean_t(attrval^)=1 then
            result:='TRUE'
          else
            result:='FALSE';
        end
        else if syntax=2  then {SYN_CE_STRING}
        begin
          result:=strpas(@CE_string_T(attrval^));
        end
        else if syntax=6  then {SYN_CI_LIST}
        begin
          result:=strpas(@CI_List_T(attrval^).s^);
        end
        else if syntax=3  then {SYN_CI_STRING}
        begin
 	  result:=strpas(@CI_String_T(attrval^));
        end
        else if syntax=20 then {SYN_CLASS_NAME}
        begin
          result:=strpas(@Class_Name_T(attrval^));
        end
        else if syntax=22 then {SYN_COUNTER}
        begin
          result:=inttostr(Counter_T(attrval^));
        end
        else if syntax=1  then {SYN_DIST_NAME}
        begin
          result:=strpas(@DN_T(attrval^));
        end
        else if syntax=14 then {SYN_EMAIL_ADDRESS}
        begin
          result:=strpas(@EMail_Address_T(attrval^).address^);
        end
        else if syntax=11 then {SYN_FAX_NUMBER}
        begin
          result:=strpas(@Fax_Number_T(attrval^).telephoneNumber^);
        end
        else if syntax=26 then {SYN_HOLD}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add(strpas(@Hold_T(attrval^).objectName^));
          frmValue.mmoValue.Lines.Add(inttostr(Hold_T(attrval^).amount));
        end
        else if (syntax=8) or (syntax=27) then {SYN_INTEGER}
        begin
          result:=inttostr(Integer_T(attrval^));
        end
        else if syntax=12 then {SYN_NET_ADDRESS}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add('Address Type: '+inttostr(Net_Address_T(attrval^).addressType));
          frmValue.mmoValue.Lines.Add('Address Length: '+inttostr(Net_Address_T(attrval^).addressLength));
//          frmValue.mmoValue.Lines.Add('Address: '+inttohex(Net_Address_T(attrval^).address^,2));
         end
        else if syntax=5  then {SYN_NU_STRING}
        begin
          result:=strpas(@NU_String_T(attrval^));
        end
        else if syntax=17 then {SYN_OBJECT_ACL}
        begin
          result:='[..]';
          privs:=Object_ACL_T(attrval^).privileges;
          sattrName:=strpas(@Object_ACL_T(attrval^).protectedAttrName^);
          rights:='[';
          if pos('[Entry Rights]',sattrName)<>0 then
          begin
             if(BOOLEAN(privs and DS_ENTRY_BROWSE)) then {privs & 0x01) /* DS_ENTRY_BROWSE */}
                rights:=rights+'B';
             if(BOOLEAN(privs and DS_ENTRY_ADD)) then { privs & 0x02)	/* DS_ENTRY_ADD */}
                rights:=rights+'A';
             if(BOOLEAN(privs and DS_ENTRY_DELETE)) then {privs & 0x04) /* DS_ENTRY_DELETE */}
                rights:=rights+'D';
             if(BOOLEAN(privs and DS_ENTRY_RENAME)) then {privs & 0x08) /* DS_ENTRY_RENAME */}
                rights:=rights+'R';
             if(BOOLEAN(privs and DS_ENTRY_SUPERVISOR)) then {privs & 0x10) /* DS_ENTRY_SUPERVISOR */}
                rights:=rights+'S';
          end
          else
          begin
             if pos('[SMS Rights]',sattrNAme)<>0 then
             begin
                if(BOOLEAN(privs and 1)) then  {DS_SMS_SCAN}
                   rights:=rights+'S';
                if(BOOLEAN(privs and 2)) then {DS_SMS_BACKUP}
                   rights:=rights+'B';
                if(BOOLEAN(privs and 3)) then  {DS_SMS_RESTORE}
                   rights:=rights+'R';
                if(BOOLEAN(privs and 4)) then {DS_SMS_RENAME}
                   rights:=rights+'C';
                if(BOOLEAN(privs and 5)) then {DS_SMS_DELETE}
                   rights:=rights+'D';
                if(BOOLEAN(privs and 6)) then {DS_SMS_ADMIN}
                   rights:=rights+'A';
             end
             else 	{/* Attribute Rights which applies to all others */}
             begin
                if(BOOLEAN(privs and DS_ATTR_COMPARE)) then
                   rights:=rights+'C';
                if(BOOLEAN(privs and DS_ATTR_READ)) then
                   rights:=rights+'R';
                if(BOOLEAN(privs and DS_ATTR_WRITE)) then
                   rights:=rights+'W';
                if(BOOLEAN(privs and DS_ATTR_SELF)) then
                   rights:=rights+'A';
                if(BOOLEAN(privs and DS_ATTR_SUPERVISOR)) then
                   rights:=rights+'S';
             end;
          end;
          frmValue.mmoValue.Lines.Add(strpas(@Object_ACL_T(attrval^).protectedAttrName^)+' '+rights+']');
        {The subjectName is a copy of protectedAttrName?? in Delphi}
       // frmValue.mmoValue.Lines.Add('Subject: '+strpas(@Object_ACL_T(attrval^).subjectName));

        end
        else if syntax=13 then {SYN_OCTET_LIST}
        begin
           result:='SYN_OCTET_LIST is a linked list it is not shown here';
        end
        else if syntax=9  then {SYN_OCTET_STRING}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add('Length: '+inttostr(Octet_String_T(attrval^).length*8)+' bits');
          frmValue.mmoValue.lines.Add('Data: 0x'+inttohex(uint8(@Octet_String_T(attrval^).data^),1));
          frmValue.mmoValue.lines.Add('Encoded Data not shown');

        end
        else if syntax=15 then {SYN_PATH}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add('Name Space Type: '+inttostr(Path_T(attrval^).nameSpaceType));
          frmValue.mmoValue.Lines.Add('Path: '+strpas(@Path_T(attrval^).path^));
          frmValue.mmoValue.Lines.Add('Volume Name: '+strpas(@Path_T(attrval^).volumeName^));
        end
        else if syntax=18 then {SYN_PO_ADDRSS}
        begin

          result:=strpas(@Postal_Address_T(attrval^));
        end
        else if syntax=4  then {SYN_PR_STRING}
        begin
          result:=strpas(@PR_String_T(attrval));
        end
        else if syntax=16 then {SYN_REPLICA_POINTER}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add('Server Name: '+strpas(@Replica_Pointer_T(attrval^).serverName^));
          frmValue.mmoValue.Lines.Add('Replica Type: '+inttostr(Replica_Pointer_T(attrval^).replicaType));
          frmValue.mmoValue.Lines.Add('Replica Number: '+inttostr(Replica_Pointer_T(attrval^).replicaNumber));
          frmValue.mmoValue.Lines.Add('Count: '+inttostr(Replica_Pointer_T(attrval^).count));
//          test:=Replica_Pointer_T(attrval^).replicaAddressHint[0];
//          frmValue.mmoValue.Lines.Add('Replica Address Hint: '+inttohex(test[0],2));
//          frmValue.mmoValue.Lines.Add('Replica Address Hint: '+strpas(Replica_Pointer_T(attrval^).replicaAddressHint[0]));
        end
        else if syntax=21 then {SYN_STREAM}
        begin
          result:='[..]';
          ccode := NWDSOpenStream(dContext, @gobjectName, @attrname, NWDS_FLAGs(1), FileHandle);
          if(ccode=0) then
          begin
               _lread(FileHandle,@tmpBuffer, 200);
               frmValue.mmoValue.SetTextBuf(@tmpBuffer);
          end
          else
            ShowMessage('NWDSOpenStream returned: '+inttostr(ccode));
          Fileclose(FileHandle);
        end
        else if syntax=10 then {SYN_TEL_NUMBER}
        begin
          result:=strpas(@TN_String_T(attrval^));
        end
        else if (syntax=24) then {SYN_TIME}
        begin
          seconds:=Integer_T(attrval^);
          days:=25569+(seconds/86400)-0.25; {There are 86400 sec in a day}
          result:=FormatDateTime('dddd m/d/yy ttt',days);
        end
        else if syntax=19 then {SYN_TIMESTAMP}
        begin
          result:='[..]';
          seconds:=NWDS_TimeStamp_T(attrval^).wholeSeconds;
          days:=25569+(seconds/86400)-0.25; {There are 86400 sec in a day}
          frmValue.mmoValue.Lines.Add(FormatDateTime('dddd mmmm, d, yyyy tt',days));
          frmValue.mmoValue.Lines.Add('Event Id: '+inttostr(NWDS_TimeStamp_T(attrval^).eventID));
        end
        else if syntax=25 then {SYN_TYPED_NAME}
        begin
          result:='[..]';
          frmValue.mmoValue.Lines.Add('Object Name: '+strpas(@Typed_Name_T(attrval^).objectName^));
          frmValue.mmoValue.Lines.Add('Level: '+inttostr(Typed_Name_T(attrval^).level));
          frmValue.mmoValue.Lines.Add('Interval: '+inttostr(Typed_Name_T(attrval^).interval));
        end
        else {SYN_UNKNOWN}
        begin
          ShowMessage('Syntax is Unknown'+inttostr(syntax));
          exit;
        end;
        FreeMem(attrval, attrsize);
     end;
  	NWDSFreeBuf(inptr);
	NWDSFreeBuf(outptr);
     if frmValue.mmoValue.Lines.Count>21 then
      frmValue.mmoValue.ScrollBars:=ssBoth;
  end;
  globalsyntax:=syntax;
end;

{This procedure shows how to use NWLOGIN to login to a server, This is a bindery
login, it will work with many 4.x servers if their bindery context is set to the
users current context}
procedure TForm1.LogMein;
var
  hexcode:string;
  ccode: NWCCODE;
  pass:array [0..128] of char;
  objname:array [0..50] of char;
begin
   strpcopy(objname, LoginForm.Edit1.Text);
   strpcopy(pass, uppercase(LoginForm.Edit2.Text));
   loginform.Edit2.Text:='';
   loginform.close;
     ccode:=nwlogintofileserver(connHandle, @objname, OT_USER, @pass);
     if ccode <>0 then
     begin
      hexcode:=inttohex(ccode,4);
      if hexcode='89C5' then
        ShowMessage('Intruder Lockout')
      else if hexcode='89FF' then
        ShowMessage('Wrong Password')
      else if hexcode='89DF' then
        ShowMessage('Password Expired')
      else
        ShowMessage('NWLogintoFileServer Failed: '+inttohex(ccode,4));
        exit;
     end;
end;

procedure TForm1.sgdSetDblClick(Sender: TObject);
var
  setCommandname: String;
  currentvalue: String;
  category: integer;
begin
  setCommandName:=sgdSet.Cells[0,sgdSet.Row];
  Category:=strtoint(sgdSet.Cells[2,sgdSet.Row]);
  CurrentValue:=sgdSet.Cells[1,sgdSet.Row];
  case category of
   1,6:
       begin
         SetForm1.Show;
         SetForm1.Label1.Caption:=setCommandname;
         if currentValue='ON' then
           SetForm1.rbnOn.Checked:=True
         else
           SetForm1.rbnOFF.Checked:=True;
         SetForm1.Label2.Caption:='Category: '+inttostr(category);
         SetForm1.edtSetstr.Visible:=False;
         SetForm1.rgpset.Visible:=True;
         SetForm1.rbnOn.Visible:=True;
         SetForm1.rbnOFF.Visible:=True;
       end;
   0,3,5:
       begin
         SetForm1.Show;
         SetForm1.Label1.Caption:=setCommandname;
         SetForm1.edtSetStr.Text:=currentValue;
         SetForm1.Label2.Caption:='Category: '+inttostr(category);
         SetForm1.edtSetstr.Visible:=True;
         SetForm1.rgpset.Visible:=False;
         SetForm1.rbnOn.Visible:=False;
         SetForm1.rbnOFF.Visible:=False;
       end;
   2,4:
       begin
         SetForm2.Show;
         SetForm2.Label1.Caption:=setCommandname;
         SetForm2.SpinEdit1.Value:=strtoint(copy(currentValue,0, pos('Days',currentValue)-2));
         SetForm2.SpinEdit2.Value:=strtoint(copy(currentValue,pos('Days',currentValue)+5,pos(' Hrs',currentValue)-(pos('Days', currentValue)+5)));
         SetForm2.SpinEdit3.Value:=strtoint(copy(currentValue,pos('Hrs',currentValue)+4,pos(' Min',currentValue)-(pos('Hrs', currentValue)+4)));
         SetForm2.SpinEdit4.Value:=strtoint(copy(currentValue,pos('Min',currentValue)+4,pos(' Sec',currentValue)-(pos('Min', currentValue)+4)));
         SetForm2.SpinEdit5.Value:=strtoint(copy(currentValue,pos('Sec',currentValue)+4,pos(' Ticks',currentValue)-(pos('Sec', currentValue)+4)));
         SetForm2.Label6.Caption:='Category: '+inttostr(category);
       end
       else
         ShowMessage(inttostr(category));
  end;
end;

procedure TForm1.TrackBarChange(Sender: TObject);
begin
  Timer1.Interval:=TrackBar.Position*1000;
  lblTTimer.Caption:='Timer Interval ('+inttostr(TrackBar.Position)+' Seconds)';
end;

procedure TForm1.LogInToTree;
var
  pass:array [0..228] of char;
  objname:array [0..200] of char;
begin
  strpcopy(objname, uppercase(LoginForm.Edit1.Text));

  strpcopy(pass, uppercase(LoginForm.Edit2.Text));

  dcode:=NWDSLogin(dContext,0,@objname,@pass,0);
  if (dcode<0) then
  begin
    if dcode=-669 then
      ShowMessage('Bad Password')
    else
      ShowMessage('NWDSLogin Failed: '+inttostr(dcode));
    exit;
  end;

  if (dcode=34970) then
  begin
    ShowMessage('The Object ID you entered could not be found'+#13+'You need to enter a correct distinguished name for your user object'+#13+'ie Admin.ACME');
    exit;
  end;

  loginform.Edit2.Text:='';
  loginform.close;

  dcode:=NWDSWhoAmI(dContext,@objName);
  if (dcode<>0) then
  begin
    ShowMessage('NWDSWhoAmI Failed: '+inttostr(dcode));
  end;

  if objName='[Public]' then
  begin
    ShowMessage('Login Failed'+#13+'You are authenticated as [Public]');
  end;

  TreeForm.tvwDS.Items.Clear;
  TreeForm.getDSList;
end;

procedure TForm1.populateStats;
var
  i : Integer;
  Item : String;
begin
  sgdStats.RowCount:=lstStats.Items.Count+1;
  for i:=0 to lstStats.Items.Count-1 do
  begin
    Item:=lstStats.Items[i];
    sgdStats.Cells[0,i+1]:=Copy(Item,0,pos('|',Item)-1);
    sgdStats.Cells[1,i+1]:=Copy(Item,pos('|',Item)+1,100);
  end;
  lstStats.Items.Clear;
end;

Function TForm1.GetPathFromDirEntry(volume: string; DirEntry : Integer): String;
var
  dirHandle : NWDIR_HANDLE;
  path : Array [0..100] of char;
  tmpdirentry : DIR_ENTRY;
  R,R2 : TSearchRec;
  K,K2 : Integer;
begin
  try
  result:='';
  if mapadrive(edtServer.Text,Volume)<>0 then
    exit;
  K := FindFirst(driveletter+':\*.*', faDirectory, R);
  while K = 0 do
  begin
    if DirectoryExists(driveletter+':\'+R.Name) then
    begin
      strpcopy(path, volume+R.Name);
      ccode := NWAllocTemporaryDirectoryHandle(connHandle,0,@path,dirHandle,nil);
      if (ccode<>0) then
      begin
        Screen.Cursor:=crDefault;
        exit;
      end;
      ccode := NWConvertPathToDirEntry(connHandle,dirHandle,@path,tmpdirentry);
      if (ccode<>0) then
      begin
        exit;
      end;
      if (tmpdirentry.direntry=DirEntry) then
      begin
        result:=path;
        break;
      end;
      {Second Iteration}
        K2 := FindFirst(driveletter+':\'+R.Name+'\*.*', faDirectory, R2);
        while K2 = 0 do
        begin
          if DirectoryExists(driveletter+':\'+R.Name+'\'+R2.Name) then
          begin
            strpcopy(path, volume+R.Name+'\'+R2.Name);
            ccode := NWAllocTemporaryDirectoryHandle(connHandle,0,@path,dirHandle,nil);
            if (ccode<>0) then
            begin
              Screen.Cursor:=crDefault;
              exit;
            end;
            ccode := NWConvertPathToDirEntry(connHandle,dirHandle,@path,tmpdirentry);
            if (ccode<>0) then
            begin
              Screen.Cursor:=crDefault;
              exit;
            end;
            if (tmpdirentry.direntry=DirEntry) then
            begin
              result:=path;
              break;
            end;
           end;
          K2 := FindNext(R2);
        end;
          FindClose(R2);
       {End Second Iteration}
    end;
    K := FindNext(R);
  end;
    FindClose(R);
  if (result='') then
    result:=volume+'...';
  finally
    deletedrive;
  end;
end;

procedure TForm1.sgdFilesClick(Sender: TObject);
var
  DirEntry : Integer;
  VolName : Array [0..20] of char;
  vol : String;
begin
  if (sgdfiles.Cells[0,sgdFiles.Row]='') then
    Exit;
  Screen.Cursor:=crHourGlass;    
  lblFileName.Caption:=sgdFiles.Cells[0,sgdFiles.Row];
  lblFileOwner.Caption:=sgdFiles.Cells[1,sgdFiles.Row];
  lblFileNS.Caption:=sgdFiles.Cells[2,sgdFiles.Row];

  ccode := NWGetVolumeName(connHandle,strtoint(sgdFiles.Cells[3,sgdFiles.Row]),@VolName);
  if (ccode<>0) then
  begin
    ShowMessage('NWGetVOlumeName Failed: '+inttohex(ccode,2));
  end;

  lblVolume.Caption:=strpas(VolName);
  DirEntry:=strtoint(sgdFiles.Cells[4,sgdFiles.Row]);
  vol:=strpas(volName)+':';
  lblDir.Caption:=GetPathFromDirEntry(Vol, DirEntry);
  Screen.Cursor:=CrDefault;
end;

procedure TForm1.AddDSObject;
var
   inbuf : ^Buf_T;
   inptr : pointer;
   row : Integer;
   value: Array [0..500] of char;
   ValueInt : Integer;
   syntax : Integer;
   nContext:array [0..MAX_DN_CHARS] of char;
   IsUser:Boolean;
//   attrval : Pointer;
begin
  screen.cursor:=crHourGlass;
  dcode := NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @inbuf);
  if (dcode <> 0)then
  begin
        ShowMessage('NWDSAllocBuf Failed'+#13+'Error Code: '+inttostr(dcode));
        Screen.Cursor := crDefault;
        exit;
  end;

  inptr := inBuf;

  dcode := NWDSInitBuf(dContext,DSV_ADD_ENTRY,inptr);
  if (dcode <> 0)then
  begin
        ShowMessage('NWDSInitBuf Failed'+#13+'Error Code: '+inttostr(dcode));
        Screen.Cursor := crDefault;
        exit;
  end;

  IsUser:=False;

//This for loop inputs all Attributes and their values into the input buffer;
  for row:=1 to attribform.sgdAttr.RowCount do
  begin
    if (attribform.sgdAttr.Cells[2,row]<>'') and (attribform.sgdAttr.Cells[2,row]<>'[..]') then
    begin
      if pos('(',attribform.sgdAttr.Cells[0,row]) >0 then
          attribform.sgdAttr.Cells[0,row]:=Copy(attribform.sgdAttr.Cells[0,row],0,pos('(',attribform.sgdAttr.Cells[0,row])-2);
      if pos('*',attribform.sgdAttr.Cells[0,row]) >0 then
          attribform.sgdAttr.Cells[0,row]:=Copy(attribform.sgdAttr.Cells[0,row],2,500);

      if (attribform.sgdAttr.Cells[0,row]='Object Class') and (attribform.sgdAttr.Cells[2,row]='User') then
         ISUser:=True;

      strpcopy(value,attribform.sgdAttr.Cells[0,row]);
      dcode := NWDSPutAttrName(dContext, inptr, @value);
      if (dcode <> 0)then
      begin
            ShowMessage('NWDSPutAttrName Failed'+#13+'Error Code: '+inttostr(dcode));
            Screen.Cursor := crDefault;
            exit;
      end;

      syntax := strtoint(attribform.sgdAttr.Cells[1,row]);
      if (syntax=7) or (syntax=8) or (syntax=22) then
      begin
        valueint:=strtoint(attribform.sgdAttr.Cells[2,row]);
        dcode := NWDSPutAttrVal(dContext, inptr, syntax, @valueint);
        if (dcode <> 0)then
        begin
              ShowMessage('NWDSPutAttrVal Failed'+#13+'Error Code: '+inttostr(dcode));
              Screen.Cursor := crDefault;
              exit;
        end;
      end
      else if (syntax=14) then
      begin
        ShowMessage('Email Address not available this version');
   {     getmem(attrval, 400);
        strpcopy(@EMail_Address_T(attrval^).address,attribform.sgdAttr.Cells[2,row]);
        dcode := NWDSPutAttrVal(dContext, inptr, syntax, attrval);
        FreeMem(attrVal);
        if (dcode <> 0)then
        begin
              ShowMessage('NWDSPutAttrVal Failed'+#13+'Error Code: '+inttostr(dcode));
              Screen.Cursor := crDefault;
              exit;
        end;}
      end
      else
      begin
        strpcopy(value,attribform.sgdAttr.Cells[2,row]);
        dcode := NWDSPutAttrVal(dContext, inptr, syntax, @value);
        if (dcode <> 0)then
        begin
              ShowMessage('NWDSPutAttrVal Failed'+#13+'Error Code: '+inttostr(dcode));
              Screen.Cursor := crDefault;
              exit;
        end;
      end;
    end;
  end;

  if (attribform.edtname.Text='') then
  begin
    ShowMessage('Your must enter an Object Name');
    Screen.Cursor := crDefault;
    exit;
  end;

  dcode:=NWDSGetContext(dContext,DCK_NAME_CONTEXT,@nContext);
  if (dcode<0)then
  begin
     Screen.Cursor := crDefault;
     ShowMessage('NWDSGetContext Failed'+#13+'Error Code: '+inttostr(dcode));
     NWDSFreeContext(dContext);
     exit;
  end;

//Now that the input buffer is full, add the object to the tree;
  if TreeForm.edtContext.Text='' then
    strpcopy(Value, attribform.edtName.Text)
  else
    strpcopy(Value, attribform.edtName.Text+'.'+TreeForm.edtContext.text);
  dcode := NWDSAddObject(dContext, @Value, nil, FALSE, inptr);
  if (dcode <> 0)then
  begin
        if dcode=-672 then
          ShowMessage('You do not have sufficient rights to add this object')
        else if dcode=-611 then
          ShowMessage('Improper Containment')
        else if dcode=-613 then
          ShowMessage('Syntax Violation - One of the attribute values is incorrect (ie ON in a boolean field')
        else if dcode=-609 then
          ShowMessage('Missing a mandatory Field')
        else if dcode=-606 then
          ShowMessage('Entry already exists')
        else
          ShowMessage('NWDSAddObject Failed'+#13+'Error Code: '+inttostr(dcode));
        Screen.Cursor := crDefault;
        exit;
  end;

  if IsUser=True then
  begin
     PassForm.lblUser.Caption:=strpas(Value);
     PassForm.Show;
  end;

//Some buffers may be quite large, need to free the memory
  dcode := NWDSFreeBuf(inptr);
  if (dcode <> 0)then
  begin
        ShowMessage('NWDSFreeBuf Failed'+#13+'Error Code: '+inttostr(dcode));
        Screen.Cursor := crDefault;
        exit;
  end;
  Screen.Cursor := crDefault;
  attribform.close;
  TreeForm.tvwDS.Items.Clear;
  TreeForm.getdslist;
end;

procedure TForm1.bbtMapClick(Sender: TObject);
begin
  mapForm.Show;
end;

procedure TForm1.bbtDistClick(Sender: TObject);
begin
  DistForm:=TDistForm.Create(Application);
  DistForm.Show;
  DistForm.Update;
end;

procedure TForm1.lvwNLMsDblClick(Sender: TObject);
begin
  getNLMInfo;
end;

procedure TForm1.bbtReLoadDSClick(Sender: TObject);
var
  servername : Array [0..100] of char;
begin
  if MessageDlg('Are you sure you want to reload DS on '+edtServer.Text+'?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
     Exit;

  strpcopy(servername,edtServer.Text);
  Screen.Cursor:=crHourGlass;
  dcode := NWDSReloadDS(dContext,@servername);
  Screen.Cursor:=CrDefault;
  if (dcode<0) then
    ShowMessage('NWDSReloadDS Failed: '+inttostr(dcode))
  else
    MessageDlg('DS was successfully reloaded on '+edtServer.Text,mtInformation,[mbOk],0);
end;

procedure TForm1.bbtSendClick(Sender: TObject);
var
  Msg : Array [0..255] of char;
  connNum : Integer;
begin

  strpcopy(msg,InputBox('Message','Enter a Message to Send',''));
  connNum:=strtoint(lblConnNum.Caption);

  ccode:=NWSendBroadcastMessage(connHandle,@msg,1,@connNum,nil);
end;

procedure TForm1.bbtTreeClick(Sender: TObject);
begin
  TreeForm.tvwDS.Items.Clear;
  TreeForm.Show;
end;

procedure TForm1.rbnNameClick(Sender: TObject);
begin
  GetConnList;
end;

procedure TForm1.rbnNodeClick(Sender: TObject);
begin
  GetConnList;
end;

procedure TForm1.DirectoryListBox1Enter(Sender: TObject);
begin
  MapADrive(edtServer.Text, 'SYS:');
end;

procedure TForm1.DirectoryListBox1Exit(Sender: TObject);
begin
  DeleteDrive;
end;

procedure TForm1.bbtExecuteClick(Sender: TObject);
var
  FileName : Array [0..200] of char;
  F2 : Textfile;
  Command : String;
begin

 //First Check that there is a Console command to send
 Command:=inputbox('Console Command','Enter a non-Interactive Console Command','');
 if (Command='') then
 begin
   exit;
 end;

 if (Uppercase(Command)='MODULES') then
 begin
   ShowMessage('MODULES is not allowed since it requires user input from the console');
   exit;
 end;

 if (UpperCase(Command)='CONFIG') then
 begin
   ShowMessage('CONFIG is not allowed since it requires user input from the console');
   exit;
 end;

 if (UpperCase(Command)='SET') then
 begin
   ShowMessage('CONFIG is not allowed since it requires user input from the console');
   exit;
 end;
   //Start Executing
  screen.cursor:=crHourGlass;
  if Form1.mapadrive(edtServer.Text,'SYS:') <> 0 then
  begin
      ShowMessage('Failed to map a drive to '+edtServer.Text);
      screen.cursor:=CrDefault;
      Exit;
  end
  else
  begin
    AssignFile(F2, driveletter+':\TEMP$$.NCF');
    ReWrite(F2);
    WriteLn(F2, Command);
    CloseFile(F2);
    strpcopy(FileName, 'SYS:TEMP$$.NCF');
    ccode := NWSMExecuteNCFFile(TmpConnHandle,@FileName);
    if (ccode <> 0 ) then
    begin
        ShowMessage('Failed to Execute '+Command+' on '+edtServer.Text+': 0x'+inttohex(ccode,2));
    end
    else
    begin
        ShowMessage('Executed '+Command+' on '+edtServer.Text);
    end;
    DeleteFile(driveletter+':\TEMP$$.NCF');
  end;
  DeleteDrive;
  screen.cursor:=crDefault;
end;

procedure TForm1.Exit2Click(Sender: TObject);
begin
  AboutForm.ShowModal;
end;

procedure TForm1.bbtHelpClick(Sender: TObject);
begin
  Application.HelpJump('');
end;

procedure TForm1.HelpTopics1Click(Sender: TObject);
begin
  Application.HelpJump('');
end;

procedure TForm1.sgdNCFClick(Sender: TObject);
var
  SelectItem: String;
begin
  if sgdNCF.Row=0 then
    Exit;
  Selectitem:=sgdNCF.Cells[0,sgdNCF.Row];
  if SelectItem='' then
    Exit;
  if (pos('.LOG',SelectItem)>0) or (pos('.ERR',SelectItem)>0)or (pos('.CFG',SelectItem)>0) then
  begin
     mmoFileContents.ReadOnly:=True;
     lblTFileContents.Caption:='File Contents (Read Only)';
  end
  else
  begin
     mmoFileContents.ReadOnly:=False;
     lblTFileContents.Caption:='File Contents';
  end;
  bbtDeleteFile.Enabled:=True;
  if mapadrive(edtServer.Text,'SYS:')<>0 then
    exit;
  try
  Screen.Cursor:=CrHourGlass;
  if fileexists(driveletter+':\'+SelectItem) then
  begin
     mmoFileContents.Visible:=False;
     mmoFileContents.Lines.Clear;
     mmoFileContents.Lines.LoadFromFile(driveletter+':\'+SelectItem);
     SaveFileName:=':\'+SelectItem;
  end;
  finally
  deletedrive;
  Screen.Cursor:=CrDefault;
  mmoFileContents.Visible:=True;
  end;
end;

procedure TForm1.bbtLoginClick(Sender: TObject);
begin
  if lblLogin.Caption<>'' then
  begin
    if MessageDlg('You are already logged in to this server as '+lblLogin.Caption+', you will lose any mapped drives to this server.'+#13+'Do you want to login to '+servername+' as a different user?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
      Exit;
  end;
  ccode:=NWLogoutFromFileServer(connHandle);
  if ccode<0 then
  begin
    ShowMessage('NWLogoutFromFileServer Failed: '+inttohex(ccode,2));
  end;
  loginform.lblServer.Caption:=edtServer.Text;
  loginform.Caption:='NetWare Bindery Login';
  loginform.show;
end;

procedure TForm1.bbtRconsoleClick(Sender: TObject);
var
 nullstring1, nullstring2, nullstring3 : Array [0..255] of char;
 errinfo, errinfo2, password : String;
 errcode, i : Integer;
 Found : Boolean;
begin
  If NLMTab.TabVisible=False then
    bbtAnalyzeClick(bbtRconsole);
  Found:=False;
  if NLMTab.TabVisible=True then
  begin
    //First Check to see if rspx.nlm and remote.nlm are loaded
    for i:=0 to lvwNLMs.Items.Count-1 do
    begin
      if lvwNLMS.Items[i].Caption='REMOTE.NLM' then
        Found:=True;
    end;
    if Found=False then
    begin
        if MessageDlg('REMOTE.NLM is not loaded.  This NLM is required for RCONSOLE.EXE to function.'+#13+'Do you want to load REMOTE.NLM?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
          Exit
        else
        begin
          Password:=Inputbox('RConsole Password','Enter the rconsole password','');
          LoadNLM('REMOTE '+password);
          ShowMessage('REMOTE.NLM was loaded with the password of '+password);
        end;
    end;
    Found:=False;
    for i:=0 to lvwNLMs.Items.Count-1 do
    begin
      if lvwNLMS.Items[i].Caption='RSPX.NLM' then
        Found:=True;
    end;
    if Found=False then
    begin
        if MessageDlg('RSPX.NLM is not loaded.  This NLM is required for RCONSOLE.EXE to function.'+#13+'Do you want to load RSPX.NLM?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
          Exit
        else
        begin
          LoadNLM('RSPX');
          ShowMessage('RSPX.NLM was loaded');
        end;
    end;
  end;
  MapADrive(edtServer.Text,'SYS:');
  strpcopy(nullstring1,driveletter+':\PUBLIC\RCONSOLE.EXE');
  strpcopy(nullstring2,edtServer.Text);
  strpcopy(nullstring3,driveletter+':\PUBLIC');
  errcode:=ShellExecute(0, 'Open', nullstring1, nullstring2, nullstring3, SW_SHOWNORMAL);
  if ((errcode<32) and (errcode>0)) then
  begin
   errinfo:='A few error descriptions are:'+#13+'0 System was out of memory or executible file was corrupt';
   errinfo2:=#13+'2  File was not found'+#13+'3  Path was not found'+#13+'8  There was insufficient memory';
   ShowMessage('Could not open RConsole, error code is '+IntToStr(errcode)+#13#13+errinfo+errinfo2);
  end;
  sleep(4000); //Need time to load rconsole;
  DeleteDrive;
end;

end.
