{****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warrantiesF with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:   
**
**   Desc: This application shows how to use several API calls to allow users to
**   create and delete drive mappings.  It also provides a listing of all servers on the
**   network.  All volumes on a specific server are also listed through this program.
**   The program lists all current active connections.  All connection Handles
**   are obtained through the new connection model.  Drives are mapped by dragging
**   and dropping server items on unmapped drives.  The program will not remap a drive
**   without the user first deleting the drive mapping. If the user is not authenticated
**   to a server the program will allow the user to login to the server using NWLOGIN.
**
**
**   Programmers:
**   Ini   Who                Firm
**   ------------------------------------------------------------------
**   SMW   Steven M. Wootton  Novell Developer Support.
**
**   History:
**
**   ------------------------------------------------------------------
**   09-05-96   SMW   First code.
*}

unit map;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, FileCtrl, StdCtrls, Buttons, vol, login, mainunit, nwinc32;

type
  Tmapform = class(TForm)
    ListBox1: TListBox;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    ListBox2: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    ListBox3: TListBox;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Edit1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBox1EndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure ListBox2DblClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure ListBox3Click(Sender: TObject);
  private
    { Private declarations }
  public
    function inttochar(i:integer): char;
    procedure updatelist;
    procedure getserverlist;
    procedure getvolumes;
    procedure mapdrive;
    procedure login;
    { Public declarations }
  end;

var
  mapform: Tmapform;
  servername: string;
  thevol:string;
  drive_num: integer;
  conn:NWCONN_HANDLE;

implementation

{$R *.DFM}


{This procedure initializes the APIs and the populates then calls getserverlist and updatelist}
procedure Tmapform.FormCreate(Sender: TObject);
begin
  getserverlist;
  updatelist;
end;

{This procedure is called when the exit button is clicked}
procedure Tmapform.BitBtn3Click(Sender: TObject);
begin
  Application.Terminate;
end;

{This fuction correlates the listbox line number to a drive letter}
function Tmapform.inttochar(i: integer): char;
begin
  if i=1 then
    result:='A'
  else if i=2 then
    result:='B'
  else if i=3 then
    result:='C'
  else if i=4 then
    result:='D'
  else if i=5 then
    result:='E'
  else if i=6 then
    result:='F'
  else if i=7 then
    result:='G'
  else if i=8 then
    result:='H'
  else if i=9 then
    result:='I'
  else if i=10 then
    result:='J'
  else if i=11 then
    result:='K'
  else if i=12 then
    result:='L'
  else if i=13 then
    result:='M'
  else if i=14 then
    result:='N'
  else if i=15 then
    result:='O'
  else if i=16 then
    result:='P'
  else if i=17 then
    result:='Q'
  else if i=18 then
    result:='R'
  else if i=19 then
    result:='S'
  else if i=20 then
    result:='T'
  else if i=21 then
    result:='U'
  else if i=22 then
    result:='V'
  else if i=23 then
    result:='W'
  else if i=24 then
    result:='X'
  else if i=25 then
    result:='Y'
  else if i=26 then
    result:='Z'
  end;

{This procedure deletes a selected drive mapping}
procedure Tmapform.BitBtn2Click(Sender: TObject);
var
  theline: string;
  ccode: NWCCODE;
begin
  if listbox1.itemindex < 0 then
  begin
    ShowMessage('Please select a drive');
    exit;
  end;
  theline:=ListBox1.items[listbox1.itemindex];
  ShowMessage('Deleting: '+theline);
  ccode := NWDeleteDriveBase(
          { > drive number    }  listbox1.itemindex+1,
          { NOVELL use only 0 }  0 );
  if (ccode<>0)then
  begin
     ShowMessage('NWDeleteDriveBase: failed'+inttostr(ccode));
     exit;
  end;
  updatelist;
end;

{This procedure uses the bindery to get all available servers on the network.
It uses the new connection model to get the default connection}
procedure Tmapform.getserverlist;
var
  ccode: NWCCODE;
  conn: NWCONN_HANDLE;
  count: Integer;
  searchstring:array [0..2] of char;
  server: array [0..250] of char;
 	id: nuint32;
  connref: nuint32;
begin
	ccode := NWCCGetPrimConnRef(@connref);
	if (ccode<>0) then
	begin
     if inttohex(ccode,2)='8847' then
     begin
       ShowMessage('You do not have a primary connection established');
       Application.Terminate;
     end
     else
		  ShowMessage('NWGetPrimConnRef returned '+inttohex(ccode,2));
     Application.Terminate;
		exit;
	end;

  ccode:=nwccopenconnbyref(connref, NWCC_OPEN_UNLICENSED, 0, @conn);
	if (ccode<>0) then
	begin
		ShowMessage('NWccopenconnbyref returned '+inttohex(ccode,2));
		exit;
	end;

	id := -1;
	count := 0;
  strcopy(searchstring, '*');

	while (ccode = 0) do
	begin
     application.processmessages;
		ccode := NWScanObject (
        {connection handle}             conn,
			{Search string wildcard}        @searchstring,
			{object type}                   {OT_WILD,}OT_FILE_SERVER,
			{ Points to the last object ID }@id,
			{the object name}               @server,
			{@objtype,}                     nil,
			{@hasPropertiesFlag,}           nil,
			{@objFlags,}                    nil,
			{@objSecurity);}                nil);

		if (ccode=0)then
		begin
        ListBox2.Items.Add(strpas(server));
			inc(count);
		end;
	end;
	Label1.Caption:=inttostr(count)+' Servers';

end;

{This procedure gets the current mappings for the client and the current active
connections.  This procedure gets called whenever a drive mapping has changed,
or the refresh button was selected}
procedure Tmapform.updatelist;
var
  ccode:NWCCODE;
  i, status: Integer;
  conn:NWCONN_HANDLE;
  rootpath:array [0..256] of char;
  relativePath: array [0..256] of char;
  driveltr: string;
  scanIterator:nuint32;
  ecode, rcode: NWRCODE;
  connref: nuint32;
  ConnInfo:NWCCConnInfo;

begin
  {Get active connection list}
  ListBox3.Items.Clear;
  scanIterator:=0;
  ecode:=0;
  while ecode=0 do
  begin
    ecode:=NWCCScanConnRefs(@scanIterator, @connRef);
    NWCCOpenConnByRef(connRef,NWCC_OPEN_LICENSED,NULL,@Conn);
    ccode:= NWCCGetAllConnInfo(conn,NWCC_INFO_VERSION,@ConnInfo);
    if not (ccode=0)then
      ShowMessage('NWCCOpenConnByRef Failed!'+#13+'Error Code: '+inttostr(ccode));
    if ecode=0 then
      listbox3.items.add(strpas(ConnInfo.servername));
    NWCCCloseConn(conn);
  end;

  {get the current drive status for A..Z}
  ListBox1.items.clear;
  for i:=1 to 26 do
  begin
    ccode := NWGetDriveStatus(
      { > drive Number    }  i,
      { > path format     }  NW_FORMAT_SERVER_VOLUME,
      { < bitmask pointer }  @status,
      { < conn Handle     }  conn,
      { < root path       }  @rootPath,
      { < relative path   }  @relativePath,
      { < full path       }  nil);
    if (ccode<0)then
    begin
       ShowMessage('NWGetDriveStatus Failed'+#13+'Error Code: '+inttostr(ccode));
       exit;
    end;
    driveltr:=inttochar(i);
    Listbox1.items.add(driveltr+': '+strpas(rootpath));
  end;
end;

{This procedure is required for a control to accept a dragged item from another
control}
procedure Tmapform.Edit1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
Accept:=True;
end;

{Same as above}
procedure Tmapform.ListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
if (Source is TListBox) then
  Accept:=True;
end;

{Use this procedure for the OnDragDrop Event.  This procedure determines by the
Y coordinate which drive is to recieve the new drive mapping.  There are 16
pixels per listbox line.}
procedure Tmapform.ListBox1EndDrag(Sender, Target: TObject; X, Y: Integer);
begin
  if Target = nil then
  begin
    ShowMessage('Rejected');
  end;
  if Y <=16 then
    drive_num:=1
  else if Y <=32 then
    drive_num:=2
  else if Y <=48 then
    drive_num:=3
  else if Y <=64 then
    drive_num:=4
  else if Y <=80 then
    drive_num:=5
  else if Y <=96 then
    drive_num:=6
  else if Y <=112 then
    drive_num:=7
  else if Y <=128 then
    drive_num:=8
  else if Y <=144 then
    drive_num:=9
  else if Y <=160 then
    drive_num:=10
  else if Y <=176 then
    drive_num:=11
  else if Y <=192 then
    drive_num:=12
  else if Y <=208 then
    drive_num:=13
  else if Y <=224 then
    drive_num:=14
  else if Y <=240 then
    drive_num:=15
  else if Y <=256 then
    drive_num:=16
  else if Y <=272 then
    drive_num:=17
  else if Y <=288 then
    drive_num:=18
  else if Y <=304 then
    drive_num:=19
  else if Y <=320 then
    drive_num:=20
  else if Y <=336 then
    drive_num:=21
  else if Y <=352 then
    drive_num:=22
  else if Y <=368 then
    drive_num:=23
  else if Y <=384 then
    drive_num:=24
  else if Y <=400 then
    drive_num:=25
  else if Y <=416 then
    drive_num:=26
  else
  begin
    ShowMessage('Drag drop out of area');
    exit;
  end;
  if ListBox2.itemindex > 0 then
    servername:=ListBox2.Items[ListBox2.Itemindex]
  else
    servername:=ListBox3.Items[ListBox3.ItemIndex];
  getvolumes;
end;

procedure Tmapform.ListBox2DblClick(Sender: TObject);
begin
  getvolumes;
end;

{This procedure creates the new drive mapping}
procedure Tmapform.MapDrive;
var
  rcode: NWRCODE;
  ccode: NWCCODE;
  upr_ans: array [0..200] of char;
  server:array [0..50] of char;
  volname:array [0..50] of char;
  dirpath:array [0..100] of char;
  conn2: NWCONN_HANDLE;
  hexcode: string;
begin
   strpcopy(@upr_ans, servername+'\'+thevol+':\:');
   ccode := NWParsePath(
           { > pointer to path                         }  @upr_ans,
           { < pointer to server name 48 char optional }  @server,
           { < pointer to conn handle                  }  conn2,
           { < pointer to volume name 17 char optional }  @volName,
           { < pointer to directory  256 char optional }  @dirPath);
   if ccode<>0 then
   begin
      showmessage('NWParsePath failed '+inttohex(ccode,4));
      exit;
   end;
      ccode := NWSetDriveBase(
            { > drive Number    }  drive_num,
            { > conn Handle     }  conn,
            { > directory handle}  0,
            { > directory path  }  @volname,
            { NOVELL use only 0 }  0);

   if ccode<>0 then
   begin
      hexcode:=inttohex(ccode,4);
      if hexcode='8803' then
      begin
        loginform.show;
      end
      else if hexcode='0055' then
      begin
        showmessage('Drive is already mapped');
      end
      else
        showmessage('NWSetDriveBase: failed 0x'+hexcode);
      exit;
   end;
   volform.close;
   updatelist;
   showMessage('May need to close conn here');
end;

{This procedure retrieves the volume information for a given server through
NWGetVolumeName}
procedure Tmapform.Getvolumes;
var
  serConnString:array [0..20] of char;
  nameFormat, openState:nuint;
  ccode: NWCCODE;
  rcode: NWRCODE;
  res: integer;
  volnum: integer;
  volname: array [0..200] of char;
begin
  nameFormat := NWCC_NAME_FORMAT_BIND;   {0x002}
  openState := NWCC_OPEN_UNLICENSED;           { 0x0002 }
  strpcopy(@serconnstring,servername);
  ccode:=NWCCOpenConnByName(0,@serconnstring,nameFormat,openState,res,@conn);
  if not (ccode=0) then
     ShowMessage('WARNING: NWCCOpenConnByName returned:  '+inttostr(ccode));
  volform.listbox1.items.clear;
  for volnum:=0 to 64 do
  begin
    NWGetVolumeName(conn, volnum, @volname);
    if strpas(volname)='' then
      exit;
    volform.listbox1.items.add(strpas(volname));
    volform.show;
  end;
end;

{According to the new connection model, All opened connections should be closed}
procedure Tmapform.FormClose(Sender: TObject; var Action: TCloseAction);
var
   rcode: NWRCODE;
begin
  rcode:=NWCCCloseConn(conn);
  if rcode<>0 then
  ShowMessage('NWCCCloseConn Failed: '+inttohex(conn,2));
end;

procedure Tmapform.BitBtn1Click(Sender: TObject);
begin
  updatelist;
end;

{This procedure shows how to use NWLOGIN to login to a server, This is a bindery
login, it will work with many 4.x servers if their bindery context is set to the
users current context}
procedure Tmapform.Login;
var
  hexcode:string;
  ccode: NWCCODE;
  pass:array [0..128] of char;
  ptr:pointer;
  objname:array [0..50] of char;
begin
   strpcopy(objname, LoginForm.Edit1.Text);
   strpcopy(pass, uppercase(LoginForm.Edit2.Text));
   loginform.Edit2.Text:='';
   loginform.close;
   ptr:=@pass;
   ccode:=nwlogintofileserver(conn, @objname, OT_USER, ptr);
   if ccode <>0 then
   begin
    hexcode:=inttohex(ccode,4);
    if hexcode='89C5' then
      ShowMessage('Intruder Lockout')
    else if hexcode='89FF' then
      ShowMessage('Wrong Password')
    else if hexcode='89DF' then
      ShowMessage('Password Expired')
    else
      ShowMessage('NWLogintoFileServer Failed: '+inttohex(ccode,4));
    exit;
   end;
   mapdrive;
end;

{This causes Listbox3 to not have anything selected so the OnDragDrop event can
tell which control to map from}
procedure Tmapform.ListBox2Click(Sender: TObject);
begin
  ListBox3.Itemindex:=-1;
end;

procedure Tmapform.ListBox3Click(Sender: TObject);
begin
  ListBox2.Itemindex:=-1;
end;

end.
