{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit map2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons, nwinc32, ExtCtrls;

type
  TmapForm = class(TForm)
    lstServers: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    bbtDelete: TBitBtn;
    BitBtn2: TBitBtn;
    lstDrive: TListBox;
    pnlLTR: TPanel;
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure lvwDriveDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvwDriveEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure bbtDeleteClick(Sender: TObject);
    procedure lstServersClick(Sender: TObject);
    procedure lstDriveClick(Sender: TObject);
    procedure FormDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lstServersDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lstServersDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure getserverlist;
    procedure updatelist;
    Function  inttochar(i: integer): char;
    procedure getvolumes;
    procedure logmein;
    procedure mapdrive;
    { Public declarations }
  end;

var
  mapForm: TmapForm;
  drive_num: integer;
  conn:NWCONN_HANDLE;
  thevol:string; 

implementation

uses mainunit, vol, Login;

{$R *.DFM}

{This procedure retrieves the volume information for a given server through
NWGetVolumeName}
procedure TmapForm.Getvolumes;
var
  serConnString:array [0..20] of char;
  nameFormat, openState:nuint;
  rcode: NWRCODE;
  volnum: integer;
  volname: array [0..200] of char;
begin
  nameFormat := NWCC_NAME_FORMAT_BIND;   {0x002}
  openState := NWCC_OPEN_UNLICENSED;           { 0x0002 }
  strpcopy(@serconnstring,servername);
  rcode:=NWCCOpenConnByName(0,@serconnstring,nameFormat,openState,0,@conn);
  if (rcode<>0) then
     ShowMessage('WARNING: NWCCOpenConnByName returned:  '+inttostr(ccode));
  frmvol.listbox1.items.clear;
  for volnum:=0 to 64 do
  begin
    NWGetVolumeName(conn, volnum, @volname);
    if strpas(volname)='' then
      exit;
    frmvol.listbox1.items.add(strpas(volname));
    frmvol.show;
  end;
end;

procedure TmapForm.GetServerlist;
var
  i : Integer;
begin
  for i:=0 to Form1.lstServers.Items.Count-1 do
  begin
    lstServers.items.Add(Form1.lstServers.Items[i]);
  end;
end;

function TmapForm.inttochar(i: integer): char;
begin
  result:='Z';
  if i=1 then
    result:='A'
  else if i=2 then
    result:='B'
  else if i=3 then
    result:='C'
  else if i=4 then
    result:='D'
  else if i=5 then
    result:='E'
  else if i=6 then
    result:='F'
  else if i=7 then
    result:='G'
  else if i=8 then
    result:='H'
  else if i=9 then
    result:='I'
  else if i=10 then
    result:='J'
  else if i=11 then
    result:='K'
  else if i=12 then
    result:='L'
  else if i=13 then
    result:='M'
  else if i=14 then
    result:='N'
  else if i=15 then
    result:='O'
  else if i=16 then
    result:='P'
  else if i=17 then
    result:='Q'
  else if i=18 then
    result:='R'
  else if i=19 then
    result:='S'
  else if i=20 then
    result:='T'
  else if i=21 then
    result:='U'
  else if i=22 then
    result:='V'
  else if i=23 then
    result:='W'
  else if i=24 then
    result:='X'
  else if i=25 then
    result:='Y'
  else if i=26 then
    result:='Z'
end;

procedure TmapForm.UpdateList;
var
  i, status: Integer;
  conn:NWCONN_HANDLE;
  rootpath:array [0..256] of char;
  relativePath: array [0..256] of char;
  driveltr: string;

begin
  {get the current drive status for A..Z}
  lstDrive.items.clear;
  for i:=1 to 26 do
  begin
    ccode := NWGetDriveStatus(
      { > drive Number    }  i,
      { > path format     }  NW_FORMAT_SERVER_VOLUME,
      { < bitmask pointer }  @status,
      { < conn Handle     }  conn,
      { < root path       }  @rootPath,
      { < relative path   }  @relativePath,
      { < full path       }  nil);
    if (ccode<0)then
    begin
       ShowMessage('NWGetDriveStatus Failed'+#13+'Error Code: '+inttostr(ccode));
       exit;
    end;
    driveltr:=inttochar(i);
    lstDrive.Items.Add(driveltr+': '+strpas(rootpath));
  end;
end;

procedure TmapForm.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TmapForm.FormShow(Sender: TObject);
begin
  getserverlist;
  updatelist;
end;

procedure TmapForm.lvwDriveDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if (Source is TListBox) then
  begin
    pnlLTR.Visible:=True;
    Accept:=True;
    if Y <=16 then
      drive_num:=1
    else if Y <=32 then
      drive_num:=2
    else if Y <=48 then
      drive_num:=3
    else if Y <=64 then
      drive_num:=4
    else if Y <=80 then
      drive_num:=5
    else if Y <=96 then
      drive_num:=6
    else if Y <=112 then
      drive_num:=7
    else if Y <=128 then
      drive_num:=8
    else if Y <=144 then
      drive_num:=9
    else if Y <=160 then
      drive_num:=10
    else if Y <=176 then
      drive_num:=11
    else if Y <=192 then
      drive_num:=12
    else if Y <=208 then
      drive_num:=13
    else if Y <=224 then
      drive_num:=14
    else if Y <=240 then
      drive_num:=15
    else if Y <=256 then
      drive_num:=16
    else if Y <=272 then
      drive_num:=17
    else if Y <=288 then
      drive_num:=18
    else if Y <=304 then
      drive_num:=19
    else if Y <=320 then
      drive_num:=20
    else if Y <=336 then
      drive_num:=21
    else if Y <=352 then
      drive_num:=22
    else if Y <=368 then
      drive_num:=23
    else if Y <=384 then
      drive_num:=24
    else if Y <=400 then
      drive_num:=25
    else if Y <=416 then
      drive_num:=26
    else
    begin
      ShowMessage('Drag drop out of area');
      exit;
    end;
    pnlLTR.Caption:=inttochar(drive_num)+':';
  end;
end;

{This procedure creates the new drive mapping}
procedure TmapForm.MapDrive;
var
  upr_ans: array [0..200] of char;
  server:array [0..50] of char;
  volname:array [0..50] of char;
  dirpath:array [0..100] of char;
  conn2: NWCONN_HANDLE;
  hexcode: string;
begin
   strpcopy(@upr_ans, servername+'\'+thevol+':\:');
   ccode := NWParsePath(
           { > pointer to path                         }  @upr_ans,
           { < pointer to server name 48 char optional }  @server,
           { < pointer to conn handle                  }  conn2,
           { < pointer to volume name 17 char optional }  @volName,
           { < pointer to directory  256 char optional }  @dirPath);
   if ccode<>0 then
   begin
      showmessage('NWParsePath failed '+inttohex(ccode,4));
      exit;
   end;
      ccode := NWSetDriveBase(
            { > drive Number    }  drive_num,
            { > conn Handle     }  conn,
            { > directory handle}  0,
            { > directory path  }  @volname,
            { NOVELL use only 0 }  0);

   if ccode<>0 then
   begin
      hexcode:=inttohex(ccode,4);
      if hexcode='8803' then
      begin
        loginform.lblServer.Caption:=servername;
        loginform.Caption:='Mapping Login';
        frmvol.close;
        loginform.show;
      end
      else if hexcode='0055' then
      begin
        showmessage('Drive is already mapped');
      end
      else
        showmessage('NWSetDriveBase: failed 0x'+hexcode);
      exit;
   end;
   frmvol.close;
   updatelist;
   nwcccloseconn(conn);
end;

procedure TmapForm.lvwDriveEndDrag(Sender, Target: TObject; X, Y: Integer);
begin
  if Target = nil then
  begin
    ShowMessage('Rejected');
  end;
  servername:=lstServers.Items[lstServers.Itemindex];
  getvolumes;
  pnlLTR.Visible:=False;
end;

procedure TmapForm.bbtDeleteClick(Sender: TObject);
var
  theline: string;
begin
  if lstDrive.itemindex < 0 then
  begin
    ShowMessage('Please select a drive');
    exit;
  end;
  theline:=lstDrive.items[lstDrive.itemindex];
  if MessageDlg('Delete '+theline+'?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
    Exit;
  ccode := NWDeleteDriveBase(lstDrive.itemindex+1,0 );
  if (ccode<>0)then
  begin
     ShowMessage('NWDeleteDriveBase: failed'+inttostr(ccode));
     Exit;
  end;
  updatelist;
end;

procedure TmapForm.lstServersClick(Sender: TObject);
begin
  pnlLTR.Caption:='';
  pnlLTR.Visible:=False;
end;

procedure TmapForm.lstDriveClick(Sender: TObject);
begin
  pnlLTR.Caption:='';
  pnlLTR.Visible:=False;
end;

procedure TmapForm.FormDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
   pnlLTR.Visible:=False;
end;

procedure TmapForm.lstServersDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
   pnlLTR.Visible:=False;
end;

procedure TmapForm.LogMein;
var
  hexcode:string;
  ccode: NWCCODE;
  pass:array [0..128] of char;
  objname:array [0..50] of char;
begin
   strpcopy(objname, LoginForm.Edit1.Text);
   strpcopy(pass, uppercase(LoginForm.Edit2.Text));
   loginform.Edit2.Text:='';
   loginform.close;
     ccode:=nwlogintofileserver(conn, @objname, OT_USER, @pass);
     if ccode <>0 then
     begin
      hexcode:=inttohex(ccode,4);
      if hexcode='89C5' then
        ShowMessage('Intruder Lockout')
      else if hexcode='89FF' then
        ShowMessage('Wrong Password')
      else if hexcode='89DF' then
        ShowMessage('Password Expired')
      else
        ShowMessage('NWLogintoFileServer Failed: '+inttohex(ccode,4));
        exit;
     end;
end;

procedure TmapForm.lstServersDblClick(Sender: TObject);
begin
  ShowMessage('Drag a server name over a drive letter to map a drive');
end;

end.
