{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit NS;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,ComCtrls, Mainunit, nwinc32;

type
  TfrmNS = class(TForm)
    GroupBox1: TGroupBox;
    rbnMac: TRadioButton;
    rbnUnix: TRadioButton;
    rbnLong: TRadioButton;
    bbtOK: TBitBtn;
    BitBtn2: TBitBtn;
    procedure bbtOKClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmNS: TfrmNS;

implementation

{$R *.DFM}

procedure TfrmNS.bbtOKClick(Sender: TObject);
var
{  Y, Z : Integer;}
  NS : Integer;
  NLMName : array [0..10] of char;
begin
  Screen.Cursor:=crHourGlass;
  strpcopy(NLMName,'');
  if rbnMAC.Checked=True then
  begin
    NS:=1;
    strpcopy(NLMName, 'MAC.NAM');
  end
  else if rbnUNIX.Checked=True then
  begin
    NS:=2;
    strpcopy(NLMName, 'NFS.NAM');
  end
  else if rbnLONG.Checked=True then
  begin
    NS:=4;
    strpcopy(NLMName, 'LONG.NAM');
  end
  else
    NS:=0;

  if strLen(NLMName)>1 then
  begin
    ccode:=NWSMLoadNLM(connHandle, @NLMName);
    Form1.lvwNLMs.Items.Clear;
    Form1.GetNLMList;
    Screen.Cursor:=crDefault;
  end;

  ccode:=NWSMAddnstoVolume(connHandle, Form1.sgdVolume.Row-1, NS);
  if (ccode<>0) then
  begin
    if (inttohex(ccode,2)='205') then
      ShowMessage('Unable to add specified name space to the volume')
    else
      ShowMessage('NWSMAddNStoVolume Failed :'+inttohex(ccode,2));
    exit;
  end;
  Close;
  Form1.GetVolList;
end;

procedure TfrmNS.BitBtn2Click(Sender: TObject);
begin
 Close;
end;

end.


